package com.netwisd.codegen;

import cn.hutool.core.collection.CollectionUtil;
import com.netwisd.codegen.service.GenService;
import com.netwisd.go.code.gen.ExcludesEnum;
import lombok.extern.slf4j.Slf4j;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.annotation.ComponentScan;

import java.util.List;

/**
 * @description:
 * @projectName: incloud5
 * @see: com.netwisd.base.codegen
 * @author: zouliming
 * @createTime: 2023/10/12 12:59
 * @version: 5.1.0
 */
@SpringBootTest
@Slf4j
@ComponentScan(basePackages = "com.netwisd.codegen.service")
public class CodeGenTest {

    @Value("${INCLOUD_CODER}")
    private String incloud_coder;

    @Autowired
    private GenService genService;

    private final static String appCode = "main";
    private String packageName = "com.netwisd.base";
    private String moduleName = "mdm";
    private String tablePrefix = "incloud_base_";
    private String tableName = "incloud_base_mdm_org";
    private String comments = "组织";
    private String templatePacket = "single-wf";
    private List<ExcludesEnum> excludes = CollectionUtil.newArrayList(ExcludesEnum.MAPPER_XML, ExcludesEnum.FEIGN);

    @Test
    public void build4Mac() {
        genService.generate("/Users/" + incloud_coder + "/gen/",appCode,tableName,comments,templatePacket,packageName,moduleName,tablePrefix,excludes);
    }

    @Test
    public void build4Win() {
        genService.generate("D:/gen/",appCode,tableName,comments,templatePacket,packageName,moduleName,tablePrefix,excludes);
    }
}
