package com.netwisd.codegen.service;

import com.netwisd.go.code.client.CodeGenClient;
import com.netwisd.go.code.gen.ExcludesEnum;
import com.netwisd.go.code.gen.GenConfig;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @description:
 * @projectName: incloud5
 * @see: com.netwisd.codegen
 * @author: zouliming
 * @createTime: 2023/10/19 11:16
 * @version: 5.1.0
 */
@Component
@Data
public class GenService {
    @Value("${INCLOUD_CODER}")
    private String incloud_coder;

    @Autowired
    private CodeGenClient codeGenClient;

    @Value("${db.dbType}")
    private String dbType;

    @Value("${db.host}")
    private String host;

    @Value("${db.port}")
    private int port;

    @Value("${db.username}")
    private String username;

    @Value("${db.password}")
    private String password;

    @Value("${db.database}")
    private String database;

    @Value("${db.schema}")
    private String schema;

    @Value("${go.server.level}")
    private String goLogLevel;

    @Value("${go.server.path}")
    private String goLogPath;

    public void generate(String buildPath, String appCode, String tableName, String comments, String templatePacket,
                               String packageName, String moduleName, String tablePrefix , List<ExcludesEnum> excludes){
        codeGenClient.generatorCode(new GenConfig(dbType,host,port,username,password,database,schema,goLogLevel,goLogPath,appCode,incloud_coder,buildPath,packageName,moduleName,tablePrefix,tableName,comments,templatePacket,excludes.stream().map(ExcludesEnum::getName).toList()));
    }
}
