  <p align="center">
   <img src="https://img.shields.io/badge/Spring%20Cloud-2022.0.1-blue.svg" alt="Coverage Status">
   <img src="https://img.shields.io/badge/Spring%20Boot-3.0.2-blue.svg" alt="Downloads">
 </p>  
 
 #### 核心依赖 
 
| 依赖                   | 版本               | 说明                   |
|----------------------|------------------|----------------------|
| JDK                  | 17               | 要求17+                |
| Docker               | 19.0+            | 基础环境部署               |
| Jenkins              | 2.204.5          | 自动构建打包部署工具集          |
| Maven                | 3.6.3            | 工程构建                 |
| Mysql                | 8.0.31           | mysql数据库             |
| Redis                | 5.0.7            | 缓存                   |
| RabbitMQ             | 3.8.2-management | 使用带后台管理版本            |
| Minio                | 6.0.11           | 文档存储                 |
| Nacos                | v2.1.1           | 服务注册与发现              |
| Seata                | 1.4.2            | 分布式事务                |
| Spring Boot          | 3.0.2            | springboot           |
| Spring Cloud         | 2022.0.1         | 微服务                  |
| spring-cloud-alibaba | 2022.0.0.0-RC1   | alibaba的spring cloud |
| MyBatis-Plus         | 3.5.1            | 数据库持久层框架             |
| Openfeign            | 2.2.2.RELEASE    | 微服务远程调用              |
| Velocity             | 1.7              | 自动生成代码模板             |
| Druid                | 1.2.15           | 数据源                  |
| Hutool               | 5.8.11           | 工具类                  |
| Dozermapper          | 6.5.0            | 数据映射工具               |
| Camunda              | 7.18.0           | 工作流引擎                |
| ElasticSearch        | 7.9.1            | 全文检索——需要JDK11+       |
| Kibana               | 7.9.1            | es相关管理——需要JDK11+     |
| Canal server         | 1.1.4            | 准实时索引同步服务端           |
| Canal admin          | 1.1.4            | 准实时索引同步管理端           |
| XXL-JOB              | 2.3.0            | 分布式任务调度              |

1.模块说明
```lua
incloud
└── incloud-base                                    -- 基础服务
    ├──  incloud-base-common                        -- 公共依赖
    ├──  incloud-base-dependency                    -- 依赖服务
         ├──  incloud-base-dependency-app           -- 应用管理依赖
         ├──  incloud-base-dependency-center        -- 任务中心依赖
         ├──  incloud-base-dependency-cts           -- 通讯录依赖
         ├──  incloud-base-dependency-dict          -- 字典依赖
         ├──  incloud-base-dependency-dynamic       -- 动态接口依赖
         ├──  incloud-base-dependency-file          -- 文件依赖
         ├──  incloud-base-dependency-log           -- 日志依赖
         ├──  incloud-base-dependency-mdm           -- 主数据依赖
         ├──  incloud-base-dependency-model         -- model依赖
         ├──  incloud-base-dependency-msg           -- msg依赖
         ├──  incloud-base-dependency-openapi       -- openapi依赖
         ├──  incloud-base-dependency-permission    -- 数据权限依赖
         ├──  incloud-base-dependency-security      -- 认证依赖
         └──  incloud-base-dependency-sms           -- 短信依赖
    ├──  incloud-base-gateway                       -- 网关服务
    ├──  incloud-base-main                          -- 主服务
    ├──  incloud-base-portal                        -- 门户服务
    ├──  incloud-base-wf                            -- 工作流服务
├──  incloud-pojo                                   -- 无状态bean
├── incloud-starter                                 -- 依赖的stater
    ├──  incloud-base-center-starter                -- 任务中心starter
    ├──  incloud-base-openapi-starter               -- openapistarter
    ├──  incloud-base-permission-starter            -- 数据权限starter
    ├──  incloud-base-security-starter              -- 认证starter
    ├──  incloud-base-wf-starter                    -- 工作流starter
    ├──  incloud-common-code-starter	            -- 代码生成核心starter
    ├──  incloud-common-codegen-starter             -- 代码生成模块starter
    ├──  incloud-common-core-starter                -- 核心模块starter
    ├──  incloud-common-db-starter                  -- 数据库依赖starter
    ├──  incloud-common-es-starter                  -- es依赖starter
    ├──  incloud-common-log-starter                 -- 日志依赖starter
    ├──  incloud-common-mq-starter                  -- 消息依赖starter
         ├──  incloud-common-mq-rabbit-starter      -- 消息实现rabbitmq
         └──  incloud-common-mq-rocket-starter      -- 消息实现rocketmq
    └──  incloud-common-task-starter	            -- 任务调度核心starter
```


2.运行说明

    基础环境：mysql、redis、rocketmq、nacos、seata(工作流需要)、minio(file需要)，建议使用docker方式，这些必须先启动
    jdk使用17以上
    使用git，本地git用户名邮箱设置一下；git config user.name “xxx” ,git config user.email “xxx”

    env:
      --根据实际情况配置自己修改，下面是mac/linux的配置，windows请配置环境变量；
    
    env: 
    --根据实际情况配置自己修改
    export INCLOUD_NACOS_SERVICE_HOST=192.168.0.79
    export INCLOUD_MYSQL_SERVICE_HOST=192.168.0.79
    export INCLOUD_KINGBASE_SERVICE_HOST=192.168.0.79
    export INCLOUD_REDIS_SERVICE_HOST=192.168.0.79
    export INCLOUD_MINIO_SERVICE_HOS=192.168.0.79
    export INCLOUD_BASE_GATEWAY_SERVICE_HOST=127.0.0.1
    export INCLOUD_ES_SERVICE_HOST=192.168.0.79
    export INCLOUD_ROCKETMQ_SERVICE_HOST=192.168.0.79
    export INCLOUD_BASE_GATEWAY_SERVICE_PORT=8000
    export INCLOUD_NACOS_SERVICE_PORT=8848
    export INCLOUD_REDIS_SERVICE_PORT=6379
    export INCLOUD_MYSQL_SERVICE_PORT=3306
    export INCLOUD_KINGBASE_SERVICE_PORT=54321
    export INCLOUD_MINIO_SERVICE_PORT=5000
    export INCLOUD_ROCKETMQ_SERVICE_PORT=9876
    export INCLOUD_ES_SERVICE_PORT=9200
    export INCLOUD_NACOS_NAMESPACE=incloud5
    export INCLOUD_DB_USER=netwisd
    export INCLOUD_DB_PWD=Netwisd*8
    export INCLOUD_DB_SCHEMA=incloud5
    export INCLOUD_DB_BACKET=backdata
    export INCLOUD_REDIS_PWD=Netwisd*8
    export INCLOUD_MINIO_ACCESSKEY=root
    export INCLOUD_MINIO_SECRETKEY=Netwisd*8
    export INCLOUD_MINIO_BACKETNAME=incloud4
    export INCLOUD_CODER=zouliming
    #export INCLOUD_APIURL=http://incloud.com/api/v4.3
    export INCLOUD_APIURL=http://127.0.0.1:8000