package com.netwisd.base.main.config;

import com.netwisd.base.security.annotation.Knife4jConfig;
import com.netwisd.base.security.annotation.ResourceConfiguration;
import org.mybatis.spring.annotation.MapperScan;
import org.mybatis.spring.annotation.MapperScans;
import org.springframework.context.annotation.ComponentScan;

/**
 * @description: 主模块配置
 * @projectName: incloud5
 * @see: com.netwisd.base.main.config
 * @author: zouliming
 * @createTime: 2023/4/20 14:45
 * @version: 5.0
 */
@Knife4jConfig(title = "主模块")
@ResourceConfiguration(permitAll = {"/ctsApiController/**", "/smsTaskApiController/**", "/securityApiController/**", "/appApiController/**",
        "/sso/**", "/authenticationManagement/authenticator", "/fileinfo/stream", "/ws/msg", "/preview/**"})
@ComponentScan(basePackages = {"com.netwisd.base.demo"})
@MapperScans(value = {@MapperScan("com.netwisd.base.demo.mapper")})
public class MainConfig {
}
