package com.netwisd.base.admin;

import cn.hutool.core.date.DateUtil;
import de.codecentric.boot.admin.server.config.EnableAdminServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableScheduling;

import java.net.Inet4Address;

/**
 * 触发构建
 */
@Configuration
@EnableAutoConfiguration
@EnableDiscoveryClient
@EnableScheduling
@EnableAdminServer
public class AdminApplication {

    public static void main(String[] args) {
        String startTime = DateUtil.now();
        Logger log = LoggerFactory.getLogger(AdminApplication.class);
        ConfigurableApplicationContext context = SpringApplication.run(AdminApplication.class);
        try {
            //ip
            String hostAddress = Inet4Address.getLocalHost().getHostAddress();
            //获取端口
            String prot = context.getBean(Environment.class).getProperty("server.port");
            String ip = "http://" + hostAddress + ":" + prot + "/swagger-ui.html";
            log.info(ip);
            String doc = "http://" + hostAddress + ":" + prot + "/doc.html";
            log.info(doc);
            log.info("SpringBoot Admin启动了,启动开始时间:{}，启动结束时间:{}", startTime, DateUtil.now());
        } catch (Exception e) {
            log.error("启动失败:", e);
        }
    }
}
