package com.netwisd.base;

import cn.hutool.core.date.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;

import java.net.Inet4Address;

@EnableFeignClients
@SpringBootApplication
@EnableDiscoveryClient
@EnableConfigurationProperties
public class LogApplication {

    public static void main(String[] args) {
        String startTime = DateUtil.now();
        Logger log = LoggerFactory.getLogger(LogApplication.class);
        ConfigurableApplicationContext context = SpringApplication.run(LogApplication.class);
        try {
            //ip
            String hostAddress = Inet4Address.getLocalHost().getHostAddress();
            //获取端口
            String port = context.getBean(Environment.class).getProperty("server.port");
            String ip = "http://" + hostAddress + ":" + port + "/swagger-ui.html";
            log.info(ip);
            String doc = "http://" + hostAddress + ":" + port + "/doc.html";
            log.info(doc);
            log.info("Log启动了,启动开始时间:{}，启动结束时间:{}", startTime, DateUtil.now());
        } catch (Exception e) {
            log.error("Log启动失败:", e);
        }
    }


}
