package com.netwisd.base.log.es;

import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.junit.jupiter.api.Test;

import java.io.IOException;

/**
 *
 */
@Slf4j
public class EsTest {

    public RestHighLevelClient initClient() {
        HttpHost httpHost = new HttpHost("192.168.100.10", 9200, "http");
        RestClientBuilder builder = RestClient.builder(httpHost);
        final BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials("elastic", "Dsjzx@2023#.com"));
        builder.setHttpClientConfigCallback(httpClientBuilder -> {
            httpClientBuilder.disableAuthCaching();
            return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        });
        return new RestHighLevelClient(builder);
    }

    @Test
    public void doTest() throws IOException {
        RestHighLevelClient client = initClient();//创建请求
        DeleteIndexRequest incloud5FrontOperateLogRequest = new DeleteIndexRequest("incloud5_front_operate_log");
        client.indices().delete(incloud5FrontOperateLogRequest, RequestOptions.DEFAULT);

        DeleteIndexRequest incloud5SystemLoginLogRequest = new DeleteIndexRequest("incloud5_system_login_log");
        client.indices().delete(incloud5SystemLoginLogRequest, RequestOptions.DEFAULT);

        DeleteIndexRequest incloud5SystemOperateLogRequest = new DeleteIndexRequest("incloud5_system_operate_log");
        client.indices().delete(incloud5SystemOperateLogRequest, RequestOptions.DEFAULT);
    }
}