
package com.netwisd.biz.demo.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.netwisd.biz.demo.dto.ProductDto;
import com.netwisd.biz.demo.service.ProductService;
import com.netwisd.biz.demo.vo.ProductVo;
import com.netwisd.common.core.annotation.App;
import com.netwisd.common.core.annotation.Validation;
import com.netwisd.common.core.util.Result;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author incoder@netwisd.com
 * @Description 商品
 * @date 2024-04-30 16:07:27
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/product")
@Slf4j
@Tag(name = "商品", description = "商品Controller")
@App("demo")
public class ProductController {

    private final ProductService productService;

    /**
     * 分页查询商品
     *
     * @param productDto 商品
     * @return
     */
    @Operation(summary = "分页查询")
    @PostMapping("/page")
    public Result<Page<ProductVo>> page(@RequestBody ProductDto productDto) {
        return Result.success(productService.page(productDto));
    }

    /**
     * 通过id查询商品
     *
     * @param id id
     * @return Result
     */
    @Operation(summary = "通过id查询")
    @GetMapping("/{id}")
    public Result<ProductVo> get(@PathVariable("id") Long id) {
        return Result.success(productService.get(id));
    }

    /**
     * 新增商品
     *
     * @param productDto 商品
     * @return Result
     */
    @Operation(summary = "新增商品")
    @PostMapping
    public Result<ProductVo> save(@Validation @RequestBody ProductDto productDto) {
        return Result.success(productService.save(productDto));
    }

    /**
     * 修改商品
     *
     * @param productDto 商品
     * @return Result
     */
    @Operation(summary = "修改商品")
    @PutMapping
    public Result<ProductVo> update(@Validation @RequestBody ProductDto productDto) {
        return Result.success(productService.update(productDto));
    }

    /**
     * 通过id删除商品
     *
     * @param id id
     * @return Result
     */
    @Operation(summary = "通过id删除商品")
    @DeleteMapping("/{id}")
    public Result<Boolean> delete(@PathVariable Long id) {
        return Result.success(productService.delete(id));
    }
}
