
package com.netwisd.biz.demo.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.netwisd.common.core.util.Result;
import com.netwisd.biz.demo.dto.PurchaseDto;
import com.netwisd.biz.demo.vo.PurchaseVo;
import com.netwisd.biz.demo.service.PurchaseService;
import com.netwisd.common.core.annotation.App;
import io.swagger.v3.oas.annotations.Operation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;
import lombok.extern.slf4j.Slf4j;
import com.netwisd.common.core.annotation.Validation;
import com.netwisd.base.wf.starter.controller.WfController;
import io.swagger.v3.oas.annotations.tags.Tag;

/**
 * @Description 采购申请单
 * @author incoder@netwisd.com
 * @date 2024-04-30 16:24:48
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/purchase" )
@Slf4j
@Tag(name = "采购申请单", description = "采购申请单Controller")
@App("demo")
public class PurchaseController extends WfController<PurchaseService,PurchaseVo>{

    private final PurchaseService purchaseService;
    /**
     * 分页查询采购申请单
     * @param purchaseDto 采购申请单
     * @return
     */
    @Operation(summary = "分页查询")
    @PostMapping("/page" )
    public Result<Page<PurchaseVo>> page(@RequestBody PurchaseDto purchaseDto) {
        return Result.success(purchaseService.page(purchaseDto));
    }

    /**
     * 新增采购申请单
     * @param purchaseDto 采购申请单
     * @return Result
     */
    @Operation(summary = "新增采购申请单")
    @PostMapping
    public Result<PurchaseVo> save(@Validation @RequestBody PurchaseDto purchaseDto) {
        return Result.success(purchaseService.save(purchaseDto));
    }

    /**
     * 修改采购申请单
     * @param purchaseDto 采购申请单
     * @return Result
     */
    @Operation(summary = "修改采购申请单")
    @PutMapping
    public Result<PurchaseVo> update(@Validation @RequestBody PurchaseDto purchaseDto) {
        return Result.success(purchaseService.update(purchaseDto));
    }
    /**
     * 通过id删除采购申请单
     * @param id id
     * @return Result
     */
    @Operation(summary = "通过id删除采购申请单")
    @DeleteMapping("/{id}" )
    public Result<Boolean> delete(@PathVariable Long id) {
        return Result.success(purchaseService.delete(id));
    }

    /**
     * 通过id查询采购申请单
     * @param id id
     * @return Result
     */
    @Operation(summary = "通过id查询")
    @GetMapping("/{id}" )
    public Result<PurchaseVo> get(@PathVariable("id" ) Long id) {
        return Result.success(purchaseService.get(id));
    }
}
