
package com.netwisd.biz.demo.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.netwisd.common.core.util.Result;
import com.netwisd.biz.demo.dto.PurchaseDetailDto;
import com.netwisd.biz.demo.vo.PurchaseDetailVo;
import com.netwisd.biz.demo.service.PurchaseDetailService;
import com.netwisd.common.core.annotation.App;
import io.swagger.v3.oas.annotations.Operation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;
import lombok.extern.slf4j.Slf4j;
import com.netwisd.common.core.annotation.Validation;
import com.netwisd.base.wf.starter.controller.WfController;
import io.swagger.v3.oas.annotations.tags.Tag;

/**
 * @Description 采购申请单详情
 * @author incoder@netwisd.com
 * @date 2024-04-30 16:24:48
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/purchaseDetail" )
@Slf4j
@Tag(name = "采购申请单详情", description = "采购申请单详情Controller")
@App("demo")
public class PurchaseDetailController extends WfController<PurchaseDetailService,PurchaseDetailVo>{

    private final PurchaseDetailService purchaseDetailService;
    /**
     * 通过id删除采购申请单详情
     * @param id id
     * @return Result
     */
    @Operation(summary = "通过id删除采购申请单详情")
    @DeleteMapping("/{id}" )
    public Result<Boolean> delete(@PathVariable Long id) {
        return Result.success(purchaseDetailService.delete(id));
    }

    /**
     * 通过id查询采购申请单详情
     * @param id id
     * @return Result
     */
    @Operation(summary = "通过id查询")
    @GetMapping("/{id}" )
    public Result<PurchaseDetailVo> get(@PathVariable("id" ) Long id) {
        return Result.success(purchaseDetailService.get(id));
    }
}
