
package com.netwisd.biz.demo.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.netwisd.biz.demo.dto.TestDto;
import com.netwisd.biz.demo.service.TestService;
import com.netwisd.biz.demo.vo.TestVo;
import com.netwisd.common.core.annotation.App;
import com.netwisd.common.core.annotation.Validation;
import com.netwisd.common.core.util.Result;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author incoder@netwisd.com
 * @Description 测试主表
 * @date 2024-04-30 14:24:43
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/test")
@Slf4j
@App("demo")
@Tag(name = "测试主表", description = "测试主表Controller")
public class TestController {

    private final TestService testService;

    /**
     * 分页查询测试主表
     *
     * @param testDto 测试主表
     * @return
     */
    @Operation(summary = "分页查询")
    @PostMapping("/page")
    public Result<Page<TestVo>> page(@RequestBody TestDto testDto) {
        log.info("请求到了");
        return Result.success(testService.page(testDto));
    }

    /**
     * 新增测试主表
     *
     * @param testDto 测试主表
     * @return Result
     */
    @Operation(summary = "新增测试主表")
    @PostMapping
    public Result<TestVo> save(@Validation @RequestBody TestDto testDto) {
        return Result.success(testService.save(testDto));
    }

    /**
     * 修改测试主表
     *
     * @param testDto 测试主表
     * @return Result
     */
    @Operation(summary = "修改测试主表")
    @PutMapping
    public Result<TestVo> update(@Validation @RequestBody TestDto testDto) {
        return Result.success(testService.update(testDto));
    }

    /**
     * 通过id删除测试主表
     *
     * @param id id
     * @return Result
     */
    @Operation(summary = "通过id删除测试主表")
    @DeleteMapping("/{id}")
    public Result<Boolean> delete(@PathVariable Long id) {
        return Result.success(testService.delete(id));
    }

    /**
     * 通过id查询测试主表
     *
     * @param id id
     * @return Result
     */
    @Operation(summary = "通过id查询")
    @GetMapping("/{id}")
    public Result<TestVo> get(@PathVariable("id") Long id) {
        return Result.success(testService.get(id));
    }
}
