
package com.netwisd.biz.demo.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.netwisd.common.core.util.Result;
import com.netwisd.biz.demo.dto.TestDetailDto;
import com.netwisd.biz.demo.vo.TestDetailVo;
import com.netwisd.biz.demo.service.TestDetailService;
import com.netwisd.common.core.annotation.App;
import io.swagger.v3.oas.annotations.Operation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;
import lombok.extern.slf4j.Slf4j;
import com.netwisd.common.core.annotation.Validation;
import io.swagger.v3.oas.annotations.tags.Tag;

/**
 * @Description 测试子表1
 * @author incoder@netwisd.com
 * @date 2024-04-30 14:24:43
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/testDetail" )
@Slf4j
@App("demo")
@Tag(name = "测试子表1", description = "测试子表1Controller")
public class TestDetailController {

    private final TestDetailService testDetailService;
    /**
     * 通过id删除测试子表1
     * @param id id
     * @return Result
     */
    @Operation(summary = "通过id删除测试子表1")
    @DeleteMapping("/{id}" )
    public Result<Boolean> delete(@PathVariable Long id) {
        return Result.success(testDetailService.delete(id));
    }

    /**
     * 通过id查询测试子表1
     * @param id id
     * @return Result
     */
    @Operation(summary = "通过id查询")
    @GetMapping("/{id}" )
    public Result<TestDetailVo> get(@PathVariable("id" ) Long id) {
        return Result.success(testDetailService.get(id));
    }
}
