package com.netwisd.biz.demo.controller.expression;

import com.netwisd.base.wf.starter.controller.WfExpressionController;
import com.netwisd.base.wf.starter.expression.ExpressionEntity;
import com.netwisd.common.core.annotation.App;
import com.netwisd.common.core.util.JacksonUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;

@Slf4j
@RestController
@RequestMapping("/wfExpressionCondition")
@Tag(name = "路由表达式接口", description = "路由表达式接口Controller")
@App(appCode = "demo")
public class WfExpressionConditionController extends WfExpressionController<WfExpressionConditionController> {

    @Operation(summary = "演示示例网关路由")
    @RequestMapping(value = "/gateway", method = RequestMethod.POST)
    public BigDecimal gateway(@RequestBody ExpressionEntity expressionEntity) {
        log.info("this.is.演示示例网关路由------------");
        log.info("expressionEntity:{}", JacksonUtil.toJSONString(expressionEntity));
        return BigDecimal.valueOf(3.1415926);
    }
}