package com.netwisd.biz.demo.controller.expression;

import com.netwisd.base.wf.starter.controller.WfExpressionController;
import com.netwisd.base.wf.starter.event.ExecutionEntity;
import com.netwisd.common.core.annotation.App;
import com.netwisd.common.core.util.JacksonUtil;
import com.netwisd.common.core.util.Result;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping("/wfExpressionExecution")
@AllArgsConstructor
@Tag(name = "工作流Exe事件接口", description = "工作流Exe事件接口Controller")
@App(appCode = "demo")
public class WfExpressionExecutionController extends WfExpressionController<WfExpressionExecutionController> {


    @Operation(summary = "演示执行表达式")
    @RequestMapping(value = "/demo1", method = RequestMethod.POST)
    public Result<Integer> demo1(@RequestBody ExecutionEntity executionEntity) {
        log.info("this.is.演示执行表达式------------");
        log.info("taskEntity:{}", JacksonUtil.toJSONString(executionEntity));
        return Result.success(123);
    }
}