package com.netwisd.biz.demo.controller.expression;

import com.netwisd.base.wf.starter.controller.WfExpressionController;
import com.netwisd.base.wf.starter.expression.ExpressionEntity;
import com.netwisd.common.core.annotation.App;
import com.netwisd.common.core.util.JacksonUtil;
import com.netwisd.pojo.mdm.constants.MdmConstants;
import com.netwisd.pojo.mdm.vo.UserExpressionVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

@Slf4j
@RestController
@RequestMapping("/wfExpressionUser")
@AllArgsConstructor
@Tag(name = "工作流人员表达式接口", description = "工作流人员表达式接口Controller")
@App(appCode = "demo")
public class WfExpressionUserController extends WfExpressionController<WfExpressionUserController> {

    @GetMapping(value = "/getUserByUserIds")
    @Operation(summary = "演示人员选择表达式")
    @Parameters({
            @Parameter(name = "userIds", description = "人员Ids", example = MdmConstants.USER_EXPRE, required = true),
            @Parameter(name = "deptIds", description = "部门IDS", example = MdmConstants.DEPT_EXPRE, required = true),
            @Parameter(name = "expressionEntity", description = "表达式调用的基本参数实体", example = MdmConstants.CUSTOM_EXPRE, hidden = true)
    })
    public List<UserExpressionVO> getUserByUserIds(@RequestParam(value = "userIds") String userIds, @RequestParam(value = "deptIds") String deptIds, ExpressionEntity expressionEntity) {
        log.info("this.is.演示人员选择表达式----------");
        log.info("userIds:{}", userIds);
        log.info("deptIds:{}", deptIds);
        log.info("expressionEntity:{}", JacksonUtil.toJSONString(expressionEntity));

        List<UserExpressionVO> userExpressionVOList = new ArrayList<>();
        UserExpressionVO userExpressionVO = new UserExpressionVO();
        userExpressionVO.setId(0L);
        userExpressionVO.setUserName("admin");
        userExpressionVO.setUserNameCh("超级管理员");
        userExpressionVO.setOrgId(1709549317002551298L);
        userExpressionVO.setOrgName("技术部");
        userExpressionVO.setInstitutionId(1709549246521466882L);
        userExpressionVO.setInstitutionName("云数网讯");
        userExpressionVOList.add(userExpressionVO);
        return userExpressionVOList;
    }
}