
package com.netwisd.biz.demo.dto;

import com.netwisd.common.core.annotation.Valid;
import com.netwisd.common.core.constants.Args;
import com.netwisd.pojo.common.dto.IDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.EqualsAndHashCode;
import com.netwisd.common.core.util.IdTypeDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.LocalDateTime;

/**
 * @Description 商品
 * @author incoder@netwisd.com
 * @date 2024-04-30 16:07:27
 */
@Data
@Schema(name = "商品Dto")
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = false)
public class ProductDto extends IDto{

    public ProductDto(Args args){
        super(args);
    }

    /**
     * code
     * 商品编码
     */
    @Valid(length = 255, nullMsg="商品编码不能为空")
    @Schema(description="商品编码")
    private String code;

    /**
     * name
     * 商品名称
     */
    @Valid(length = 255, nullMsg="商品名称不能为空")
    @Schema(description="商品名称")
    private String name;

    /**
     * batch_number
     * 批次号
     */
    @Valid(length = 255, nullMsg="批次号不能为空")
    @Schema(description="批次号")
    private String batchNumber;
}
