
package com.netwisd.biz.demo.dto;

import com.netwisd.common.core.annotation.Valid;
import com.netwisd.common.core.constants.Args;
import com.netwisd.pojo.wf.dto.WfDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.EqualsAndHashCode;
import java.math.BigDecimal;
import com.netwisd.common.core.util.IdTypeDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.netwisd.common.db.annotation.Fk;
import com.netwisd.common.db.annotation.Map;
import java.time.LocalDateTime;

/**
 * @Description 采购申请单详情
 * @author incoder@netwisd.com
 * @date 2024-04-30 16:24:48
 */
@Data
@Map("incloud_biz_demo_purchase_detail")
@Schema(name = "采购申请单详情 Dto")
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = false)
public class PurchaseDetailDto extends WfDto{

    public PurchaseDetailDto(Args args){
        super(args);
    }

    /**
     * purchase_id
     * 采购单ID
     */
    @JsonDeserialize(using = IdTypeDeserializer.class)
    @Fk(table = "incloud_biz_demo_purchase", field = "id")
    @Valid(length = 19, nullMsg="采购单ID不能为空")
    @Schema(description="采购单ID")
    private Long purchaseId;

    /**
     * code
     * 商品编码
     */
    @Valid(length = 255, nullMsg="商品编码不能为空")
    @Schema(description="商品编码")
    private String code;

    /**
     * name
     * 商品名称
     */
    @Valid(length = 255, nullMsg="商品名称不能为空")
    @Schema(description="商品名称")
    private String name;

    /**
     * batch_number
     * 批次号
     */
    @Valid(length = 255, nullMsg="批次号不能为空")
    @Schema(description="批次号")
    private String batchNumber;

    /**
     * price
     * 单品价格
     */
    @Valid(length = 10, nullMsg="单品价格不能为空")
    @Schema(description="单品价格")
    private BigDecimal price;

    /**
     * count
     * 数量
     */
    @Schema(description="数量")
    private Integer count;

    /**
     * sum_price
     * 合计总价
     */
    @Schema(description="合计总价")
    private BigDecimal sumPrice;
    
}
