
package com.netwisd.biz.demo.dto;

import com.netwisd.common.core.annotation.Valid;
import com.netwisd.common.core.constants.Args;
import com.netwisd.pojo.wf.dto.WfDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.EqualsAndHashCode;
import java.math.BigDecimal;
import com.netwisd.common.core.util.IdTypeDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.netwisd.common.db.annotation.Map;
import java.time.LocalDateTime;import java.util.Collections;
import java.util.List;
import com.netwisd.biz.demo.dto.PurchaseDetailDto;

/**
 * @Description 采购申请单
 * @author incoder@netwisd.com
 * @date 2024-04-30 16:24:48
 */
@Data
@Map("incloud_biz_demo_purchase")
@Schema(name = "采购申请单 Dto")
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = false)
public class PurchaseDto extends WfDto{

    public PurchaseDto(Args args){
        super(args);
    }

    /**
     * ser_number
     * 采购单号
     */
    @Valid(length = 10, nullMsg="采购单号不能为空")
    @Schema(description="采购单号")
    private Integer serNumber;

    /**
     * reason
     * 申请原因
     */
    @Valid(length = 255, nullMsg="申请原因不能为空")
    @Schema(description="申请原因")
    private String reason;

    /**
     * count
     * 采购数量
     */
    @Valid(length = 10, nullMsg="采购数量不能为空")
    @Schema(description="采购数量")
    private Integer count;

    /**
     * apply_time
     * 申请时间
     */
    @Valid(length = 0, nullMsg="申请时间不能为空")
    @Schema(description="申请时间")
    private LocalDateTime applyTime;

    /**
     * type
     * 采购类型
     */
    @Valid(length = 10, nullMsg="采购类型不能为空")
    @Schema(description="采购类型")
    private Integer type;

    /**
     * sum_price
     * 采购总价
     */
    @Valid(length = 10, nullMsg="采购总价不能为空")
    @Schema(description="采购总价")
    private BigDecimal sumPrice;

    /**
     * remark
     * 备注
     */
    @Schema(description="备注")
    private String remark;
    
    @Schema(description="purchaseDetailList")
    private List<PurchaseDetailDto> purchaseDetailList = Collections.emptyList();
}
