
package com.netwisd.biz.demo.dto;

import com.netwisd.common.core.annotation.Valid;
import com.netwisd.common.core.constants.Args;
import com.netwisd.pojo.common.dto.IDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.EqualsAndHashCode;
import com.netwisd.common.core.util.IdTypeDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.netwisd.common.db.annotation.Fk;
import com.netwisd.common.db.annotation.Map;
import java.time.LocalDateTime;

/**
 * @Description 测试子表1
 * @author incoder@netwisd.com
 * @date 2024-04-30 14:24:43
 */
@Data
@Map("incloud_biz_demo_test_detail")
@Schema(name = "测试子表1 Dto")
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = false)
public class TestDetailDto extends IDto{

    public TestDetailDto(Args args){
        super(args);
    }

    /**
     * test_id
     * 主表ID
     */
    @JsonDeserialize(using = IdTypeDeserializer.class)
    @Fk(table = "incloud_biz_demo_test", field = "id")
    @Valid(length = 19, nullMsg="主表ID不能为空")
    @Schema(description="主表ID")
    private Long testId;

    /**
     * test_detail_name
     * 子表名称
     */
    @Valid(length = 255, nullMsg="子表名称不能为空")
    @Schema(description="子表名称")
    private String testDetailName;

    /**
     * test_detail_code
     * 子表编码
     */
    @Valid(length = 255, nullMsg="子表编码不能为空")
    @Schema(description="子表编码")
    private String testDetailCode;

    /**
     * sort
     * 排序
     */
    @Schema(description="排序")
    private Integer sort;
    
}
