
package com.netwisd.biz.demo.dto;

import com.netwisd.common.core.annotation.Valid;
import com.netwisd.common.core.constants.Args;
import com.netwisd.common.db.annotation.Map;
import com.netwisd.pojo.common.dto.IDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;

/**
 * @author incoder@netwisd.com
 * @Description 测试主表
 * @date 2024-04-30 14:24:43
 */
@Data
@Map("incloud_biz_demo_test")
@Schema(name = "测试主表 Dto")
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = false)
public class TestDto extends IDto {

    public TestDto(Args args) {
        super(args);
    }

    /**
     * test_name
     * 测试名称
     */
    @Valid(length = 255, nullMsg = "测试名称不能为空")
    @Schema(description = "测试名称")
    private String testName;

    /**
     * test_code
     * 测试编码
     */
    @Valid(length = 255, nullMsg = "测试编码不能为空")
    @Schema(description = "测试编码")
    private String testCode;

    /**
     * fill_time
     * 填报时间
     */
    @Schema(description = "填报时间")
    private LocalDateTime fillTime;

    /**
     * explanation
     * 备注
     */
    @Schema(description = "备注")
    private String explanation;

    @Schema(description = "testDetailList")
    private List<TestDetailDto> testDetailList = Collections.emptyList();
}
