
package com.netwisd.biz.demo.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.netwisd.common.db.annotation.Column;
import com.netwisd.common.db.annotation.Table;
import com.netwisd.common.db.data.DataType;
import com.netwisd.common.db.data.IModel;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.time.LocalDateTime;
/**
 * @Description 商品
 * @author incoder@netwisd.com
 * @date 2024-04-30 16:07:27
 */
@Data
@Table(value = "incloud_biz_demo_product",comment = "商品")
@TableName("incloud_biz_demo_product")
@EqualsAndHashCode(callSuper = true)
@Schema(name = "商品 Entity")
public class Product extends IModel<Product> {

    /**
     * code
     * 商品编码
     */
    @Schema(description="商品编码")
    @TableField(value="code")
    @Column(type=DataType.VARCHAR, length=255, isNull=false, comment="商品编码")
    private String code;

    /**
     * name
     * 商品名称
     */
    @Schema(description="商品名称")
    @TableField(value="name")
    @Column(type=DataType.VARCHAR, length=255, isNull=false, comment="商品名称")
    private String name;

    /**
     * batch_number
     * 批次号
     */
    @Schema(description="批次号")
    @TableField(value="batch_number")
    @Column(type=DataType.VARCHAR, length=255, isNull=false, comment="批次号")
    private String batchNumber;
}
