
package com.netwisd.biz.demo.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.netwisd.common.db.annotation.Column;
import com.netwisd.common.db.annotation.Table;
import com.netwisd.common.db.data.DataType;
import com.netwisd.base.wf.starter.entitiy.WfEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.time.LocalDateTime;
import java.math.BigDecimal;

/**
 * @Description 采购申请单
 * @author incoder@netwisd.com
 * @date 2024-04-30 16:24:48
 */
@Data
@Table(value = "incloud_biz_demo_purchase",comment = "采购申请单")
@TableName("incloud_biz_demo_purchase")
@EqualsAndHashCode(callSuper = true)
@Schema(name = "采购申请单 Entity")
public class Purchase extends WfEntity<Purchase> {

    /**
     * ser_number
     * 采购单号
     */
    @Schema(description="采购单号")
    @TableField(value="ser_number")
    @Column(type=DataType.INT, length=10, isNull=false, comment="采购单号")
    private Integer serNumber;

    /**
     * reason
     * 申请原因
     */
    @Schema(description="申请原因")
    @TableField(value="reason")
    @Column(type=DataType.VARCHAR, length=255, isNull=false, comment="申请原因")
    private String reason;

    /**
     * count
     * 采购数量
     */
    @Schema(description="采购数量")
    @TableField(value="count")
    @Column(type=DataType.INT, length=10, isNull=false, comment="采购数量")
    private Integer count;

    /**
     * apply_time
     * 申请时间
     */
    @Schema(description="申请时间")
    @TableField(value="apply_time")
    @Column(type=DataType.DATETIME, length=0, isNull=false, comment="申请时间")
    private LocalDateTime applyTime;

    /**
     * type
     * 采购类型
     */
    @Schema(description="采购类型")
    @TableField(value="type")
    @Column(type=DataType.INT, length=10, isNull=false, comment="采购类型")
    private Integer type;

    /**
     * sum_price
     * 采购总价
     */
    @Schema(description="采购总价")
    @TableField(value="sum_price")
    @Column(type=DataType.DECIMAL, length=10, precision=2, isNull=false, comment="采购总价")
    private BigDecimal sumPrice;

    /**
     * remark
     * 备注
     */
    @Schema(description="备注")
    @TableField(value="remark")
    @Column(type=DataType.VARCHAR, length=255, isNull=true, comment="备注")
    private String remark;
}
