
package com.netwisd.biz.demo.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.netwisd.common.db.annotation.Column;
import com.netwisd.common.db.annotation.Table;
import com.netwisd.common.db.data.DataType;
import com.netwisd.base.wf.starter.entitiy.WfEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.time.LocalDateTime;
import java.math.BigDecimal;

/**
 * @Description 采购申请单详情
 * @author incoder@netwisd.com
 * @date 2024-04-30 16:24:48
 */
@Data
@Table(value = "incloud_biz_demo_purchase_detail",comment = "采购申请单详情")
@TableName("incloud_biz_demo_purchase_detail")
@EqualsAndHashCode(callSuper = true)
@Schema(name = "采购申请单详情 Entity")
public class PurchaseDetail extends WfEntity<PurchaseDetail> {

    /**
     * purchase_id
     * 采购单ID
     */
    @Schema(description="采购单ID")
    @TableField(value="purchase_id")
    @Column(type=DataType.BIGINT, length=19, isNull=false, comment="采购单ID")
    private Long purchaseId;

    /**
     * code
     * 商品编码
     */
    @Schema(description="商品编码")
    @TableField(value="code")
    @Column(type=DataType.VARCHAR, length=255, isNull=false, comment="商品编码")
    private String code;

    /**
     * name
     * 商品名称
     */
    @Schema(description="商品名称")
    @TableField(value="name")
    @Column(type=DataType.VARCHAR, length=255, isNull=false, comment="商品名称")
    private String name;

    /**
     * batch_number
     * 批次号
     */
    @Schema(description="批次号")
    @TableField(value="batch_number")
    @Column(type=DataType.VARCHAR, length=255, isNull=false, comment="批次号")
    private String batchNumber;

    /**
     * price
     * 单品价格
     */
    @Schema(description="单品价格")
    @TableField(value="price")
    @Column(type=DataType.DECIMAL, length=10, precision=2, isNull=false, comment="单品价格")
    private BigDecimal price;

    /**
     * count
     * 数量
     */
    @Schema(description="数量")
    @TableField(value="count")
    @Column(type=DataType.INT, length=10, isNull=true, comment="数量")
    private Integer count;

    /**
     * sum_price
     * 合计总价
     */
    @Schema(description="合计总价")
    @TableField(value="sum_price")
    @Column(type=DataType.DECIMAL, length=10, precision=2, isNull=true, comment="合计总价")
    private BigDecimal sumPrice;
}
