
package com.netwisd.biz.demo.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.netwisd.common.db.annotation.Column;
import com.netwisd.common.db.annotation.Table;
import com.netwisd.common.db.data.DataType;
import com.netwisd.common.db.data.IModel;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.time.LocalDateTime;
/**
 * @Description 测试主表
 * @author incoder@netwisd.com
 * @date 2024-04-30 14:24:43
 */
@Data
@Table(value = "incloud_biz_demo_test",comment = "测试主表")
@TableName("incloud_biz_demo_test")
@EqualsAndHashCode(callSuper = true)
@Schema(name = "测试主表 Entity")
public class Test extends IModel<Test> {

    /**
     * test_name
     * 测试名称
     */
    @Schema(description="测试名称")
    @TableField(value="test_name")
    @Column(type=DataType.VARCHAR, length=255, isNull=false, comment="测试名称")
    private String testName;

    /**
     * test_code
     * 测试编码
     */
    @Schema(description="测试编码")
    @TableField(value="test_code")
    @Column(type=DataType.VARCHAR, length=255, isNull=false, comment="测试编码")
    private String testCode;

    /**
     * fill_time
     * 填报时间
     */
    @Schema(description="填报时间")
    @TableField(value="fill_time")
    @Column(type=DataType.DATETIME, length=0, isNull=true, comment="填报时间")
    private LocalDateTime fillTime;

    /**
     * explanation
     * 备注
     */
    @Schema(description="备注")
    @TableField(value="explanation")
    @Column(type=DataType.VARCHAR, length=500, isNull=true, comment="备注")
    private String explanation;
}
