
package com.netwisd.biz.demo.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.netwisd.common.db.annotation.Column;
import com.netwisd.common.db.annotation.Table;
import com.netwisd.common.db.data.DataType;
import com.netwisd.common.db.data.IModel;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.time.LocalDateTime;
/**
 * @Description 测试子表1
 * @author incoder@netwisd.com
 * @date 2024-04-30 14:24:43
 */
@Data
@Table(value = "incloud_biz_demo_test_detail",comment = "测试子表1")
@TableName("incloud_biz_demo_test_detail")
@EqualsAndHashCode(callSuper = true)
@Schema(name = "测试子表1 Entity")
public class TestDetail extends IModel<TestDetail> {

    /**
     * test_id
     * 主表ID
     */
    @Schema(description="主表ID")
    @TableField(value="test_id")
    @Column(type=DataType.BIGINT, length=19, isNull=false, comment="主表ID")
    private Long testId;

    /**
     * test_detail_name
     * 子表名称
     */
    @Schema(description="子表名称")
    @TableField(value="test_detail_name")
    @Column(type=DataType.VARCHAR, length=255, isNull=false, comment="子表名称")
    private String testDetailName;

    /**
     * test_detail_code
     * 子表编码
     */
    @Schema(description="子表编码")
    @TableField(value="test_detail_code")
    @Column(type=DataType.VARCHAR, length=255, isNull=false, comment="子表编码")
    private String testDetailCode;

    /**
     * sort
     * 排序
     */
    @Schema(description="排序")
    @TableField(value="sort")
    @Column(type=DataType.INT, length=10, isNull=true, comment="排序")
    private Integer sort;
}
