
package com.netwisd.biz.demo.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.netwisd.base.wf.starter.service.impl.WfServiceImpl;
import com.netwisd.biz.demo.entity.PurchaseDetail;
import com.netwisd.biz.demo.mapper.PurchaseDetailMapper;
import com.netwisd.biz.demo.service.PurchaseDetailService;
import org.springframework.stereotype.Service;
import com.github.dozermapper.core.Mapper;
import com.netwisd.common.core.util.DozerUtils;
import com.netwisd.biz.demo.dto.PurchaseDetailDto;
import com.netwisd.biz.demo.vo.PurchaseDetailVo;
import org.springframework.transaction.annotation.Transactional;
import lombok.extern.slf4j.Slf4j;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import com.netwisd.common.db.util.EntityListConvert;
import lombok.RequiredArgsConstructor;
import com.netwisd.biz.demo.dto.PurchaseDto;

/**
 * @Description 采购申请单详情
 * @author incoder@netwisd.com
 * @date 2024-04-30 16:24:48
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class PurchaseDetailServiceImpl extends WfServiceImpl<PurchaseDetailMapper, PurchaseDetail, PurchaseDetailDto , PurchaseDetailVo> implements PurchaseDetailService {

    private final Mapper dozerMapper;
    @Override
    public void saveByParent(PurchaseDto PurchaseDto) {
        List<PurchaseDetailDto> purchaseDetailList = PurchaseDto.getPurchaseDetailList();
        //根据主实体DTO映射其子表的关联键为其赋值
        EntityListConvert.convert(PurchaseDto,purchaseDetailList);
        //调用保存子表的集合方法
        super.saveBatch(DozerUtils.mapList(dozerMapper, purchaseDetailList, PurchaseDetail.class));
    }

    @Override
    public void updateByParent(PurchaseDto PurchaseDto) {
        List<PurchaseDetailDto> purchaseDetailList = PurchaseDto.getPurchaseDetailList();
        //根据主实体DTO映射其子表的关联键为其赋值
        EntityListConvert.convert(PurchaseDto,purchaseDetailList);
        //调用更新方法
        super.saveOrUpdateOrDeleteBatch(Wrappers.<PurchaseDetail>lambdaQuery()
                .eq(ObjectUtil.isNotEmpty(PurchaseDto.getId()), PurchaseDetail::getPurchaseId, PurchaseDto.getId())
                ,DozerUtils.mapList(dozerMapper, purchaseDetailList, PurchaseDetail.class));
    }

    /**
     * 通过外建删除
     * @param id
     * @return
     */
    @Override
    public Boolean deleteByFkId(Long id){
        LambdaQueryWrapper<PurchaseDetail> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ObjectUtil.isNotEmpty(id), PurchaseDetail::getPurchaseId, id);
        return remove(queryWrapper);
    }

    /**
     * 通过外建获取
     * @param id
     * @return
     */
    @Override
    public List<PurchaseDetailVo> getByFkIdVo(Long id){
        LambdaQueryWrapper<PurchaseDetail> queryWrapper = Wrappers.lambdaQuery();queryWrapper.eq(ObjectUtil.isNotEmpty(id), PurchaseDetail::getPurchaseId, id);
        List<PurchaseDetailVo> purchaseDetailVos = DozerUtils.mapList(dozerMapper, this.list(queryWrapper), PurchaseDetailVo.class);
        return purchaseDetailVos;
    }
}
