
package com.netwisd.biz.demo.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.netwisd.base.wf.starter.service.impl.WfServiceImpl;
import com.netwisd.biz.demo.entity.Purchase;
import com.netwisd.biz.demo.mapper.PurchaseMapper;
import com.netwisd.biz.demo.service.PurchaseService;
import org.springframework.stereotype.Service;
import com.github.dozermapper.core.Mapper;
import com.netwisd.common.core.util.DozerUtils;
import com.netwisd.biz.demo.dto.PurchaseDto;
import com.netwisd.biz.demo.vo.PurchaseVo;
import org.springframework.transaction.annotation.Transactional;
import lombok.extern.slf4j.Slf4j;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import com.netwisd.common.db.util.EntityListConvert;
import lombok.RequiredArgsConstructor;
import com.netwisd.biz.demo.service.PurchaseDetailService;
import com.netwisd.biz.demo.entity.PurchaseDetail;
import com.netwisd.biz.demo.vo.PurchaseDetailVo;

/**
 * @Description 采购申请单
 * @author incoder@netwisd.com
 * @date 2024-04-30 16:24:48
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class PurchaseServiceImpl extends WfServiceImpl<PurchaseMapper, Purchase, PurchaseDto , PurchaseVo> implements PurchaseService {

    private final Mapper dozerMapper;
    private final PurchaseDetailService purchaseDetailService;
    /**
    * 单表简单查询操作
    * @param purchaseDto
    * @return
    */
    @Override
    public Page<PurchaseVo> page(PurchaseDto purchaseDto) {
        return DozerUtils.mapPage(dozerMapper, super.page(purchaseDto.getPage(),query(purchaseDto)), PurchaseVo.class);
    }

    /**
     * 查询条件构造器
     * @param purchaseDto
     * @return
     */
    public LambdaQueryWrapper<Purchase> query(PurchaseDto purchaseDto){
        return Wrappers.<Purchase>lambdaQuery().apply(StrUtil.isNotEmpty( purchaseDto.getDataPermissionSql()),  purchaseDto.getDataPermissionSql());

    }

    /**
     * 通过ID查询实体
     * @param id
     * @return
     */
    @Override
    public PurchaseVo get(Long id) {
        Purchase purchase = super.getById(id);
        if(ObjectUtil.isEmpty(purchase)){return null;}
        PurchaseVo purchaseVo = dozerMapper.map(purchase,PurchaseVo.class);
        purchaseVo.setPurchaseDetailList(purchaseDetailService.getByFkIdVo(id));
        return purchaseVo;
    }

    /**
    * 保存实体
    * @param purchaseDto
    * @return PurchaseVo
    */
    @Transactional
    @Override
    public PurchaseVo save(PurchaseDto purchaseDto) {
        super.save(dozerMapper.map(purchaseDto,Purchase.class));
        purchaseDetailService.saveByParent(purchaseDto);
        return get(purchaseDto.getId());
    }

    /**
     * 修改实体
     * @param purchaseDto
     * @return PurchaseVo
     */
    @Transactional
    @Override
    public PurchaseVo update(PurchaseDto purchaseDto) {
        purchaseDto.setUpdateTime(LocalDateTime.now());
        super.updateById(dozerMapper.map(purchaseDto,Purchase.class));
        purchaseDetailService.updateByParent(purchaseDto);
        return get(purchaseDto.getId());
    }

    /**
    * 通过ID删除
    * @param id
    * @return
    */
    @Transactional
    @Override
    public Boolean delete(Long id) {
        purchaseDetailService.deleteByFkId(id);
        return super.removeById(id);
    }

    /**
    * 流程删除数据
    * @param procInstId
    * @return
    */
    @Override
    @Transactional
    public Boolean deleteByProcess(String procInstId) {
        Purchase purchase = getByProcInstId(procInstId);
        purchaseDetailService.deleteByFkId(purchase.getId());
        return super.deleteByProcess(procInstId, purchase);
    }

}
