
package com.netwisd.biz.demo.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.netwisd.common.db.data.IncloudServiceImpl;
import com.netwisd.biz.demo.entity.TestDetail;
import com.netwisd.biz.demo.mapper.TestDetailMapper;
import com.netwisd.biz.demo.service.TestDetailService;
import org.springframework.stereotype.Service;
import com.github.dozermapper.core.Mapper;
import com.netwisd.common.core.util.DozerUtils;
import com.netwisd.biz.demo.dto.TestDetailDto;
import com.netwisd.biz.demo.vo.TestDetailVo;
import org.springframework.transaction.annotation.Transactional;
import lombok.extern.slf4j.Slf4j;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import com.netwisd.common.db.util.EntityListConvert;
import lombok.RequiredArgsConstructor;
import com.netwisd.biz.demo.dto.TestDto;

/**
 * @Description 测试子表1
 * @author incoder@netwisd.com
 * @date 2024-04-30 14:24:43
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class TestDetailServiceImpl extends IncloudServiceImpl<TestDetailMapper, TestDetail, TestDetailDto , TestDetailVo> implements TestDetailService {

    private final Mapper dozerMapper;
    @Override
    public void saveByParent(TestDto TestDto) {
        List<TestDetailDto> testDetailList = TestDto.getTestDetailList();
        //根据主实体DTO映射其子表的关联键为其赋值
        EntityListConvert.convert(TestDto,testDetailList);
        //调用保存子表的集合方法
        super.saveBatch(DozerUtils.mapList(dozerMapper, testDetailList, TestDetail.class));
    }

    @Override
    public void updateByParent(TestDto TestDto) {
        List<TestDetailDto> testDetailList = TestDto.getTestDetailList();
        //根据主实体DTO映射其子表的关联键为其赋值
        EntityListConvert.convert(TestDto,testDetailList);
        //调用更新方法
        super.saveOrUpdateOrDeleteBatch(Wrappers.<TestDetail>lambdaQuery()
                .eq(ObjectUtil.isNotEmpty(TestDto.getId()), TestDetail::getTestId, TestDto.getId())
                ,DozerUtils.mapList(dozerMapper, testDetailList, TestDetail.class));}

    /**
     * 通过外建删除
     * @param id
     * @return
     */
    @Override
    public Boolean deleteByFkId(Long id){
        LambdaQueryWrapper<TestDetail> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ObjectUtil.isNotEmpty(id), TestDetail::getTestId, id);
        return remove(queryWrapper);
    }

    /**
     * 通过外建获取
     * @param id
     * @return
     */
    @Override
    public List<TestDetailVo> getByFkIdVo(Long id){
        LambdaQueryWrapper<TestDetail> queryWrapper = Wrappers.lambdaQuery();queryWrapper.eq(ObjectUtil.isNotEmpty(id), TestDetail::getTestId, id);
        List<TestDetailVo> testDetailVos = DozerUtils.mapList(dozerMapper, this.list(queryWrapper), TestDetailVo.class);
        return testDetailVos;
    }
}
