
package com.netwisd.biz.demo.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.netwisd.common.db.data.IncloudServiceImpl;
import com.netwisd.biz.demo.entity.Test;
import com.netwisd.biz.demo.mapper.TestMapper;
import com.netwisd.biz.demo.service.TestService;
import org.springframework.stereotype.Service;
import com.github.dozermapper.core.Mapper;
import com.netwisd.common.core.util.DozerUtils;
import com.netwisd.biz.demo.dto.TestDto;
import com.netwisd.biz.demo.vo.TestVo;
import org.springframework.transaction.annotation.Transactional;
import lombok.extern.slf4j.Slf4j;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import com.netwisd.common.db.util.EntityListConvert;
import lombok.RequiredArgsConstructor;
import com.netwisd.biz.demo.service.TestDetailService;
import com.netwisd.biz.demo.vo.TestDetailVo;

/**
 * @Description 测试主表
 * @author incoder@netwisd.com
 * @date 2024-04-30 14:24:43
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class TestServiceImpl extends IncloudServiceImpl<TestMapper, Test, TestDto , TestVo> implements TestService {

    private final Mapper dozerMapper;
    private final TestDetailService testDetailService;
    /**
    * 单表简单查询操作
    * @param testDto
    * @return
    */
    @Override
    public Page<TestVo> page(TestDto testDto) {
        return DozerUtils.mapPage(dozerMapper, super.page(testDto.getPage(),query(testDto)), TestVo.class);
    }

    /**
     * 查询条件构造器
     * @param testDto
     * @return
     */
    public LambdaQueryWrapper<Test> query(TestDto testDto){
        return Wrappers.<Test>lambdaQuery().apply(StrUtil.isNotEmpty( testDto.getDataPermissionSql()),  testDto.getDataPermissionSql());

    }

    /**
     * 通过ID查询实体
     * @param id
     * @return
     */
    @Override
    public TestVo get(Long id) {
        Test test = super.getById(id);
        if(ObjectUtil.isEmpty(test)){return null;}
        TestVo testVo = dozerMapper.map(test,TestVo.class);
        testVo.setTestDetailList(testDetailService.getByFkIdVo(id));
        return testVo;
    }

    /**
    * 保存实体
    * @param testDto
    * @return TestVo
    */
    @Transactional
    @Override
    public TestVo save(TestDto testDto) {
        super.save(dozerMapper.map(testDto,Test.class));
        testDetailService.saveByParent(testDto);
        return get(testDto.getId());
    }

    /**
     * 修改实体
     * @param testDto
     * @return TestVo
     */
    @Transactional
    @Override
    public TestVo update(TestDto testDto) {
        testDto.setUpdateTime(LocalDateTime.now());
        super.updateById(dozerMapper.map(testDto,Test.class));
        testDetailService.updateByParent(testDto);
        return get(testDto.getId());
    }

    /**
    * 通过ID删除
    * @param id
    * @return
    */
    @Transactional
    @Override
    public Boolean delete(Long id) {
        testDetailService.deleteByFkId(id);
        return super.removeById(id);
    }

}
