
package com.netwisd.biz.demo.vo;

import com.netwisd.pojo.wf.vo.WfVo;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import java.math.BigDecimal;

import com.netwisd.common.core.util.IdTypeSerializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.LocalDateTime;
import java.util.List;


/**
 * @Description 采购申请单详情
 * @author incoder@netwisd.com
 * @date 2024-04-30 16:24:48
 */
@Data
@Schema(name = "采购申请单详情 Vo")
public class PurchaseDetailVo extends WfVo{

    /**
     * purchase_id
     * 采购单ID
     */
    @JsonSerialize(using = IdTypeSerializer.class)
    @Schema(description="采购单ID")
    private Long purchaseId;

    /**
     * code
     * 商品编码
     */
    @Schema(description="商品编码")
    private String code;

    /**
     * name
     * 商品名称
     */
    @Schema(description="商品名称")
    private String name;

    /**
     * batch_number
     * 批次号
     */
    @Schema(description="批次号")
    private String batchNumber;

    /**
     * price
     * 单品价格
     */
    @Schema(description="单品价格")
    private BigDecimal price;

    /**
     * count
     * 数量
     */
    @Schema(description="数量")
    private Integer count;

    /**
     * sum_price
     * 合计总价
     */
    @Schema(description="合计总价")
    private BigDecimal sumPrice;

    
}
