
package com.netwisd.biz.demo.vo;

import com.netwisd.pojo.wf.vo.WfVo;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import java.math.BigDecimal;

import com.netwisd.common.core.util.IdTypeSerializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.LocalDateTime;
import java.util.List;
import com.netwisd.biz.demo.vo.PurchaseDetailVo;

/**
 * @Description 采购申请单
 * @author incoder@netwisd.com
 * @date 2024-04-30 16:24:48
 */
@Data
@Schema(name = "采购申请单 Vo")
public class PurchaseVo extends WfVo{

    /**
     * ser_number
     * 采购单号
     */
    @Schema(description="采购单号")
    private Integer serNumber;

    /**
     * reason
     * 申请原因
     */
    @Schema(description="申请原因")
    private String reason;

    /**
     * count
     * 采购数量
     */
    @Schema(description="采购数量")
    private Integer count;

    /**
     * apply_time
     * 申请时间
     */
    @Schema(description="申请时间")
    private LocalDateTime applyTime;

    /**
     * type
     * 采购类型
     */
    @Schema(description="采购类型")
    private Integer type;

    /**
     * sum_price
     * 采购总价
     */
    @Schema(description="采购总价")
    private BigDecimal sumPrice;

    /**
     * remark
     * 备注
     */
    @Schema(description="备注")
    private String remark;

    @Schema(description="purchaseDetailList")
    private List<PurchaseDetailVo> purchaseDetailList;
}
