
package com.netwisd.biz.demo.vo;

import com.netwisd.common.core.vo.IVo;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import com.netwisd.common.core.util.IdTypeSerializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.LocalDateTime;
import java.util.List;


/**
 * @Description 测试子表1
 * @author incoder@netwisd.com
 * @date 2024-04-30 14:24:43
 */
@Data
@Schema(name = "测试子表1 Vo")
public class TestDetailVo extends IVo{

    /**
     * test_id
     * 主表ID
     */
    @JsonSerialize(using = IdTypeSerializer.class)
    @Schema(description="主表ID")
    private Long testId;

    /**
     * test_detail_name
     * 子表名称
     */
    @Schema(description="子表名称")
    private String testDetailName;

    /**
     * test_detail_code
     * 子表编码
     */
    @Schema(description="子表编码")
    private String testDetailCode;

    /**
     * sort
     * 排序
     */
    @Schema(description="排序")
    private Integer sort;

    
}
