
package com.netwisd.biz.demo.vo;

import com.netwisd.common.core.vo.IVo;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import com.netwisd.common.core.util.IdTypeSerializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.LocalDateTime;
import java.util.List;
import com.netwisd.biz.demo.vo.TestDetailVo;

/**
 * @Description 测试主表
 * @author incoder@netwisd.com
 * @date 2024-04-30 14:24:43
 */
@Data
@Schema(name = "测试主表 Vo")
public class TestVo extends IVo{

    /**
     * test_name
     * 测试名称
     */
    @Schema(description="测试名称")
    private String testName;

    /**
     * test_code
     * 测试编码
     */
    @Schema(description="测试编码")
    private String testCode;

    /**
     * fill_time
     * 填报时间
     */
    @Schema(description="填报时间")
    private LocalDateTime fillTime;

    /**
     * explanation
     * 备注
     */
    @Schema(description="备注")
    private String explanation;

    @Schema(description="testDetailList")
    private List<TestDetailVo> testDetailList;
}
