/*
 Navicat Premium Data Transfer

 Source Server         : 192.168.20.128_mysql
 Source Server Type    : MySQL
 Source Server Version : 80100
 Source Host           : 192.168.20.128:3306
 Source Schema         : incloud5

 Target Server Type    : MySQL
 Target Server Version : 80100
 File Encoding         : 65001

 Date: 23/11/2023 18:19:55
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for incloud_base_app_application
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_app_application`;
CREATE TABLE `incloud_base_app_application`  (
  `id` bigint NOT NULL COMMENT '主键',
  `code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '编码',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '名称',
  `icon` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '图标',
  `sort` int NOT NULL COMMENT '排序',
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '应用描述',
  `pool_name` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '数据源',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  `pool_id` bigint NOT NULL COMMENT '数据源ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '微应用管理' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_app_application
-- ----------------------------
INSERT INTO `incloud_base_app_application` VALUES (1688812003631738882, 'taskManager', '任务中心', 'icon-n-n-shijianguanli', 2, NULL, 'master', '2023-08-08 15:18:53', '2023-08-08 15:18:53', 1, 'admin', '0', 0, 'root', 1661720027937050625);
INSERT INTO `incloud_base_app_application` VALUES (1727632910883581954, 'demo', '演示系统', 'icon-a-mainapplication', 1, NULL, 'master', '2023-11-23 18:19:18', '2023-11-23 18:19:18', 1, 'admin', '0', 0, 'root', 1690202859793518594);

-- ----------------------------
-- Table structure for incloud_base_app_application_authority
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_app_application_authority`;
CREATE TABLE `incloud_base_app_application_authority`  (
  `id` bigint NOT NULL COMMENT '主键',
  `app_id` bigint NOT NULL COMMENT '应用id',
  `user_id` bigint NOT NULL COMMENT '授权的用户ID',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_app_application_authority
-- ----------------------------

-- ----------------------------
-- Table structure for incloud_base_center_done
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_center_done`;
CREATE TABLE `incloud_base_center_done`  (
  `id` bigint NOT NULL COMMENT '主键',
  `task_start_time` datetime NULL DEFAULT NULL COMMENT '任务发起时间',
  `task_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '任务名称',
  `task_start_userid` bigint NULL DEFAULT NULL COMMENT '任务发起人',
  `task_start_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '任务发起人',
  `task_receive_person_type` int NULL DEFAULT NULL COMMENT '任务接收人类型 1人2角色3职位4岗位',
  `task_receive_person_id` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '任务接收人,角色、职位、岗位存储的是Code码',
  `task_receive_person_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '任务接收人',
  `task_todo_person_id` bigint NULL DEFAULT NULL COMMENT '任务办理人',
  `task_todo_person_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '任务办理人',
  `task_todo_org_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '任务办理机构',
  `task_todo_org_id` bigint NULL DEFAULT NULL COMMENT '任务办理机构',
  `task_todo_dept_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '任务办理部门',
  `task_todo_dept_id` bigint NULL DEFAULT NULL COMMENT '任务办理部门',
  `task_minute` bigint NULL DEFAULT NULL COMMENT '办理时长',
  `task_state` int NULL DEFAULT 0 COMMENT '任务状态 0.未开始1处理中2完成3.超期',
  `sys_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '子系统',
  `sys_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '子系统',
  `is_main_task` bigint NULL DEFAULT 0 COMMENT '是否是主任务',
  `task_level` bigint NULL DEFAULT 0 COMMENT '节点级别',
  `task_source` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '任务来源',
  `task_inst_id` bigint NULL DEFAULT NULL COMMENT '任务实例Id',
  `apply_code` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '申请单号',
  `apply_reason` varchar(1024) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '申请说明',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  `task_type` int NULL DEFAULT NULL COMMENT '任务类型1手动2系统',
  `task_end_time` datetime NULL DEFAULT NULL COMMENT '任务结束日期',
  `schedule_type` int NULL DEFAULT NULL COMMENT '日程类型1我的日程2他人日程',
  `task_classify_dict_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '任务分类',
  `task_classify_dict_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '任务分类',
  `priority` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '优先级',
  `participant_person_ids` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '参与人',
  `participant_person_names` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '参与人',
  `task_handle_start_time` datetime NULL DEFAULT NULL COMMENT '任务实际办理开始时间',
  `task_handle_end_time` datetime NULL DEFAULT NULL COMMENT '任务实际办理结束时间',
  `task_node_inst_id` bigint NULL DEFAULT NULL COMMENT '任务节点Id',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '已办任务' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_center_done
-- ----------------------------

-- ----------------------------
-- Table structure for incloud_base_center_done_fun
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_center_done_fun`;
CREATE TABLE `incloud_base_center_done_fun`  (
  `id` bigint NOT NULL COMMENT '主键',
  `task_done_id` bigint NULL DEFAULT NULL COMMENT '已办任务id',
  `func_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '功能类型',
  `fun_unique` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '功能唯一标识',
  `full_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '功能名称',
  `func_param` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL COMMENT '功能参数',
  `camunda_procins_id` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '流程实例Id',
  `camunda_procdef_key` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '流程定义Id',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '已办任务功能' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_center_done_fun
-- ----------------------------

-- ----------------------------
-- Table structure for incloud_base_center_help
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_center_help`;
CREATE TABLE `incloud_base_center_help`  (
  `help_id` int NULL DEFAULT NULL
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_center_help
-- ----------------------------

-- ----------------------------
-- Table structure for incloud_base_center_todo
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_center_todo`;
CREATE TABLE `incloud_base_center_todo`  (
  `id` bigint NOT NULL COMMENT '主键',
  `task_start_time` datetime NULL DEFAULT NULL COMMENT '任务发起时间',
  `task_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '任务名称',
  `task_start_userid` bigint NULL DEFAULT NULL COMMENT '任务发起人',
  `task_start_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '任务发起人',
  `task_source` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '任务来源',
  `task_receive_person_type` int NULL DEFAULT NULL COMMENT '任务接收人类型 1人2角色3职位4岗位',
  `task_receive_person_id` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '任务接收人,角色、职位、岗位存储的是Code码',
  `task_receive_person_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '任务接收人',
  `task_state` int NULL DEFAULT 0 COMMENT '任务状态 0.未开始1处理中2完成3.超期',
  `sys_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '子系统',
  `sys_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '子系统',
  `is_main_task` bigint NULL DEFAULT 0 COMMENT '是否是主任务',
  `task_level` bigint NULL DEFAULT 0 COMMENT '节点级别',
  `task_inst_id` bigint NULL DEFAULT NULL COMMENT '任务实例Id',
  `task_node_inst_id` bigint NULL DEFAULT NULL COMMENT '任务节点Id',
  `apply_code` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '申请单号',
  `apply_reason` varchar(1024) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '申请说明',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  `task_type` int NULL DEFAULT 1 COMMENT '任务类型1手动2系统',
  `task_end_time` datetime NULL DEFAULT NULL COMMENT '任务结束日期',
  `schedule_type` int NULL DEFAULT NULL COMMENT '日程类型1我的日程2他人日程',
  `task_classify_dict_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '任务分类',
  `task_classify_dict_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '任务分类',
  `priority` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '优先级',
  `participant_person_ids` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '参与人',
  `participant_person_names` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '参与人',
  `finish_explain` varchar(900) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '完成说明',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  `participant_org_ids` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '参与组织机构',
  `participant_org_names` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '参与组织机构',
  `participant_contact_group_ids` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '参与联系人组',
  `participant_contact_group_names` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '参与联系人组',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '待办任务' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_center_todo
-- ----------------------------

-- ----------------------------
-- Table structure for incloud_base_center_todo_fun
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_center_todo_fun`;
CREATE TABLE `incloud_base_center_todo_fun`  (
  `id` bigint NOT NULL COMMENT '主键',
  `task_todo_id` bigint NULL DEFAULT NULL COMMENT '待办任务id',
  `fun_unique` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '功能唯一标识',
  `full_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '功能名称',
  `func_param` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL COMMENT '功能参数',
  `func_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '功能类型',
  `camunda_procins_id` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '流程实例Id',
  `camunda_procdef_key` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '流程定义Id',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '待办任务功能' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_center_todo_fun
-- ----------------------------

-- ----------------------------
-- Table structure for incloud_base_center_todo_reminder
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_center_todo_reminder`;
CREATE TABLE `incloud_base_center_todo_reminder`  (
  `id` bigint NOT NULL COMMENT '主键',
  `task_todo_id` bigint NULL DEFAULT NULL COMMENT '待办任务id',
  `reminder_method` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '提醒方式1即时通2短信',
  `reminder_time_type` varchar(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '提醒时间类型',
  `reminder_time` datetime NULL DEFAULT NULL COMMENT '提醒时间',
  `job_id` bigint NULL DEFAULT NULL COMMENT '定时调度任务Id',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  `reminder_user_ids` varchar(1024) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '提醒人',
  `reminder_org_ids` varchar(1024) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '提醒组织',
  `reminder_contact_group_ids` varchar(1024) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '提醒常用联系人组',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '待办任务提醒' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_center_todo_reminder
-- ----------------------------

-- ----------------------------
-- Table structure for incloud_base_cts_contact_group
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_cts_contact_group`;
CREATE TABLE `incloud_base_cts_contact_group`  (
  `id` bigint NOT NULL COMMENT '主键',
  `contact_group_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '常用联系人名称',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '常用联系组' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_cts_contact_group
-- ----------------------------

-- ----------------------------
-- Table structure for incloud_base_cts_contact_group_data
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_cts_contact_group_data`;
CREATE TABLE `incloud_base_cts_contact_group_data`  (
  `id` bigint NOT NULL COMMENT '主键',
  `contact_group_id` bigint NOT NULL COMMENT '常用联系人组ID',
  `contact_group_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '常用联系人组名称',
  `contact_group_data_type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '数据类型',
  `contact_group_data_id` bigint NOT NULL COMMENT '数据ID',
  `contact_group_data_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '数据名称',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '常用联系组数据' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_cts_contact_group_data
-- ----------------------------

-- ----------------------------
-- Table structure for incloud_base_cts_contact_group_user
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_cts_contact_group_user`;
CREATE TABLE `incloud_base_cts_contact_group_user`  (
  `id` bigint NOT NULL COMMENT '主键',
  `contact_group_id` bigint NOT NULL COMMENT '常用联系人组ID',
  `contact_group_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '常用联系人组名称',
  `contact_group_user_id` bigint NOT NULL COMMENT '数据ID',
  `contact_group_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '数据名称',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '常用联系组人员' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_cts_contact_group_user
-- ----------------------------

-- ----------------------------
-- Table structure for incloud_base_cts_multi_send_log
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_cts_multi_send_log`;
CREATE TABLE `incloud_base_cts_multi_send_log`  (
  `id` bigint NOT NULL COMMENT '主键',
  `msg_title` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '标题',
  `msg_content` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '内容',
  `receiver_user_ids` varchar(3000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '接收人ids',
  `receiver_user_names` varchar(3000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '接收人名称',
  `receiver_dept_ids` varchar(3000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '接收部门ids',
  `receiver_dept_names` varchar(3000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '接收部门名称',
  `send_user_id` bigint NOT NULL COMMENT '发送人id',
  `send_user_name_ch` varchar(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '发送人名称',
  `sms_msg_type` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '消息类型',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  `receiver_group_ids` varchar(3000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '接收部门ids',
  `receiver_group_names` varchar(3000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '接收部门名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '通讯录消息群发记录' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_cts_multi_send_log
-- ----------------------------

-- ----------------------------
-- Table structure for incloud_base_demo_product
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_demo_product`;
CREATE TABLE `incloud_base_demo_product`  (
  `id` bigint NOT NULL COMMENT '主键',
  `code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '商品编码',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '商品名称',
  `batch_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '批次号',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人机构ID',
  `process_instance_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程实例id',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `process_instance_status` int NULL DEFAULT NULL COMMENT '流程实例状态',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人机构名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '商品' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_demo_product
-- ----------------------------

-- ----------------------------
-- Table structure for incloud_base_demo_purchase
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_demo_purchase`;
CREATE TABLE `incloud_base_demo_purchase`  (
  `id` bigint NOT NULL COMMENT '主键',
  `ser_number` int NOT NULL COMMENT '采购单号',
  `reason` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '申请原因',
  `count` int NOT NULL COMMENT '采购数量',
  `apply_time` datetime NOT NULL COMMENT '申请时间',
  `type` int NOT NULL COMMENT '采购类型',
  `sum_price` decimal(10, 2) NOT NULL COMMENT '采购总价',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人机构ID',
  `process_instance_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程实例id',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `process_instance_status` int NULL DEFAULT NULL COMMENT '流程实例状态',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人机构名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '采购申请单' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_demo_purchase
-- ----------------------------

-- ----------------------------
-- Table structure for incloud_base_demo_purchase_detail
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_demo_purchase_detail`;
CREATE TABLE `incloud_base_demo_purchase_detail`  (
  `id` bigint NOT NULL COMMENT '主键',
  `purchase_id` bigint NOT NULL COMMENT '采购单ID',
  `code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '商品编码',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '商品名称',
  `batch_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '批次号',
  `price` decimal(10, 2) NOT NULL COMMENT '单品价格',
  `count` int NULL DEFAULT NULL COMMENT '数量',
  `sum_price` decimal(10, 2) NULL DEFAULT NULL COMMENT '合计总价',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人机构ID',
  `process_instance_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '流程实例id',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `process_instance_status` int NULL DEFAULT NULL COMMENT '流程实例状态',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人机构名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '采购申请单详情' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_demo_purchase_detail
-- ----------------------------

-- ----------------------------
-- Table structure for incloud_base_dict
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_dict`;
CREATE TABLE `incloud_base_dict`  (
  `id` bigint NOT NULL COMMENT '主键',
  `dict_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '字典名称',
  `dict_code` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '字典编码',
  `remark` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  `dict_type` int NULL DEFAULT NULL COMMENT '字典类型',
  `dict_name_alias` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '字典名称别名',
  `dict_code_alias` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '字典编码别名',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  `app_id` bigint NULL DEFAULT NULL COMMENT 'AppId',
  `app_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT 'AppName',
  `dict_classify` int NULL DEFAULT NULL COMMENT '字典分类',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '字典' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_dict
-- ----------------------------
INSERT INTO `incloud_base_dict` VALUES (1450345937061810178, '系统日志类型', 'SYSTEM_LOG_TYPE', NULL, '2021-10-19 14:19:52', '2021-10-19 14:19:52', NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1);
INSERT INTO `incloud_base_dict` VALUES (1450346170210586625, '系统日志操作类型', 'SYSTEM_LOG_OPERATE_TYPE', NULL, '2021-10-19 14:20:48', '2021-10-19 14:20:48', NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1);
INSERT INTO `incloud_base_dict` VALUES (1450395355265896450, '请求类型', 'REQUEST_TYPE', NULL, '2021-10-19 17:36:14', '2021-10-19 17:36:14', NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1);
INSERT INTO `incloud_base_dict` VALUES (1450631776195055617, '系统名称', 'APP_NAME', '系统名称：工作流表单、日志使用', '2021-10-20 09:15:42', '2021-10-20 09:15:42', NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1);
INSERT INTO `incloud_base_dict` VALUES (1452450906661457921, '日志级别', 'LOG_LEVEL', NULL, '2021-10-25 09:44:16', '2021-10-25 09:44:16', NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1);
INSERT INTO `incloud_base_dict` VALUES (1458608540775092226, '数据建模子系统', 'MODEL_APP_NAME', NULL, '2021-11-11 09:32:30', '2021-11-11 09:32:30', 10000, 'admin', NULL, 1, '子系统名称', '子系统编码', NULL, NULL, NULL, NULL, 1);
INSERT INTO `incloud_base_dict` VALUES (1458608751526285314, '数据建模按钮', 'MODEL_BUTTON', NULL, '2021-11-11 09:33:21', '2021-11-11 09:33:21', 10000, 'admin', NULL, 1, '按钮名称', '按钮编码', NULL, NULL, NULL, NULL, 1);
INSERT INTO `incloud_base_dict` VALUES (1460859037615656961, '数据类型', 'MODEL_DB_TYPE', NULL, '2021-11-17 14:35:11', '2021-11-17 14:35:11', 0, 'admin', NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1);
INSERT INTO `incloud_base_dict` VALUES (1508750085104603138, '工作流优先级', 'wfBizPriority', NULL, '2022-03-29 18:17:06', '2022-03-29 18:17:06', 0, 'admin', '0', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1);
INSERT INTO `incloud_base_dict` VALUES (1572025848807460866, '日程分类', 'TASK-CLASSIFY', NULL, '2022-09-20 08:52:24', '2022-09-20 08:52:24', 0, 'admin', '0', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1);
INSERT INTO `incloud_base_dict` VALUES (1657599083668770817, '日程优先级', 'TASK-PRIORITY', '日程优先级', '2023-05-14 12:09:53', '2023-05-14 12:09:53', 1, 'admin', '0', 1, NULL, NULL, 0, NULL, NULL, NULL, 1);
INSERT INTO `incloud_base_dict` VALUES (1657616436532023298, '日程提醒时间选项', 'TASK-REMINDER-TIME-TYPE', '日程提醒时间选项', '2023-05-14 13:18:50', '2023-05-14 13:18:50', 1, 'admin', '0', 1, NULL, NULL, 0, NULL, NULL, NULL, 1);
INSERT INTO `incloud_base_dict` VALUES (1658025329381945345, '通讯录消息类型', 'CTS-REMINDER-TYPE', '通讯录消息类型', '2023-05-15 16:23:38', '2023-05-15 16:23:38', 1, 'admin', '0', 1, NULL, NULL, 0, NULL, NULL, NULL, 1);
INSERT INTO `incloud_base_dict` VALUES (1660313137788342273, '日程提醒方式', 'TASK-REMINDER-TYPE', '日程提醒方式', '2023-05-21 23:54:34', '2023-05-21 23:54:34', 1, 'admin', '0', 1, NULL, NULL, 0, NULL, NULL, NULL, 1);
INSERT INTO `incloud_base_dict` VALUES (1665598558092214273, '用户职级', 'MDM-USER-RANK', NULL, '2023-06-05 13:56:56', '2023-06-05 13:56:56', 1, 'admin', '0', 1, 'MDM-USER-RANK', NULL, 0, NULL, NULL, NULL, 1);

-- ----------------------------
-- Table structure for incloud_base_dict_item
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_dict_item`;
CREATE TABLE `incloud_base_dict_item`  (
  `id` bigint NOT NULL COMMENT '主键',
  `dict_id` bigint NOT NULL COMMENT '所属字典类id',
  `dict_code` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '字典编码',
  `remark` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '备注',
  `sort` int NULL DEFAULT NULL COMMENT '排序值，默认升序',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  `dict_item_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '字典项名称',
  `dict_item_code` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '字典项编码',
  `is_enable` int NULL DEFAULT 0 COMMENT '是否启用',
  `version` int NULL DEFAULT 1 COMMENT '版本号',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  `parent_id` bigint NULL DEFAULT 0 COMMENT '父级ID',
  `grade` int NULL DEFAULT 1 COMMENT '级别',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '字典项' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_dict_item
-- ----------------------------
INSERT INTO `incloud_base_dict_item` VALUES (1450346003923210241, 1450345937061810178, 'SYSTEM_LOG_TYPE', NULL, 1, '2021-10-19 14:20:08', '2021-10-19 14:20:08', NULL, NULL, NULL, '登录', 'LOG_TYPE_LOGIN', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1450346003923210245, 1450345937061810178, 'subordinate_platform', NULL, 1, '2021-10-19 14:20:08', '2021-10-19 14:20:08', NULL, NULL, NULL, '所属平台', 'subordinate_platform', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1450346037184040962, 1450345937061810178, 'SYSTEM_LOG_TYPE', NULL, 2, '2021-10-19 14:20:16', '2021-10-19 14:20:16', NULL, NULL, NULL, '退出', 'LOG_TYPE_LOGOUT', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1450346067802460161, 1450345937061810178, 'SYSTEM_LOG_TYPE', NULL, 3, '2021-10-19 14:20:23', '2021-10-19 14:20:23', NULL, NULL, NULL, '操作', 'LOG_TYPE_OPERATE', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1450346212854075393, 1450346170210586625, 'SYSTEM_LOG_OPERATE_TYPE', NULL, 1, '2021-10-19 14:20:58', '2021-10-19 14:20:58', NULL, NULL, NULL, '查询', 'OPERATE_TYPE_QUERY', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1450346251408117762, 1450346170210586625, 'SYSTEM_LOG_OPERATE_TYPE', NULL, 2, '2021-10-19 14:21:07', '2021-10-19 14:21:07', NULL, NULL, NULL, '添加', 'OPERATE_TYPE_ADD', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1450346280512393218, 1450346170210586625, 'SYSTEM_LOG_OPERATE_TYPE', NULL, 3, '2021-10-19 14:21:14', '2021-10-19 14:21:14', NULL, NULL, NULL, '更新', 'OPERATE_TYPE_EDIT', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1450346315375448066, 1450346170210586625, 'SYSTEM_LOG_OPERATE_TYPE', NULL, 4, '2021-10-19 14:21:22', '2021-10-19 14:21:22', NULL, NULL, NULL, '删除', 'OPERATE_TYPE_DEL', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1450346360703291393, 1450346170210586625, 'SYSTEM_LOG_OPERATE_TYPE', NULL, 5, '2021-10-19 14:21:33', '2021-10-19 14:21:33', NULL, NULL, NULL, '导入', 'OPERATE_TYPE_IMPORT', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1450346404990947330, 1450346170210586625, 'SYSTEM_LOG_OPERATE_TYPE', NULL, 6, '2021-10-19 14:21:44', '2021-10-19 14:21:44', NULL, NULL, NULL, '导出', 'OPERATE_TYPE_EXPORT', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1450395385561354241, 1450395355265896450, 'REQUEST_TYPE', NULL, NULL, '2021-10-19 17:36:22', '2021-11-10 17:17:38', NULL, NULL, NULL, 'GET', 'GET', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1450395405635293185, 1450395355265896450, 'REQUEST_TYPE', NULL, NULL, '2021-10-19 17:36:26', '2021-11-10 17:17:38', NULL, NULL, NULL, 'POST', 'POST', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1450395465253130241, 1450395355265896450, 'REQUEST_TYPE', NULL, NULL, '2021-10-19 17:36:41', '2021-11-10 17:17:38', NULL, NULL, NULL, 'DELETE', 'DELETE', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1450631878527684610, 1450631776195055617, 'APP_NAME', NULL, 5, '2021-10-20 09:16:06', '2022-03-09 16:02:25', NULL, NULL, NULL, 'Main', 'incloud-base-main', 0, 2, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1450631878527684611, 1450631776195055617, 'widgets-type', NULL, 5, '2021-10-20 09:16:06', '2022-03-09 16:02:25', NULL, NULL, NULL, '日常组件', 'widgets-type-day', 0, 2, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1450631958332706818, 1450631776195055617, 'APP_NAME', NULL, 2, '2021-10-20 09:16:25', '2022-03-09 16:02:25', NULL, NULL, NULL, '认证中心', 'incloud-base-oauth', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1450632022950154241, 1450631776195055617, 'APP_NAME', NULL, 1, '2021-10-20 09:16:40', '2022-03-09 16:02:25', NULL, NULL, NULL, '网关', 'incloud-base-gateway', 0, 2, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1452450940845035521, 1452450906661457921, 'LOG_LEVEL', NULL, NULL, '2021-10-25 09:44:24', '2021-10-25 09:44:24', NULL, NULL, NULL, 'INFO', 'INFO', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1452450957022466050, 1452450906661457921, 'LOG_LEVEL', NULL, NULL, '2021-10-25 09:44:28', '2021-10-25 09:44:28', NULL, NULL, NULL, 'ERROR', 'ERROR', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1458377286171496450, 1452450906661457921, 'LOG_LEVEL', NULL, NULL, '2021-11-10 18:13:35', '2021-11-10 18:13:35', 10000, 'admin', NULL, 'DEBUG', 'DEBUG', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1458377350004609026, 1452450906661457921, 'LOG_LEVEL', NULL, NULL, '2021-11-10 18:13:50', '2021-11-10 18:13:50', 10000, 'admin', NULL, 'WARN', 'WARN', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1460529719416983553, 1458608540775092226, 'MODEL_APP_NAME', NULL, NULL, '2021-11-16 16:46:35', '2021-11-25 09:44:43', 0, 'admin', NULL, '测试建模', 'csjm', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1460859285192839170, 1460859037615656961, 'MODEL_DB_TYPE', NULL, NULL, '2021-11-17 14:36:10', '2021-11-17 14:36:10', 0, 'admin', NULL, 'bigint', 'bigint', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1460859475123507201, 1460859037615656961, 'MODEL_DB_TYPE', NULL, NULL, '2021-11-17 14:36:55', '2021-11-17 14:36:55', 0, 'admin', NULL, 'int', 'int', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1460859573328941058, 1460859037615656961, 'MODEL_DB_TYPE', NULL, NULL, '2021-11-17 14:37:18', '2021-11-17 14:37:18', 0, 'admin', NULL, 'double', 'double', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1460859591347671041, 1460859037615656961, 'MODEL_DB_TYPE', NULL, NULL, '2021-11-17 14:37:23', '2021-11-17 14:37:23', 0, 'admin', NULL, 'decimal', 'decimal', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1460859780829548546, 1460859037615656961, 'MODEL_DB_TYPE', NULL, NULL, '2021-11-17 14:38:08', '2021-11-17 14:38:08', 0, 'admin', NULL, 'varchar', 'varchar', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1460859799477424130, 1460859037615656961, 'MODEL_DB_TYPE', NULL, NULL, '2021-11-17 14:38:12', '2021-11-17 14:38:12', 0, 'admin', NULL, 'char', 'char', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1460859841726648321, 1460859037615656961, 'MODEL_DB_TYPE', NULL, NULL, '2021-11-17 14:38:22', '2021-11-17 14:38:22', 0, 'admin', NULL, 'text', 'text', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1460859869614575618, 1460859037615656961, 'MODEL_DB_TYPE', NULL, NULL, '2021-11-17 14:38:29', '2021-11-17 14:38:29', 0, 'admin', NULL, 'longtext', 'longtext', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1460859887159349250, 1460859037615656961, 'MODEL_DB_TYPE', NULL, NULL, '2021-11-17 14:38:33', '2021-11-17 14:38:33', 0, 'admin', NULL, 'mediumtext', 'mediumtext', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1460859906201489409, 1460859037615656961, 'MODEL_DB_TYPE', NULL, NULL, '2021-11-17 14:38:38', '2021-11-17 14:38:38', 0, 'admin', NULL, 'date', 'date', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1460859924576735233, 1460859037615656961, 'MODEL_DB_TYPE', NULL, NULL, '2021-11-17 14:38:42', '2021-11-17 14:38:42', 0, 'admin', NULL, 'datetime', 'datetime', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1460859960383508481, 1460859037615656961, 'MODEL_DB_TYPE', NULL, NULL, '2021-11-17 14:38:51', '2021-11-17 14:38:51', 0, 'admin', NULL, 'timestamp', 'timestamp', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1463689311021961217, 1458608540775092226, 'MODEL_APP_NAME', NULL, NULL, '2021-11-25 10:01:40', '2021-11-25 10:01:40', 0, 'admin', NULL, '中原建', 'zyj', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1463761535779213313, 1450631776195055617, 'APP_NAME', NULL, 9, '2021-11-25 14:48:40', '2022-03-09 16:02:25', 0, 'admin', NULL, '在线学习', 'incloud-biz-study', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1465139977951121410, 1458608751526285314, 'MODEL_BUTTON', NULL, NULL, '2021-11-29 10:06:06', '2021-11-29 10:06:06', 0, 'admin', NULL, '保存', 'save', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1465140001359532034, 1458608751526285314, 'MODEL_BUTTON', NULL, NULL, '2021-11-29 10:06:12', '2021-11-29 10:06:12', 0, 'admin', NULL, '修改', 'update', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1465140024759554050, 1458608751526285314, 'MODEL_BUTTON', NULL, NULL, '2021-11-29 10:06:18', '2021-11-29 10:06:18', 0, 'admin', NULL, '删除', 'del', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1465140068032188418, 1458608751526285314, 'MODEL_BUTTON', NULL, NULL, '2021-11-29 10:06:28', '2021-11-29 10:06:28', 0, 'admin', NULL, '查询', 'query', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1465140107471228930, 1458608751526285314, 'MODEL_BUTTON', NULL, NULL, '2021-11-29 10:06:37', '2021-11-29 10:06:37', 0, 'admin', NULL, '提交', 'submit', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1465614921600339969, 1465614808781950978, 'Study_Exam_Database_Def', NULL, 1, '2021-11-30 17:33:22', '2021-11-30 17:33:22', 0, 'admin', NULL, '测试_1', 'ceshi', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1475779591313297409, 1475779482399805441, 'Study_certificate', NULL, 1, '2021-12-28 18:44:08', '2021-12-28 18:44:08', 0, 'admin', '0', '证书分类1', 'zsfl1', 0, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1498251135754964994, 1458608540775092226, 'MODEL_APP_NAME', '3', 3, '2022-02-28 18:58:02', '2022-02-28 18:58:02', 0, 'admin', '0', 'test33', 'test33', -1, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1508750220769366017, 1508750085104603138, 'wfBizPriority', NULL, 0, '2022-03-29 18:17:39', '2023-03-09 09:16:20', 0, 'admin', '0', '一般', 'general', 1, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1508750337513623553, 1508750085104603138, 'wfBizPriority', NULL, 1, '2022-03-29 18:18:06', '2023-03-09 09:16:20', 0, 'admin', '0', '重要', 'important', 1, 2, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1508750463208525826, 1508750085104603138, 'wfBizPriority', NULL, 2, '2022-03-29 18:18:36', '2023-03-09 09:16:20', 0, 'admin', '0', '非常重要', 'veryimportant', 1, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1546406196652982273, 1450631776195055617, 'APP_NAME', NULL, 10, '2022-07-11 16:09:03', '2022-07-11 16:09:03', 0, 'admin', '0', '任务中心', 'incloud-base-center', -1, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1563107224437452802, 1450631776195055617, 'APP_NAME', NULL, 13, '2022-08-26 18:12:58', '2022-08-26 18:12:58', 0, 'admin', '0', '报表填报系统', 'incloud-biz-smm', -1, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1563107224437452805, 1450631776195055617, 'APP_NAME', NULL, 15, '2022-08-26 18:12:58', '2022-08-26 18:12:58', 0, 'admin', '0', '门户管理', 'incloud-base-portal', -1, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1563107224437452866, 1450631776195055617, 'APP_NAME', NULL, 15, '2022-08-26 18:12:58', '2022-08-26 18:12:58', 0, 'admin', '0', '物资采购填报', 'incloud-biz-supp', -1, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1572026079125082113, 1572025848807460866, 'TASK-CLASSIFY', NULL, 0, '2022-09-20 08:53:19', '2022-09-20 08:53:19', 0, 'admin', '0', '日常', 'rc', 1, 2, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1572026136209559553, 1572025848807460866, 'TASK-CLASSIFY', NULL, 1, '2022-09-20 08:53:32', '2022-09-20 08:53:32', 0, 'admin', '0', '会议', 'hy', 1, 2, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1572026335124426753, 1572025848807460866, 'TASK-CLASSIFY', NULL, 2, '2022-09-20 08:54:20', '2022-09-20 08:54:20', 0, 'admin', '0', '特殊', 'ts', 1, 1, NULL, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1657599252032327681, 1657599083668770817, 'TASK-PRIORITY', NULL, 1, '2023-05-14 12:10:33', '2023-05-14 12:34:01', 1, 'admin', '0', '紧急', '1', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1657599310639337473, 1657599083668770817, 'TASK-PRIORITY', NULL, 2, '2023-05-14 12:10:47', '2023-05-14 12:34:01', 1, 'admin', '0', '中级', '2', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1657599403350233089, 1657599083668770817, 'TASK-PRIORITY', NULL, 3, '2023-05-14 12:11:09', '2023-05-14 12:34:01', 1, 'admin', '0', '一般', '3', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1657620038763876353, 1657616436532023298, 'TASK-REMINDER-TIME-TYPE', NULL, 1, '2023-05-14 13:33:09', '2023-05-21 23:51:34', 1, 'admin', '0', '十分钟前', 'shifenzhongqian', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1657620441756798978, 1657616436532023298, 'TASK-REMINDER-TIME-TYPE', NULL, 3, '2023-05-14 13:34:45', '2023-05-21 23:51:34', 1, 'admin', '0', '半小时之前', '30m', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1657620520894926850, 1657616436532023298, 'TASK-REMINDER-TIME-TYPE', NULL, 4, '2023-05-14 13:35:04', '2023-05-21 23:51:34', 1, 'admin', '0', '一小时之前', '1h', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1657620688084078594, 1657616436532023298, 'TASK-REMINDER-TIME-TYPE', NULL, 5, '2023-05-14 13:35:44', '2023-05-21 23:51:34', 1, 'admin', '0', '一天之前', '24h', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1657620864454561793, 1657616436532023298, 'TASK-REMINDER-TIME-TYPE', NULL, 100, '2023-05-14 13:36:26', '2023-05-21 23:51:34', 1, 'admin', '0', '自定义', 'SELF-SAVE', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1658046988578631682, 1658025329381945345, 'CTS-REMINDER-TYPE', '华北油田，短信', 1, '2023-05-15 17:49:42', '2023-05-15 17:49:42', 1, 'admin', '0', '短信', 'hb-sms', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1658047154626932738, 1658025329381945345, 'CTS-REMINDER-TYPE', NULL, 2, '2023-05-15 17:50:21', '2023-05-15 17:50:21', 1, 'admin', '0', '企业微信', 'hb-WeChat', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1658047258540814338, 1658025329381945345, 'CTS-REMINDER-TYPE', '平台邮箱', 3, '2023-05-15 17:50:46', '2023-05-15 17:50:46', 1, 'admin', '0', '邮箱', 'email', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1660313299524898818, 1660313137788342273, 'TASK-REMINDER-TYPE', '短信', 1, '2023-05-21 23:55:12', '2023-05-21 23:55:12', 1, 'admin', '0', '短信', 'sms', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1660313485873631233, 1660313137788342273, 'TASK-REMINDER-TYPE', NULL, 2, '2023-05-21 23:55:57', '2023-05-21 23:55:57', 1, 'admin', '0', '及时通', 'wechat', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1665557121457852417, 1665598558092214273, 'MDM-USER-RANK', NULL, 1, '2023-06-05 11:12:17', '2023-06-05 11:12:17', 0, 'admin', '0', '一般员工', '10', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1665557221517168641, 1665598558092214273, 'MDM-USER-RANK', NULL, 2, '2023-06-05 11:12:41', '2023-06-05 11:12:41', 0, 'admin', '0', '三级正', '31', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1665557290073067521, 1665598558092214273, 'MDM-USER-RANK', NULL, 30, '2023-06-05 11:12:57', '2023-06-05 11:12:57', 0, 'admin', '0', '三级副', '30', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1665557347446951938, 1665598558092214273, 'MDM-USER-RANK', NULL, 50, '2023-06-05 11:13:11', '2023-06-05 11:13:11', 0, 'admin', '0', '厂级机关员工', '50', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1665557407228366850, 1665598558092214273, 'MDM-USER-RANK', NULL, 20, '2023-06-05 11:13:25', '2023-06-05 11:13:25', 0, 'admin', '0', '二级副', '20', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1665557464824549377, 1665598558092214273, 'MDM-USER-RANK', NULL, 21, '2023-06-05 11:13:39', '2023-06-05 11:13:39', 0, 'admin', '0', '二级正', '21', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1665557519455358977, 1665598558092214273, 'MDM-USER-RANK', NULL, 99, '2023-06-05 11:13:52', '2023-06-05 11:13:52', 0, 'admin', '0', '公司执行董事', '99', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1665557570575536130, 1665598558092214273, 'MDM-USER-RANK', NULL, 42, '2023-06-05 11:14:04', '2023-06-05 11:14:04', 0, 'admin', '0', '首席专家', '42', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1665557627429326849, 1665598558092214273, 'MDM-USER-RANK', NULL, 40, '2023-06-05 11:14:18', '2023-06-05 11:14:18', 0, 'admin', '0', '二级技术专家', '40', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1665557687965716481, 1665598558092214273, 'MDM-USER-RANK', NULL, 41, '2023-06-05 11:14:32', '2023-06-05 11:14:32', 0, 'admin', '0', '一级技术专家', '41', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1665557745314435073, 1665598558092214273, 'MDM-USER-RANK', NULL, 61, '2023-06-05 11:14:46', '2023-06-05 11:14:46', 0, 'admin', '0', '一级工程师', '61', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1665557800507281410, 1665598558092214273, 'MDM-USER-RANK', NULL, 62, '2023-06-05 11:14:59', '2023-06-05 11:14:59', 0, 'admin', '0', '二级工程师', '62', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1665557855960174594, 1665598558092214273, 'MDM-USER-RANK', NULL, 43, '2023-06-05 11:15:12', '2023-06-05 11:15:12', 0, 'admin', '0', '咨询专家', '43', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1665557977297195010, 1665598558092214273, 'MDM-USER-RANK', NULL, 51, '2023-06-05 11:15:41', '2023-06-05 11:15:41', 0, 'admin', '0', '公司机关员工', '51', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1665558036512378881, 1665598558092214273, 'MDM-USER-RANK', NULL, 90, '2023-06-05 11:15:55', '2023-06-05 11:15:55', 0, 'admin', '0', '一级副', '90', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1665558087284428801, 1665598558092214273, 'MDM-USER-RANK', NULL, 91, '2023-06-05 11:16:07', '2023-06-05 11:16:07', 0, 'admin', '0', '一级正', '91', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1667751397286121473, 1660313137788342273, 'TASK-REMINDER-TYPE', NULL, 3, '2023-06-11 12:31:33', '2023-06-11 12:31:33', 1, 'admin', '0', '邮件', 'email', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1669004047282012162, 1450631776195055617, 'APP_NAME', NULL, 2, '2023-06-14 23:29:08', '2023-06-14 23:29:08', 1, 'admin', '0', '门户2', 'incloud-biz-portal', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1673528464641966081, 1572025848807460866, 'TASK-CLASSIFY', NULL, 3, '2023-06-27 11:07:33', '2023-06-27 11:07:33', 1, 'admin', '0', '短期任务', 'duanqirenwu', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1673528791210475522, 1657616436532023298, 'TASK-REMINDER-TIME-TYPE', NULL, 2, '2023-06-27 11:08:51', '2023-06-27 11:08:51', 1, 'admin', '0', '十五分钟前', '15m', 1, 1, 0, NULL, 0, 1);
INSERT INTO `incloud_base_dict_item` VALUES (1684089916509827074, 1450395355265896450, 'REQUEST_TYPE', NULL, NULL, '2023-07-26 14:35:00', '2023-07-26 14:35:00', 1, 'admin', '0,1665239138713931778', 'PUT', 'PUT', 0, 1, 1665239138713931778, NULL, 0, 1);

-- ----------------------------
-- Table structure for incloud_base_dict_item_version
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_dict_item_version`;
CREATE TABLE `incloud_base_dict_item_version`  (
  `id` bigint NOT NULL COMMENT '主键',
  `old_dict_item_id` bigint NULL DEFAULT NULL COMMENT '原字典项Id',
  `version` int NULL DEFAULT NULL COMMENT 'version',
  `is_main_version` int NULL DEFAULT 1 COMMENT '是否主版本',
  `dict_id` bigint NOT NULL COMMENT '所属字典类id',
  `dict_code` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '字典编码',
  `dict_item_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '字典项名称',
  `dict_item_code` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '字典项编码',
  `remark` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '备注',
  `sort` int NULL DEFAULT NULL COMMENT '排序值，默认升序',
  `is_enable` int NULL DEFAULT 0 COMMENT '是否启用',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '字典项版本' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_dict_item_version
-- ----------------------------

-- ----------------------------
-- Table structure for incloud_base_dict_tree
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_dict_tree`;
CREATE TABLE `incloud_base_dict_tree`  (
  `id` bigint NOT NULL COMMENT '主键',
  `dict_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '字典名称',
  `dict_code` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '字典编码',
  `remark` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '备注',
  `parent_id` bigint NULL DEFAULT NULL COMMENT '父级ID',
  `grade` int NULL DEFAULT NULL COMMENT '级别',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  `dict_name_alias` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '字典名称别名',
  `dict_code_alias` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '字典编码别名',
  `version` int NULL DEFAULT NULL COMMENT '版本号',
  `ext_id` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '扩展Id',
  `ext_pid` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '扩展父级Id',
  `ext_full_code` varchar(1024) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '扩展父级Id',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '字典树形' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_dict_tree
-- ----------------------------
INSERT INTO `incloud_base_dict_tree` VALUES (1643581671751995393, '地区', 'diqu', NULL, 0, 1, '2023-04-05 19:49:41', '2023-04-05 19:49:41', 0, 'admin', '0', NULL, NULL, 1, NULL, NULL, NULL, 1637657267702616065, NULL);
INSERT INTO `incloud_base_dict_tree` VALUES (1643581748910411778, '北京', 'beijing', NULL, 1643581671751995393, 2, '2023-04-05 19:50:00', '2023-04-05 19:50:00', 0, 'admin', '0', NULL, NULL, 1, NULL, NULL, NULL, 1637657267702616065, NULL);
INSERT INTO `incloud_base_dict_tree` VALUES (1643581799560826882, '河北', 'hebei', NULL, 1643581671751995393, 2, '2023-04-05 19:50:12', '2023-04-05 19:50:12', 0, 'admin', '0', NULL, NULL, 1, NULL, NULL, NULL, 1637657267702616065, NULL);

-- ----------------------------
-- Table structure for incloud_base_dict_tree_version
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_dict_tree_version`;
CREATE TABLE `incloud_base_dict_tree_version`  (
  `id` bigint NOT NULL COMMENT '主键',
  `version` int NULL DEFAULT NULL COMMENT 'version',
  `is_main_version` int NULL DEFAULT 1 COMMENT '是否主版本',
  `dict_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '字典名称',
  `dict_code` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '字典编码',
  `dict_name_alias` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '字典名称别名',
  `dict_code_alias` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '字典编码别名',
  `remark` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '备注',
  `parent_id` bigint NULL DEFAULT NULL COMMENT '父级ID',
  `grade` int NULL DEFAULT NULL COMMENT '级别',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  `old_dict_tree_id` bigint NULL DEFAULT NULL COMMENT '原字典Id',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '字典树形版本' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_dict_tree_version
-- ----------------------------
INSERT INTO `incloud_base_dict_tree_version` VALUES (1643581671798132737, 1, 1, '地区', 'diqu', NULL, NULL, NULL, 0, 1, '2023-04-05 19:49:41', '2023-04-05 19:49:41', 0, 'admin', '0', 1643581671751995393, 1637657267702616065, NULL);
INSERT INTO `incloud_base_dict_tree_version` VALUES (1643581748956549121, 1, 1, '北京', 'beijing', NULL, NULL, NULL, 1643581671751995393, 2, '2023-04-05 19:50:00', '2023-04-05 19:50:00', 0, 'admin', '0', 1643581748910411778, 1637657267702616065, NULL);
INSERT INTO `incloud_base_dict_tree_version` VALUES (1643581799602769921, 1, 1, '河北', 'hebei', NULL, NULL, NULL, 1643581671751995393, 2, '2023-04-05 19:50:12', '2023-04-05 19:50:12', 0, 'admin', '0', 1643581799560826882, 1637657267702616065, NULL);

-- ----------------------------
-- Table structure for incloud_base_dynamic_metadata
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_dynamic_metadata`;
CREATE TABLE `incloud_base_dynamic_metadata`  (
  `id` bigint NOT NULL COMMENT '主键',
  `content` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '存储数据',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  `route_id` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '路由ID',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '动态接口元数据存储' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_dynamic_metadata
-- ----------------------------

-- ----------------------------
-- Table structure for incloud_base_enterprise_information
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_enterprise_information`;
CREATE TABLE `incloud_base_enterprise_information`  (
  `id` bigint NOT NULL COMMENT '主键',
  `home_top_file_id` bigint NULL DEFAULT NULL COMMENT '首页上方logo',
  `home_top_file_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '首页上方logoUrl',
  `home_bottom_file_id` bigint NULL DEFAULT NULL COMMENT '首页下方logo',
  `home_bottom_file_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '首页下方logoUrl',
  `home_background_file_id` bigint NULL DEFAULT NULL COMMENT '首页背景图',
  `home_background_file_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '首页背景图url',
  `main_top_file_id` bigint NULL DEFAULT NULL COMMENT '主页上方logo',
  `main_top_file_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '主页上方logoUrl',
  `copyright` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '版权',
  `company_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '企业名称',
  `english_name_abbreviation` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '企业英文简称',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  `is_expand` int NOT NULL DEFAULT 0 COMMENT '是否展开左侧菜单0不展开1展开',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '企业信息' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_enterprise_information
-- ----------------------------
INSERT INTO `incloud_base_enterprise_information` VALUES (1727632374717313026, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '云数网讯', 'netwisd', '2023-11-23 18:18:11', '2023-11-23 18:18:11', 1, 'admin', 0, 'root', '0', 1);

-- ----------------------------
-- Table structure for incloud_base_file_ds
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_file_ds`;
CREATE TABLE `incloud_base_file_ds`  (
  `id` bigint NOT NULL COMMENT '主键',
  `pool_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '数据源名称',
  `type` varchar(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '文档存储类型',
  `is_default` int NOT NULL COMMENT '是否默认实现',
  `minio_url` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT 'minio地址',
  `minio_access_key` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT 'minio账号',
  `minio_secret_key` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT 'minio密码',
  `minio_bucket_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT 'minio库名称',
  `local_file_path` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '本地存储路径',
  `local_file_prefix` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '本地存储前缀',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '文件数据源' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_file_ds
-- ----------------------------
INSERT INTO `incloud_base_file_ds` VALUES (1509841063911624705, 'default', 'LOCAL', 1, NULL, NULL, NULL, NULL, '/opt/localFile', '/localFile', '2022-04-06 16:20:48', '2023-05-02 10:57:10', 0, 'admin', '0', NULL, NULL);

-- ----------------------------
-- Table structure for incloud_base_file_info
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_file_info`;
CREATE TABLE `incloud_base_file_info`  (
  `id` bigint NOT NULL COMMENT '主键',
  `file_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '原始文件名',
  `file_is_img` int NULL DEFAULT NULL COMMENT '是否是图片,0:是，1:不是',
  `file_content_type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '文件的真实类型',
  `file_source` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '文件来源，业务来源',
  `file_store_type` varchar(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '文件存储方式；1.本地；2aliyun；3.minio',
  `file_md5_code` varchar(32) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT 'md5文件唯一标识',
  `file_bucket_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT 'minio和aliyun时会用到',
  `file_size` bigint NOT NULL COMMENT '文件大小',
  `file_size_view` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '文件展示大小',
  `file_path` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '本地存储时使用，真实路径',
  `file_url` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '本地存储时使用，访问路径',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  `file_pool_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '文件存储的库',
  `file_duration` bigint NULL DEFAULT NULL COMMENT '媒体文件时长毫秒',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '文件存储' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_file_info
-- ----------------------------
INSERT INTO `incloud_base_file_info` VALUES (1688753583402692610, 'WechatIMG24.jpg', 0, 'image/jpeg', 'portal', 'LOCAL', '1ed5ad5e7b981e052fe06c942a382945', NULL, 15465, '15.1KB', '/opt/localFile/2023/08/08/1ed5ad5e7b981e052fe06c942a382945.jpg', '/localFile/2023/08/08/1ed5ad5e7b981e052fe06c942a382945.jpg', '2023-08-08 11:26:44', '2023-08-08 11:26:44', 1, 'admin', '0,1665239138713931778', 'default', NULL, 1665239138713931778, NULL);
INSERT INTO `incloud_base_file_info` VALUES (1688788974042263554, 'WechatIMG14436.jpg', 0, 'image/jpeg', 'main', 'LOCAL', '2bc2ff16decdb9a8e7cd49df21bcbc2a', NULL, 546845, '534KB', '/opt/localFile/2023/08/08/2bc2ff16decdb9a8e7cd49df21bcbc2a.jpg', '/localFile/2023/08/08/2bc2ff16decdb9a8e7cd49df21bcbc2a.jpg', '2023-08-08 13:47:19', '2023-08-08 13:47:19', 1, 'admin', '0', 'default', NULL, 0, NULL);

-- ----------------------------
-- Table structure for incloud_base_file_watermark
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_file_watermark`;
CREATE TABLE `incloud_base_file_watermark`  (
  `id` bigint NOT NULL COMMENT '主键',
  `width` int NULL DEFAULT NULL COMMENT '宽',
  `height` int NULL DEFAULT NULL COMMENT '高',
  `rotate` int NULL DEFAULT NULL COMMENT '旋转度',
  `watermark` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '水印内容',
  `font_size` int NULL DEFAULT NULL COMMENT '字体大小',
  `color` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '颜色',
  `alpha` decimal(10, 2) NULL DEFAULT NULL COMMENT '透明度',
  `offset_x` int NULL DEFAULT NULL COMMENT '偏移',
  `offset_y` int NULL DEFAULT NULL COMMENT '偏移',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '文件水印' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_file_watermark
-- ----------------------------
INSERT INTO `incloud_base_file_watermark` VALUES (1683754814056747010, 300, 200, -45, '云数网讯', 30, '#fa0000', 0.60, 50, -50, '2023-07-25 16:23:25', '2023-07-25 16:23:25', 1, 'admin', 1665239138713931778, '华北油田分公司', '0,1665239138713931778');

-- ----------------------------
-- Table structure for incloud_base_gateway_dynamic_route
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_gateway_dynamic_route`;
CREATE TABLE `incloud_base_gateway_dynamic_route`  (
  `id` bigint NOT NULL COMMENT '主键',
  `route_id` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '路由ID',
  `content` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '内容',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '动态网关' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_gateway_dynamic_route
-- ----------------------------

-- ----------------------------
-- Table structure for incloud_base_help_md
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_help_md`;
CREATE TABLE `incloud_base_help_md`  (
  `id` bigint NOT NULL COMMENT '主键',
  `md_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT 'md名称',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  `md_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT 'md编码',
  `md_type` int NOT NULL COMMENT '文档类型',
  `md_content` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT 'md内容',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_help_md
-- ----------------------------

-- ----------------------------
-- Table structure for incloud_base_mdm_area
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_mdm_area`;
CREATE TABLE `incloud_base_mdm_area`  (
  `id` bigint NOT NULL COMMENT '主键',
  `code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '编码',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '名称',
  `level` int NULL DEFAULT NULL COMMENT '等级 1：省 2：市 3：区',
  `parent_id` bigint NULL DEFAULT NULL COMMENT '父级id',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_parent_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_parent_org_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  `create_user_parent_dept_id` bigint NULL DEFAULT NULL COMMENT '创建人父级部门ID',
  `create_user_parent_dept_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '创建人父级部门名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '地区表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_mdm_area
-- ----------------------------
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871873, '11', '北京', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871874, '1101', '市辖区', 2, 1611571208257871873, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871875, '110101', '东城区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871876, '110102', '西城区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871877, '110105', '朝阳区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871878, '110106', '丰台区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871879, '110107', '石景山区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871880, '110108', '海淀区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871881, '110109', '门头沟区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871882, '110111', '房山区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871883, '110112', '通州区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871884, '110113', '顺义区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871885, '110114', '昌平区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871886, '110115', '大兴区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871887, '110116', '怀柔区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871888, '110117', '平谷区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871889, '1102', '县', 2, 1611571208257871873, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871890, '110228', '密云县', 3, 1611571208257871889, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871891, '110229', '延庆县', 3, 1611571208257871889, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871892, '12', '天津', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871893, '1201', '市辖区', 2, 1611571208257871892, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871894, '120101', '和平区', 3, 1611571208257871893, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871895, '120102', '河东区', 3, 1611571208257871893, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871896, '120103', '河西区', 3, 1611571208257871893, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871897, '120104', '南开区', 3, 1611571208257871893, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871898, '120105', '河北区', 3, 1611571208257871893, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871899, '120106', '红桥区', 3, 1611571208257871893, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871900, '120110', '东丽区', 3, 1611571208257871893, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871901, '120111', '西青区', 3, 1611571208257871893, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871902, '120112', '津南区', 3, 1611571208257871893, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871903, '120113', '北辰区', 3, 1611571208257871893, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871904, '120114', '武清区', 3, 1611571208257871893, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871905, '120115', '宝坻区', 3, 1611571208257871893, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871906, '120116', '滨海新区', 3, 1611571208257871893, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871907, '1202', '县', 2, 1611571208257871892, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871908, '120221', '宁河县', 3, 1611571208257871907, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871909, '120223', '静海县', 3, 1611571208257871907, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871910, '120225', '蓟县', 3, 1611571208257871907, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871911, '13', '河北', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871912, '1301', '石家庄市', 2, 1611571208257871911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871913, '130101', '市辖区', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871914, '130102', '长安区', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871915, '130103', '桥东区', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871916, '130104', '桥西区', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871917, '130105', '新华区', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871918, '130107', '井陉矿区', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871919, '130108', '裕华区', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871920, '130121', '井陉县', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871921, '130123', '正定县', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871922, '130124', '栾城县', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871923, '130125', '行唐县', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871924, '130126', '灵寿县', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871925, '130127', '高邑县', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871926, '130128', '深泽县', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871927, '130129', '赞皇县', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871928, '130130', '无极县', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871929, '130131', '平山县', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871930, '130132', '元氏县', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871931, '130133', '赵县', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871932, '130181', '辛集市', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871933, '130182', '藁城市', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871934, '130183', '晋州市', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871935, '130184', '新乐市', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871936, '130185', '鹿泉市', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871937, '1302', '唐山市', 2, 1611571208257871911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871938, '130201', '市辖区', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871939, '130202', '路南区', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871940, '130203', '路北区', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871941, '130204', '古冶区', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871942, '130205', '开平区', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871943, '130207', '丰南区', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871944, '130208', '丰润区', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871945, '130209', '曹妃甸区', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871946, '130223', '滦县', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871947, '130224', '滦南县', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871948, '130225', '乐亭县', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871949, '130227', '迁西县', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871950, '130229', '玉田县', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871951, '130281', '遵化市', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871952, '130283', '迁安市', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871953, '1303', '秦皇岛市', 2, 1611571208257871911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871954, '130301', '市辖区', 3, 1611571208257871953, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871955, '130302', '海港区', 3, 1611571208257871953, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871956, '130303', '山海关区', 3, 1611571208257871953, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871957, '130304', '北戴河区', 3, 1611571208257871953, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871958, '130321', '青龙满族自治县', 3, 1611571208257871953, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871959, '130322', '昌黎县', 3, 1611571208257871953, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871960, '130323', '抚宁县', 3, 1611571208257871953, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871961, '130324', '卢龙县', 3, 1611571208257871953, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871962, '1304', '邯郸市', 2, 1611571208257871911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871963, '130401', '市辖区', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871964, '130402', '邯山区', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871965, '130403', '丛台区', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871966, '130404', '复兴区', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871967, '130406', '峰峰矿区', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871968, '130421', '邯郸县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871969, '130423', '临漳县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871970, '130424', '成安县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871971, '130425', '大名县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871972, '130426', '涉县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871973, '130427', '磁县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871974, '130428', '肥乡县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871975, '130429', '永年县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871976, '130430', '邱县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871977, '130431', '鸡泽县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871978, '130432', '广平县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871979, '130433', '馆陶县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871980, '130434', '魏县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871981, '130435', '曲周县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871982, '130481', '武安市', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871983, '1305', '邢台市', 2, 1611571208257871911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871984, '130501', '市辖区', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871985, '130502', '桥东区', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871986, '130503', '桥西区', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871987, '130521', '邢台县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871988, '130522', '临城县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871989, '130523', '内丘县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871990, '130524', '柏乡县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871991, '130525', '隆尧县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871992, '130526', '任县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871993, '130527', '南和县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871994, '130528', '宁晋县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871995, '130529', '巨鹿县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871996, '130530', '新河县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871997, '130531', '广宗县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871998, '130532', '平乡县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257871999, '130533', '威县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872000, '130534', '清河县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872001, '130535', '临西县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872002, '130581', '南宫市', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872003, '130582', '沙河市', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872004, '1306', '保定市', 2, 1611571208257871911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872005, '130601', '市辖区', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872006, '130602', '新市区', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872007, '130603', '北市区', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872008, '130604', '南市区', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872009, '130621', '满城县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872010, '130622', '清苑县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872011, '130623', '涞水县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872012, '130624', '阜平县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872013, '130625', '徐水县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872014, '130626', '定兴县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872015, '130627', '唐县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872016, '130628', '高阳县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872017, '130629', '容城县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872018, '130630', '涞源县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872019, '130631', '望都县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872020, '130632', '安新县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872021, '130633', '易县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872022, '130634', '曲阳县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872023, '130635', '蠡县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872024, '130636', '顺平县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872025, '130637', '博野县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872026, '130638', '雄县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872027, '130681', '涿州市', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872028, '130682', '定州市', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872029, '130683', '安国市', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872030, '130684', '高碑店市', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872031, '1307', '张家口市', 2, 1611571208257871911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872032, '130701', '市辖区', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872033, '130702', '桥东区', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872034, '130703', '桥西区', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872035, '130705', '宣化区', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872036, '130706', '下花园区', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872037, '130721', '宣化县', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872038, '130722', '张北县', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872039, '130723', '康保县', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872040, '130724', '沽源县', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872041, '130725', '尚义县', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872042, '130726', '蔚县', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872043, '130727', '阳原县', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872044, '130728', '怀安县', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872045, '130729', '万全县', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872046, '130730', '怀来县', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872047, '130731', '涿鹿县', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872048, '130732', '赤城县', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872049, '130733', '崇礼县', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872050, '1308', '承德市', 2, 1611571208257871911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872051, '130801', '市辖区', 3, 1611571208257872050, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872052, '130802', '双桥区', 3, 1611571208257872050, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872053, '130803', '双滦区', 3, 1611571208257872050, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872054, '130804', '鹰手营子矿区', 3, 1611571208257872050, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872055, '130821', '承德县', 3, 1611571208257872050, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872056, '130822', '兴隆县', 3, 1611571208257872050, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872057, '130823', '平泉县', 3, 1611571208257872050, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872058, '130824', '滦平县', 3, 1611571208257872050, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872059, '130825', '隆化县', 3, 1611571208257872050, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872060, '130826', '丰宁满族自治县', 3, 1611571208257872050, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872061, '130827', '宽城满族自治县', 3, 1611571208257872050, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872062, '130828', '围场满族蒙古族自治县', 3, 1611571208257872050, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872063, '1309', '沧州市', 2, 1611571208257871911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872064, '130901', '市辖区', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872065, '130902', '新华区', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872066, '130903', '运河区', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872067, '130921', '沧县', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872068, '130922', '青县', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872069, '130923', '东光县', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872070, '130924', '海兴县', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872071, '130925', '盐山县', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872072, '130926', '肃宁县', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872073, '130927', '南皮县', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872074, '130928', '吴桥县', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872075, '130929', '献县', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872076, '130930', '孟村回族自治县', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872077, '130981', '泊头市', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872078, '130982', '任丘市', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872079, '130983', '黄骅市', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872080, '130984', '河间市', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872081, '1310', '廊坊市', 2, 1611571208257871911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872082, '131001', '市辖区', 3, 1611571208257872081, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872083, '131002', '安次区', 3, 1611571208257872081, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872084, '131003', '广阳区', 3, 1611571208257872081, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872085, '131022', '固安县', 3, 1611571208257872081, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872086, '131023', '永清县', 3, 1611571208257872081, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872087, '131024', '香河县', 3, 1611571208257872081, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872088, '131025', '大城县', 3, 1611571208257872081, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872089, '131026', '文安县', 3, 1611571208257872081, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872090, '131028', '大厂回族自治县', 3, 1611571208257872081, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872091, '131081', '霸州市', 3, 1611571208257872081, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872092, '131082', '三河市', 3, 1611571208257872081, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872093, '1311', '衡水市', 2, 1611571208257871911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872094, '131101', '市辖区', 3, 1611571208257872093, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872095, '131102', '桃城区', 3, 1611571208257872093, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872096, '131121', '枣强县', 3, 1611571208257872093, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872097, '131122', '武邑县', 3, 1611571208257872093, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872098, '131123', '武强县', 3, 1611571208257872093, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872099, '131124', '饶阳县', 3, 1611571208257872093, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872100, '131125', '安平县', 3, 1611571208257872093, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872101, '131126', '故城县', 3, 1611571208257872093, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872102, '131127', '景县', 3, 1611571208257872093, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872103, '131128', '阜城县', 3, 1611571208257872093, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872104, '131181', '冀州市', 3, 1611571208257872093, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872105, '131182', '深州市', 3, 1611571208257872093, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872106, '14', '山西', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872107, '1401', '太原市', 2, 1611571208257872106, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872108, '140101', '市辖区', 3, 1611571208257872107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872109, '140105', '小店区', 3, 1611571208257872107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872110, '140106', '迎泽区', 3, 1611571208257872107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872111, '140107', '杏花岭区', 3, 1611571208257872107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872112, '140108', '尖草坪区', 3, 1611571208257872107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872113, '140109', '万柏林区', 3, 1611571208257872107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872114, '140110', '晋源区', 3, 1611571208257872107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872115, '140121', '清徐县', 3, 1611571208257872107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872116, '140122', '阳曲县', 3, 1611571208257872107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872117, '140123', '娄烦县', 3, 1611571208257872107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872118, '140181', '古交市', 3, 1611571208257872107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872119, '1402', '大同市', 2, 1611571208257872106, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872120, '140201', '市辖区', 3, 1611571208257872119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872121, '140202', '城区', 3, 1611571208257872119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872122, '140203', '矿区', 3, 1611571208257872119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872123, '140211', '南郊区', 3, 1611571208257872119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872124, '140212', '新荣区', 3, 1611571208257872119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872125, '140221', '阳高县', 3, 1611571208257872119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872126, '140222', '天镇县', 3, 1611571208257872119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872127, '140223', '广灵县', 3, 1611571208257872119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872128, '140224', '灵丘县', 3, 1611571208257872119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872129, '140225', '浑源县', 3, 1611571208257872119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872130, '140226', '左云县', 3, 1611571208257872119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872131, '140227', '大同县', 3, 1611571208257872119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872132, '1403', '阳泉市', 2, 1611571208257872106, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872133, '140301', '市辖区', 3, 1611571208257872132, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872134, '140302', '城区', 3, 1611571208257872132, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872135, '140303', '矿区', 3, 1611571208257872132, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872136, '140311', '郊区', 3, 1611571208257872132, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872137, '140321', '平定县', 3, 1611571208257872132, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872138, '140322', '盂县', 3, 1611571208257872132, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872139, '1404', '长治市', 2, 1611571208257872106, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872140, '140401', '市辖区', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872141, '140402', '城区', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872142, '140411', '郊区', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872143, '140421', '长治县', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872144, '140423', '襄垣县', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872145, '140424', '屯留县', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872146, '140425', '平顺县', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872147, '140426', '黎城县', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872148, '140427', '壶关县', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872149, '140428', '长子县', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872150, '140429', '武乡县', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872151, '140430', '沁县', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872152, '140431', '沁源县', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872153, '140481', '潞城市', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872154, '1405', '晋城市', 2, 1611571208257872106, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872155, '140501', '市辖区', 3, 1611571208257872154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872156, '140502', '城区', 3, 1611571208257872154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872157, '140521', '沁水县', 3, 1611571208257872154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872158, '140522', '阳城县', 3, 1611571208257872154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872159, '140524', '陵川县', 3, 1611571208257872154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872160, '140525', '泽州县', 3, 1611571208257872154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872161, '140581', '高平市', 3, 1611571208257872154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872162, '1406', '朔州市', 2, 1611571208257872106, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872163, '140601', '市辖区', 3, 1611571208257872162, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872164, '140602', '朔城区', 3, 1611571208257872162, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872165, '140603', '平鲁区', 3, 1611571208257872162, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872166, '140621', '山阴县', 3, 1611571208257872162, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872167, '140622', '应县', 3, 1611571208257872162, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872168, '140623', '右玉县', 3, 1611571208257872162, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872169, '140624', '怀仁县', 3, 1611571208257872162, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872170, '1407', '晋中市', 2, 1611571208257872106, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872171, '140701', '市辖区', 3, 1611571208257872170, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872172, '140702', '榆次区', 3, 1611571208257872170, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872173, '140721', '榆社县', 3, 1611571208257872170, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872174, '140722', '左权县', 3, 1611571208257872170, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872175, '140723', '和顺县', 3, 1611571208257872170, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872176, '140724', '昔阳县', 3, 1611571208257872170, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872177, '140725', '寿阳县', 3, 1611571208257872170, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872178, '140726', '太谷县', 3, 1611571208257872170, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872179, '140727', '祁县', 3, 1611571208257872170, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872180, '140728', '平遥县', 3, 1611571208257872170, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872181, '140729', '灵石县', 3, 1611571208257872170, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872182, '140781', '介休市', 3, 1611571208257872170, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872183, '1408', '运城市', 2, 1611571208257872106, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872184, '140801', '市辖区', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872185, '140802', '盐湖区', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872186, '140821', '临猗县', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872187, '140822', '万荣县', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872188, '140823', '闻喜县', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872189, '140824', '稷山县', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872190, '140825', '新绛县', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872191, '140826', '绛县', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872192, '140827', '垣曲县', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872193, '140828', '夏县', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872194, '140829', '平陆县', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872195, '140830', '芮城县', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872196, '140881', '永济市', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872197, '140882', '河津市', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872198, '1409', '忻州市', 2, 1611571208257872106, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872199, '140901', '市辖区', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872200, '140902', '忻府区', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872201, '140921', '定襄县', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872202, '140922', '五台县', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872203, '140923', '代县', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872204, '140924', '繁峙县', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872205, '140925', '宁武县', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872206, '140926', '静乐县', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872207, '140927', '神池县', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872208, '140928', '五寨县', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872209, '140929', '岢岚县', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872210, '140930', '河曲县', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872211, '140931', '保德县', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872212, '140932', '偏关县', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872213, '140981', '原平市', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872214, '1410', '临汾市', 2, 1611571208257872106, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872215, '141001', '市辖区', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872216, '141002', '尧都区', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872217, '141021', '曲沃县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872218, '141022', '翼城县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872219, '141023', '襄汾县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872220, '141024', '洪洞县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872221, '141025', '古县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872222, '141026', '安泽县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872223, '141027', '浮山县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872224, '141028', '吉县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872225, '141029', '乡宁县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872226, '141030', '大宁县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872227, '141031', '隰县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872228, '141032', '永和县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872229, '141033', '蒲县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872230, '141034', '汾西县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872231, '141081', '侯马市', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872232, '141082', '霍州市', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872233, '1411', '吕梁市', 2, 1611571208257872106, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872234, '141101', '市辖区', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872235, '141102', '离石区', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872236, '141121', '文水县', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872237, '141122', '交城县', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872238, '141123', '兴县', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872239, '141124', '临县', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872240, '141125', '柳林县', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872241, '141126', '石楼县', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872242, '141127', '岚县', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872243, '141128', '方山县', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872244, '141129', '中阳县', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872245, '141130', '交口县', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872246, '141181', '孝义市', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872247, '141182', '汾阳市', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872248, '15', '内蒙古', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872249, '1501', '呼和浩特市', 2, 1611571208257872248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872250, '150101', '市辖区', 3, 1611571208257872249, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872251, '150102', '新城区', 3, 1611571208257872249, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872252, '150103', '回民区', 3, 1611571208257872249, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872253, '150104', '玉泉区', 3, 1611571208257872249, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872254, '150105', '赛罕区', 3, 1611571208257872249, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208257872255, '150121', '土默特左旗', 3, 1611571208257872249, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208530501633, '150122', '托克托县', 3, 1611571208257872249, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056066, '150123', '和林格尔县', 3, 1611571208257872249, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056067, '150124', '清水河县', 3, 1611571208257872249, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056068, '150125', '武川县', 3, 1611571208257872249, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056069, '1502', '包头市', 2, 1611571208257872248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056070, '150201', '市辖区', 3, 1611571208564056069, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056071, '150202', '东河区', 3, 1611571208564056069, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056072, '150203', '昆都仑区', 3, 1611571208564056069, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056073, '150204', '青山区', 3, 1611571208564056069, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056074, '150205', '石拐区', 3, 1611571208564056069, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056075, '150206', '白云鄂博矿区', 3, 1611571208564056069, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056076, '150207', '九原区', 3, 1611571208564056069, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056077, '150221', '土默特右旗', 3, 1611571208564056069, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056078, '150222', '固阳县', 3, 1611571208564056069, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056079, '150223', '达尔罕茂明安联合旗', 3, 1611571208564056069, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056080, '1503', '乌海市', 2, 1611571208257872248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056081, '150301', '市辖区', 3, 1611571208564056080, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056082, '150302', '海勃湾区', 3, 1611571208564056080, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056083, '150303', '海南区', 3, 1611571208564056080, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056084, '150304', '乌达区', 3, 1611571208564056080, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056085, '1504', '赤峰市', 2, 1611571208257872248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056086, '150401', '市辖区', 3, 1611571208564056085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056087, '150402', '红山区', 3, 1611571208564056085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056088, '150403', '元宝山区', 3, 1611571208564056085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056089, '150404', '松山区', 3, 1611571208564056085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056090, '150421', '阿鲁科尔沁旗', 3, 1611571208564056085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056091, '150422', '巴林左旗', 3, 1611571208564056085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056092, '150423', '巴林右旗', 3, 1611571208564056085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056093, '150424', '林西县', 3, 1611571208564056085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056094, '150425', '克什克腾旗', 3, 1611571208564056085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056095, '150426', '翁牛特旗', 3, 1611571208564056085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056096, '150428', '喀喇沁旗', 3, 1611571208564056085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056097, '150429', '宁城县', 3, 1611571208564056085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056098, '150430', '敖汉旗', 3, 1611571208564056085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056099, '1505', '通辽市', 2, 1611571208257872248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056100, '150501', '市辖区', 3, 1611571208564056099, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056101, '150502', '科尔沁区', 3, 1611571208564056099, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056102, '150521', '科尔沁左翼中旗', 3, 1611571208564056099, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056103, '150522', '科尔沁左翼后旗', 3, 1611571208564056099, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056104, '150523', '开鲁县', 3, 1611571208564056099, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056105, '150524', '库伦旗', 3, 1611571208564056099, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056106, '150525', '奈曼旗', 3, 1611571208564056099, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056107, '150526', '扎鲁特旗', 3, 1611571208564056099, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056108, '150581', '霍林郭勒市', 3, 1611571208564056099, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056109, '1506', '鄂尔多斯市', 2, 1611571208257872248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056110, '150601', '市辖区', 3, 1611571208564056109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056111, '150602', '东胜区', 3, 1611571208564056109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056112, '150621', '达拉特旗', 3, 1611571208564056109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056113, '150622', '准格尔旗', 3, 1611571208564056109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056114, '150623', '鄂托克前旗', 3, 1611571208564056109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056115, '150624', '鄂托克旗', 3, 1611571208564056109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056116, '150625', '杭锦旗', 3, 1611571208564056109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056117, '150626', '乌审旗', 3, 1611571208564056109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056118, '150627', '伊金霍洛旗', 3, 1611571208564056109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056119, '1507', '呼伦贝尔市', 2, 1611571208257872248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056120, '150701', '市辖区', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056121, '150702', '海拉尔区', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056122, '150721', '阿荣旗', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056123, '150722', '莫力达瓦达斡尔族自治旗', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056124, '150723', '鄂伦春自治旗', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056125, '150724', '鄂温克族自治旗', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056126, '150725', '陈巴尔虎旗', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056127, '150726', '新巴尔虎左旗', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056128, '150727', '新巴尔虎右旗', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056129, '150781', '满洲里市', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056130, '150782', '牙克石市', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056131, '150783', '扎兰屯市', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056132, '150784', '额尔古纳市', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056133, '150785', '根河市', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056134, '1508', '巴彦淖尔市', 2, 1611571208257872248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056135, '150801', '市辖区', 3, 1611571208564056134, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056136, '150802', '临河区', 3, 1611571208564056134, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056137, '150821', '五原县', 3, 1611571208564056134, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056138, '150822', '磴口县', 3, 1611571208564056134, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056139, '150823', '乌拉特前旗', 3, 1611571208564056134, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056140, '150824', '乌拉特中旗', 3, 1611571208564056134, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056141, '150825', '乌拉特后旗', 3, 1611571208564056134, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056142, '150826', '杭锦后旗', 3, 1611571208564056134, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056143, '1509', '乌兰察布市', 2, 1611571208257872248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056144, '150901', '市辖区', 3, 1611571208564056143, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056145, '150902', '集宁区', 3, 1611571208564056143, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056146, '150921', '卓资县', 3, 1611571208564056143, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056147, '150922', '化德县', 3, 1611571208564056143, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056148, '150923', '商都县', 3, 1611571208564056143, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056149, '150924', '兴和县', 3, 1611571208564056143, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056150, '150925', '凉城县', 3, 1611571208564056143, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056151, '150926', '察哈尔右翼前旗', 3, 1611571208564056143, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056152, '150927', '察哈尔右翼中旗', 3, 1611571208564056143, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056153, '150928', '察哈尔右翼后旗', 3, 1611571208564056143, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056154, '150929', '四子王旗', 3, 1611571208564056143, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056155, '150981', '丰镇市', 3, 1611571208564056143, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056156, '1522', '兴安盟', 2, 1611571208257872248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056157, '152201', '乌兰浩特市', 3, 1611571208564056156, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056158, '152202', '阿尔山市', 3, 1611571208564056156, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056159, '152221', '科尔沁右翼前旗', 3, 1611571208564056156, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056160, '152222', '科尔沁右翼中旗', 3, 1611571208564056156, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056161, '152223', '扎赉特旗', 3, 1611571208564056156, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056162, '152224', '突泉县', 3, 1611571208564056156, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056163, '1525', '锡林郭勒盟', 2, 1611571208257872248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056164, '152501', '二连浩特市', 3, 1611571208564056163, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056165, '152502', '锡林浩特市', 3, 1611571208564056163, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056166, '152522', '阿巴嘎旗', 3, 1611571208564056163, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056167, '152523', '苏尼特左旗', 3, 1611571208564056163, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056168, '152524', '苏尼特右旗', 3, 1611571208564056163, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056169, '152525', '东乌珠穆沁旗', 3, 1611571208564056163, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056170, '152526', '西乌珠穆沁旗', 3, 1611571208564056163, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056171, '152527', '太仆寺旗', 3, 1611571208564056163, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056172, '152528', '镶黄旗', 3, 1611571208564056163, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056173, '152529', '正镶白旗', 3, 1611571208564056163, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056174, '152530', '正蓝旗', 3, 1611571208564056163, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056175, '152531', '多伦县', 3, 1611571208564056163, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056176, '1529', '阿拉善盟', 2, 1611571208257872248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056177, '152921', '阿拉善左旗', 3, 1611571208564056176, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056178, '152922', '阿拉善右旗', 3, 1611571208564056176, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056179, '152923', '额济纳旗', 3, 1611571208564056176, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056180, '21', '辽宁', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056181, '2101', '沈阳市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056182, '210101', '市辖区', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056183, '210102', '和平区', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056184, '210103', '沈河区', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056185, '210104', '大东区', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056186, '210105', '皇姑区', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056187, '210106', '铁西区', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056188, '210111', '苏家屯区', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056189, '210112', '东陵区', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056190, '210113', '沈北新区', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056191, '210114', '于洪区', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056192, '210122', '辽中县', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056193, '210123', '康平县', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056194, '210124', '法库县', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056195, '210181', '新民市', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056196, '2102', '大连市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056197, '210201', '市辖区', 3, 1611571208564056196, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056198, '210202', '中山区', 3, 1611571208564056196, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056199, '210203', '西岗区', 3, 1611571208564056196, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056200, '210204', '沙河口区', 3, 1611571208564056196, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056201, '210211', '甘井子区', 3, 1611571208564056196, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056202, '210212', '旅顺口区', 3, 1611571208564056196, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056203, '210213', '金州区', 3, 1611571208564056196, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056204, '210224', '长海县', 3, 1611571208564056196, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056205, '210281', '瓦房店市', 3, 1611571208564056196, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056206, '210282', '普兰店市', 3, 1611571208564056196, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056207, '210283', '庄河市', 3, 1611571208564056196, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056208, '2103', '鞍山市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056209, '210301', '市辖区', 3, 1611571208564056208, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056210, '210302', '铁东区', 3, 1611571208564056208, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056211, '210303', '铁西区', 3, 1611571208564056208, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056212, '210304', '立山区', 3, 1611571208564056208, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056213, '210311', '千山区', 3, 1611571208564056208, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056214, '210321', '台安县', 3, 1611571208564056208, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056215, '210323', '岫岩满族自治县', 3, 1611571208564056208, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056216, '210381', '海城市', 3, 1611571208564056208, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056217, '2104', '抚顺市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056218, '210401', '市辖区', 3, 1611571208564056217, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056219, '210402', '新抚区', 3, 1611571208564056217, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056220, '210403', '东洲区', 3, 1611571208564056217, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056221, '210404', '望花区', 3, 1611571208564056217, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056222, '210411', '顺城区', 3, 1611571208564056217, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056223, '210421', '抚顺县', 3, 1611571208564056217, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056224, '210422', '新宾满族自治县', 3, 1611571208564056217, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056225, '210423', '清原满族自治县', 3, 1611571208564056217, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056226, '2105', '本溪市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056227, '210501', '市辖区', 3, 1611571208564056226, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056228, '210502', '平山区', 3, 1611571208564056226, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056229, '210503', '溪湖区', 3, 1611571208564056226, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056230, '210504', '明山区', 3, 1611571208564056226, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056231, '210505', '南芬区', 3, 1611571208564056226, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056232, '210521', '本溪满族自治县', 3, 1611571208564056226, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056233, '210522', '桓仁满族自治县', 3, 1611571208564056226, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056234, '2106', '丹东市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056235, '210601', '市辖区', 3, 1611571208564056234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056236, '210602', '元宝区', 3, 1611571208564056234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056237, '210603', '振兴区', 3, 1611571208564056234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056238, '210604', '振安区', 3, 1611571208564056234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056239, '210624', '宽甸满族自治县', 3, 1611571208564056234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056240, '210681', '东港市', 3, 1611571208564056234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056241, '210682', '凤城市', 3, 1611571208564056234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056242, '2107', '锦州市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056243, '210701', '市辖区', 3, 1611571208564056242, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056244, '210702', '古塔区', 3, 1611571208564056242, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056245, '210703', '凌河区', 3, 1611571208564056242, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056246, '210711', '太和区', 3, 1611571208564056242, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056247, '210726', '黑山县', 3, 1611571208564056242, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056248, '210727', '义县', 3, 1611571208564056242, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056249, '210781', '凌海市', 3, 1611571208564056242, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056250, '210782', '北镇市', 3, 1611571208564056242, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056251, '2108', '营口市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056252, '210801', '市辖区', 3, 1611571208564056251, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056253, '210802', '站前区', 3, 1611571208564056251, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056254, '210803', '西市区', 3, 1611571208564056251, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056255, '210804', '鲅鱼圈区', 3, 1611571208564056251, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056256, '210811', '老边区', 3, 1611571208564056251, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056257, '210881', '盖州市', 3, 1611571208564056251, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056258, '210882', '大石桥市', 3, 1611571208564056251, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056259, '2109', '阜新市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056260, '210901', '市辖区', 3, 1611571208564056259, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056261, '210902', '海州区', 3, 1611571208564056259, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056262, '210903', '新邱区', 3, 1611571208564056259, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056263, '210904', '太平区', 3, 1611571208564056259, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056264, '210905', '清河门区', 3, 1611571208564056259, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056265, '210911', '细河区', 3, 1611571208564056259, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056266, '210921', '阜新蒙古族自治县', 3, 1611571208564056259, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056267, '210922', '彰武县', 3, 1611571208564056259, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056268, '2110', '辽阳市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056269, '211001', '市辖区', 3, 1611571208564056268, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056270, '211002', '白塔区', 3, 1611571208564056268, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056271, '211003', '文圣区', 3, 1611571208564056268, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056272, '211004', '宏伟区', 3, 1611571208564056268, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056273, '211005', '弓长岭区', 3, 1611571208564056268, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056274, '211011', '太子河区', 3, 1611571208564056268, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056275, '211021', '辽阳县', 3, 1611571208564056268, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056276, '211081', '灯塔市', 3, 1611571208564056268, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056277, '2111', '盘锦市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056278, '211101', '市辖区', 3, 1611571208564056277, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056279, '211102', '双台子区', 3, 1611571208564056277, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056280, '211103', '兴隆台区', 3, 1611571208564056277, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056281, '211121', '大洼县', 3, 1611571208564056277, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056282, '211122', '盘山县', 3, 1611571208564056277, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056283, '2112', '铁岭市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056284, '211201', '市辖区', 3, 1611571208564056283, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056285, '211202', '银州区', 3, 1611571208564056283, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056286, '211204', '清河区', 3, 1611571208564056283, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056287, '211221', '铁岭县', 3, 1611571208564056283, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056288, '211223', '西丰县', 3, 1611571208564056283, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056289, '211224', '昌图县', 3, 1611571208564056283, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056290, '211281', '调兵山市', 3, 1611571208564056283, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056291, '211282', '开原市', 3, 1611571208564056283, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056292, '2113', '朝阳市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056293, '211301', '市辖区', 3, 1611571208564056292, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056294, '211302', '双塔区', 3, 1611571208564056292, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056295, '211303', '龙城区', 3, 1611571208564056292, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056296, '211321', '朝阳县', 3, 1611571208564056292, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056297, '211322', '建平县', 3, 1611571208564056292, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056298, '211324', '喀喇沁左翼蒙古族自治县', 3, 1611571208564056292, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056299, '211381', '北票市', 3, 1611571208564056292, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056300, '211382', '凌源市', 3, 1611571208564056292, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056301, '2114', '葫芦岛市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056302, '211401', '市辖区', 3, 1611571208564056301, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056303, '211402', '连山区', 3, 1611571208564056301, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056304, '211403', '龙港区', 3, 1611571208564056301, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056305, '211404', '南票区', 3, 1611571208564056301, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056306, '211421', '绥中县', 3, 1611571208564056301, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056307, '211422', '建昌县', 3, 1611571208564056301, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056308, '211481', '兴城市', 3, 1611571208564056301, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056309, '22', '吉林', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056310, '2201', '长春市', 2, 1611571208564056309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056311, '220101', '市辖区', 3, 1611571208564056310, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056312, '220102', '南关区', 3, 1611571208564056310, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056313, '220103', '宽城区', 3, 1611571208564056310, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056314, '220104', '朝阳区', 3, 1611571208564056310, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056315, '220105', '二道区', 3, 1611571208564056310, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056316, '220106', '绿园区', 3, 1611571208564056310, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056317, '220112', '双阳区', 3, 1611571208564056310, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056318, '220122', '农安县', 3, 1611571208564056310, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056319, '220181', '九台市', 3, 1611571208564056310, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056320, '220182', '榆树市', 3, 1611571208564056310, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056321, '220183', '德惠市', 3, 1611571208564056310, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056322, '2202', '吉林市', 2, 1611571208564056309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056323, '220201', '市辖区', 3, 1611571208564056322, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056324, '220202', '昌邑区', 3, 1611571208564056322, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056325, '220203', '龙潭区', 3, 1611571208564056322, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056326, '220204', '船营区', 3, 1611571208564056322, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056327, '220211', '丰满区', 3, 1611571208564056322, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056328, '220221', '永吉县', 3, 1611571208564056322, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056329, '220281', '蛟河市', 3, 1611571208564056322, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056330, '220282', '桦甸市', 3, 1611571208564056322, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056331, '220283', '舒兰市', 3, 1611571208564056322, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056332, '220284', '磐石市', 3, 1611571208564056322, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056333, '2203', '四平市', 2, 1611571208564056309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056334, '220301', '市辖区', 3, 1611571208564056333, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056335, '220302', '铁西区', 3, 1611571208564056333, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056336, '220303', '铁东区', 3, 1611571208564056333, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056337, '220322', '梨树县', 3, 1611571208564056333, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056338, '220323', '伊通满族自治县', 3, 1611571208564056333, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056339, '220381', '公主岭市', 3, 1611571208564056333, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056340, '220382', '双辽市', 3, 1611571208564056333, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056341, '2204', '辽源市', 2, 1611571208564056309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056342, '220401', '市辖区', 3, 1611571208564056341, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056343, '220402', '龙山区', 3, 1611571208564056341, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056344, '220403', '西安区', 3, 1611571208564056341, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056345, '220421', '东丰县', 3, 1611571208564056341, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056346, '220422', '东辽县', 3, 1611571208564056341, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056347, '2205', '通化市', 2, 1611571208564056309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056348, '220501', '市辖区', 3, 1611571208564056347, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056349, '220502', '东昌区', 3, 1611571208564056347, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056350, '220503', '二道江区', 3, 1611571208564056347, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056351, '220521', '通化县', 3, 1611571208564056347, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056352, '220523', '辉南县', 3, 1611571208564056347, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056353, '220524', '柳河县', 3, 1611571208564056347, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056354, '220581', '梅河口市', 3, 1611571208564056347, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056355, '220582', '集安市', 3, 1611571208564056347, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056356, '2206', '白山市', 2, 1611571208564056309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056357, '220601', '市辖区', 3, 1611571208564056356, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056358, '220602', '浑江区', 3, 1611571208564056356, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056359, '220605', '江源区', 3, 1611571208564056356, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056360, '220621', '抚松县', 3, 1611571208564056356, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056361, '220622', '靖宇县', 3, 1611571208564056356, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056362, '220623', '长白朝鲜族自治县', 3, 1611571208564056356, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056363, '220681', '临江市', 3, 1611571208564056356, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056364, '2207', '松原市', 2, 1611571208564056309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056365, '220701', '市辖区', 3, 1611571208564056364, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056366, '220702', '宁江区', 3, 1611571208564056364, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056367, '220721', '前郭尔罗斯蒙古族自治县', 3, 1611571208564056364, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056368, '220722', '长岭县', 3, 1611571208564056364, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056369, '220723', '乾安县', 3, 1611571208564056364, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056370, '220724', '扶余县', 3, 1611571208564056364, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056371, '2208', '白城市', 2, 1611571208564056309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056372, '220801', '市辖区', 3, 1611571208564056371, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056373, '220802', '洮北区', 3, 1611571208564056371, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056374, '220821', '镇赉县', 3, 1611571208564056371, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056375, '220822', '通榆县', 3, 1611571208564056371, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056376, '220881', '洮南市', 3, 1611571208564056371, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056377, '220882', '大安市', 3, 1611571208564056371, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056378, '2224', '延边朝鲜族自治州', 2, 1611571208564056309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056379, '222401', '延吉市', 3, 1611571208564056378, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056380, '222402', '图们市', 3, 1611571208564056378, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056381, '222403', '敦化市', 3, 1611571208564056378, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056382, '222404', '珲春市', 3, 1611571208564056378, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056383, '222405', '龙井市', 3, 1611571208564056378, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056384, '222406', '和龙市', 3, 1611571208564056378, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056385, '222424', '汪清县', 3, 1611571208564056378, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056386, '222426', '安图县', 3, 1611571208564056378, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056387, '23', '黑龙江', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056388, '2301', '哈尔滨市', 2, 1611571208564056387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056389, '230101', '市辖区', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056390, '230102', '道里区', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056391, '230103', '南岗区', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056392, '230104', '道外区', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056393, '230108', '平房区', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056394, '230109', '松北区', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056395, '230110', '香坊区', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056396, '230111', '呼兰区', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056397, '230112', '阿城区', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056398, '230123', '依兰县', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056399, '230124', '方正县', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056400, '230125', '宾县', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056401, '230126', '巴彦县', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056402, '230127', '木兰县', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056403, '230128', '通河县', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056404, '230129', '延寿县', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056405, '230182', '双城市', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056406, '230183', '尚志市', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056407, '230184', '五常市', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056408, '2302', '齐齐哈尔市', 2, 1611571208564056387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056409, '230201', '市辖区', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056410, '230202', '龙沙区', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056411, '230203', '建华区', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056412, '230204', '铁锋区', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056413, '230205', '昂昂溪区', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056414, '230206', '富拉尔基区', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056415, '230207', '碾子山区', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056416, '230208', '梅里斯达斡尔族区', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056417, '230221', '龙江县', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056418, '230223', '依安县', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056419, '230224', '泰来县', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056420, '230225', '甘南县', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056421, '230227', '富裕县', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056422, '230229', '克山县', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056423, '230230', '克东县', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056424, '230231', '拜泉县', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056425, '230281', '讷河市', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056426, '2303', '鸡西市', 2, 1611571208564056387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056427, '230301', '市辖区', 3, 1611571208564056426, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056428, '230302', '鸡冠区', 3, 1611571208564056426, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056429, '230303', '恒山区', 3, 1611571208564056426, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056430, '230304', '滴道区', 3, 1611571208564056426, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056431, '230305', '梨树区', 3, 1611571208564056426, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056432, '230306', '城子河区', 3, 1611571208564056426, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056433, '230307', '麻山区', 3, 1611571208564056426, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056434, '230321', '鸡东县', 3, 1611571208564056426, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056435, '230381', '虎林市', 3, 1611571208564056426, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056436, '230382', '密山市', 3, 1611571208564056426, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056437, '2304', '鹤岗市', 2, 1611571208564056387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056438, '230401', '市辖区', 3, 1611571208564056437, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056439, '230402', '向阳区', 3, 1611571208564056437, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056440, '230403', '工农区', 3, 1611571208564056437, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056441, '230404', '南山区', 3, 1611571208564056437, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056442, '230405', '兴安区', 3, 1611571208564056437, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056443, '230406', '东山区', 3, 1611571208564056437, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056444, '230407', '兴山区', 3, 1611571208564056437, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056445, '230421', '萝北县', 3, 1611571208564056437, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056446, '230422', '绥滨县', 3, 1611571208564056437, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056447, '2305', '双鸭山市', 2, 1611571208564056387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056448, '230501', '市辖区', 3, 1611571208564056447, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056449, '230502', '尖山区', 3, 1611571208564056447, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056450, '230503', '岭东区', 3, 1611571208564056447, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056451, '230505', '四方台区', 3, 1611571208564056447, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056452, '230506', '宝山区', 3, 1611571208564056447, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056453, '230521', '集贤县', 3, 1611571208564056447, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056454, '230522', '友谊县', 3, 1611571208564056447, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056455, '230523', '宝清县', 3, 1611571208564056447, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056456, '230524', '饶河县', 3, 1611571208564056447, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056457, '2306', '大庆市', 2, 1611571208564056387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056458, '230601', '市辖区', 3, 1611571208564056457, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056459, '230602', '萨尔图区', 3, 1611571208564056457, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056460, '230603', '龙凤区', 3, 1611571208564056457, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056461, '230604', '让胡路区', 3, 1611571208564056457, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056462, '230605', '红岗区', 3, 1611571208564056457, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056463, '230606', '大同区', 3, 1611571208564056457, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056464, '230621', '肇州县', 3, 1611571208564056457, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056465, '230622', '肇源县', 3, 1611571208564056457, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056466, '230623', '林甸县', 3, 1611571208564056457, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056467, '230624', '杜尔伯特蒙古族自治县', 3, 1611571208564056457, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056468, '2307', '伊春市', 2, 1611571208564056387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056469, '230701', '市辖区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056470, '230702', '伊春区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056471, '230703', '南岔区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056472, '230704', '友好区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056473, '230705', '西林区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056474, '230706', '翠峦区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056475, '230707', '新青区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056476, '230708', '美溪区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056477, '230709', '金山屯区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056478, '230710', '五营区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056479, '230711', '乌马河区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056480, '230712', '汤旺河区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056481, '230713', '带岭区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056482, '230714', '乌伊岭区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056483, '230715', '红星区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056484, '230716', '上甘岭区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056485, '230722', '嘉荫县', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056486, '230781', '铁力市', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056487, '2308', '佳木斯市', 2, 1611571208564056387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056488, '230801', '市辖区', 3, 1611571208564056487, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056489, '230803', '向阳区', 3, 1611571208564056487, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056490, '230804', '前进区', 3, 1611571208564056487, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056491, '230805', '东风区', 3, 1611571208564056487, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056492, '230811', '郊区', 3, 1611571208564056487, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056493, '230822', '桦南县', 3, 1611571208564056487, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056494, '230826', '桦川县', 3, 1611571208564056487, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056495, '230828', '汤原县', 3, 1611571208564056487, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056496, '230833', '抚远县', 3, 1611571208564056487, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056497, '230881', '同江市', 3, 1611571208564056487, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056498, '230882', '富锦市', 3, 1611571208564056487, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056499, '2309', '七台河市', 2, 1611571208564056387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056500, '230901', '市辖区', 3, 1611571208564056499, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056501, '230902', '新兴区', 3, 1611571208564056499, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056502, '230903', '桃山区', 3, 1611571208564056499, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056503, '230904', '茄子河区', 3, 1611571208564056499, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056504, '230921', '勃利县', 3, 1611571208564056499, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056505, '2310', '牡丹江市', 2, 1611571208564056387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056506, '231001', '市辖区', 3, 1611571208564056505, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056507, '231002', '东安区', 3, 1611571208564056505, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056508, '231003', '阳明区', 3, 1611571208564056505, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056509, '231004', '爱民区', 3, 1611571208564056505, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056510, '231005', '西安区', 3, 1611571208564056505, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056511, '231024', '东宁县', 3, 1611571208564056505, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056512, '231025', '林口县', 3, 1611571208564056505, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056513, '231081', '绥芬河市', 3, 1611571208564056505, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056514, '231083', '海林市', 3, 1611571208564056505, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056515, '231084', '宁安市', 3, 1611571208564056505, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056516, '231085', '穆棱市', 3, 1611571208564056505, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056517, '2311', '黑河市', 2, 1611571208564056387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056518, '231101', '市辖区', 3, 1611571208564056517, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056519, '231102', '爱辉区', 3, 1611571208564056517, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056520, '231121', '嫩江县', 3, 1611571208564056517, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056521, '231123', '逊克县', 3, 1611571208564056517, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056522, '231124', '孙吴县', 3, 1611571208564056517, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056523, '231181', '北安市', 3, 1611571208564056517, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056524, '231182', '五大连池市', 3, 1611571208564056517, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056525, '2312', '绥化市', 2, 1611571208564056387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056526, '231201', '市辖区', 3, 1611571208564056525, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056527, '231202', '北林区', 3, 1611571208564056525, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056528, '231221', '望奎县', 3, 1611571208564056525, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056529, '231222', '兰西县', 3, 1611571208564056525, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056530, '231223', '青冈县', 3, 1611571208564056525, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056531, '231224', '庆安县', 3, 1611571208564056525, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056532, '231225', '明水县', 3, 1611571208564056525, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056533, '231226', '绥棱县', 3, 1611571208564056525, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056534, '231281', '安达市', 3, 1611571208564056525, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056535, '231282', '肇东市', 3, 1611571208564056525, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056536, '231283', '海伦市', 3, 1611571208564056525, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056537, '2327', '大兴安岭地区', 2, 1611571208564056387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056538, '232721', '呼玛县', 3, 1611571208564056537, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056539, '232722', '塔河县', 3, 1611571208564056537, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056540, '232723', '漠河县', 3, 1611571208564056537, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056541, '31', '上海', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056542, '3101', '市辖区', 2, 1611571208564056541, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056543, '310101', '黄浦区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056544, '310104', '徐汇区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056545, '310105', '长宁区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056546, '310106', '静安区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056547, '310107', '普陀区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056548, '310108', '闸北区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056549, '310109', '虹口区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056550, '310110', '杨浦区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056551, '310112', '闵行区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056552, '310113', '宝山区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056553, '310114', '嘉定区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056554, '310115', '浦东新区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056555, '310116', '金山区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056556, '310117', '松江区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056557, '310118', '青浦区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056558, '310120', '奉贤区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056559, '3102', '县', 2, 1611571208564056541, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056560, '310230', '崇明县', 3, 1611571208564056559, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056561, '32', '江苏', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056562, '3201', '南京市', 2, 1611571208564056561, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056563, '320101', '市辖区', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056564, '320102', '玄武区', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056565, '320103', '白下区', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056566, '320104', '秦淮区', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056567, '320105', '建邺区', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056568, '320106', '鼓楼区', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056569, '320107', '下关区', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056570, '320111', '浦口区', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056571, '320113', '栖霞区', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056572, '320114', '雨花台区', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056573, '320115', '江宁区', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056574, '320116', '六合区', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056575, '320124', '溧水县', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056576, '320125', '高淳县', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056577, '3202', '无锡市', 2, 1611571208564056561, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056578, '320201', '市辖区', 3, 1611571208564056577, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056579, '320202', '崇安区', 3, 1611571208564056577, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056580, '320203', '南长区', 3, 1611571208564056577, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056581, '320204', '北塘区', 3, 1611571208564056577, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056582, '320205', '锡山区', 3, 1611571208564056577, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056583, '320206', '惠山区', 3, 1611571208564056577, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056584, '320211', '滨湖区', 3, 1611571208564056577, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056585, '320281', '江阴市', 3, 1611571208564056577, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056586, '320282', '宜兴市', 3, 1611571208564056577, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056587, '3203', '徐州市', 2, 1611571208564056561, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056588, '320301', '市辖区', 3, 1611571208564056587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056589, '320302', '鼓楼区', 3, 1611571208564056587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056590, '320303', '云龙区', 3, 1611571208564056587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056591, '320305', '贾汪区', 3, 1611571208564056587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056592, '320311', '泉山区', 3, 1611571208564056587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056593, '320312', '铜山区', 3, 1611571208564056587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056594, '320321', '丰县', 3, 1611571208564056587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056595, '320322', '沛县', 3, 1611571208564056587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056596, '320324', '睢宁县', 3, 1611571208564056587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056597, '320381', '新沂市', 3, 1611571208564056587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056598, '320382', '邳州市', 3, 1611571208564056587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056599, '3204', '常州市', 2, 1611571208564056561, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056600, '320401', '市辖区', 3, 1611571208564056599, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056601, '320402', '天宁区', 3, 1611571208564056599, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056602, '320404', '钟楼区', 3, 1611571208564056599, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056603, '320405', '戚墅堰区', 3, 1611571208564056599, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056604, '320411', '新北区', 3, 1611571208564056599, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056605, '320412', '武进区', 3, 1611571208564056599, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056606, '320481', '溧阳市', 3, 1611571208564056599, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056607, '320482', '金坛市', 3, 1611571208564056599, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056608, '3205', '苏州市', 2, 1611571208564056561, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056609, '320501', '市辖区', 3, 1611571208564056608, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056610, '320505', '虎丘区', 3, 1611571208564056608, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056611, '320506', '吴中区', 3, 1611571208564056608, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056612, '320507', '相城区', 3, 1611571208564056608, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056613, '320508', '姑苏区', 3, 1611571208564056608, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056614, '320509', '吴江区', 3, 1611571208564056608, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056615, '320581', '常熟市', 3, 1611571208564056608, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056616, '320582', '张家港市', 3, 1611571208564056608, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056617, '320583', '昆山市', 3, 1611571208564056608, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056618, '320585', '太仓市', 3, 1611571208564056608, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056619, '3206', '南通市', 2, 1611571208564056561, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056620, '320601', '市辖区', 3, 1611571208564056619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056621, '320602', '崇川区', 3, 1611571208564056619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056622, '320611', '港闸区', 3, 1611571208564056619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056623, '320612', '通州区', 3, 1611571208564056619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056624, '320621', '海安县', 3, 1611571208564056619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056625, '320623', '如东县', 3, 1611571208564056619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056626, '320681', '启东市', 3, 1611571208564056619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056627, '320682', '如皋市', 3, 1611571208564056619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056628, '320684', '海门市', 3, 1611571208564056619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056629, '3207', '连云港市', 2, 1611571208564056561, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056630, '320701', '市辖区', 3, 1611571208564056629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056631, '320703', '连云区', 3, 1611571208564056629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056632, '320705', '新浦区', 3, 1611571208564056629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056633, '320706', '海州区', 3, 1611571208564056629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056634, '320721', '赣榆县', 3, 1611571208564056629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056635, '320722', '东海县', 3, 1611571208564056629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056636, '320723', '灌云县', 3, 1611571208564056629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056637, '320724', '灌南县', 3, 1611571208564056629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056638, '3208', '淮安市', 2, 1611571208564056561, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056639, '320801', '市辖区', 3, 1611571208564056638, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056640, '320802', '清河区', 3, 1611571208564056638, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056641, '320803', '淮安区', 3, 1611571208564056638, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056642, '320804', '淮阴区', 3, 1611571208564056638, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056643, '320811', '清浦区', 3, 1611571208564056638, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056644, '320826', '涟水县', 3, 1611571208564056638, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056645, '320829', '洪泽县', 3, 1611571208564056638, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056646, '320830', '盱眙县', 3, 1611571208564056638, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056647, '320831', '金湖县', 3, 1611571208564056638, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056648, '3209', '盐城市', 2, 1611571208564056561, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056649, '320901', '市辖区', 3, 1611571208564056648, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056650, '320902', '亭湖区', 3, 1611571208564056648, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056651, '320903', '盐都区', 3, 1611571208564056648, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056652, '320921', '响水县', 3, 1611571208564056648, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056653, '320922', '滨海县', 3, 1611571208564056648, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056654, '320923', '阜宁县', 3, 1611571208564056648, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056655, '320924', '射阳县', 3, 1611571208564056648, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056656, '320925', '建湖县', 3, 1611571208564056648, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056657, '320981', '东台市', 3, 1611571208564056648, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056658, '320982', '大丰市', 3, 1611571208564056648, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056659, '3210', '扬州市', 2, 1611571208564056561, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056660, '321001', '市辖区', 3, 1611571208564056659, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056661, '321002', '广陵区', 3, 1611571208564056659, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056662, '321003', '邗江区', 3, 1611571208564056659, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056663, '321012', '江都区', 3, 1611571208564056659, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056664, '321023', '宝应县', 3, 1611571208564056659, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056665, '321081', '仪征市', 3, 1611571208564056659, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056666, '321084', '高邮市', 3, 1611571208564056659, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056667, '3211', '镇江市', 2, 1611571208564056561, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056668, '321101', '市辖区', 3, 1611571208564056667, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056669, '321102', '京口区', 3, 1611571208564056667, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056670, '321111', '润州区', 3, 1611571208564056667, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056671, '321112', '丹徒区', 3, 1611571208564056667, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056672, '321181', '丹阳市', 3, 1611571208564056667, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056673, '321182', '扬中市', 3, 1611571208564056667, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056674, '321183', '句容市', 3, 1611571208564056667, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056675, '3212', '泰州市', 2, 1611571208564056561, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056676, '321201', '市辖区', 3, 1611571208564056675, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056677, '321202', '海陵区', 3, 1611571208564056675, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056678, '321203', '高港区', 3, 1611571208564056675, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056679, '321281', '兴化市', 3, 1611571208564056675, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056680, '321282', '靖江市', 3, 1611571208564056675, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056681, '321283', '泰兴市', 3, 1611571208564056675, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056682, '321284', '姜堰市', 3, 1611571208564056675, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056683, '3213', '宿迁市', 2, 1611571208564056561, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056684, '321301', '市辖区', 3, 1611571208564056683, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056685, '321302', '宿城区', 3, 1611571208564056683, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056686, '321311', '宿豫区', 3, 1611571208564056683, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056687, '321322', '沭阳县', 3, 1611571208564056683, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056688, '321323', '泗阳县', 3, 1611571208564056683, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056689, '321324', '泗洪县', 3, 1611571208564056683, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056690, '33', '浙江', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056691, '3301', '杭州市', 2, 1611571208564056690, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056692, '330101', '市辖区', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056693, '330102', '上城区', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056694, '330103', '下城区', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056695, '330104', '江干区', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056696, '330105', '拱墅区', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056697, '330106', '西湖区', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056698, '330108', '滨江区', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056699, '330109', '萧山区', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056700, '330110', '余杭区', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056701, '330122', '桐庐县', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056702, '330127', '淳安县', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056703, '330182', '建德市', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056704, '330183', '富阳市', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056705, '330185', '临安市', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056706, '3302', '宁波市', 2, 1611571208564056690, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056707, '330201', '市辖区', 3, 1611571208564056706, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056708, '330203', '海曙区', 3, 1611571208564056706, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056709, '330204', '江东区', 3, 1611571208564056706, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056710, '330205', '江北区', 3, 1611571208564056706, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056711, '330206', '北仑区', 3, 1611571208564056706, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056712, '330211', '镇海区', 3, 1611571208564056706, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056713, '330212', '鄞州区', 3, 1611571208564056706, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056714, '330225', '象山县', 3, 1611571208564056706, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056715, '330226', '宁海县', 3, 1611571208564056706, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056716, '330281', '余姚市', 3, 1611571208564056706, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056717, '330282', '慈溪市', 3, 1611571208564056706, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056718, '330283', '奉化市', 3, 1611571208564056706, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056719, '3303', '温州市', 2, 1611571208564056690, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056720, '330301', '市辖区', 3, 1611571208564056719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056721, '330302', '鹿城区', 3, 1611571208564056719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056722, '330303', '龙湾区', 3, 1611571208564056719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056723, '330304', '瓯海区', 3, 1611571208564056719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056724, '330322', '洞头县', 3, 1611571208564056719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056725, '330324', '永嘉县', 3, 1611571208564056719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056726, '330326', '平阳县', 3, 1611571208564056719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056727, '330327', '苍南县', 3, 1611571208564056719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056728, '330328', '文成县', 3, 1611571208564056719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056729, '330329', '泰顺县', 3, 1611571208564056719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056730, '330381', '瑞安市', 3, 1611571208564056719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056731, '330382', '乐清市', 3, 1611571208564056719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056732, '3304', '嘉兴市', 2, 1611571208564056690, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056733, '330401', '市辖区', 3, 1611571208564056732, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056734, '330402', '南湖区', 3, 1611571208564056732, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056735, '330411', '秀洲区', 3, 1611571208564056732, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056736, '330421', '嘉善县', 3, 1611571208564056732, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056737, '330424', '海盐县', 3, 1611571208564056732, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056738, '330481', '海宁市', 3, 1611571208564056732, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056739, '330482', '平湖市', 3, 1611571208564056732, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056740, '330483', '桐乡市', 3, 1611571208564056732, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056741, '3305', '湖州市', 2, 1611571208564056690, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056742, '330501', '市辖区', 3, 1611571208564056741, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056743, '330502', '吴兴区', 3, 1611571208564056741, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056744, '330503', '南浔区', 3, 1611571208564056741, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056745, '330521', '德清县', 3, 1611571208564056741, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056746, '330522', '长兴县', 3, 1611571208564056741, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056747, '330523', '安吉县', 3, 1611571208564056741, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056748, '3306', '绍兴市', 2, 1611571208564056690, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056749, '330601', '市辖区', 3, 1611571208564056748, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056750, '330602', '越城区', 3, 1611571208564056748, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056751, '330621', '绍兴县', 3, 1611571208564056748, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056752, '330624', '新昌县', 3, 1611571208564056748, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056753, '330681', '诸暨市', 3, 1611571208564056748, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056754, '330682', '上虞市', 3, 1611571208564056748, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056755, '330683', '嵊州市', 3, 1611571208564056748, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056756, '3307', '金华市', 2, 1611571208564056690, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056757, '330701', '市辖区', 3, 1611571208564056756, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056758, '330702', '婺城区', 3, 1611571208564056756, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056759, '330703', '金东区', 3, 1611571208564056756, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056760, '330723', '武义县', 3, 1611571208564056756, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056761, '330726', '浦江县', 3, 1611571208564056756, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056762, '330727', '磐安县', 3, 1611571208564056756, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056763, '330781', '兰溪市', 3, 1611571208564056756, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056764, '330782', '义乌市', 3, 1611571208564056756, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056765, '330783', '东阳市', 3, 1611571208564056756, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056766, '330784', '永康市', 3, 1611571208564056756, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056767, '3308', '衢州市', 2, 1611571208564056690, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056768, '330801', '市辖区', 3, 1611571208564056767, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056769, '330802', '柯城区', 3, 1611571208564056767, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056770, '330803', '衢江区', 3, 1611571208564056767, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056771, '330822', '常山县', 3, 1611571208564056767, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056772, '330824', '开化县', 3, 1611571208564056767, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056773, '330825', '龙游县', 3, 1611571208564056767, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056774, '330881', '江山市', 3, 1611571208564056767, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056775, '3309', '舟山市', 2, 1611571208564056690, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056776, '330901', '市辖区', 3, 1611571208564056775, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056777, '330902', '定海区', 3, 1611571208564056775, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056778, '330903', '普陀区', 3, 1611571208564056775, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056779, '330921', '岱山县', 3, 1611571208564056775, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056780, '330922', '嵊泗县', 3, 1611571208564056775, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056781, '3310', '台州市', 2, 1611571208564056690, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056782, '331001', '市辖区', 3, 1611571208564056781, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056783, '331002', '椒江区', 3, 1611571208564056781, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056784, '331003', '黄岩区', 3, 1611571208564056781, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056785, '331004', '路桥区', 3, 1611571208564056781, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056786, '331021', '玉环县', 3, 1611571208564056781, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056787, '331022', '三门县', 3, 1611571208564056781, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056788, '331023', '天台县', 3, 1611571208564056781, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056789, '331024', '仙居县', 3, 1611571208564056781, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056790, '331081', '温岭市', 3, 1611571208564056781, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056791, '331082', '临海市', 3, 1611571208564056781, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056792, '3311', '丽水市', 2, 1611571208564056690, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056793, '331101', '市辖区', 3, 1611571208564056792, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056794, '331102', '莲都区', 3, 1611571208564056792, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056795, '331121', '青田县', 3, 1611571208564056792, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056796, '331122', '缙云县', 3, 1611571208564056792, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056797, '331123', '遂昌县', 3, 1611571208564056792, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056798, '331124', '松阳县', 3, 1611571208564056792, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056799, '331125', '云和县', 3, 1611571208564056792, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056800, '331126', '庆元县', 3, 1611571208564056792, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056801, '331127', '景宁畲族自治县', 3, 1611571208564056792, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056802, '331181', '龙泉市', 3, 1611571208564056792, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056803, '34', '安徽', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056804, '3401', '合肥市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056805, '340101', '市辖区', 3, 1611571208564056804, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056806, '340102', '瑶海区', 3, 1611571208564056804, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056807, '340103', '庐阳区', 3, 1611571208564056804, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056808, '340104', '蜀山区', 3, 1611571208564056804, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056809, '340111', '包河区', 3, 1611571208564056804, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056810, '340121', '长丰县', 3, 1611571208564056804, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056811, '340122', '肥东县', 3, 1611571208564056804, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056812, '340123', '肥西县', 3, 1611571208564056804, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056813, '340124', '庐江县', 3, 1611571208564056804, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056814, '340181', '巢湖市', 3, 1611571208564056804, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056815, '3402', '芜湖市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056816, '340201', '市辖区', 3, 1611571208564056815, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056817, '340202', '镜湖区', 3, 1611571208564056815, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056818, '340203', '弋江区', 3, 1611571208564056815, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056819, '340207', '鸠江区', 3, 1611571208564056815, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056820, '340208', '三山区', 3, 1611571208564056815, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056821, '340221', '芜湖县', 3, 1611571208564056815, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056822, '340222', '繁昌县', 3, 1611571208564056815, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056823, '340223', '南陵县', 3, 1611571208564056815, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056824, '340225', '无为县', 3, 1611571208564056815, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056825, '3403', '蚌埠市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056826, '340301', '市辖区', 3, 1611571208564056825, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056827, '340302', '龙子湖区', 3, 1611571208564056825, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056828, '340303', '蚌山区', 3, 1611571208564056825, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056829, '340304', '禹会区', 3, 1611571208564056825, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056830, '340311', '淮上区', 3, 1611571208564056825, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056831, '340321', '怀远县', 3, 1611571208564056825, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056832, '340322', '五河县', 3, 1611571208564056825, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056833, '340323', '固镇县', 3, 1611571208564056825, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056834, '3404', '淮南市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056835, '340401', '市辖区', 3, 1611571208564056834, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056836, '340402', '大通区', 3, 1611571208564056834, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056837, '340403', '田家庵区', 3, 1611571208564056834, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056838, '340404', '谢家集区', 3, 1611571208564056834, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056839, '340405', '八公山区', 3, 1611571208564056834, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056840, '340406', '潘集区', 3, 1611571208564056834, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056841, '340421', '凤台县', 3, 1611571208564056834, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056842, '3405', '马鞍山市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056843, '340501', '市辖区', 3, 1611571208564056842, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056844, '340503', '花山区', 3, 1611571208564056842, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056845, '340504', '雨山区', 3, 1611571208564056842, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056846, '340506', '博望区', 3, 1611571208564056842, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056847, '340521', '当涂县', 3, 1611571208564056842, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056848, '340522', '含山县', 3, 1611571208564056842, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056849, '340523', '和县', 3, 1611571208564056842, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056850, '3406', '淮北市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056851, '340601', '市辖区', 3, 1611571208564056850, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056852, '340602', '杜集区', 3, 1611571208564056850, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056853, '340603', '相山区', 3, 1611571208564056850, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056854, '340604', '烈山区', 3, 1611571208564056850, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056855, '340621', '濉溪县', 3, 1611571208564056850, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056856, '3407', '铜陵市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056857, '340701', '市辖区', 3, 1611571208564056856, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056858, '340702', '铜官山区', 3, 1611571208564056856, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056859, '340703', '狮子山区', 3, 1611571208564056856, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056860, '340711', '郊区', 3, 1611571208564056856, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056861, '340721', '铜陵县', 3, 1611571208564056856, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056862, '3408', '安庆市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056863, '340801', '市辖区', 3, 1611571208564056862, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056864, '340802', '迎江区', 3, 1611571208564056862, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056865, '340803', '大观区', 3, 1611571208564056862, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056866, '340811', '宜秀区', 3, 1611571208564056862, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056867, '340822', '怀宁县', 3, 1611571208564056862, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056868, '340823', '枞阳县', 3, 1611571208564056862, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056869, '340824', '潜山县', 3, 1611571208564056862, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056870, '340825', '太湖县', 3, 1611571208564056862, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056871, '340826', '宿松县', 3, 1611571208564056862, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056872, '340827', '望江县', 3, 1611571208564056862, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056873, '340828', '岳西县', 3, 1611571208564056862, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056874, '340881', '桐城市', 3, 1611571208564056862, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056875, '3410', '黄山市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056876, '341001', '市辖区', 3, 1611571208564056875, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056877, '341002', '屯溪区', 3, 1611571208564056875, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056878, '341003', '黄山区', 3, 1611571208564056875, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056879, '341004', '徽州区', 3, 1611571208564056875, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056880, '341021', '歙县', 3, 1611571208564056875, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056881, '341022', '休宁县', 3, 1611571208564056875, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056882, '341023', '黟县', 3, 1611571208564056875, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056883, '341024', '祁门县', 3, 1611571208564056875, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056884, '3411', '滁州市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056885, '341101', '市辖区', 3, 1611571208564056884, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056886, '341102', '琅琊区', 3, 1611571208564056884, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056887, '341103', '南谯区', 3, 1611571208564056884, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056888, '341122', '来安县', 3, 1611571208564056884, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056889, '341124', '全椒县', 3, 1611571208564056884, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056890, '341125', '定远县', 3, 1611571208564056884, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056891, '341126', '凤阳县', 3, 1611571208564056884, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056892, '341181', '天长市', 3, 1611571208564056884, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056893, '341182', '明光市', 3, 1611571208564056884, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056894, '3412', '阜阳市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056895, '341201', '市辖区', 3, 1611571208564056894, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056896, '341202', '颍州区', 3, 1611571208564056894, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056897, '341203', '颍东区', 3, 1611571208564056894, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056898, '341204', '颍泉区', 3, 1611571208564056894, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056899, '341221', '临泉县', 3, 1611571208564056894, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056900, '341222', '太和县', 3, 1611571208564056894, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056901, '341225', '阜南县', 3, 1611571208564056894, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056902, '341226', '颍上县', 3, 1611571208564056894, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056903, '341282', '界首市', 3, 1611571208564056894, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056904, '3413', '宿州市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056905, '341301', '市辖区', 3, 1611571208564056904, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056906, '341302', '埇桥区', 3, 1611571208564056904, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056907, '341321', '砀山县', 3, 1611571208564056904, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056908, '341322', '萧县', 3, 1611571208564056904, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056909, '341323', '灵璧县', 3, 1611571208564056904, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056910, '341324', '泗县', 3, 1611571208564056904, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056911, '3415', '六安市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056912, '341501', '市辖区', 3, 1611571208564056911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056913, '341502', '金安区', 3, 1611571208564056911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056914, '341503', '裕安区', 3, 1611571208564056911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056915, '341521', '寿县', 3, 1611571208564056911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056916, '341522', '霍邱县', 3, 1611571208564056911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056917, '341523', '舒城县', 3, 1611571208564056911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056918, '341524', '金寨县', 3, 1611571208564056911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056919, '341525', '霍山县', 3, 1611571208564056911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056920, '3416', '亳州市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056921, '341601', '市辖区', 3, 1611571208564056920, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056922, '341602', '谯城区', 3, 1611571208564056920, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056923, '341621', '涡阳县', 3, 1611571208564056920, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056924, '341622', '蒙城县', 3, 1611571208564056920, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056925, '341623', '利辛县', 3, 1611571208564056920, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056926, '3417', '池州市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056927, '341701', '市辖区', 3, 1611571208564056926, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056928, '341702', '贵池区', 3, 1611571208564056926, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056929, '341721', '东至县', 3, 1611571208564056926, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056930, '341722', '石台县', 3, 1611571208564056926, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056931, '341723', '青阳县', 3, 1611571208564056926, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056932, '3418', '宣城市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056933, '341801', '市辖区', 3, 1611571208564056932, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056934, '341802', '宣州区', 3, 1611571208564056932, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056935, '341821', '郎溪县', 3, 1611571208564056932, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056936, '341822', '广德县', 3, 1611571208564056932, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056937, '341823', '泾县', 3, 1611571208564056932, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056938, '341824', '绩溪县', 3, 1611571208564056932, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056939, '341825', '旌德县', 3, 1611571208564056932, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056940, '341881', '宁国市', 3, 1611571208564056932, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056941, '35', '福建', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056942, '3501', '福州市', 2, 1611571208564056941, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056943, '350101', '市辖区', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056944, '350102', '鼓楼区', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056945, '350103', '台江区', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056946, '350104', '仓山区', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056947, '350105', '马尾区', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056948, '350111', '晋安区', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056949, '350121', '闽侯县', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056950, '350122', '连江县', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056951, '350123', '罗源县', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056952, '350124', '闽清县', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056953, '350125', '永泰县', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056954, '350128', '平潭县', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056955, '350181', '福清市', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056956, '350182', '长乐市', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056957, '3502', '厦门市', 2, 1611571208564056941, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056958, '350201', '市辖区', 3, 1611571208564056957, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056959, '350203', '思明区', 3, 1611571208564056957, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056960, '350205', '海沧区', 3, 1611571208564056957, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056961, '350206', '湖里区', 3, 1611571208564056957, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056962, '350211', '集美区', 3, 1611571208564056957, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056963, '350212', '同安区', 3, 1611571208564056957, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056964, '350213', '翔安区', 3, 1611571208564056957, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056965, '3503', '莆田市', 2, 1611571208564056941, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056966, '350301', '市辖区', 3, 1611571208564056965, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056967, '350302', '城厢区', 3, 1611571208564056965, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056968, '350303', '涵江区', 3, 1611571208564056965, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056969, '350304', '荔城区', 3, 1611571208564056965, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056970, '350305', '秀屿区', 3, 1611571208564056965, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056971, '350322', '仙游县', 3, 1611571208564056965, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056972, '3504', '三明市', 2, 1611571208564056941, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056973, '350401', '市辖区', 3, 1611571208564056972, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056974, '350402', '梅列区', 3, 1611571208564056972, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056975, '350403', '三元区', 3, 1611571208564056972, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056976, '350421', '明溪县', 3, 1611571208564056972, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056977, '350423', '清流县', 3, 1611571208564056972, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056978, '350424', '宁化县', 3, 1611571208564056972, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056979, '350425', '大田县', 3, 1611571208564056972, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056980, '350426', '尤溪县', 3, 1611571208564056972, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056981, '350427', '沙县', 3, 1611571208564056972, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056982, '350428', '将乐县', 3, 1611571208564056972, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056983, '350429', '泰宁县', 3, 1611571208564056972, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056984, '350430', '建宁县', 3, 1611571208564056972, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056985, '350481', '永安市', 3, 1611571208564056972, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056986, '3505', '泉州市', 2, 1611571208564056941, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056987, '350501', '市辖区', 3, 1611571208564056986, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056988, '350502', '鲤城区', 3, 1611571208564056986, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056989, '350503', '丰泽区', 3, 1611571208564056986, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056990, '350504', '洛江区', 3, 1611571208564056986, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056991, '350505', '泉港区', 3, 1611571208564056986, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056992, '350521', '惠安县', 3, 1611571208564056986, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056993, '350524', '安溪县', 3, 1611571208564056986, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056994, '350525', '永春县', 3, 1611571208564056986, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056995, '350526', '德化县', 3, 1611571208564056986, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056996, '350527', '金门县', 3, 1611571208564056986, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056997, '350581', '石狮市', 3, 1611571208564056986, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056998, '350582', '晋江市', 3, 1611571208564056986, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564056999, '350583', '南安市', 3, 1611571208564056986, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057000, '3506', '漳州市', 2, 1611571208564056941, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057001, '350601', '市辖区', 3, 1611571208564057000, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057002, '350602', '芗城区', 3, 1611571208564057000, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057003, '350603', '龙文区', 3, 1611571208564057000, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057004, '350622', '云霄县', 3, 1611571208564057000, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057005, '350623', '漳浦县', 3, 1611571208564057000, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057006, '350624', '诏安县', 3, 1611571208564057000, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057007, '350625', '长泰县', 3, 1611571208564057000, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057008, '350626', '东山县', 3, 1611571208564057000, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057009, '350627', '南靖县', 3, 1611571208564057000, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057010, '350628', '平和县', 3, 1611571208564057000, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057011, '350629', '华安县', 3, 1611571208564057000, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057012, '350681', '龙海市', 3, 1611571208564057000, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057013, '3507', '南平市', 2, 1611571208564056941, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057014, '350701', '市辖区', 3, 1611571208564057013, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057015, '350702', '延平区', 3, 1611571208564057013, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057016, '350721', '顺昌县', 3, 1611571208564057013, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057017, '350722', '浦城县', 3, 1611571208564057013, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057018, '350723', '光泽县', 3, 1611571208564057013, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057019, '350724', '松溪县', 3, 1611571208564057013, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057020, '350725', '政和县', 3, 1611571208564057013, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057021, '350781', '邵武市', 3, 1611571208564057013, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057022, '350782', '武夷山市', 3, 1611571208564057013, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057023, '350783', '建瓯市', 3, 1611571208564057013, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057024, '350784', '建阳市', 3, 1611571208564057013, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057025, '3508', '龙岩市', 2, 1611571208564056941, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057026, '350801', '市辖区', 3, 1611571208564057025, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057027, '350802', '新罗区', 3, 1611571208564057025, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057028, '350821', '长汀县', 3, 1611571208564057025, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057029, '350822', '永定县', 3, 1611571208564057025, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057030, '350823', '上杭县', 3, 1611571208564057025, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057031, '350824', '武平县', 3, 1611571208564057025, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057032, '350825', '连城县', 3, 1611571208564057025, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057033, '350881', '漳平市', 3, 1611571208564057025, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057034, '3509', '宁德市', 2, 1611571208564056941, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057035, '350901', '市辖区', 3, 1611571208564057034, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057036, '350902', '蕉城区', 3, 1611571208564057034, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057037, '350921', '霞浦县', 3, 1611571208564057034, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057038, '350922', '古田县', 3, 1611571208564057034, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057039, '350923', '屏南县', 3, 1611571208564057034, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057040, '350924', '寿宁县', 3, 1611571208564057034, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057041, '350925', '周宁县', 3, 1611571208564057034, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057042, '350926', '柘荣县', 3, 1611571208564057034, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057043, '350981', '福安市', 3, 1611571208564057034, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057044, '350982', '福鼎市', 3, 1611571208564057034, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057045, '36', '江西', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057046, '3601', '南昌市', 2, 1611571208564057045, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057047, '360101', '市辖区', 3, 1611571208564057046, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057048, '360102', '东湖区', 3, 1611571208564057046, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057049, '360103', '西湖区', 3, 1611571208564057046, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057050, '360104', '青云谱区', 3, 1611571208564057046, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057051, '360105', '湾里区', 3, 1611571208564057046, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057052, '360111', '青山湖区', 3, 1611571208564057046, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057053, '360121', '南昌县', 3, 1611571208564057046, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057054, '360122', '新建县', 3, 1611571208564057046, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057055, '360123', '安义县', 3, 1611571208564057046, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057056, '360124', '进贤县', 3, 1611571208564057046, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057057, '3602', '景德镇市', 2, 1611571208564057045, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057058, '360201', '市辖区', 3, 1611571208564057057, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057059, '360202', '昌江区', 3, 1611571208564057057, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057060, '360203', '珠山区', 3, 1611571208564057057, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057061, '360222', '浮梁县', 3, 1611571208564057057, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057062, '360281', '乐平市', 3, 1611571208564057057, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057063, '3603', '萍乡市', 2, 1611571208564057045, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057064, '360301', '市辖区', 3, 1611571208564057063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057065, '360302', '安源区', 3, 1611571208564057063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057066, '360313', '湘东区', 3, 1611571208564057063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057067, '360321', '莲花县', 3, 1611571208564057063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057068, '360322', '上栗县', 3, 1611571208564057063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057069, '360323', '芦溪县', 3, 1611571208564057063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057070, '3604', '九江市', 2, 1611571208564057045, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057071, '360401', '市辖区', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057072, '360402', '庐山区', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057073, '360403', '浔阳区', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057074, '360421', '九江县', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057075, '360423', '武宁县', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057076, '360424', '修水县', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057077, '360425', '永修县', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057078, '360426', '德安县', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057079, '360427', '星子县', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057080, '360428', '都昌县', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057081, '360429', '湖口县', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057082, '360430', '彭泽县', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057083, '360481', '瑞昌市', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057084, '360482', '共青城市', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057085, '3605', '新余市', 2, 1611571208564057045, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057086, '360501', '市辖区', 3, 1611571208564057085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057087, '360502', '渝水区', 3, 1611571208564057085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057088, '360521', '分宜县', 3, 1611571208564057085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057089, '3606', '鹰潭市', 2, 1611571208564057045, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057090, '360601', '市辖区', 3, 1611571208564057089, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057091, '360602', '月湖区', 3, 1611571208564057089, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057092, '360622', '余江县', 3, 1611571208564057089, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057093, '360681', '贵溪市', 3, 1611571208564057089, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057094, '3607', '赣州市', 2, 1611571208564057045, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057095, '360701', '市辖区', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057096, '360702', '章贡区', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057097, '360721', '赣县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057098, '360722', '信丰县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057099, '360723', '大余县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057100, '360724', '上犹县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057101, '360725', '崇义县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057102, '360726', '安远县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057103, '360727', '龙南县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057104, '360728', '定南县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057105, '360729', '全南县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057106, '360730', '宁都县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057107, '360731', '于都县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057108, '360732', '兴国县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057109, '360733', '会昌县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057110, '360734', '寻乌县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057111, '360735', '石城县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057112, '360781', '瑞金市', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057113, '360782', '南康市', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057114, '3608', '吉安市', 2, 1611571208564057045, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057115, '360801', '市辖区', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057116, '360802', '吉州区', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057117, '360803', '青原区', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057118, '360821', '吉安县', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057119, '360822', '吉水县', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057120, '360823', '峡江县', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057121, '360824', '新干县', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057122, '360825', '永丰县', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057123, '360826', '泰和县', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057124, '360827', '遂川县', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057125, '360828', '万安县', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057126, '360829', '安福县', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057127, '360830', '永新县', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057128, '360881', '井冈山市', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057129, '3609', '宜春市', 2, 1611571208564057045, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057130, '360901', '市辖区', 3, 1611571208564057129, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057131, '360902', '袁州区', 3, 1611571208564057129, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057132, '360921', '奉新县', 3, 1611571208564057129, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057133, '360922', '万载县', 3, 1611571208564057129, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057134, '360923', '上高县', 3, 1611571208564057129, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057135, '360924', '宜丰县', 3, 1611571208564057129, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057136, '360925', '靖安县', 3, 1611571208564057129, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057137, '360926', '铜鼓县', 3, 1611571208564057129, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057138, '360981', '丰城市', 3, 1611571208564057129, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057139, '360982', '樟树市', 3, 1611571208564057129, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057140, '360983', '高安市', 3, 1611571208564057129, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057141, '3610', '抚州市', 2, 1611571208564057045, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057142, '361001', '市辖区', 3, 1611571208564057141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057143, '361002', '临川区', 3, 1611571208564057141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057144, '361021', '南城县', 3, 1611571208564057141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057145, '361022', '黎川县', 3, 1611571208564057141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057146, '361023', '南丰县', 3, 1611571208564057141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057147, '361024', '崇仁县', 3, 1611571208564057141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057148, '361025', '乐安县', 3, 1611571208564057141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057149, '361026', '宜黄县', 3, 1611571208564057141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057150, '361027', '金溪县', 3, 1611571208564057141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057151, '361028', '资溪县', 3, 1611571208564057141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057152, '361029', '东乡县', 3, 1611571208564057141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057153, '361030', '广昌县', 3, 1611571208564057141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057154, '3611', '上饶市', 2, 1611571208564057045, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057155, '361101', '市辖区', 3, 1611571208564057154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057156, '361102', '信州区', 3, 1611571208564057154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057157, '361121', '上饶县', 3, 1611571208564057154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057158, '361122', '广丰县', 3, 1611571208564057154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057159, '361123', '玉山县', 3, 1611571208564057154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057160, '361124', '铅山县', 3, 1611571208564057154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057161, '361125', '横峰县', 3, 1611571208564057154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057162, '361126', '弋阳县', 3, 1611571208564057154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057163, '361127', '余干县', 3, 1611571208564057154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057164, '361128', '鄱阳县', 3, 1611571208564057154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057165, '361129', '万年县', 3, 1611571208564057154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057166, '361130', '婺源县', 3, 1611571208564057154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057167, '361181', '德兴市', 3, 1611571208564057154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057168, '37', '山东', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057169, '3701', '济南市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057170, '370101', '市辖区', 3, 1611571208564057169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057171, '370102', '历下区', 3, 1611571208564057169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057172, '370103', '市中区', 3, 1611571208564057169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057173, '370104', '槐荫区', 3, 1611571208564057169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057174, '370105', '天桥区', 3, 1611571208564057169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057175, '370112', '历城区', 3, 1611571208564057169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057176, '370113', '长清区', 3, 1611571208564057169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057177, '370124', '平阴县', 3, 1611571208564057169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057178, '370125', '济阳县', 3, 1611571208564057169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057179, '370126', '商河县', 3, 1611571208564057169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057180, '370181', '章丘市', 3, 1611571208564057169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057181, '3702', '青岛市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057182, '370201', '市辖区', 3, 1611571208564057181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057183, '370202', '市南区', 3, 1611571208564057181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057184, '370203', '市北区', 3, 1611571208564057181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057185, '370205', '四方区', 3, 1611571208564057181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057186, '370211', '黄岛区', 3, 1611571208564057181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057187, '370212', '崂山区', 3, 1611571208564057181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057188, '370213', '李沧区', 3, 1611571208564057181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057189, '370214', '城阳区', 3, 1611571208564057181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057190, '370281', '胶州市', 3, 1611571208564057181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057191, '370282', '即墨市', 3, 1611571208564057181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057192, '370283', '平度市', 3, 1611571208564057181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057193, '370284', '胶南市', 3, 1611571208564057181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057194, '370285', '莱西市', 3, 1611571208564057181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057195, '3703', '淄博市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057196, '370301', '市辖区', 3, 1611571208564057195, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057197, '370302', '淄川区', 3, 1611571208564057195, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057198, '370303', '张店区', 3, 1611571208564057195, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057199, '370304', '博山区', 3, 1611571208564057195, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057200, '370305', '临淄区', 3, 1611571208564057195, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057201, '370306', '周村区', 3, 1611571208564057195, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057202, '370321', '桓台县', 3, 1611571208564057195, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057203, '370322', '高青县', 3, 1611571208564057195, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057204, '370323', '沂源县', 3, 1611571208564057195, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057205, '3704', '枣庄市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057206, '370401', '市辖区', 3, 1611571208564057205, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057207, '370402', '市中区', 3, 1611571208564057205, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057208, '370403', '薛城区', 3, 1611571208564057205, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057209, '370404', '峄城区', 3, 1611571208564057205, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057210, '370405', '台儿庄区', 3, 1611571208564057205, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057211, '370406', '山亭区', 3, 1611571208564057205, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057212, '370481', '滕州市', 3, 1611571208564057205, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057213, '3705', '东营市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057214, '370501', '市辖区', 3, 1611571208564057213, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057215, '370502', '东营区', 3, 1611571208564057213, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057216, '370503', '河口区', 3, 1611571208564057213, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057217, '370521', '垦利县', 3, 1611571208564057213, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057218, '370522', '利津县', 3, 1611571208564057213, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057219, '370523', '广饶县', 3, 1611571208564057213, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057220, '3706', '烟台市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057221, '370601', '市辖区', 3, 1611571208564057220, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057222, '370602', '芝罘区', 3, 1611571208564057220, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057223, '370611', '福山区', 3, 1611571208564057220, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057224, '370612', '牟平区', 3, 1611571208564057220, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057225, '370613', '莱山区', 3, 1611571208564057220, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057226, '370634', '长岛县', 3, 1611571208564057220, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057227, '370681', '龙口市', 3, 1611571208564057220, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057228, '370682', '莱阳市', 3, 1611571208564057220, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057229, '370683', '莱州市', 3, 1611571208564057220, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057230, '370684', '蓬莱市', 3, 1611571208564057220, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057231, '370685', '招远市', 3, 1611571208564057220, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057232, '370686', '栖霞市', 3, 1611571208564057220, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057233, '370687', '海阳市', 3, 1611571208564057220, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057234, '3707', '潍坊市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057235, '370701', '市辖区', 3, 1611571208564057234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057236, '370702', '潍城区', 3, 1611571208564057234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057237, '370703', '寒亭区', 3, 1611571208564057234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057238, '370704', '坊子区', 3, 1611571208564057234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057239, '370705', '奎文区', 3, 1611571208564057234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057240, '370724', '临朐县', 3, 1611571208564057234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057241, '370725', '昌乐县', 3, 1611571208564057234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057242, '370781', '青州市', 3, 1611571208564057234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057243, '370782', '诸城市', 3, 1611571208564057234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057244, '370783', '寿光市', 3, 1611571208564057234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057245, '370784', '安丘市', 3, 1611571208564057234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057246, '370785', '高密市', 3, 1611571208564057234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057247, '370786', '昌邑市', 3, 1611571208564057234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057248, '3708', '济宁市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057249, '370801', '市辖区', 3, 1611571208564057248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057250, '370802', '市中区', 3, 1611571208564057248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057251, '370811', '任城区', 3, 1611571208564057248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057252, '370826', '微山县', 3, 1611571208564057248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057253, '370827', '鱼台县', 3, 1611571208564057248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057254, '370828', '金乡县', 3, 1611571208564057248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057255, '370829', '嘉祥县', 3, 1611571208564057248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057256, '370830', '汶上县', 3, 1611571208564057248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057257, '370831', '泗水县', 3, 1611571208564057248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057258, '370832', '梁山县', 3, 1611571208564057248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057259, '370881', '曲阜市', 3, 1611571208564057248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057260, '370882', '兖州市', 3, 1611571208564057248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057261, '370883', '邹城市', 3, 1611571208564057248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057262, '3709', '泰安市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057263, '370901', '市辖区', 3, 1611571208564057262, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057264, '370902', '泰山区', 3, 1611571208564057262, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057265, '370911', '岱岳区', 3, 1611571208564057262, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057266, '370921', '宁阳县', 3, 1611571208564057262, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057267, '370923', '东平县', 3, 1611571208564057262, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057268, '370982', '新泰市', 3, 1611571208564057262, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057269, '370983', '肥城市', 3, 1611571208564057262, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057270, '3710', '威海市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057271, '371001', '市辖区', 3, 1611571208564057270, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057272, '371002', '环翠区', 3, 1611571208564057270, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057273, '371081', '文登市', 3, 1611571208564057270, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057274, '371082', '荣成市', 3, 1611571208564057270, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057275, '371083', '乳山市', 3, 1611571208564057270, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057276, '3711', '日照市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057277, '371101', '市辖区', 3, 1611571208564057276, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057278, '371102', '东港区', 3, 1611571208564057276, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057279, '371103', '岚山区', 3, 1611571208564057276, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057280, '371121', '五莲县', 3, 1611571208564057276, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057281, '371122', '莒县', 3, 1611571208564057276, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057282, '3712', '莱芜市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057283, '371201', '市辖区', 3, 1611571208564057282, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057284, '371202', '莱城区', 3, 1611571208564057282, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057285, '371203', '钢城区', 3, 1611571208564057282, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057286, '3713', '临沂市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057287, '371301', '市辖区', 3, 1611571208564057286, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057288, '371302', '兰山区', 3, 1611571208564057286, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057289, '371311', '罗庄区', 3, 1611571208564057286, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057290, '371312', '河东区', 3, 1611571208564057286, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057291, '371321', '沂南县', 3, 1611571208564057286, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057292, '371322', '郯城县', 3, 1611571208564057286, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057293, '371323', '沂水县', 3, 1611571208564057286, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057294, '371324', '苍山县', 3, 1611571208564057286, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057295, '371325', '费县', 3, 1611571208564057286, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057296, '371326', '平邑县', 3, 1611571208564057286, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057297, '371327', '莒南县', 3, 1611571208564057286, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057298, '371328', '蒙阴县', 3, 1611571208564057286, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057299, '371329', '临沭县', 3, 1611571208564057286, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057300, '3714', '德州市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057301, '371401', '市辖区', 3, 1611571208564057300, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057302, '371402', '德城区', 3, 1611571208564057300, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057303, '371421', '陵县', 3, 1611571208564057300, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057304, '371422', '宁津县', 3, 1611571208564057300, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057305, '371423', '庆云县', 3, 1611571208564057300, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057306, '371424', '临邑县', 3, 1611571208564057300, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057307, '371425', '齐河县', 3, 1611571208564057300, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057308, '371426', '平原县', 3, 1611571208564057300, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057309, '371427', '夏津县', 3, 1611571208564057300, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057310, '371428', '武城县', 3, 1611571208564057300, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057311, '371481', '乐陵市', 3, 1611571208564057300, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057312, '371482', '禹城市', 3, 1611571208564057300, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057313, '3715', '聊城市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057314, '371501', '市辖区', 3, 1611571208564057313, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057315, '371502', '东昌府区', 3, 1611571208564057313, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057316, '371521', '阳谷县', 3, 1611571208564057313, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057317, '371522', '莘县', 3, 1611571208564057313, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057318, '371523', '茌平县', 3, 1611571208564057313, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057319, '371524', '东阿县', 3, 1611571208564057313, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057320, '371525', '冠县', 3, 1611571208564057313, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057321, '371526', '高唐县', 3, 1611571208564057313, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057322, '371581', '临清市', 3, 1611571208564057313, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057323, '3716', '滨州市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057324, '371601', '市辖区', 3, 1611571208564057323, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057325, '371602', '滨城区', 3, 1611571208564057323, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057326, '371621', '惠民县', 3, 1611571208564057323, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057327, '371622', '阳信县', 3, 1611571208564057323, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057328, '371623', '无棣县', 3, 1611571208564057323, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057329, '371624', '沾化县', 3, 1611571208564057323, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057330, '371625', '博兴县', 3, 1611571208564057323, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057331, '371626', '邹平县', 3, 1611571208564057323, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057332, '3717', '菏泽市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057333, '371701', '市辖区', 3, 1611571208564057332, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057334, '371702', '牡丹区', 3, 1611571208564057332, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057335, '371721', '曹县', 3, 1611571208564057332, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057336, '371722', '单县', 3, 1611571208564057332, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057337, '371723', '成武县', 3, 1611571208564057332, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057338, '371724', '巨野县', 3, 1611571208564057332, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057339, '371725', '郓城县', 3, 1611571208564057332, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057340, '371726', '鄄城县', 3, 1611571208564057332, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057341, '371727', '定陶县', 3, 1611571208564057332, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057342, '371728', '东明县', 3, 1611571208564057332, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057343, '41', '河南', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057344, '4101', '郑州市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057345, '410101', '市辖区', 3, 1611571208564057344, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057346, '410102', '中原区', 3, 1611571208564057344, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057347, '410103', '二七区', 3, 1611571208564057344, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057348, '410104', '管城回族区', 3, 1611571208564057344, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057349, '410105', '金水区', 3, 1611571208564057344, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057350, '410106', '上街区', 3, 1611571208564057344, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057351, '410108', '惠济区', 3, 1611571208564057344, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057352, '410122', '中牟县', 3, 1611571208564057344, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057353, '410181', '巩义市', 3, 1611571208564057344, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057354, '410182', '荥阳市', 3, 1611571208564057344, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057355, '410183', '新密市', 3, 1611571208564057344, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057356, '410184', '新郑市', 3, 1611571208564057344, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057357, '410185', '登封市', 3, 1611571208564057344, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057358, '4102', '开封市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057359, '410201', '市辖区', 3, 1611571208564057358, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057360, '410202', '龙亭区', 3, 1611571208564057358, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057361, '410203', '顺河回族区', 3, 1611571208564057358, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057362, '410204', '鼓楼区', 3, 1611571208564057358, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057363, '410205', '禹王台区', 3, 1611571208564057358, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057364, '410211', '金明区', 3, 1611571208564057358, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057365, '410221', '杞县', 3, 1611571208564057358, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057366, '410222', '通许县', 3, 1611571208564057358, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057367, '410223', '尉氏县', 3, 1611571208564057358, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057368, '410224', '开封县', 3, 1611571208564057358, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057369, '410225', '兰考县', 3, 1611571208564057358, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057370, '4103', '洛阳市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057371, '410301', '市辖区', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057372, '410302', '老城区', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057373, '410303', '西工区', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057374, '410304', '瀍河回族区', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057375, '410305', '涧西区', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057376, '410306', '吉利区', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057377, '410311', '洛龙区', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057378, '410322', '孟津县', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057379, '410323', '新安县', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057380, '410324', '栾川县', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057381, '410325', '嵩县', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057382, '410326', '汝阳县', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057383, '410327', '宜阳县', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057384, '410328', '洛宁县', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057385, '410329', '伊川县', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057386, '410381', '偃师市', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057387, '4104', '平顶山市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057388, '410401', '市辖区', 3, 1611571208564057387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057389, '410402', '新华区', 3, 1611571208564057387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057390, '410403', '卫东区', 3, 1611571208564057387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057391, '410404', '石龙区', 3, 1611571208564057387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057392, '410411', '湛河区', 3, 1611571208564057387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057393, '410421', '宝丰县', 3, 1611571208564057387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057394, '410422', '叶县', 3, 1611571208564057387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057395, '410423', '鲁山县', 3, 1611571208564057387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057396, '410425', '郏县', 3, 1611571208564057387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057397, '410481', '舞钢市', 3, 1611571208564057387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057398, '410482', '汝州市', 3, 1611571208564057387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057399, '4105', '安阳市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057400, '410501', '市辖区', 3, 1611571208564057399, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057401, '410502', '文峰区', 3, 1611571208564057399, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057402, '410503', '北关区', 3, 1611571208564057399, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057403, '410505', '殷都区', 3, 1611571208564057399, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057404, '410506', '龙安区', 3, 1611571208564057399, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057405, '410522', '安阳县', 3, 1611571208564057399, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057406, '410523', '汤阴县', 3, 1611571208564057399, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057407, '410526', '滑县', 3, 1611571208564057399, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057408, '410527', '内黄县', 3, 1611571208564057399, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057409, '410581', '林州市', 3, 1611571208564057399, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057410, '4106', '鹤壁市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057411, '410601', '市辖区', 3, 1611571208564057410, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057412, '410602', '鹤山区', 3, 1611571208564057410, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057413, '410603', '山城区', 3, 1611571208564057410, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057414, '410611', '淇滨区', 3, 1611571208564057410, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057415, '410621', '浚县', 3, 1611571208564057410, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057416, '410622', '淇县', 3, 1611571208564057410, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057417, '4107', '新乡市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057418, '410701', '市辖区', 3, 1611571208564057417, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057419, '410702', '红旗区', 3, 1611571208564057417, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057420, '410703', '卫滨区', 3, 1611571208564057417, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057421, '410704', '凤泉区', 3, 1611571208564057417, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057422, '410711', '牧野区', 3, 1611571208564057417, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057423, '410721', '新乡县', 3, 1611571208564057417, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057424, '410724', '获嘉县', 3, 1611571208564057417, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057425, '410725', '原阳县', 3, 1611571208564057417, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057426, '410726', '延津县', 3, 1611571208564057417, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057427, '410727', '封丘县', 3, 1611571208564057417, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057428, '410728', '长垣县', 3, 1611571208564057417, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057429, '410781', '卫辉市', 3, 1611571208564057417, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057430, '410782', '辉县市', 3, 1611571208564057417, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057431, '4108', '焦作市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057432, '410801', '市辖区', 3, 1611571208564057431, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057433, '410802', '解放区', 3, 1611571208564057431, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057434, '410803', '中站区', 3, 1611571208564057431, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057435, '410804', '马村区', 3, 1611571208564057431, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057436, '410811', '山阳区', 3, 1611571208564057431, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057437, '410821', '修武县', 3, 1611571208564057431, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057438, '410822', '博爱县', 3, 1611571208564057431, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057439, '410823', '武陟县', 3, 1611571208564057431, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057440, '410825', '温县', 3, 1611571208564057431, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057441, '410882', '沁阳市', 3, 1611571208564057431, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057442, '410883', '孟州市', 3, 1611571208564057431, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057443, '4109', '濮阳市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057444, '410901', '市辖区', 3, 1611571208564057443, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057445, '410902', '华龙区', 3, 1611571208564057443, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057446, '410922', '清丰县', 3, 1611571208564057443, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057447, '410923', '南乐县', 3, 1611571208564057443, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057448, '410926', '范县', 3, 1611571208564057443, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057449, '410927', '台前县', 3, 1611571208564057443, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057450, '410928', '濮阳县', 3, 1611571208564057443, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057451, '4110', '许昌市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057452, '411001', '市辖区', 3, 1611571208564057451, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057453, '411002', '魏都区', 3, 1611571208564057451, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057454, '411023', '许昌县', 3, 1611571208564057451, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057455, '411024', '鄢陵县', 3, 1611571208564057451, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057456, '411025', '襄城县', 3, 1611571208564057451, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057457, '411081', '禹州市', 3, 1611571208564057451, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057458, '411082', '长葛市', 3, 1611571208564057451, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057459, '4111', '漯河市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057460, '411101', '市辖区', 3, 1611571208564057459, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057461, '411102', '源汇区', 3, 1611571208564057459, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057462, '411103', '郾城区', 3, 1611571208564057459, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057463, '411104', '召陵区', 3, 1611571208564057459, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057464, '411121', '舞阳县', 3, 1611571208564057459, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057465, '411122', '临颍县', 3, 1611571208564057459, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057466, '4112', '三门峡市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057467, '411201', '市辖区', 3, 1611571208564057466, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057468, '411202', '湖滨区', 3, 1611571208564057466, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057469, '411221', '渑池县', 3, 1611571208564057466, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057470, '411222', '陕县', 3, 1611571208564057466, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057471, '411224', '卢氏县', 3, 1611571208564057466, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057472, '411281', '义马市', 3, 1611571208564057466, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057473, '411282', '灵宝市', 3, 1611571208564057466, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057474, '4113', '南阳市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057475, '411301', '市辖区', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057476, '411302', '宛城区', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057477, '411303', '卧龙区', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057478, '411321', '南召县', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057479, '411322', '方城县', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057480, '411323', '西峡县', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057481, '411324', '镇平县', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057482, '411325', '内乡县', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057483, '411326', '淅川县', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057484, '411327', '社旗县', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057485, '411328', '唐河县', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057486, '411329', '新野县', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057487, '411330', '桐柏县', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057488, '411381', '邓州市', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057489, '4114', '商丘市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057490, '411401', '市辖区', 3, 1611571208564057489, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057491, '411402', '梁园区', 3, 1611571208564057489, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057492, '411403', '睢阳区', 3, 1611571208564057489, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057493, '411421', '民权县', 3, 1611571208564057489, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057494, '411422', '睢县', 3, 1611571208564057489, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057495, '411423', '宁陵县', 3, 1611571208564057489, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057496, '411424', '柘城县', 3, 1611571208564057489, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057497, '411425', '虞城县', 3, 1611571208564057489, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057498, '411426', '夏邑县', 3, 1611571208564057489, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057499, '411481', '永城市', 3, 1611571208564057489, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057500, '4115', '信阳市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057501, '411501', '市辖区', 3, 1611571208564057500, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057502, '411502', '浉河区', 3, 1611571208564057500, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057503, '411503', '平桥区', 3, 1611571208564057500, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057504, '411521', '罗山县', 3, 1611571208564057500, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057505, '411522', '光山县', 3, 1611571208564057500, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057506, '411523', '新县', 3, 1611571208564057500, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057507, '411524', '商城县', 3, 1611571208564057500, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057508, '411525', '固始县', 3, 1611571208564057500, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057509, '411526', '潢川县', 3, 1611571208564057500, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057510, '411527', '淮滨县', 3, 1611571208564057500, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057511, '411528', '息县', 3, 1611571208564057500, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057512, '4116', '周口市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057513, '411601', '市辖区', 3, 1611571208564057512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057514, '411602', '川汇区', 3, 1611571208564057512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057515, '411621', '扶沟县', 3, 1611571208564057512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057516, '411622', '西华县', 3, 1611571208564057512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057517, '411623', '商水县', 3, 1611571208564057512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057518, '411624', '沈丘县', 3, 1611571208564057512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057519, '411625', '郸城县', 3, 1611571208564057512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057520, '411626', '淮阳县', 3, 1611571208564057512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057521, '411627', '太康县', 3, 1611571208564057512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057522, '411628', '鹿邑县', 3, 1611571208564057512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057523, '411681', '项城市', 3, 1611571208564057512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057524, '4117', '驻马店市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057525, '411701', '市辖区', 3, 1611571208564057524, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057526, '411702', '驿城区', 3, 1611571208564057524, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057527, '411721', '西平县', 3, 1611571208564057524, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057528, '411722', '上蔡县', 3, 1611571208564057524, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057529, '411723', '平舆县', 3, 1611571208564057524, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057530, '411724', '正阳县', 3, 1611571208564057524, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057531, '411725', '确山县', 3, 1611571208564057524, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057532, '411726', '泌阳县', 3, 1611571208564057524, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057533, '411727', '汝南县', 3, 1611571208564057524, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057534, '411728', '遂平县', 3, 1611571208564057524, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057535, '411729', '新蔡县', 3, 1611571208564057524, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057536, '4190', '省直辖县级行政区划', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057537, '419001', '济源市', 3, 1611571208564057536, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057538, '42', '湖北', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057539, '4201', '武汉市', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057540, '420101', '市辖区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057541, '420102', '江岸区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057542, '420103', '江汉区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057543, '420104', '硚口区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057544, '420105', '汉阳区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057545, '420106', '武昌区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057546, '420107', '青山区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057547, '420111', '洪山区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057548, '420112', '东西湖区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057549, '420113', '汉南区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057550, '420114', '蔡甸区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057551, '420115', '江夏区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057552, '420116', '黄陂区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057553, '420117', '新洲区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057554, '4202', '黄石市', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057555, '420201', '市辖区', 3, 1611571208564057554, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057556, '420202', '黄石港区', 3, 1611571208564057554, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057557, '420203', '西塞山区', 3, 1611571208564057554, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057558, '420204', '下陆区', 3, 1611571208564057554, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057559, '420205', '铁山区', 3, 1611571208564057554, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057560, '420222', '阳新县', 3, 1611571208564057554, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057561, '420281', '大冶市', 3, 1611571208564057554, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057562, '4203', '十堰市', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057563, '420301', '市辖区', 3, 1611571208564057562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057564, '420302', '茅箭区', 3, 1611571208564057562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057565, '420303', '张湾区', 3, 1611571208564057562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057566, '420321', '郧县', 3, 1611571208564057562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057567, '420322', '郧西县', 3, 1611571208564057562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057568, '420323', '竹山县', 3, 1611571208564057562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057569, '420324', '竹溪县', 3, 1611571208564057562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057570, '420325', '房县', 3, 1611571208564057562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057571, '420381', '丹江口市', 3, 1611571208564057562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057572, '4205', '宜昌市', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057573, '420501', '市辖区', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057574, '420502', '西陵区', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057575, '420503', '伍家岗区', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057576, '420504', '点军区', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057577, '420505', '猇亭区', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057578, '420506', '夷陵区', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057579, '420525', '远安县', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057580, '420526', '兴山县', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057581, '420527', '秭归县', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057582, '420528', '长阳土家族自治县', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057583, '420529', '五峰土家族自治县', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057584, '420581', '宜都市', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057585, '420582', '当阳市', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057586, '420583', '枝江市', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057587, '4206', '襄阳市', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057588, '420601', '市辖区', 3, 1611571208564057587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057589, '420602', '襄城区', 3, 1611571208564057587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057590, '420606', '樊城区', 3, 1611571208564057587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057591, '420607', '襄州区', 3, 1611571208564057587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057592, '420624', '南漳县', 3, 1611571208564057587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057593, '420625', '谷城县', 3, 1611571208564057587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057594, '420626', '保康县', 3, 1611571208564057587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057595, '420682', '老河口市', 3, 1611571208564057587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057596, '420683', '枣阳市', 3, 1611571208564057587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057597, '420684', '宜城市', 3, 1611571208564057587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057598, '4207', '鄂州市', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057599, '420701', '市辖区', 3, 1611571208564057598, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057600, '420702', '梁子湖区', 3, 1611571208564057598, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057601, '420703', '华容区', 3, 1611571208564057598, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057602, '420704', '鄂城区', 3, 1611571208564057598, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057603, '4208', '荆门市', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057604, '420801', '市辖区', 3, 1611571208564057603, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057605, '420802', '东宝区', 3, 1611571208564057603, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057606, '420804', '掇刀区', 3, 1611571208564057603, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057607, '420821', '京山县', 3, 1611571208564057603, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057608, '420822', '沙洋县', 3, 1611571208564057603, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057609, '420881', '钟祥市', 3, 1611571208564057603, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057610, '4209', '孝感市', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057611, '420901', '市辖区', 3, 1611571208564057610, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057612, '420902', '孝南区', 3, 1611571208564057610, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057613, '420921', '孝昌县', 3, 1611571208564057610, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057614, '420922', '大悟县', 3, 1611571208564057610, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057615, '420923', '云梦县', 3, 1611571208564057610, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057616, '420981', '应城市', 3, 1611571208564057610, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057617, '420982', '安陆市', 3, 1611571208564057610, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057618, '420984', '汉川市', 3, 1611571208564057610, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057619, '4210', '荆州市', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057620, '421001', '市辖区', 3, 1611571208564057619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057621, '421002', '沙市区', 3, 1611571208564057619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057622, '421003', '荆州区', 3, 1611571208564057619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057623, '421022', '公安县', 3, 1611571208564057619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057624, '421023', '监利县', 3, 1611571208564057619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057625, '421024', '江陵县', 3, 1611571208564057619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057626, '421081', '石首市', 3, 1611571208564057619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057627, '421083', '洪湖市', 3, 1611571208564057619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057628, '421087', '松滋市', 3, 1611571208564057619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057629, '4211', '黄冈市', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057630, '421101', '市辖区', 3, 1611571208564057629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057631, '421102', '黄州区', 3, 1611571208564057629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057632, '421121', '团风县', 3, 1611571208564057629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057633, '421122', '红安县', 3, 1611571208564057629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057634, '421123', '罗田县', 3, 1611571208564057629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057635, '421124', '英山县', 3, 1611571208564057629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057636, '421125', '浠水县', 3, 1611571208564057629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057637, '421126', '蕲春县', 3, 1611571208564057629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057638, '421127', '黄梅县', 3, 1611571208564057629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057639, '421181', '麻城市', 3, 1611571208564057629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057640, '421182', '武穴市', 3, 1611571208564057629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057641, '4212', '咸宁市', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057642, '421201', '市辖区', 3, 1611571208564057641, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057643, '421202', '咸安区', 3, 1611571208564057641, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057644, '421221', '嘉鱼县', 3, 1611571208564057641, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057645, '421222', '通城县', 3, 1611571208564057641, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057646, '421223', '崇阳县', 3, 1611571208564057641, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057647, '421224', '通山县', 3, 1611571208564057641, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057648, '421281', '赤壁市', 3, 1611571208564057641, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057649, '4213', '随州市', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057650, '421301', '市辖区', 3, 1611571208564057649, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057651, '421303', '曾都区', 3, 1611571208564057649, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057652, '421321', '随县', 3, 1611571208564057649, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057653, '421381', '广水市', 3, 1611571208564057649, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057654, '4228', '恩施土家族苗族自治州', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057655, '422801', '恩施市', 3, 1611571208564057654, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057656, '422802', '利川市', 3, 1611571208564057654, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057657, '422822', '建始县', 3, 1611571208564057654, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057658, '422823', '巴东县', 3, 1611571208564057654, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057659, '422825', '宣恩县', 3, 1611571208564057654, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057660, '422826', '咸丰县', 3, 1611571208564057654, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057661, '422827', '来凤县', 3, 1611571208564057654, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057662, '422828', '鹤峰县', 3, 1611571208564057654, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057663, '4290', '省直辖县级行政区划', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057664, '429004', '仙桃市', 3, 1611571208564057663, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057665, '429005', '潜江市', 3, 1611571208564057663, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057666, '429006', '天门市', 3, 1611571208564057663, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057667, '429021', '神农架林区', 3, 1611571208564057663, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057668, '43', '湖南', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057669, '4301', '长沙市', 2, 1611571208564057668, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057670, '430101', '市辖区', 3, 1611571208564057669, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057671, '430102', '芙蓉区', 3, 1611571208564057669, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057672, '430103', '天心区', 3, 1611571208564057669, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057673, '430104', '岳麓区', 3, 1611571208564057669, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057674, '430105', '开福区', 3, 1611571208564057669, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057675, '430111', '雨花区', 3, 1611571208564057669, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057676, '430112', '望城区', 3, 1611571208564057669, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057677, '430121', '长沙县', 3, 1611571208564057669, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057678, '430124', '宁乡县', 3, 1611571208564057669, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057679, '430181', '浏阳市', 3, 1611571208564057669, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057680, '4302', '株洲市', 2, 1611571208564057668, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057681, '430201', '市辖区', 3, 1611571208564057680, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057682, '430202', '荷塘区', 3, 1611571208564057680, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057683, '430203', '芦淞区', 3, 1611571208564057680, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057684, '430204', '石峰区', 3, 1611571208564057680, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057685, '430211', '天元区', 3, 1611571208564057680, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057686, '430221', '株洲县', 3, 1611571208564057680, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057687, '430223', '攸县', 3, 1611571208564057680, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057688, '430224', '茶陵县', 3, 1611571208564057680, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057689, '430225', '炎陵县', 3, 1611571208564057680, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057690, '430281', '醴陵市', 3, 1611571208564057680, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057691, '4303', '湘潭市', 2, 1611571208564057668, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057692, '430301', '市辖区', 3, 1611571208564057691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057693, '430302', '雨湖区', 3, 1611571208564057691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057694, '430304', '岳塘区', 3, 1611571208564057691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057695, '430321', '湘潭县', 3, 1611571208564057691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057696, '430381', '湘乡市', 3, 1611571208564057691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057697, '430382', '韶山市', 3, 1611571208564057691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057698, '4304', '衡阳市', 2, 1611571208564057668, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057699, '430401', '市辖区', 3, 1611571208564057698, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057700, '430405', '珠晖区', 3, 1611571208564057698, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057701, '430406', '雁峰区', 3, 1611571208564057698, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057702, '430407', '石鼓区', 3, 1611571208564057698, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057703, '430408', '蒸湘区', 3, 1611571208564057698, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057704, '430412', '南岳区', 3, 1611571208564057698, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057705, '430421', '衡阳县', 3, 1611571208564057698, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057706, '430422', '衡南县', 3, 1611571208564057698, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057707, '430423', '衡山县', 3, 1611571208564057698, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057708, '430424', '衡东县', 3, 1611571208564057698, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057709, '430426', '祁东县', 3, 1611571208564057698, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057710, '430481', '耒阳市', 3, 1611571208564057698, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057711, '430482', '常宁市', 3, 1611571208564057698, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057712, '4305', '邵阳市', 2, 1611571208564057668, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057713, '430501', '市辖区', 3, 1611571208564057712, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057714, '430502', '双清区', 3, 1611571208564057712, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057715, '430503', '大祥区', 3, 1611571208564057712, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057716, '430511', '北塔区', 3, 1611571208564057712, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057717, '430521', '邵东县', 3, 1611571208564057712, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057718, '430522', '新邵县', 3, 1611571208564057712, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057719, '430523', '邵阳县', 3, 1611571208564057712, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057720, '430524', '隆回县', 3, 1611571208564057712, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057721, '430525', '洞口县', 3, 1611571208564057712, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057722, '430527', '绥宁县', 3, 1611571208564057712, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057723, '430528', '新宁县', 3, 1611571208564057712, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057724, '430529', '城步苗族自治县', 3, 1611571208564057712, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057725, '430581', '武冈市', 3, 1611571208564057712, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057726, '4306', '岳阳市', 2, 1611571208564057668, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057727, '430601', '市辖区', 3, 1611571208564057726, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057728, '430602', '岳阳楼区', 3, 1611571208564057726, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057729, '430603', '云溪区', 3, 1611571208564057726, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057730, '430611', '君山区', 3, 1611571208564057726, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057731, '430621', '岳阳县', 3, 1611571208564057726, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057732, '430623', '华容县', 3, 1611571208564057726, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057733, '430624', '湘阴县', 3, 1611571208564057726, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057734, '430626', '平江县', 3, 1611571208564057726, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057735, '430681', '汨罗市', 3, 1611571208564057726, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057736, '430682', '临湘市', 3, 1611571208564057726, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057737, '4307', '常德市', 2, 1611571208564057668, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057738, '430701', '市辖区', 3, 1611571208564057737, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057739, '430702', '武陵区', 3, 1611571208564057737, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057740, '430703', '鼎城区', 3, 1611571208564057737, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057741, '430721', '安乡县', 3, 1611571208564057737, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057742, '430722', '汉寿县', 3, 1611571208564057737, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057743, '430723', '澧县', 3, 1611571208564057737, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057744, '430724', '临澧县', 3, 1611571208564057737, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057745, '430725', '桃源县', 3, 1611571208564057737, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057746, '430726', '石门县', 3, 1611571208564057737, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057747, '430781', '津市市', 3, 1611571208564057737, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057748, '4308', '张家界市', 2, 1611571208564057668, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057749, '430801', '市辖区', 3, 1611571208564057748, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057750, '430802', '永定区', 3, 1611571208564057748, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057751, '430811', '武陵源区', 3, 1611571208564057748, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057752, '430821', '慈利县', 3, 1611571208564057748, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057753, '430822', '桑植县', 3, 1611571208564057748, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057754, '4309', '益阳市', 2, 1611571208564057668, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057755, '430901', '市辖区', 3, 1611571208564057754, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057756, '430902', '资阳区', 3, 1611571208564057754, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057757, '430903', '赫山区', 3, 1611571208564057754, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057758, '430921', '南县', 3, 1611571208564057754, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057759, '430922', '桃江县', 3, 1611571208564057754, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057760, '430923', '安化县', 3, 1611571208564057754, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057761, '430981', '沅江市', 3, 1611571208564057754, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057762, '4310', '郴州市', 2, 1611571208564057668, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057763, '431001', '市辖区', 3, 1611571208564057762, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057764, '431002', '北湖区', 3, 1611571208564057762, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057765, '431003', '苏仙区', 3, 1611571208564057762, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057766, '431021', '桂阳县', 3, 1611571208564057762, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057767, '431022', '宜章县', 3, 1611571208564057762, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057768, '431023', '永兴县', 3, 1611571208564057762, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057769, '431024', '嘉禾县', 3, 1611571208564057762, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057770, '431025', '临武县', 3, 1611571208564057762, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057771, '431026', '汝城县', 3, 1611571208564057762, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057772, '431027', '桂东县', 3, 1611571208564057762, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057773, '431028', '安仁县', 3, 1611571208564057762, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057774, '431081', '资兴市', 3, 1611571208564057762, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057775, '4311', '永州市', 2, 1611571208564057668, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057776, '431101', '市辖区', 3, 1611571208564057775, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057777, '431102', '零陵区', 3, 1611571208564057775, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057778, '431103', '冷水滩区', 3, 1611571208564057775, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057779, '431121', '祁阳县', 3, 1611571208564057775, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057780, '431122', '东安县', 3, 1611571208564057775, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057781, '431123', '双牌县', 3, 1611571208564057775, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057782, '431124', '道县', 3, 1611571208564057775, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057783, '431125', '江永县', 3, 1611571208564057775, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057784, '431126', '宁远县', 3, 1611571208564057775, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057785, '431127', '蓝山县', 3, 1611571208564057775, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057786, '431128', '新田县', 3, 1611571208564057775, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057787, '431129', '江华瑶族自治县', 3, 1611571208564057775, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057788, '4312', '怀化市', 2, 1611571208564057668, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057789, '431201', '市辖区', 3, 1611571208564057788, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057790, '431202', '鹤城区', 3, 1611571208564057788, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057791, '431221', '中方县', 3, 1611571208564057788, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057792, '431222', '沅陵县', 3, 1611571208564057788, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057793, '431223', '辰溪县', 3, 1611571208564057788, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057794, '431224', '溆浦县', 3, 1611571208564057788, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057795, '431225', '会同县', 3, 1611571208564057788, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057796, '431226', '麻阳苗族自治县', 3, 1611571208564057788, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057797, '431227', '新晃侗族自治县', 3, 1611571208564057788, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057798, '431228', '芷江侗族自治县', 3, 1611571208564057788, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057799, '431229', '靖州苗族侗族自治县', 3, 1611571208564057788, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057800, '431230', '通道侗族自治县', 3, 1611571208564057788, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057801, '431281', '洪江市', 3, 1611571208564057788, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057802, '4313', '娄底市', 2, 1611571208564057668, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057803, '431301', '市辖区', 3, 1611571208564057802, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057804, '431302', '娄星区', 3, 1611571208564057802, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057805, '431321', '双峰县', 3, 1611571208564057802, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057806, '431322', '新化县', 3, 1611571208564057802, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057807, '431381', '冷水江市', 3, 1611571208564057802, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057808, '431382', '涟源市', 3, 1611571208564057802, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057809, '4331', '湘西土家族苗族自治州', 2, 1611571208564057668, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057810, '433101', '吉首市', 3, 1611571208564057809, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057811, '433122', '泸溪县', 3, 1611571208564057809, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057812, '433123', '凤凰县', 3, 1611571208564057809, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057813, '433124', '花垣县', 3, 1611571208564057809, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057814, '433125', '保靖县', 3, 1611571208564057809, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057815, '433126', '古丈县', 3, 1611571208564057809, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057816, '433127', '永顺县', 3, 1611571208564057809, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057817, '433130', '龙山县', 3, 1611571208564057809, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057818, '44', '广东', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057819, '4401', '广州市', 2, 1611571208564057818, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057820, '440101', '市辖区', 3, 1611571208564057819, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057821, '440103', '荔湾区', 3, 1611571208564057819, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057822, '440104', '越秀区', 3, 1611571208564057819, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057823, '440105', '海珠区', 3, 1611571208564057819, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057824, '440106', '天河区', 3, 1611571208564057819, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057825, '440111', '白云区', 3, 1611571208564057819, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057826, '440112', '黄埔区', 3, 1611571208564057819, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057827, '440113', '番禺区', 3, 1611571208564057819, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057828, '440114', '花都区', 3, 1611571208564057819, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057829, '440115', '南沙区', 3, 1611571208564057819, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057830, '440116', '萝岗区', 3, 1611571208564057819, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057831, '440183', '增城市', 3, 1611571208564057819, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057832, '440184', '从化市', 3, 1611571208564057819, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057833, '4402', '韶关市', 2, 1611571208564057818, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057834, '440201', '市辖区', 3, 1611571208564057833, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057835, '440203', '武江区', 3, 1611571208564057833, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057836, '440204', '浈江区', 3, 1611571208564057833, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057837, '440205', '曲江区', 3, 1611571208564057833, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057838, '440222', '始兴县', 3, 1611571208564057833, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057839, '440224', '仁化县', 3, 1611571208564057833, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057840, '440229', '翁源县', 3, 1611571208564057833, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057841, '440232', '乳源瑶族自治县', 3, 1611571208564057833, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057842, '440233', '新丰县', 3, 1611571208564057833, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057843, '440281', '乐昌市', 3, 1611571208564057833, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057844, '440282', '南雄市', 3, 1611571208564057833, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057845, '4403', '深圳市', 2, 1611571208564057818, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057846, '440301', '市辖区', 3, 1611571208564057845, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057847, '440303', '罗湖区', 3, 1611571208564057845, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057848, '440304', '福田区', 3, 1611571208564057845, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057849, '440305', '南山区', 3, 1611571208564057845, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057850, '440306', '宝安区', 3, 1611571208564057845, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057851, '440307', '龙岗区', 3, 1611571208564057845, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057852, '440308', '盐田区', 3, 1611571208564057845, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057853, '4404', '珠海市', 2, 1611571208564057818, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057854, '440401', '市辖区', 3, 1611571208564057853, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057855, '440402', '香洲区', 3, 1611571208564057853, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057856, '440403', '斗门区', 3, 1611571208564057853, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057857, '440404', '金湾区', 3, 1611571208564057853, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057858, '4405', '汕头市', 2, 1611571208564057818, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057859, '440501', '市辖区', 3, 1611571208564057858, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057860, '440507', '龙湖区', 3, 1611571208564057858, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057861, '440511', '金平区', 3, 1611571208564057858, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057862, '440512', '濠江区', 3, 1611571208564057858, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057863, '440513', '潮阳区', 3, 1611571208564057858, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057864, '440514', '潮南区', 3, 1611571208564057858, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057865, '440515', '澄海区', 3, 1611571208564057858, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057866, '440523', '南澳县', 3, 1611571208564057858, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057867, '4406', '佛山市', 2, 1611571208564057818, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057868, '440601', '市辖区', 3, 1611571208564057867, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057869, '440604', '禅城区', 3, 1611571208564057867, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057870, '440605', '南海区', 3, 1611571208564057867, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057871, '440606', '顺德区', 3, 1611571208564057867, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057872, '440607', '三水区', 3, 1611571208564057867, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057873, '440608', '高明区', 3, 1611571208564057867, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057874, '4407', '江门市', 2, 1611571208564057818, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057875, '440701', '市辖区', 3, 1611571208564057874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057876, '440703', '蓬江区', 3, 1611571208564057874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057877, '440704', '江海区', 3, 1611571208564057874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057878, '440705', '新会区', 3, 1611571208564057874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057879, '440781', '台山市', 3, 1611571208564057874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057880, '440783', '开平市', 3, 1611571208564057874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057881, '440784', '鹤山市', 3, 1611571208564057874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057882, '440785', '恩平市', 3, 1611571208564057874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057883, '4408', '湛江市', 2, 1611571208564057818, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057884, '440801', '市辖区', 3, 1611571208564057883, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057885, '440802', '赤坎区', 3, 1611571208564057883, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057886, '440803', '霞山区', 3, 1611571208564057883, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057887, '440804', '坡头区', 3, 1611571208564057883, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057888, '440811', '麻章区', 3, 1611571208564057883, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057889, '440823', '遂溪县', 3, 1611571208564057883, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057890, '440825', '徐闻县', 3, 1611571208564057883, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057891, '440881', '廉江市', 3, 1611571208564057883, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057892, '440882', '雷州市', 3, 1611571208564057883, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057893, '440883', '吴川市', 3, 1611571208564057883, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057894, '4409', '茂名市', 2, 1611571208564057818, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057895, '440901', '市辖区', 3, 1611571208564057894, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057896, '440902', '茂南区', 3, 1611571208564057894, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057897, '440903', '茂港区', 3, 1611571208564057894, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057898, '440923', '电白县', 3, 1611571208564057894, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057899, '440981', '高州市', 3, 1611571208564057894, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057900, '440982', '化州市', 3, 1611571208564057894, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057901, '440983', '信宜市', 3, 1611571208564057894, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057902, '4412', '肇庆市', 2, 1611571208564057818, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057903, '441201', '市辖区', 3, 1611571208564057902, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057904, '441202', '端州区', 3, 1611571208564057902, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057905, '441203', '鼎湖区', 3, 1611571208564057902, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057906, '441223', '广宁县', 3, 1611571208564057902, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057907, '441224', '怀集县', 3, 1611571208564057902, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057908, '441225', '封开县', 3, 1611571208564057902, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057909, '441226', '德庆县', 3, 1611571208564057902, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057910, '441283', '高要市', 3, 1611571208564057902, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057911, '441284', '四会市', 3, 1611571208564057902, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057912, '4413', '惠州市', 2, 1611571208564057818, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057913, '441301', '市辖区', 3, 1611571208564057912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057914, '441302', '惠城区', 3, 1611571208564057912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057915, '441303', '惠阳区', 3, 1611571208564057912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057916, '441322', '博罗县', 3, 1611571208564057912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057917, '441323', '惠东县', 3, 1611571208564057912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057918, '441324', '龙门县', 3, 1611571208564057912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057919, '4414', '梅州市', 2, 1611571208564057818, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057920, '441401', '市辖区', 3, 1611571208564057919, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057921, '441402', '梅江区', 3, 1611571208564057919, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057922, '441421', '梅县', 3, 1611571208564057919, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057923, '441422', '大埔县', 3, 1611571208564057919, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057924, '441423', '丰顺县', 3, 1611571208564057919, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057925, '441424', '五华县', 3, 1611571208564057919, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057926, '441426', '平远县', 3, 1611571208564057919, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057927, '441427', '蕉岭县', 3, 1611571208564057919, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057928, '441481', '兴宁市', 3, 1611571208564057919, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057929, '4415', '汕尾市', 2, 1611571208564057818, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057930, '441501', '市辖区', 3, 1611571208564057929, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057931, '441502', '城区', 3, 1611571208564057929, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057932, '441521', '海丰县', 3, 1611571208564057929, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057933, '441523', '陆河县', 3, 1611571208564057929, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057934, '441581', '陆丰市', 3, 1611571208564057929, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057935, '4416', '河源市', 2, 1611571208564057818, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057936, '441601', '市辖区', 3, 1611571208564057935, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057937, '441602', '源城区', 3, 1611571208564057935, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057938, '441621', '紫金县', 3, 1611571208564057935, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057939, '441622', '龙川县', 3, 1611571208564057935, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057940, '441623', '连平县', 3, 1611571208564057935, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057941, '441624', '和平县', 3, 1611571208564057935, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057942, '441625', '东源县', 3, 1611571208564057935, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057943, '4417', '阳江市', 2, 1611571208564057818, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057944, '441701', '市辖区', 3, 1611571208564057943, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057945, '441702', '江城区', 3, 1611571208564057943, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057946, '441721', '阳西县', 3, 1611571208564057943, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057947, '441723', '阳东县', 3, 1611571208564057943, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057948, '441781', '阳春市', 3, 1611571208564057943, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057949, '4418', '清远市', 2, 1611571208564057818, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057950, '441801', '市辖区', 3, 1611571208564057949, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057951, '441802', '清城区', 3, 1611571208564057949, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057952, '441821', '佛冈县', 3, 1611571208564057949, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057953, '441823', '阳山县', 3, 1611571208564057949, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057954, '441825', '连山壮族瑶族自治县', 3, 1611571208564057949, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057955, '441826', '连南瑶族自治县', 3, 1611571208564057949, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057956, '441827', '清新县', 3, 1611571208564057949, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057957, '441881', '英德市', 3, 1611571208564057949, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057958, '441882', '连州市', 3, 1611571208564057949, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057959, '4419', '东莞市', 2, 1611571208564057818, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057960, '4420', '中山市', 2, 1611571208564057818, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057961, '4451', '潮州市', 2, 1611571208564057818, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057962, '445101', '市辖区', 3, 1611571208564057961, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057963, '445102', '湘桥区', 3, 1611571208564057961, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057964, '445121', '潮安县', 3, 1611571208564057961, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057965, '445122', '饶平县', 3, 1611571208564057961, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057966, '4452', '揭阳市', 2, 1611571208564057818, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057967, '445201', '市辖区', 3, 1611571208564057966, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057968, '445202', '榕城区', 3, 1611571208564057966, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057969, '445221', '揭东县', 3, 1611571208564057966, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057970, '445222', '揭西县', 3, 1611571208564057966, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057971, '445224', '惠来县', 3, 1611571208564057966, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057972, '445281', '普宁市', 3, 1611571208564057966, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057973, '4453', '云浮市', 2, 1611571208564057818, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057974, '445301', '市辖区', 3, 1611571208564057973, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057975, '445302', '云城区', 3, 1611571208564057973, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057976, '445321', '新兴县', 3, 1611571208564057973, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057977, '445322', '郁南县', 3, 1611571208564057973, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057978, '445323', '云安县', 3, 1611571208564057973, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057979, '445381', '罗定市', 3, 1611571208564057973, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057980, '45', '广西', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057981, '4501', '南宁市', 2, 1611571208564057980, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057982, '450101', '市辖区', 3, 1611571208564057981, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057983, '450102', '兴宁区', 3, 1611571208564057981, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057984, '450103', '青秀区', 3, 1611571208564057981, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057985, '450105', '江南区', 3, 1611571208564057981, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057986, '450107', '西乡塘区', 3, 1611571208564057981, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057987, '450108', '良庆区', 3, 1611571208564057981, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057988, '450109', '邕宁区', 3, 1611571208564057981, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057989, '450122', '武鸣县', 3, 1611571208564057981, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057990, '450123', '隆安县', 3, 1611571208564057981, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057991, '450124', '马山县', 3, 1611571208564057981, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057992, '450125', '上林县', 3, 1611571208564057981, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057993, '450126', '宾阳县', 3, 1611571208564057981, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057994, '450127', '横县', 3, 1611571208564057981, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057995, '4502', '柳州市', 2, 1611571208564057980, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057996, '450201', '市辖区', 3, 1611571208564057995, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057997, '450202', '城中区', 3, 1611571208564057995, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057998, '450203', '鱼峰区', 3, 1611571208564057995, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564057999, '450204', '柳南区', 3, 1611571208564057995, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058000, '450205', '柳北区', 3, 1611571208564057995, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058001, '450221', '柳江县', 3, 1611571208564057995, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058002, '450222', '柳城县', 3, 1611571208564057995, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058003, '450223', '鹿寨县', 3, 1611571208564057995, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058004, '450224', '融安县', 3, 1611571208564057995, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058005, '450225', '融水苗族自治县', 3, 1611571208564057995, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058006, '450226', '三江侗族自治县', 3, 1611571208564057995, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058007, '4503', '桂林市', 2, 1611571208564057980, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058008, '450301', '市辖区', 3, 1611571208564058007, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058009, '450302', '秀峰区', 3, 1611571208564058007, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058010, '450303', '叠彩区', 3, 1611571208564058007, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058011, '450304', '象山区', 3, 1611571208564058007, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058012, '450305', '七星区', 3, 1611571208564058007, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058013, '450311', '雁山区', 3, 1611571208564058007, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058014, '450321', '阳朔县', 3, 1611571208564058007, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058015, '450322', '临桂县', 3, 1611571208564058007, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058016, '450323', '灵川县', 3, 1611571208564058007, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058017, '450324', '全州县', 3, 1611571208564058007, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058018, '450325', '兴安县', 3, 1611571208564058007, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058019, '450326', '永福县', 3, 1611571208564058007, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058020, '450327', '灌阳县', 3, 1611571208564058007, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058021, '450328', '龙胜各族自治县', 3, 1611571208564058007, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058022, '450329', '资源县', 3, 1611571208564058007, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058023, '450330', '平乐县', 3, 1611571208564058007, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058024, '450331', '荔浦县', 3, 1611571208564058007, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058025, '450332', '恭城瑶族自治县', 3, 1611571208564058007, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058026, '4504', '梧州市', 2, 1611571208564057980, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058027, '450401', '市辖区', 3, 1611571208564058026, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058028, '450403', '万秀区', 3, 1611571208564058026, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058029, '450404', '蝶山区', 3, 1611571208564058026, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058030, '450405', '长洲区', 3, 1611571208564058026, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058031, '450421', '苍梧县', 3, 1611571208564058026, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058032, '450422', '藤县', 3, 1611571208564058026, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058033, '450423', '蒙山县', 3, 1611571208564058026, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058034, '450481', '岑溪市', 3, 1611571208564058026, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058035, '4505', '北海市', 2, 1611571208564057980, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058036, '450501', '市辖区', 3, 1611571208564058035, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058037, '450502', '海城区', 3, 1611571208564058035, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058038, '450503', '银海区', 3, 1611571208564058035, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058039, '450512', '铁山港区', 3, 1611571208564058035, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058040, '450521', '合浦县', 3, 1611571208564058035, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058041, '4506', '防城港市', 2, 1611571208564057980, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058042, '450601', '市辖区', 3, 1611571208564058041, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058043, '450602', '港口区', 3, 1611571208564058041, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058044, '450603', '防城区', 3, 1611571208564058041, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058045, '450621', '上思县', 3, 1611571208564058041, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058046, '450681', '东兴市', 3, 1611571208564058041, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058047, '4507', '钦州市', 2, 1611571208564057980, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058048, '450701', '市辖区', 3, 1611571208564058047, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058049, '450702', '钦南区', 3, 1611571208564058047, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058050, '450703', '钦北区', 3, 1611571208564058047, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058051, '450721', '灵山县', 3, 1611571208564058047, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058052, '450722', '浦北县', 3, 1611571208564058047, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058053, '4508', '贵港市', 2, 1611571208564057980, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058054, '450801', '市辖区', 3, 1611571208564058053, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058055, '450802', '港北区', 3, 1611571208564058053, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058056, '450803', '港南区', 3, 1611571208564058053, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058057, '450804', '覃塘区', 3, 1611571208564058053, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058058, '450821', '平南县', 3, 1611571208564058053, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058059, '450881', '桂平市', 3, 1611571208564058053, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058060, '4509', '玉林市', 2, 1611571208564057980, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058061, '450901', '市辖区', 3, 1611571208564058060, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058062, '450902', '玉州区', 3, 1611571208564058060, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058063, '450921', '容县', 3, 1611571208564058060, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058064, '450922', '陆川县', 3, 1611571208564058060, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058065, '450923', '博白县', 3, 1611571208564058060, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058066, '450924', '兴业县', 3, 1611571208564058060, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058067, '450981', '北流市', 3, 1611571208564058060, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058068, '4510', '百色市', 2, 1611571208564057980, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058069, '451001', '市辖区', 3, 1611571208564058068, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058070, '451002', '右江区', 3, 1611571208564058068, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058071, '451021', '田阳县', 3, 1611571208564058068, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058072, '451022', '田东县', 3, 1611571208564058068, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058073, '451023', '平果县', 3, 1611571208564058068, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058074, '451024', '德保县', 3, 1611571208564058068, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058075, '451025', '靖西县', 3, 1611571208564058068, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058076, '451026', '那坡县', 3, 1611571208564058068, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058077, '451027', '凌云县', 3, 1611571208564058068, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058078, '451028', '乐业县', 3, 1611571208564058068, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058079, '451029', '田林县', 3, 1611571208564058068, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058080, '451030', '西林县', 3, 1611571208564058068, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058081, '451031', '隆林各族自治县', 3, 1611571208564058068, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058082, '4511', '贺州市', 2, 1611571208564057980, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058083, '451101', '市辖区', 3, 1611571208564058082, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058084, '451102', '八步区', 3, 1611571208564058082, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058085, '451121', '昭平县', 3, 1611571208564058082, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058086, '451122', '钟山县', 3, 1611571208564058082, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058087, '451123', '富川瑶族自治县', 3, 1611571208564058082, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058088, '4512', '河池市', 2, 1611571208564057980, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058089, '451201', '市辖区', 3, 1611571208564058088, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058090, '451202', '金城江区', 3, 1611571208564058088, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058091, '451221', '南丹县', 3, 1611571208564058088, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058092, '451222', '天峨县', 3, 1611571208564058088, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058093, '451223', '凤山县', 3, 1611571208564058088, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058094, '451224', '东兰县', 3, 1611571208564058088, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058095, '451225', '罗城仫佬族自治县', 3, 1611571208564058088, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058096, '451226', '环江毛南族自治县', 3, 1611571208564058088, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058097, '451227', '巴马瑶族自治县', 3, 1611571208564058088, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058098, '451228', '都安瑶族自治县', 3, 1611571208564058088, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058099, '451229', '大化瑶族自治县', 3, 1611571208564058088, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058100, '451281', '宜州市', 3, 1611571208564058088, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058101, '4513', '来宾市', 2, 1611571208564057980, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058102, '451301', '市辖区', 3, 1611571208564058101, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058103, '451302', '兴宾区', 3, 1611571208564058101, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058104, '451321', '忻城县', 3, 1611571208564058101, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058105, '451322', '象州县', 3, 1611571208564058101, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058106, '451323', '武宣县', 3, 1611571208564058101, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058107, '451324', '金秀瑶族自治县', 3, 1611571208564058101, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058108, '451381', '合山市', 3, 1611571208564058101, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058109, '4514', '崇左市', 2, 1611571208564057980, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058110, '451401', '市辖区', 3, 1611571208564058109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058111, '451402', '江洲区', 3, 1611571208564058109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058112, '451421', '扶绥县', 3, 1611571208564058109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058113, '451422', '宁明县', 3, 1611571208564058109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058114, '451423', '龙州县', 3, 1611571208564058109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058115, '451424', '大新县', 3, 1611571208564058109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058116, '451425', '天等县', 3, 1611571208564058109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058117, '451481', '凭祥市', 3, 1611571208564058109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058118, '46', '海南', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058119, '4601', '海口市', 2, 1611571208564058118, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058120, '460101', '市辖区', 3, 1611571208564058119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058121, '460105', '秀英区', 3, 1611571208564058119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058122, '460106', '龙华区', 3, 1611571208564058119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058123, '460107', '琼山区', 3, 1611571208564058119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058124, '460108', '美兰区', 3, 1611571208564058119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058125, '4602', '三亚市', 2, 1611571208564058118, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058126, '460201', '市辖区', 3, 1611571208564058125, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058127, '4603', '三沙市', 2, 1611571208564058118, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058128, '460321', '西沙群岛', 3, 1611571208564058127, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058129, '460322', '南沙群岛', 3, 1611571208564058127, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058130, '460323', '中沙群岛的岛礁及其海域', 3, 1611571208564058127, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058131, '4690', '省直辖县级行政区划', 2, 1611571208564058118, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058132, '469001', '五指山市', 3, 1611571208564058131, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058133, '469002', '琼海市', 3, 1611571208564058131, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058134, '469003', '儋州市', 3, 1611571208564058131, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058135, '469005', '文昌市', 3, 1611571208564058131, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058136, '469006', '万宁市', 3, 1611571208564058131, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058137, '469007', '东方市', 3, 1611571208564058131, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058138, '469021', '定安县', 3, 1611571208564058131, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058139, '469022', '屯昌县', 3, 1611571208564058131, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058140, '469023', '澄迈县', 3, 1611571208564058131, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058141, '469024', '临高县', 3, 1611571208564058131, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058142, '469025', '白沙黎族自治县', 3, 1611571208564058131, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058143, '469026', '昌江黎族自治县', 3, 1611571208564058131, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058144, '469027', '乐东黎族自治县', 3, 1611571208564058131, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058145, '469028', '陵水黎族自治县', 3, 1611571208564058131, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058146, '469029', '保亭黎族苗族自治县', 3, 1611571208564058131, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058147, '469030', '琼中黎族苗族自治县', 3, 1611571208564058131, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058148, '50', '重庆', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058149, '5001', '市辖区', 2, 1611571208564058148, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058150, '500101', '万州区', 3, 1611571208564058149, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058151, '500102', '涪陵区', 3, 1611571208564058149, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058152, '500103', '渝中区', 3, 1611571208564058149, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058153, '500104', '大渡口区', 3, 1611571208564058149, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058154, '500105', '江北区', 3, 1611571208564058149, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058155, '500106', '沙坪坝区', 3, 1611571208564058149, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058156, '500107', '九龙坡区', 3, 1611571208564058149, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058157, '500108', '南岸区', 3, 1611571208564058149, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058158, '500109', '北碚区', 3, 1611571208564058149, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058159, '500110', '綦江区', 3, 1611571208564058149, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058160, '500111', '大足区', 3, 1611571208564058149, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058161, '500112', '渝北区', 3, 1611571208564058149, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058162, '500113', '巴南区', 3, 1611571208564058149, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058163, '500114', '黔江区', 3, 1611571208564058149, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058164, '500115', '长寿区', 3, 1611571208564058149, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058165, '500116', '江津区', 3, 1611571208564058149, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058166, '500117', '合川区', 3, 1611571208564058149, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058167, '500118', '永川区', 3, 1611571208564058149, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058168, '500119', '南川区', 3, 1611571208564058149, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058169, '5002', '县', 2, 1611571208564058148, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058170, '500223', '潼南县', 3, 1611571208564058169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058171, '500224', '铜梁县', 3, 1611571208564058169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058172, '500226', '荣昌县', 3, 1611571208564058169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058173, '500227', '璧山县', 3, 1611571208564058169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058174, '500228', '梁平县', 3, 1611571208564058169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058175, '500229', '城口县', 3, 1611571208564058169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058176, '500230', '丰都县', 3, 1611571208564058169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058177, '500231', '垫江县', 3, 1611571208564058169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058178, '500232', '武隆县', 3, 1611571208564058169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058179, '500233', '忠县', 3, 1611571208564058169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058180, '500234', '开县', 3, 1611571208564058169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058181, '500235', '云阳县', 3, 1611571208564058169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058182, '500236', '奉节县', 3, 1611571208564058169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058183, '500237', '巫山县', 3, 1611571208564058169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058184, '500238', '巫溪县', 3, 1611571208564058169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058185, '500240', '石柱土家族自治县', 3, 1611571208564058169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058186, '500241', '秀山土家族苗族自治县', 3, 1611571208564058169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058187, '500242', '酉阳土家族苗族自治县', 3, 1611571208564058169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058188, '500243', '彭水苗族土家族自治县', 3, 1611571208564058169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058189, '51', '四川', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058190, '5101', '成都市', 2, 1611571208564058189, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058191, '510101', '市辖区', 3, 1611571208564058190, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058192, '510104', '锦江区', 3, 1611571208564058190, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058193, '510105', '青羊区', 3, 1611571208564058190, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058194, '510106', '金牛区', 3, 1611571208564058190, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058195, '510107', '武侯区', 3, 1611571208564058190, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058196, '510108', '成华区', 3, 1611571208564058190, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058197, '510112', '龙泉驿区', 3, 1611571208564058190, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058198, '510113', '青白江区', 3, 1611571208564058190, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058199, '510114', '新都区', 3, 1611571208564058190, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058200, '510115', '温江区', 3, 1611571208564058190, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058201, '510121', '金堂县', 3, 1611571208564058190, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058202, '510122', '双流县', 3, 1611571208564058190, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058203, '510124', '郫县', 3, 1611571208564058190, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058204, '510129', '大邑县', 3, 1611571208564058190, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058205, '510131', '蒲江县', 3, 1611571208564058190, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058206, '510132', '新津县', 3, 1611571208564058190, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058207, '510181', '都江堰市', 3, 1611571208564058190, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058208, '510182', '彭州市', 3, 1611571208564058190, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058209, '510183', '邛崃市', 3, 1611571208564058190, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058210, '510184', '崇州市', 3, 1611571208564058190, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058211, '5103', '自贡市', 2, 1611571208564058189, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058212, '510301', '市辖区', 3, 1611571208564058211, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058213, '510302', '自流井区', 3, 1611571208564058211, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058214, '510303', '贡井区', 3, 1611571208564058211, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058215, '510304', '大安区', 3, 1611571208564058211, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058216, '510311', '沿滩区', 3, 1611571208564058211, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058217, '510321', '荣县', 3, 1611571208564058211, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058218, '510322', '富顺县', 3, 1611571208564058211, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058219, '5104', '攀枝花市', 2, 1611571208564058189, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058220, '510401', '市辖区', 3, 1611571208564058219, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058221, '510402', '东区', 3, 1611571208564058219, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058222, '510403', '西区', 3, 1611571208564058219, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058223, '510411', '仁和区', 3, 1611571208564058219, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058224, '510421', '米易县', 3, 1611571208564058219, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058225, '510422', '盐边县', 3, 1611571208564058219, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058226, '5105', '泸州市', 2, 1611571208564058189, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058227, '510501', '市辖区', 3, 1611571208564058226, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058228, '510502', '江阳区', 3, 1611571208564058226, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058229, '510503', '纳溪区', 3, 1611571208564058226, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058230, '510504', '龙马潭区', 3, 1611571208564058226, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058231, '510521', '泸县', 3, 1611571208564058226, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058232, '510522', '合江县', 3, 1611571208564058226, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058233, '510524', '叙永县', 3, 1611571208564058226, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058234, '510525', '古蔺县', 3, 1611571208564058226, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058235, '5106', '德阳市', 2, 1611571208564058189, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058236, '510601', '市辖区', 3, 1611571208564058235, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058237, '510603', '旌阳区', 3, 1611571208564058235, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058238, '510623', '中江县', 3, 1611571208564058235, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058239, '510626', '罗江县', 3, 1611571208564058235, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058240, '510681', '广汉市', 3, 1611571208564058235, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058241, '510682', '什邡市', 3, 1611571208564058235, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058242, '510683', '绵竹市', 3, 1611571208564058235, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058243, '5107', '绵阳市', 2, 1611571208564058189, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058244, '510701', '市辖区', 3, 1611571208564058243, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058245, '510703', '涪城区', 3, 1611571208564058243, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058246, '510704', '游仙区', 3, 1611571208564058243, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058247, '510722', '三台县', 3, 1611571208564058243, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058248, '510723', '盐亭县', 3, 1611571208564058243, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058249, '510724', '安县', 3, 1611571208564058243, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058250, '510725', '梓潼县', 3, 1611571208564058243, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058251, '510726', '北川羌族自治县', 3, 1611571208564058243, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058252, '510727', '平武县', 3, 1611571208564058243, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058253, '510781', '江油市', 3, 1611571208564058243, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058254, '5108', '广元市', 2, 1611571208564058189, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058255, '510801', '市辖区', 3, 1611571208564058254, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058256, '510802', '利州区', 3, 1611571208564058254, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058257, '510811', '元坝区', 3, 1611571208564058254, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058258, '510812', '朝天区', 3, 1611571208564058254, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058259, '510821', '旺苍县', 3, 1611571208564058254, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058260, '510822', '青川县', 3, 1611571208564058254, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058261, '510823', '剑阁县', 3, 1611571208564058254, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058262, '510824', '苍溪县', 3, 1611571208564058254, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058263, '5109', '遂宁市', 2, 1611571208564058189, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058264, '510901', '市辖区', 3, 1611571208564058263, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058265, '510903', '船山区', 3, 1611571208564058263, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058266, '510904', '安居区', 3, 1611571208564058263, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058267, '510921', '蓬溪县', 3, 1611571208564058263, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058268, '510922', '射洪县', 3, 1611571208564058263, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058269, '510923', '大英县', 3, 1611571208564058263, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058270, '5110', '内江市', 2, 1611571208564058189, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058271, '511001', '市辖区', 3, 1611571208564058270, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058272, '511002', '市中区', 3, 1611571208564058270, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058273, '511011', '东兴区', 3, 1611571208564058270, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058274, '511024', '威远县', 3, 1611571208564058270, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058275, '511025', '资中县', 3, 1611571208564058270, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058276, '511028', '隆昌县', 3, 1611571208564058270, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058277, '5111', '乐山市', 2, 1611571208564058189, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058278, '511101', '市辖区', 3, 1611571208564058277, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058279, '511102', '市中区', 3, 1611571208564058277, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058280, '511111', '沙湾区', 3, 1611571208564058277, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058281, '511112', '五通桥区', 3, 1611571208564058277, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058282, '511113', '金口河区', 3, 1611571208564058277, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058283, '511123', '犍为县', 3, 1611571208564058277, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058284, '511124', '井研县', 3, 1611571208564058277, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058285, '511126', '夹江县', 3, 1611571208564058277, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058286, '511129', '沐川县', 3, 1611571208564058277, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058287, '511132', '峨边彝族自治县', 3, 1611571208564058277, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058288, '511133', '马边彝族自治县', 3, 1611571208564058277, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058289, '511181', '峨眉山市', 3, 1611571208564058277, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058290, '5113', '南充市', 2, 1611571208564058189, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058291, '511301', '市辖区', 3, 1611571208564058290, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058292, '511302', '顺庆区', 3, 1611571208564058290, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058293, '511303', '高坪区', 3, 1611571208564058290, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058294, '511304', '嘉陵区', 3, 1611571208564058290, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058295, '511321', '南部县', 3, 1611571208564058290, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058296, '511322', '营山县', 3, 1611571208564058290, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058297, '511323', '蓬安县', 3, 1611571208564058290, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058298, '511324', '仪陇县', 3, 1611571208564058290, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058299, '511325', '西充县', 3, 1611571208564058290, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058300, '511381', '阆中市', 3, 1611571208564058290, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058301, '5114', '眉山市', 2, 1611571208564058189, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058302, '511401', '市辖区', 3, 1611571208564058301, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058303, '511402', '东坡区', 3, 1611571208564058301, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058304, '511421', '仁寿县', 3, 1611571208564058301, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058305, '511422', '彭山县', 3, 1611571208564058301, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058306, '511423', '洪雅县', 3, 1611571208564058301, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058307, '511424', '丹棱县', 3, 1611571208564058301, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058308, '511425', '青神县', 3, 1611571208564058301, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058309, '5115', '宜宾市', 2, 1611571208564058189, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058310, '511501', '市辖区', 3, 1611571208564058309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058311, '511502', '翠屏区', 3, 1611571208564058309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058312, '511503', '南溪区', 3, 1611571208564058309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058313, '511521', '宜宾县', 3, 1611571208564058309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058314, '511523', '江安县', 3, 1611571208564058309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058315, '511524', '长宁县', 3, 1611571208564058309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058316, '511525', '高县', 3, 1611571208564058309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058317, '511526', '珙县', 3, 1611571208564058309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058318, '511527', '筠连县', 3, 1611571208564058309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058319, '511528', '兴文县', 3, 1611571208564058309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058320, '511529', '屏山县', 3, 1611571208564058309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058321, '5116', '广安市', 2, 1611571208564058189, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058322, '511601', '市辖区', 3, 1611571208564058321, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058323, '511602', '广安区', 3, 1611571208564058321, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058324, '511621', '岳池县', 3, 1611571208564058321, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058325, '511622', '武胜县', 3, 1611571208564058321, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058326, '511623', '邻水县', 3, 1611571208564058321, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058327, '511681', '华蓥市', 3, 1611571208564058321, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058328, '5117', '达州市', 2, 1611571208564058189, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058329, '511701', '市辖区', 3, 1611571208564058328, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058330, '511702', '通川区', 3, 1611571208564058328, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058331, '511721', '达县', 3, 1611571208564058328, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058332, '511722', '宣汉县', 3, 1611571208564058328, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058333, '511723', '开江县', 3, 1611571208564058328, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058334, '511724', '大竹县', 3, 1611571208564058328, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058335, '511725', '渠县', 3, 1611571208564058328, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058336, '511781', '万源市', 3, 1611571208564058328, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058337, '5118', '雅安市', 2, 1611571208564058189, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058338, '511801', '市辖区', 3, 1611571208564058337, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058339, '511802', '雨城区', 3, 1611571208564058337, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058340, '511803', '名山区', 3, 1611571208564058337, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058341, '511822', '荥经县', 3, 1611571208564058337, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058342, '511823', '汉源县', 3, 1611571208564058337, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058343, '511824', '石棉县', 3, 1611571208564058337, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058344, '511825', '天全县', 3, 1611571208564058337, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058345, '511826', '芦山县', 3, 1611571208564058337, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058346, '511827', '宝兴县', 3, 1611571208564058337, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058347, '5119', '巴中市', 2, 1611571208564058189, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058348, '511901', '市辖区', 3, 1611571208564058347, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058349, '511902', '巴州区', 3, 1611571208564058347, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058350, '511921', '通江县', 3, 1611571208564058347, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058351, '511922', '南江县', 3, 1611571208564058347, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058352, '511923', '平昌县', 3, 1611571208564058347, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058353, '5120', '资阳市', 2, 1611571208564058189, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058354, '512001', '市辖区', 3, 1611571208564058353, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058355, '512002', '雁江区', 3, 1611571208564058353, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058356, '512021', '安岳县', 3, 1611571208564058353, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058357, '512022', '乐至县', 3, 1611571208564058353, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058358, '512081', '简阳市', 3, 1611571208564058353, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058359, '5132', '阿坝藏族羌族自治州', 2, 1611571208564058189, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058360, '513221', '汶川县', 3, 1611571208564058359, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058361, '513222', '理县', 3, 1611571208564058359, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058362, '513223', '茂县', 3, 1611571208564058359, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058363, '513224', '松潘县', 3, 1611571208564058359, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058364, '513225', '九寨沟县', 3, 1611571208564058359, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058365, '513226', '金川县', 3, 1611571208564058359, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058366, '513227', '小金县', 3, 1611571208564058359, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058367, '513228', '黑水县', 3, 1611571208564058359, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058368, '513229', '马尔康县', 3, 1611571208564058359, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058369, '513230', '壤塘县', 3, 1611571208564058359, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058370, '513231', '阿坝县', 3, 1611571208564058359, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058371, '513232', '若尔盖县', 3, 1611571208564058359, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058372, '513233', '红原县', 3, 1611571208564058359, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058373, '5133', '甘孜藏族自治州', 2, 1611571208564058189, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058374, '513321', '康定县', 3, 1611571208564058373, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058375, '513322', '泸定县', 3, 1611571208564058373, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058376, '513323', '丹巴县', 3, 1611571208564058373, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058377, '513324', '九龙县', 3, 1611571208564058373, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058378, '513325', '雅江县', 3, 1611571208564058373, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058379, '513326', '道孚县', 3, 1611571208564058373, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058380, '513327', '炉霍县', 3, 1611571208564058373, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058381, '513328', '甘孜县', 3, 1611571208564058373, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058382, '513329', '新龙县', 3, 1611571208564058373, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058383, '513330', '德格县', 3, 1611571208564058373, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058384, '513331', '白玉县', 3, 1611571208564058373, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058385, '513332', '石渠县', 3, 1611571208564058373, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058386, '513333', '色达县', 3, 1611571208564058373, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058387, '513334', '理塘县', 3, 1611571208564058373, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058388, '513335', '巴塘县', 3, 1611571208564058373, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058389, '513336', '乡城县', 3, 1611571208564058373, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058390, '513337', '稻城县', 3, 1611571208564058373, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058391, '513338', '得荣县', 3, 1611571208564058373, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058392, '5134', '凉山彝族自治州', 2, 1611571208564058189, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058393, '513401', '西昌市', 3, 1611571208564058392, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058394, '513422', '木里藏族自治县', 3, 1611571208564058392, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058395, '513423', '盐源县', 3, 1611571208564058392, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058396, '513424', '德昌县', 3, 1611571208564058392, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058397, '513425', '会理县', 3, 1611571208564058392, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058398, '513426', '会东县', 3, 1611571208564058392, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058399, '513427', '宁南县', 3, 1611571208564058392, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058400, '513428', '普格县', 3, 1611571208564058392, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058401, '513429', '布拖县', 3, 1611571208564058392, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058402, '513430', '金阳县', 3, 1611571208564058392, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058403, '513431', '昭觉县', 3, 1611571208564058392, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058404, '513432', '喜德县', 3, 1611571208564058392, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058405, '513433', '冕宁县', 3, 1611571208564058392, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058406, '513434', '越西县', 3, 1611571208564058392, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058407, '513435', '甘洛县', 3, 1611571208564058392, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058408, '513436', '美姑县', 3, 1611571208564058392, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058409, '513437', '雷波县', 3, 1611571208564058392, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058410, '52', '贵州', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058411, '5201', '贵阳市', 2, 1611571208564058410, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058412, '520101', '市辖区', 3, 1611571208564058411, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058413, '520102', '南明区', 3, 1611571208564058411, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058414, '520103', '云岩区', 3, 1611571208564058411, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058415, '520111', '花溪区', 3, 1611571208564058411, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058416, '520112', '乌当区', 3, 1611571208564058411, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058417, '520113', '白云区', 3, 1611571208564058411, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058418, '520114', '小河区', 3, 1611571208564058411, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058419, '520121', '开阳县', 3, 1611571208564058411, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058420, '520122', '息烽县', 3, 1611571208564058411, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058421, '520123', '修文县', 3, 1611571208564058411, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058422, '520181', '清镇市', 3, 1611571208564058411, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058423, '5202', '六盘水市', 2, 1611571208564058410, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058424, '520201', '钟山区', 3, 1611571208564058423, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058425, '520203', '六枝特区', 3, 1611571208564058423, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058426, '520221', '水城县', 3, 1611571208564058423, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058427, '520222', '盘县', 3, 1611571208564058423, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058428, '5203', '遵义市', 2, 1611571208564058410, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058429, '520301', '市辖区', 3, 1611571208564058428, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058430, '520302', '红花岗区', 3, 1611571208564058428, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058431, '520303', '汇川区', 3, 1611571208564058428, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058432, '520321', '遵义县', 3, 1611571208564058428, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058433, '520322', '桐梓县', 3, 1611571208564058428, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058434, '520323', '绥阳县', 3, 1611571208564058428, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058435, '520324', '正安县', 3, 1611571208564058428, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058436, '520325', '道真仡佬族苗族自治县', 3, 1611571208564058428, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058437, '520326', '务川仡佬族苗族自治县', 3, 1611571208564058428, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058438, '520327', '凤冈县', 3, 1611571208564058428, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058439, '520328', '湄潭县', 3, 1611571208564058428, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058440, '520329', '余庆县', 3, 1611571208564058428, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058441, '520330', '习水县', 3, 1611571208564058428, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058442, '520381', '赤水市', 3, 1611571208564058428, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058443, '520382', '仁怀市', 3, 1611571208564058428, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058444, '5204', '安顺市', 2, 1611571208564058410, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058445, '520401', '市辖区', 3, 1611571208564058444, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058446, '520402', '西秀区', 3, 1611571208564058444, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058447, '520421', '平坝县', 3, 1611571208564058444, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058448, '520422', '普定县', 3, 1611571208564058444, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058449, '520423', '镇宁布依族苗族自治县', 3, 1611571208564058444, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058450, '520424', '关岭布依族苗族自治县', 3, 1611571208564058444, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058451, '520425', '紫云苗族布依族自治县', 3, 1611571208564058444, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058452, '5205', '毕节市', 2, 1611571208564058410, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058453, '520502', '七星关区', 3, 1611571208564058452, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058454, '520521', '大方县', 3, 1611571208564058452, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058455, '520522', '黔西县', 3, 1611571208564058452, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058456, '520523', '金沙县', 3, 1611571208564058452, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058457, '520524', '织金县', 3, 1611571208564058452, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058458, '520525', '纳雍县', 3, 1611571208564058452, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058459, '520526', '威宁彝族回族苗族自治县', 3, 1611571208564058452, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058460, '520527', '赫章县', 3, 1611571208564058452, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058461, '5206', '铜仁市', 2, 1611571208564058410, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058462, '520602', '碧江区', 3, 1611571208564058461, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058463, '520603', '万山区', 3, 1611571208564058461, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058464, '520621', '江口县', 3, 1611571208564058461, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058465, '520622', '玉屏侗族自治县', 3, 1611571208564058461, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058466, '520623', '石阡县', 3, 1611571208564058461, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058467, '520624', '思南县', 3, 1611571208564058461, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058468, '520625', '印江土家族苗族自治县', 3, 1611571208564058461, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058469, '520626', '德江县', 3, 1611571208564058461, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058470, '520627', '沿河土家族自治县', 3, 1611571208564058461, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058471, '520628', '松桃苗族自治县', 3, 1611571208564058461, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058472, '5223', '黔西南布依族苗族自治州', 2, 1611571208564058410, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058473, '522301', '兴义市', 3, 1611571208564058472, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058474, '522322', '兴仁县', 3, 1611571208564058472, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058475, '522323', '普安县', 3, 1611571208564058472, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058476, '522324', '晴隆县', 3, 1611571208564058472, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058477, '522325', '贞丰县', 3, 1611571208564058472, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058478, '522326', '望谟县', 3, 1611571208564058472, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058479, '522327', '册亨县', 3, 1611571208564058472, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058480, '522328', '安龙县', 3, 1611571208564058472, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058481, '5226', '黔东南苗族侗族自治州', 2, 1611571208564058410, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058482, '522601', '凯里市', 3, 1611571208564058481, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058483, '522622', '黄平县', 3, 1611571208564058481, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058484, '522623', '施秉县', 3, 1611571208564058481, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058485, '522624', '三穗县', 3, 1611571208564058481, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058486, '522625', '镇远县', 3, 1611571208564058481, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058487, '522626', '岑巩县', 3, 1611571208564058481, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058488, '522627', '天柱县', 3, 1611571208564058481, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058489, '522628', '锦屏县', 3, 1611571208564058481, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058490, '522629', '剑河县', 3, 1611571208564058481, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058491, '522630', '台江县', 3, 1611571208564058481, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058492, '522631', '黎平县', 3, 1611571208564058481, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058493, '522632', '榕江县', 3, 1611571208564058481, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058494, '522633', '从江县', 3, 1611571208564058481, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058495, '522634', '雷山县', 3, 1611571208564058481, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058496, '522635', '麻江县', 3, 1611571208564058481, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058497, '522636', '丹寨县', 3, 1611571208564058481, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058498, '5227', '黔南布依族苗族自治州', 2, 1611571208564058410, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058499, '522701', '都匀市', 3, 1611571208564058498, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058500, '522702', '福泉市', 3, 1611571208564058498, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058501, '522722', '荔波县', 3, 1611571208564058498, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058502, '522723', '贵定县', 3, 1611571208564058498, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058503, '522725', '瓮安县', 3, 1611571208564058498, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058504, '522726', '独山县', 3, 1611571208564058498, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058505, '522727', '平塘县', 3, 1611571208564058498, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058506, '522728', '罗甸县', 3, 1611571208564058498, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058507, '522729', '长顺县', 3, 1611571208564058498, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058508, '522730', '龙里县', 3, 1611571208564058498, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058509, '522731', '惠水县', 3, 1611571208564058498, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058510, '522732', '三都水族自治县', 3, 1611571208564058498, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058511, '53', '云南', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058512, '5301', '昆明市', 2, 1611571208564058511, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058513, '530101', '市辖区', 3, 1611571208564058512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058514, '530102', '五华区', 3, 1611571208564058512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058515, '530103', '盘龙区', 3, 1611571208564058512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058516, '530111', '官渡区', 3, 1611571208564058512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058517, '530112', '西山区', 3, 1611571208564058512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058518, '530113', '东川区', 3, 1611571208564058512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058519, '530114', '呈贡区', 3, 1611571208564058512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058520, '530122', '晋宁县', 3, 1611571208564058512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058521, '530124', '富民县', 3, 1611571208564058512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058522, '530125', '宜良县', 3, 1611571208564058512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058523, '530126', '石林彝族自治县', 3, 1611571208564058512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058524, '530127', '嵩明县', 3, 1611571208564058512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058525, '530128', '禄劝彝族苗族自治县', 3, 1611571208564058512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058526, '530129', '寻甸回族彝族自治县', 3, 1611571208564058512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058527, '530181', '安宁市', 3, 1611571208564058512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058528, '5303', '曲靖市', 2, 1611571208564058511, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058529, '530301', '市辖区', 3, 1611571208564058528, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058530, '530302', '麒麟区', 3, 1611571208564058528, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058531, '530321', '马龙县', 3, 1611571208564058528, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058532, '530322', '陆良县', 3, 1611571208564058528, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058533, '530323', '师宗县', 3, 1611571208564058528, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058534, '530324', '罗平县', 3, 1611571208564058528, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058535, '530325', '富源县', 3, 1611571208564058528, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058536, '530326', '会泽县', 3, 1611571208564058528, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058537, '530328', '沾益县', 3, 1611571208564058528, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058538, '530381', '宣威市', 3, 1611571208564058528, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058539, '5304', '玉溪市', 2, 1611571208564058511, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058540, '530402', '红塔区', 3, 1611571208564058539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058541, '530421', '江川县', 3, 1611571208564058539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058542, '530422', '澄江县', 3, 1611571208564058539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058543, '530423', '通海县', 3, 1611571208564058539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058544, '530424', '华宁县', 3, 1611571208564058539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058545, '530425', '易门县', 3, 1611571208564058539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058546, '530426', '峨山彝族自治县', 3, 1611571208564058539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058547, '530427', '新平彝族傣族自治县', 3, 1611571208564058539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058548, '530428', '元江哈尼族彝族傣族自治县', 3, 1611571208564058539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058549, '5305', '保山市', 2, 1611571208564058511, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058550, '530501', '市辖区', 3, 1611571208564058549, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058551, '530502', '隆阳区', 3, 1611571208564058549, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058552, '530521', '施甸县', 3, 1611571208564058549, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058553, '530522', '腾冲县', 3, 1611571208564058549, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058554, '530523', '龙陵县', 3, 1611571208564058549, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058555, '530524', '昌宁县', 3, 1611571208564058549, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058556, '5306', '昭通市', 2, 1611571208564058511, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058557, '530601', '市辖区', 3, 1611571208564058556, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058558, '530602', '昭阳区', 3, 1611571208564058556, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058559, '530621', '鲁甸县', 3, 1611571208564058556, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058560, '530622', '巧家县', 3, 1611571208564058556, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058561, '530623', '盐津县', 3, 1611571208564058556, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058562, '530624', '大关县', 3, 1611571208564058556, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058563, '530625', '永善县', 3, 1611571208564058556, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058564, '530626', '绥江县', 3, 1611571208564058556, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058565, '530627', '镇雄县', 3, 1611571208564058556, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058566, '530628', '彝良县', 3, 1611571208564058556, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058567, '530629', '威信县', 3, 1611571208564058556, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058568, '530630', '水富县', 3, 1611571208564058556, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058569, '5307', '丽江市', 2, 1611571208564058511, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058570, '530701', '市辖区', 3, 1611571208564058569, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058571, '530702', '古城区', 3, 1611571208564058569, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058572, '530721', '玉龙纳西族自治县', 3, 1611571208564058569, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058573, '530722', '永胜县', 3, 1611571208564058569, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058574, '530723', '华坪县', 3, 1611571208564058569, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058575, '530724', '宁蒗彝族自治县', 3, 1611571208564058569, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058576, '5308', '普洱市', 2, 1611571208564058511, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058577, '530801', '市辖区', 3, 1611571208564058576, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058578, '530802', '思茅区', 3, 1611571208564058576, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058579, '530821', '宁洱哈尼族彝族自治县', 3, 1611571208564058576, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058580, '530822', '墨江哈尼族自治县', 3, 1611571208564058576, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058581, '530823', '景东彝族自治县', 3, 1611571208564058576, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058582, '530824', '景谷傣族彝族自治县', 3, 1611571208564058576, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058583, '530825', '镇沅彝族哈尼族拉祜族自治县', 3, 1611571208564058576, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058584, '530826', '江城哈尼族彝族自治县', 3, 1611571208564058576, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058585, '530827', '孟连傣族拉祜族佤族自治县', 3, 1611571208564058576, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058586, '530828', '澜沧拉祜族自治县', 3, 1611571208564058576, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058587, '530829', '西盟佤族自治县', 3, 1611571208564058576, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058588, '5309', '临沧市', 2, 1611571208564058511, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058589, '530901', '市辖区', 3, 1611571208564058588, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058590, '530902', '临翔区', 3, 1611571208564058588, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058591, '530921', '凤庆县', 3, 1611571208564058588, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058592, '530922', '云县', 3, 1611571208564058588, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058593, '530923', '永德县', 3, 1611571208564058588, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058594, '530924', '镇康县', 3, 1611571208564058588, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058595, '530925', '双江拉祜族佤族布朗族傣族自治县', 3, 1611571208564058588, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058596, '530926', '耿马傣族佤族自治县', 3, 1611571208564058588, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058597, '530927', '沧源佤族自治县', 3, 1611571208564058588, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058598, '5323', '楚雄彝族自治州', 2, 1611571208564058511, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058599, '532301', '楚雄市', 3, 1611571208564058598, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058600, '532322', '双柏县', 3, 1611571208564058598, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058601, '532323', '牟定县', 3, 1611571208564058598, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058602, '532324', '南华县', 3, 1611571208564058598, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058603, '532325', '姚安县', 3, 1611571208564058598, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058604, '532326', '大姚县', 3, 1611571208564058598, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058605, '532327', '永仁县', 3, 1611571208564058598, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058606, '532328', '元谋县', 3, 1611571208564058598, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058607, '532329', '武定县', 3, 1611571208564058598, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058608, '532331', '禄丰县', 3, 1611571208564058598, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058609, '5325', '红河哈尼族彝族自治州', 2, 1611571208564058511, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058610, '532501', '个旧市', 3, 1611571208564058609, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058611, '532502', '开远市', 3, 1611571208564058609, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058612, '532503', '蒙自市', 3, 1611571208564058609, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058613, '532523', '屏边苗族自治县', 3, 1611571208564058609, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058614, '532524', '建水县', 3, 1611571208564058609, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058615, '532525', '石屏县', 3, 1611571208564058609, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058616, '532526', '弥勒县', 3, 1611571208564058609, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058617, '532527', '泸西县', 3, 1611571208564058609, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058618, '532528', '元阳县', 3, 1611571208564058609, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058619, '532529', '红河县', 3, 1611571208564058609, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058620, '532530', '金平苗族瑶族傣族自治县', 3, 1611571208564058609, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058621, '532531', '绿春县', 3, 1611571208564058609, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058622, '532532', '河口瑶族自治县', 3, 1611571208564058609, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058623, '5326', '文山壮族苗族自治州', 2, 1611571208564058511, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058624, '532601', '文山市', 3, 1611571208564058623, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058625, '532622', '砚山县', 3, 1611571208564058623, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058626, '532623', '西畴县', 3, 1611571208564058623, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058627, '532624', '麻栗坡县', 3, 1611571208564058623, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058628, '532625', '马关县', 3, 1611571208564058623, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058629, '532626', '丘北县', 3, 1611571208564058623, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058630, '532627', '广南县', 3, 1611571208564058623, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058631, '532628', '富宁县', 3, 1611571208564058623, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058632, '5328', '西双版纳傣族自治州', 2, 1611571208564058511, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058633, '532801', '景洪市', 3, 1611571208564058632, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058634, '532822', '勐海县', 3, 1611571208564058632, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058635, '532823', '勐腊县', 3, 1611571208564058632, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058636, '5329', '大理白族自治州', 2, 1611571208564058511, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058637, '532901', '大理市', 3, 1611571208564058636, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058638, '532922', '漾濞彝族自治县', 3, 1611571208564058636, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058639, '532923', '祥云县', 3, 1611571208564058636, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058640, '532924', '宾川县', 3, 1611571208564058636, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058641, '532925', '弥渡县', 3, 1611571208564058636, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058642, '532926', '南涧彝族自治县', 3, 1611571208564058636, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058643, '532927', '巍山彝族回族自治县', 3, 1611571208564058636, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058644, '532928', '永平县', 3, 1611571208564058636, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058645, '532929', '云龙县', 3, 1611571208564058636, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058646, '532930', '洱源县', 3, 1611571208564058636, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058647, '532931', '剑川县', 3, 1611571208564058636, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058648, '532932', '鹤庆县', 3, 1611571208564058636, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058649, '5331', '德宏傣族景颇族自治州', 2, 1611571208564058511, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058650, '533102', '瑞丽市', 3, 1611571208564058649, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058651, '533103', '芒市', 3, 1611571208564058649, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058652, '533122', '梁河县', 3, 1611571208564058649, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058653, '533123', '盈江县', 3, 1611571208564058649, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058654, '533124', '陇川县', 3, 1611571208564058649, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058655, '5333', '怒江傈僳族自治州', 2, 1611571208564058511, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058656, '533321', '泸水县', 3, 1611571208564058655, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058657, '533323', '福贡县', 3, 1611571208564058655, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058658, '533324', '贡山独龙族怒族自治县', 3, 1611571208564058655, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058659, '533325', '兰坪白族普米族自治县', 3, 1611571208564058655, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058660, '5334', '迪庆藏族自治州', 2, 1611571208564058511, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058661, '533421', '香格里拉县', 3, 1611571208564058660, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058662, '533422', '德钦县', 3, 1611571208564058660, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058663, '533423', '维西傈僳族自治县', 3, 1611571208564058660, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058664, '54', '西藏', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058665, '5401', '拉萨市', 2, 1611571208564058664, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058666, '540101', '市辖区', 3, 1611571208564058665, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058667, '540102', '城关区', 3, 1611571208564058665, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058668, '540121', '林周县', 3, 1611571208564058665, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058669, '540122', '当雄县', 3, 1611571208564058665, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058670, '540123', '尼木县', 3, 1611571208564058665, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058671, '540124', '曲水县', 3, 1611571208564058665, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058672, '540125', '堆龙德庆县', 3, 1611571208564058665, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058673, '540126', '达孜县', 3, 1611571208564058665, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058674, '540127', '墨竹工卡县', 3, 1611571208564058665, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058675, '5421', '昌都地区', 2, 1611571208564058664, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058676, '542121', '昌都县', 3, 1611571208564058675, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058677, '542122', '江达县', 3, 1611571208564058675, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058678, '542123', '贡觉县', 3, 1611571208564058675, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058679, '542124', '类乌齐县', 3, 1611571208564058675, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058680, '542125', '丁青县', 3, 1611571208564058675, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058681, '542126', '察雅县', 3, 1611571208564058675, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058682, '542127', '八宿县', 3, 1611571208564058675, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058683, '542128', '左贡县', 3, 1611571208564058675, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058684, '542129', '芒康县', 3, 1611571208564058675, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058685, '542132', '洛隆县', 3, 1611571208564058675, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058686, '542133', '边坝县', 3, 1611571208564058675, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058687, '5422', '山南地区', 2, 1611571208564058664, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058688, '542221', '乃东县', 3, 1611571208564058687, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058689, '542222', '扎囊县', 3, 1611571208564058687, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058690, '542223', '贡嘎县', 3, 1611571208564058687, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058691, '542224', '桑日县', 3, 1611571208564058687, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058692, '542225', '琼结县', 3, 1611571208564058687, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058693, '542226', '曲松县', 3, 1611571208564058687, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058694, '542227', '措美县', 3, 1611571208564058687, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058695, '542228', '洛扎县', 3, 1611571208564058687, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058696, '542229', '加查县', 3, 1611571208564058687, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058697, '542231', '隆子县', 3, 1611571208564058687, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058698, '542232', '错那县', 3, 1611571208564058687, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058699, '542233', '浪卡子县', 3, 1611571208564058687, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058700, '5423', '日喀则地区', 2, 1611571208564058664, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058701, '542301', '日喀则市', 3, 1611571208564058700, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058702, '542322', '南木林县', 3, 1611571208564058700, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058703, '542323', '江孜县', 3, 1611571208564058700, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058704, '542324', '定日县', 3, 1611571208564058700, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058705, '542325', '萨迦县', 3, 1611571208564058700, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058706, '542326', '拉孜县', 3, 1611571208564058700, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058707, '542327', '昂仁县', 3, 1611571208564058700, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058708, '542328', '谢通门县', 3, 1611571208564058700, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058709, '542329', '白朗县', 3, 1611571208564058700, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058710, '542330', '仁布县', 3, 1611571208564058700, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058711, '542331', '康马县', 3, 1611571208564058700, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058712, '542332', '定结县', 3, 1611571208564058700, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058713, '542333', '仲巴县', 3, 1611571208564058700, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058714, '542334', '亚东县', 3, 1611571208564058700, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058715, '542335', '吉隆县', 3, 1611571208564058700, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058716, '542336', '聂拉木县', 3, 1611571208564058700, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058717, '542337', '萨嘎县', 3, 1611571208564058700, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058718, '542338', '岗巴县', 3, 1611571208564058700, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058719, '5424', '那曲地区', 2, 1611571208564058664, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058720, '542421', '那曲县', 3, 1611571208564058719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058721, '542422', '嘉黎县', 3, 1611571208564058719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058722, '542423', '比如县', 3, 1611571208564058719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058723, '542424', '聂荣县', 3, 1611571208564058719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058724, '542425', '安多县', 3, 1611571208564058719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058725, '542426', '申扎县', 3, 1611571208564058719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058726, '542427', '索县', 3, 1611571208564058719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058727, '542428', '班戈县', 3, 1611571208564058719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058728, '542429', '巴青县', 3, 1611571208564058719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058729, '542430', '尼玛县', 3, 1611571208564058719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058730, '5425', '阿里地区', 2, 1611571208564058664, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058731, '542521', '普兰县', 3, 1611571208564058730, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058732, '542522', '札达县', 3, 1611571208564058730, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058733, '542523', '噶尔县', 3, 1611571208564058730, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058734, '542524', '日土县', 3, 1611571208564058730, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058735, '542525', '革吉县', 3, 1611571208564058730, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058736, '542526', '改则县', 3, 1611571208564058730, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058737, '542527', '措勤县', 3, 1611571208564058730, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058738, '5426', '林芝地区', 2, 1611571208564058664, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058739, '542621', '林芝县', 3, 1611571208564058738, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058740, '542622', '工布江达县', 3, 1611571208564058738, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058741, '542623', '米林县', 3, 1611571208564058738, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058742, '542624', '墨脱县', 3, 1611571208564058738, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058743, '542625', '波密县', 3, 1611571208564058738, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058744, '542626', '察隅县', 3, 1611571208564058738, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058745, '542627', '朗县', 3, 1611571208564058738, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058746, '61', '陕西', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058747, '6101', '西安市', 2, 1611571208564058746, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058748, '610101', '市辖区', 3, 1611571208564058747, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058749, '610102', '新城区', 3, 1611571208564058747, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058750, '610103', '碑林区', 3, 1611571208564058747, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058751, '610104', '莲湖区', 3, 1611571208564058747, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058752, '610111', '灞桥区', 3, 1611571208564058747, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058753, '610112', '未央区', 3, 1611571208564058747, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058754, '610113', '雁塔区', 3, 1611571208564058747, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058755, '610114', '阎良区', 3, 1611571208564058747, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058756, '610115', '临潼区', 3, 1611571208564058747, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058757, '610116', '长安区', 3, 1611571208564058747, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058758, '610122', '蓝田县', 3, 1611571208564058747, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058759, '610124', '周至县', 3, 1611571208564058747, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058760, '610125', '户县', 3, 1611571208564058747, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058761, '610126', '高陵县', 3, 1611571208564058747, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058762, '6102', '铜川市', 2, 1611571208564058746, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058763, '610201', '市辖区', 3, 1611571208564058762, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058764, '610202', '王益区', 3, 1611571208564058762, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058765, '610203', '印台区', 3, 1611571208564058762, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058766, '610204', '耀州区', 3, 1611571208564058762, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058767, '610222', '宜君县', 3, 1611571208564058762, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058768, '6103', '宝鸡市', 2, 1611571208564058746, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058769, '610301', '市辖区', 3, 1611571208564058768, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058770, '610302', '渭滨区', 3, 1611571208564058768, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058771, '610303', '金台区', 3, 1611571208564058768, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058772, '610304', '陈仓区', 3, 1611571208564058768, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058773, '610322', '凤翔县', 3, 1611571208564058768, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058774, '610323', '岐山县', 3, 1611571208564058768, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058775, '610324', '扶风县', 3, 1611571208564058768, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058776, '610326', '眉县', 3, 1611571208564058768, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058777, '610327', '陇县', 3, 1611571208564058768, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058778, '610328', '千阳县', 3, 1611571208564058768, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058779, '610329', '麟游县', 3, 1611571208564058768, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058780, '610330', '凤县', 3, 1611571208564058768, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058781, '610331', '太白县', 3, 1611571208564058768, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058782, '6104', '咸阳市', 2, 1611571208564058746, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058783, '610401', '市辖区', 3, 1611571208564058782, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058784, '610402', '秦都区', 3, 1611571208564058782, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058785, '610403', '杨陵区', 3, 1611571208564058782, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058786, '610404', '渭城区', 3, 1611571208564058782, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058787, '610422', '三原县', 3, 1611571208564058782, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058788, '610423', '泾阳县', 3, 1611571208564058782, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058789, '610424', '乾县', 3, 1611571208564058782, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058790, '610425', '礼泉县', 3, 1611571208564058782, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058791, '610426', '永寿县', 3, 1611571208564058782, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058792, '610427', '彬县', 3, 1611571208564058782, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058793, '610428', '长武县', 3, 1611571208564058782, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058794, '610429', '旬邑县', 3, 1611571208564058782, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058795, '610430', '淳化县', 3, 1611571208564058782, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058796, '610431', '武功县', 3, 1611571208564058782, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058797, '610481', '兴平市', 3, 1611571208564058782, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058798, '6105', '渭南市', 2, 1611571208564058746, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058799, '610501', '市辖区', 3, 1611571208564058798, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058800, '610502', '临渭区', 3, 1611571208564058798, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058801, '610521', '华县', 3, 1611571208564058798, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058802, '610522', '潼关县', 3, 1611571208564058798, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058803, '610523', '大荔县', 3, 1611571208564058798, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058804, '610524', '合阳县', 3, 1611571208564058798, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058805, '610525', '澄城县', 3, 1611571208564058798, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058806, '610526', '蒲城县', 3, 1611571208564058798, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058807, '610527', '白水县', 3, 1611571208564058798, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058808, '610528', '富平县', 3, 1611571208564058798, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058809, '610581', '韩城市', 3, 1611571208564058798, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058810, '610582', '华阴市', 3, 1611571208564058798, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058811, '6106', '延安市', 2, 1611571208564058746, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058812, '610601', '市辖区', 3, 1611571208564058811, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058813, '610602', '宝塔区', 3, 1611571208564058811, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058814, '610621', '延长县', 3, 1611571208564058811, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058815, '610622', '延川县', 3, 1611571208564058811, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058816, '610623', '子长县', 3, 1611571208564058811, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058817, '610624', '安塞县', 3, 1611571208564058811, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058818, '610625', '志丹县', 3, 1611571208564058811, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058819, '610626', '吴起县', 3, 1611571208564058811, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058820, '610627', '甘泉县', 3, 1611571208564058811, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058821, '610628', '富县', 3, 1611571208564058811, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058822, '610629', '洛川县', 3, 1611571208564058811, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058823, '610630', '宜川县', 3, 1611571208564058811, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058824, '610631', '黄龙县', 3, 1611571208564058811, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058825, '610632', '黄陵县', 3, 1611571208564058811, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058826, '6107', '汉中市', 2, 1611571208564058746, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058827, '610701', '市辖区', 3, 1611571208564058826, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058828, '610702', '汉台区', 3, 1611571208564058826, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058829, '610721', '南郑县', 3, 1611571208564058826, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058830, '610722', '城固县', 3, 1611571208564058826, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058831, '610723', '洋县', 3, 1611571208564058826, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058832, '610724', '西乡县', 3, 1611571208564058826, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058833, '610725', '勉县', 3, 1611571208564058826, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058834, '610726', '宁强县', 3, 1611571208564058826, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058835, '610727', '略阳县', 3, 1611571208564058826, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058836, '610728', '镇巴县', 3, 1611571208564058826, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058837, '610729', '留坝县', 3, 1611571208564058826, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058838, '610730', '佛坪县', 3, 1611571208564058826, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058839, '6108', '榆林市', 2, 1611571208564058746, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058840, '610801', '市辖区', 3, 1611571208564058839, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058841, '610802', '榆阳区', 3, 1611571208564058839, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058842, '610821', '神木县', 3, 1611571208564058839, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058843, '610822', '府谷县', 3, 1611571208564058839, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058844, '610823', '横山县', 3, 1611571208564058839, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058845, '610824', '靖边县', 3, 1611571208564058839, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058846, '610825', '定边县', 3, 1611571208564058839, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058847, '610826', '绥德县', 3, 1611571208564058839, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058848, '610827', '米脂县', 3, 1611571208564058839, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058849, '610828', '佳县', 3, 1611571208564058839, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058850, '610829', '吴堡县', 3, 1611571208564058839, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058851, '610830', '清涧县', 3, 1611571208564058839, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058852, '610831', '子洲县', 3, 1611571208564058839, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058853, '6109', '安康市', 2, 1611571208564058746, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058854, '610901', '市辖区', 3, 1611571208564058853, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058855, '610902', '汉滨区', 3, 1611571208564058853, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058856, '610921', '汉阴县', 3, 1611571208564058853, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058857, '610922', '石泉县', 3, 1611571208564058853, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058858, '610923', '宁陕县', 3, 1611571208564058853, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058859, '610924', '紫阳县', 3, 1611571208564058853, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058860, '610925', '岚皋县', 3, 1611571208564058853, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058861, '610926', '平利县', 3, 1611571208564058853, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058862, '610927', '镇坪县', 3, 1611571208564058853, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058863, '610928', '旬阳县', 3, 1611571208564058853, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058864, '610929', '白河县', 3, 1611571208564058853, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058865, '6110', '商洛市', 2, 1611571208564058746, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058866, '611001', '市辖区', 3, 1611571208564058865, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058867, '611002', '商州区', 3, 1611571208564058865, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058868, '611021', '洛南县', 3, 1611571208564058865, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058869, '611022', '丹凤县', 3, 1611571208564058865, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058870, '611023', '商南县', 3, 1611571208564058865, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058871, '611024', '山阳县', 3, 1611571208564058865, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058872, '611025', '镇安县', 3, 1611571208564058865, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058873, '611026', '柞水县', 3, 1611571208564058865, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058874, '62', '甘肃', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058875, '6201', '兰州市', 2, 1611571208564058874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058876, '620101', '市辖区', 3, 1611571208564058875, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058877, '620102', '城关区', 3, 1611571208564058875, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058878, '620103', '七里河区', 3, 1611571208564058875, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058879, '620104', '西固区', 3, 1611571208564058875, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058880, '620105', '安宁区', 3, 1611571208564058875, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058881, '620111', '红古区', 3, 1611571208564058875, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058882, '620121', '永登县', 3, 1611571208564058875, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058883, '620122', '皋兰县', 3, 1611571208564058875, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058884, '620123', '榆中县', 3, 1611571208564058875, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058885, '6202', '嘉峪关市', 2, 1611571208564058874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058886, '620201', '市辖区', 3, 1611571208564058885, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058887, '6203', '金昌市', 2, 1611571208564058874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058888, '620301', '市辖区', 3, 1611571208564058887, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058889, '620302', '金川区', 3, 1611571208564058887, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058890, '620321', '永昌县', 3, 1611571208564058887, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058891, '6204', '白银市', 2, 1611571208564058874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058892, '620401', '市辖区', 3, 1611571208564058891, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058893, '620402', '白银区', 3, 1611571208564058891, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058894, '620403', '平川区', 3, 1611571208564058891, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058895, '620421', '靖远县', 3, 1611571208564058891, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058896, '620422', '会宁县', 3, 1611571208564058891, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058897, '620423', '景泰县', 3, 1611571208564058891, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058898, '6205', '天水市', 2, 1611571208564058874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058899, '620501', '市辖区', 3, 1611571208564058898, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058900, '620502', '秦州区', 3, 1611571208564058898, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058901, '620503', '麦积区', 3, 1611571208564058898, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058902, '620521', '清水县', 3, 1611571208564058898, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058903, '620522', '秦安县', 3, 1611571208564058898, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058904, '620523', '甘谷县', 3, 1611571208564058898, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058905, '620524', '武山县', 3, 1611571208564058898, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058906, '620525', '张家川回族自治县', 3, 1611571208564058898, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058907, '6206', '武威市', 2, 1611571208564058874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058908, '620601', '市辖区', 3, 1611571208564058907, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058909, '620602', '凉州区', 3, 1611571208564058907, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058910, '620621', '民勤县', 3, 1611571208564058907, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058911, '620622', '古浪县', 3, 1611571208564058907, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058912, '620623', '天祝藏族自治县', 3, 1611571208564058907, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058913, '6207', '张掖市', 2, 1611571208564058874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058914, '620701', '市辖区', 3, 1611571208564058913, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058915, '620702', '甘州区', 3, 1611571208564058913, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058916, '620721', '肃南裕固族自治县', 3, 1611571208564058913, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058917, '620722', '民乐县', 3, 1611571208564058913, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058918, '620723', '临泽县', 3, 1611571208564058913, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058919, '620724', '高台县', 3, 1611571208564058913, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058920, '620725', '山丹县', 3, 1611571208564058913, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058921, '6208', '平凉市', 2, 1611571208564058874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058922, '620801', '市辖区', 3, 1611571208564058921, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058923, '620802', '崆峒区', 3, 1611571208564058921, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058924, '620821', '泾川县', 3, 1611571208564058921, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058925, '620822', '灵台县', 3, 1611571208564058921, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058926, '620823', '崇信县', 3, 1611571208564058921, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058927, '620824', '华亭县', 3, 1611571208564058921, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058928, '620825', '庄浪县', 3, 1611571208564058921, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058929, '620826', '静宁县', 3, 1611571208564058921, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058930, '6209', '酒泉市', 2, 1611571208564058874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058931, '620901', '市辖区', 3, 1611571208564058930, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058932, '620902', '肃州区', 3, 1611571208564058930, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058933, '620921', '金塔县', 3, 1611571208564058930, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058934, '620922', '瓜州县', 3, 1611571208564058930, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058935, '620923', '肃北蒙古族自治县', 3, 1611571208564058930, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058936, '620924', '阿克塞哈萨克族自治县', 3, 1611571208564058930, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058937, '620981', '玉门市', 3, 1611571208564058930, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058938, '620982', '敦煌市', 3, 1611571208564058930, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058939, '6210', '庆阳市', 2, 1611571208564058874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058940, '621001', '市辖区', 3, 1611571208564058939, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058941, '621002', '西峰区', 3, 1611571208564058939, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058942, '621021', '庆城县', 3, 1611571208564058939, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058943, '621022', '环县', 3, 1611571208564058939, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058944, '621023', '华池县', 3, 1611571208564058939, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058945, '621024', '合水县', 3, 1611571208564058939, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058946, '621025', '正宁县', 3, 1611571208564058939, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058947, '621026', '宁县', 3, 1611571208564058939, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058948, '621027', '镇原县', 3, 1611571208564058939, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058949, '6211', '定西市', 2, 1611571208564058874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058950, '621101', '市辖区', 3, 1611571208564058949, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058951, '621102', '安定区', 3, 1611571208564058949, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058952, '621121', '通渭县', 3, 1611571208564058949, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058953, '621122', '陇西县', 3, 1611571208564058949, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058954, '621123', '渭源县', 3, 1611571208564058949, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058955, '621124', '临洮县', 3, 1611571208564058949, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058956, '621125', '漳县', 3, 1611571208564058949, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058957, '621126', '岷县', 3, 1611571208564058949, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058958, '6212', '陇南市', 2, 1611571208564058874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058959, '621201', '市辖区', 3, 1611571208564058958, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058960, '621202', '武都区', 3, 1611571208564058958, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058961, '621221', '成县', 3, 1611571208564058958, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058962, '621222', '文县', 3, 1611571208564058958, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058963, '621223', '宕昌县', 3, 1611571208564058958, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058964, '621224', '康县', 3, 1611571208564058958, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058965, '621225', '西和县', 3, 1611571208564058958, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058966, '621226', '礼县', 3, 1611571208564058958, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058967, '621227', '徽县', 3, 1611571208564058958, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058968, '621228', '两当县', 3, 1611571208564058958, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058969, '6229', '临夏回族自治州', 2, 1611571208564058874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058970, '622901', '临夏市', 3, 1611571208564058969, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058971, '622921', '临夏县', 3, 1611571208564058969, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058972, '622922', '康乐县', 3, 1611571208564058969, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058973, '622923', '永靖县', 3, 1611571208564058969, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058974, '622924', '广河县', 3, 1611571208564058969, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058975, '622925', '和政县', 3, 1611571208564058969, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058976, '622926', '东乡族自治县', 3, 1611571208564058969, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058977, '622927', '积石山保安族东乡族撒拉族自治县', 3, 1611571208564058969, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058978, '6230', '甘南藏族自治州', 2, 1611571208564058874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058979, '623001', '合作市', 3, 1611571208564058978, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058980, '623021', '临潭县', 3, 1611571208564058978, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058981, '623022', '卓尼县', 3, 1611571208564058978, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058982, '623023', '舟曲县', 3, 1611571208564058978, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058983, '623024', '迭部县', 3, 1611571208564058978, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058984, '623025', '玛曲县', 3, 1611571208564058978, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058985, '623026', '碌曲县', 3, 1611571208564058978, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058986, '623027', '夏河县', 3, 1611571208564058978, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058987, '63', '青海', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058988, '6301', '西宁市', 2, 1611571208564058987, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058989, '630101', '市辖区', 3, 1611571208564058988, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058990, '630102', '城东区', 3, 1611571208564058988, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058991, '630103', '城中区', 3, 1611571208564058988, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058992, '630104', '城西区', 3, 1611571208564058988, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058993, '630105', '城北区', 3, 1611571208564058988, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058994, '630121', '大通回族土族自治县', 3, 1611571208564058988, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058995, '630122', '湟中县', 3, 1611571208564058988, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058996, '630123', '湟源县', 3, 1611571208564058988, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058997, '6321', '海东地区', 2, 1611571208564058987, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058998, '632121', '平安县', 3, 1611571208564058997, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564058999, '632122', '民和回族土族自治县', 3, 1611571208564058997, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059000, '632123', '乐都县', 3, 1611571208564058997, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059001, '632126', '互助土族自治县', 3, 1611571208564058997, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059002, '632127', '化隆回族自治县', 3, 1611571208564058997, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059003, '632128', '循化撒拉族自治县', 3, 1611571208564058997, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059004, '6322', '海北藏族自治州', 2, 1611571208564058987, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059005, '632221', '门源回族自治县', 3, 1611571208564059004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059006, '632222', '祁连县', 3, 1611571208564059004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059007, '632223', '海晏县', 3, 1611571208564059004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059008, '632224', '刚察县', 3, 1611571208564059004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059009, '6323', '黄南藏族自治州', 2, 1611571208564058987, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059010, '632321', '同仁县', 3, 1611571208564059009, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059011, '632322', '尖扎县', 3, 1611571208564059009, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059012, '632323', '泽库县', 3, 1611571208564059009, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059013, '632324', '河南蒙古族自治县', 3, 1611571208564059009, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059014, '6325', '海南藏族自治州', 2, 1611571208564058987, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059015, '632521', '共和县', 3, 1611571208564059014, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059016, '632522', '同德县', 3, 1611571208564059014, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059017, '632523', '贵德县', 3, 1611571208564059014, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059018, '632524', '兴海县', 3, 1611571208564059014, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059019, '632525', '贵南县', 3, 1611571208564059014, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059020, '6326', '果洛藏族自治州', 2, 1611571208564058987, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059021, '632621', '玛沁县', 3, 1611571208564059020, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059022, '632622', '班玛县', 3, 1611571208564059020, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059023, '632623', '甘德县', 3, 1611571208564059020, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059024, '632624', '达日县', 3, 1611571208564059020, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059025, '632625', '久治县', 3, 1611571208564059020, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059026, '632626', '玛多县', 3, 1611571208564059020, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059027, '6327', '玉树藏族自治州', 2, 1611571208564058987, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059028, '632721', '玉树县', 3, 1611571208564059027, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059029, '632722', '杂多县', 3, 1611571208564059027, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059030, '632723', '称多县', 3, 1611571208564059027, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059031, '632724', '治多县', 3, 1611571208564059027, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059032, '632725', '囊谦县', 3, 1611571208564059027, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059033, '632726', '曲麻莱县', 3, 1611571208564059027, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059034, '6328', '海西蒙古族藏族自治州', 2, 1611571208564058987, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059035, '632801', '格尔木市', 3, 1611571208564059034, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059036, '632802', '德令哈市', 3, 1611571208564059034, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059037, '632821', '乌兰县', 3, 1611571208564059034, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059038, '632822', '都兰县', 3, 1611571208564059034, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059039, '632823', '天峻县', 3, 1611571208564059034, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059040, '64', '宁夏', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059041, '6401', '银川市', 2, 1611571208564059040, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059042, '640101', '市辖区', 3, 1611571208564059041, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059043, '640104', '兴庆区', 3, 1611571208564059041, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059044, '640105', '西夏区', 3, 1611571208564059041, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059045, '640106', '金凤区', 3, 1611571208564059041, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059046, '640121', '永宁县', 3, 1611571208564059041, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059047, '640122', '贺兰县', 3, 1611571208564059041, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059048, '640181', '灵武市', 3, 1611571208564059041, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059049, '6402', '石嘴山市', 2, 1611571208564059040, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059050, '640201', '市辖区', 3, 1611571208564059049, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059051, '640202', '大武口区', 3, 1611571208564059049, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059052, '640205', '惠农区', 3, 1611571208564059049, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059053, '640221', '平罗县', 3, 1611571208564059049, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059054, '6403', '吴忠市', 2, 1611571208564059040, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059055, '640301', '市辖区', 3, 1611571208564059054, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059056, '640302', '利通区', 3, 1611571208564059054, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059057, '640303', '红寺堡区', 3, 1611571208564059054, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059058, '640323', '盐池县', 3, 1611571208564059054, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059059, '640324', '同心县', 3, 1611571208564059054, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059060, '640381', '青铜峡市', 3, 1611571208564059054, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059061, '6404', '固原市', 2, 1611571208564059040, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059062, '640401', '市辖区', 3, 1611571208564059061, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059063, '640402', '原州区', 3, 1611571208564059061, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059064, '640422', '西吉县', 3, 1611571208564059061, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059065, '640423', '隆德县', 3, 1611571208564059061, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059066, '640424', '泾源县', 3, 1611571208564059061, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059067, '640425', '彭阳县', 3, 1611571208564059061, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059068, '6405', '中卫市', 2, 1611571208564059040, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059069, '640501', '市辖区', 3, 1611571208564059068, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059070, '640502', '沙坡头区', 3, 1611571208564059068, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059071, '640521', '中宁县', 3, 1611571208564059068, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059072, '640522', '海原县', 3, 1611571208564059068, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059073, '65', '新疆', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059074, '6501', '乌鲁木齐市', 2, 1611571208564059073, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059075, '650101', '市辖区', 3, 1611571208564059074, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059076, '650102', '天山区', 3, 1611571208564059074, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059077, '650103', '沙依巴克区', 3, 1611571208564059074, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059078, '650104', '新市区', 3, 1611571208564059074, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059079, '650105', '水磨沟区', 3, 1611571208564059074, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059080, '650106', '头屯河区', 3, 1611571208564059074, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059081, '650107', '达坂城区', 3, 1611571208564059074, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059082, '650109', '米东区', 3, 1611571208564059074, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059083, '650121', '乌鲁木齐县', 3, 1611571208564059074, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059084, '6502', '克拉玛依市', 2, 1611571208564059073, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059085, '650201', '市辖区', 3, 1611571208564059084, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059086, '650202', '独山子区', 3, 1611571208564059084, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059087, '650203', '克拉玛依区', 3, 1611571208564059084, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059088, '650204', '白碱滩区', 3, 1611571208564059084, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059089, '650205', '乌尔禾区', 3, 1611571208564059084, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059090, '6521', '吐鲁番地区', 2, 1611571208564059073, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059091, '652101', '吐鲁番市', 3, 1611571208564059090, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059092, '652122', '鄯善县', 3, 1611571208564059090, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059093, '652123', '托克逊县', 3, 1611571208564059090, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059094, '6522', '哈密地区', 2, 1611571208564059073, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059095, '652201', '哈密市', 3, 1611571208564059094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059096, '652222', '巴里坤哈萨克自治县', 3, 1611571208564059094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059097, '652223', '伊吾县', 3, 1611571208564059094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059098, '6523', '昌吉回族自治州', 2, 1611571208564059073, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059099, '652301', '昌吉市', 3, 1611571208564059098, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059100, '652302', '阜康市', 3, 1611571208564059098, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059101, '652323', '呼图壁县', 3, 1611571208564059098, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059102, '652324', '玛纳斯县', 3, 1611571208564059098, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059103, '652325', '奇台县', 3, 1611571208564059098, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059104, '652327', '吉木萨尔县', 3, 1611571208564059098, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059105, '652328', '木垒哈萨克自治县', 3, 1611571208564059098, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059106, '6527', '博尔塔拉蒙古自治州', 2, 1611571208564059073, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059107, '652701', '博乐市', 3, 1611571208564059106, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059108, '652722', '精河县', 3, 1611571208564059106, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059109, '652723', '温泉县', 3, 1611571208564059106, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059110, '6528', '巴音郭楞蒙古自治州', 2, 1611571208564059073, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059111, '652801', '库尔勒市', 3, 1611571208564059110, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059112, '652822', '轮台县', 3, 1611571208564059110, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059113, '652823', '尉犁县', 3, 1611571208564059110, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059114, '652824', '若羌县', 3, 1611571208564059110, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059115, '652825', '且末县', 3, 1611571208564059110, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059116, '652826', '焉耆回族自治县', 3, 1611571208564059110, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059117, '652827', '和静县', 3, 1611571208564059110, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059118, '652828', '和硕县', 3, 1611571208564059110, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059119, '652829', '博湖县', 3, 1611571208564059110, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059120, '6529', '阿克苏地区', 2, 1611571208564059073, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059121, '652901', '阿克苏市', 3, 1611571208564059120, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059122, '652922', '温宿县', 3, 1611571208564059120, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059123, '652923', '库车县', 3, 1611571208564059120, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059124, '652924', '沙雅县', 3, 1611571208564059120, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059125, '652925', '新和县', 3, 1611571208564059120, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059126, '652926', '拜城县', 3, 1611571208564059120, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059127, '652927', '乌什县', 3, 1611571208564059120, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059128, '652928', '阿瓦提县', 3, 1611571208564059120, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059129, '652929', '柯坪县', 3, 1611571208564059120, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059130, '6530', '克孜勒苏柯尔克孜自治州', 2, 1611571208564059073, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059131, '653001', '阿图什市', 3, 1611571208564059130, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059132, '653022', '阿克陶县', 3, 1611571208564059130, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059133, '653023', '阿合奇县', 3, 1611571208564059130, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059134, '653024', '乌恰县', 3, 1611571208564059130, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059135, '6531', '喀什地区', 2, 1611571208564059073, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059136, '653101', '喀什市', 3, 1611571208564059135, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059137, '653121', '疏附县', 3, 1611571208564059135, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059138, '653122', '疏勒县', 3, 1611571208564059135, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059139, '653123', '英吉沙县', 3, 1611571208564059135, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059140, '653124', '泽普县', 3, 1611571208564059135, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059141, '653125', '莎车县', 3, 1611571208564059135, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059142, '653126', '叶城县', 3, 1611571208564059135, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059143, '653127', '麦盖提县', 3, 1611571208564059135, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059144, '653128', '岳普湖县', 3, 1611571208564059135, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059145, '653129', '伽师县', 3, 1611571208564059135, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059146, '653130', '巴楚县', 3, 1611571208564059135, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059147, '653131', '塔什库尔干塔吉克自治县', 3, 1611571208564059135, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059148, '6532', '和田地区', 2, 1611571208564059073, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059149, '653201', '和田市', 3, 1611571208564059148, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059150, '653221', '和田县', 3, 1611571208564059148, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059151, '653222', '墨玉县', 3, 1611571208564059148, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059152, '653223', '皮山县', 3, 1611571208564059148, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059153, '653224', '洛浦县', 3, 1611571208564059148, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059154, '653225', '策勒县', 3, 1611571208564059148, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059155, '653226', '于田县', 3, 1611571208564059148, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059156, '653227', '民丰县', 3, 1611571208564059148, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059157, '6540', '伊犁哈萨克自治州', 2, 1611571208564059073, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059158, '654002', '伊宁市', 3, 1611571208564059157, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059159, '654003', '奎屯市', 3, 1611571208564059157, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059160, '654021', '伊宁县', 3, 1611571208564059157, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059161, '654022', '察布查尔锡伯自治县', 3, 1611571208564059157, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059162, '654023', '霍城县', 3, 1611571208564059157, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059163, '654024', '巩留县', 3, 1611571208564059157, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059164, '654025', '新源县', 3, 1611571208564059157, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059165, '654026', '昭苏县', 3, 1611571208564059157, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059166, '654027', '特克斯县', 3, 1611571208564059157, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059167, '654028', '尼勒克县', 3, 1611571208564059157, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059168, '6542', '塔城地区', 2, 1611571208564059073, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059169, '654201', '塔城市', 3, 1611571208564059168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059170, '654202', '乌苏市', 3, 1611571208564059168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059171, '654221', '额敏县', 3, 1611571208564059168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059172, '654223', '沙湾县', 3, 1611571208564059168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059173, '654224', '托里县', 3, 1611571208564059168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059174, '654225', '裕民县', 3, 1611571208564059168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059175, '654226', '和布克赛尔蒙古自治县', 3, 1611571208564059168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059176, '6543', '阿勒泰地区', 2, 1611571208564059073, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059177, '654301', '阿勒泰市', 3, 1611571208564059176, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059178, '654321', '布尔津县', 3, 1611571208564059176, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059179, '654322', '富蕴县', 3, 1611571208564059176, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059180, '654323', '福海县', 3, 1611571208564059176, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059181, '654324', '哈巴河县', 3, 1611571208564059176, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059182, '654325', '青河县', 3, 1611571208564059176, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059183, '654326', '吉木乃县', 3, 1611571208564059176, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059184, '6590', '自治区直辖县级行政区划', 2, 1611571208564059073, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059185, '659001', '石河子市', 3, 1611571208564059184, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059186, '659002', '阿拉尔市', 3, 1611571208564059184, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059187, '659003', '图木舒克市', 3, 1611571208564059184, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `incloud_base_mdm_area` VALUES (1611571208564059188, '659004', '五家渠市', 3, 1611571208564059184, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for incloud_base_mdm_biz_resource
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_mdm_biz_resource`;
CREATE TABLE `incloud_base_mdm_biz_resource`  (
  `id` bigint NOT NULL COMMENT '主键',
  `resource_code` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '资源编码',
  `resource_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '资源名称',
  `resource_url` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '资源url',
  `resource_type` int NULL DEFAULT NULL COMMENT '资源类型',
  `icon` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '图标',
  `sort` int NULL DEFAULT NULL COMMENT '排序',
  `description` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '描述',
  `parent_id` bigint NOT NULL COMMENT '父级ID',
  `open_way` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '打开方式',
  `status` int NOT NULL DEFAULT 1 COMMENT '状态',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  `view_id` bigint NULL DEFAULT NULL COMMENT '视图ID',
  `view_code` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '视图Code',
  `app_id` bigint NOT NULL COMMENT 'AppId',
  `app_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT 'AppName',
  `app_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT 'AppCode',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '业务端资源' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_mdm_biz_resource
-- ----------------------------
INSERT INTO `incloud_base_mdm_biz_resource` VALUES (1688812152852492290, 'todo', '我的待办', '/web-wf/html/todo.html', 4, NULL, 0, '我的待办', 0, NULL, 1, '2023-08-08 15:19:29', '2023-08-08 15:19:29', 1, 'admin', 0, 'root', '0', NULL, NULL, 1688812003631738882, '任务中心', NULL);
INSERT INTO `incloud_base_mdm_biz_resource` VALUES (1688812226382835713, 'draft', '我的草稿', '/web-wf/html/draft.html', 4, NULL, 3, '', 0, NULL, 1, '2023-08-08 15:19:46', '2023-08-08 15:19:46', 1, 'admin', 0, 'root', '0', NULL, NULL, 1688812003631738882, '任务中心', NULL);
INSERT INTO `incloud_base_mdm_biz_resource` VALUES (1688812488619110402, 'havedone', '我的已办', '/web-wf/html/havedone.html', 4, NULL, 4, '', 0, NULL, 1, '2023-08-08 15:20:49', '2023-08-08 15:20:49', 1, 'admin', 0, 'root', '0', NULL, NULL, 1688812003631738882, '任务中心', NULL);
INSERT INTO `incloud_base_mdm_biz_resource` VALUES (1688812562069762050, 'flow-instance', '流程实例', '/web-wf/html/flow-instance.html', 4, NULL, 1, '', 0, NULL, 1, '2023-08-08 15:21:06', '2023-08-08 15:21:06', 1, 'admin', 0, 'root', '0', NULL, NULL, 1688812003631738882, '任务中心', NULL);
INSERT INTO `incloud_base_mdm_biz_resource` VALUES (1688812719830118402, 'all-news', '所有消息', '/web-wf/html/all-news.html', 4, NULL, 1, '', 0, NULL, 1, '2023-08-08 15:21:44', '2023-08-08 15:21:44', 1, 'admin', 0, 'root', '0', NULL, NULL, 1688812003631738882, '任务中心', NULL);
INSERT INTO `incloud_base_mdm_biz_resource` VALUES (1688812816156504066, 'my-news', '我的消息', '/web-wf/html/my-news.html', 4, NULL, 5, '', 0, NULL, 1, '2023-08-08 15:22:07', '2023-08-08 15:22:07', 1, 'admin', 0, 'root', '0', NULL, NULL, 1688812003631738882, '任务中心', NULL);
INSERT INTO `incloud_base_mdm_biz_resource` VALUES (1688813051222077442, 'outduplicate', '发出的传阅', '/web-wf/html/outduplicate.html', 4, NULL, 8, '', 0, NULL, 1, '2023-08-08 15:23:03', '2023-08-08 15:23:03', 1, 'admin', 0, 'root', '0', NULL, NULL, 1688812003631738882, '任务中心', NULL);
INSERT INTO `incloud_base_mdm_biz_resource` VALUES (1688813120176435201, 'InDuplicate', '收到的传阅', '/web-wf/html/induplicate.html', 4, NULL, 9, '', 0, NULL, 1, '2023-08-08 15:23:19', '2023-08-08 15:23:19', 1, 'admin', 0, 'root', '0', NULL, NULL, 1688812003631738882, '任务中心', NULL);

-- ----------------------------
-- Table structure for incloud_base_mdm_dept
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_mdm_dept`;
CREATE TABLE `incloud_base_mdm_dept`  (
  `dept_id` bigint NOT NULL AUTO_INCREMENT COMMENT '部门id',
  `parent_id` bigint NULL DEFAULT 0 COMMENT '父部门id',
  `ancestors` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '祖级列表',
  `dept_name` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '部门名称',
  `order_num` int NULL DEFAULT 0 COMMENT '显示顺序',
  `org_code` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '机构编码',
  `org_full_path` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '机构完整路径',
  `org_type` tinyint NULL DEFAULT NULL COMMENT '组织机构类型，1生产单位',
  `org_level` tinyint NULL DEFAULT NULL COMMENT '组织机构级别（0逻辑目录，1公司，2厂、处，3科、工区，4站，5班组）',
  `area_code` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '所属行政区域代码',
  `parent_code` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '父机构编码',
  `parent_codes` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '编码祖级列表',
  `status` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '0' COMMENT '部门状态（0正常 1停用）',
  `del_flag` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '0' COMMENT '删除标志（0代表存在 2代表删除）',
  `create_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `level2_code` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '处级编码',
  `level3_code` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '科级编码',
  `jiguan_flag` smallint NULL DEFAULT NULL COMMENT '是否为机关,0二级单位，1机关',
  PRIMARY KEY (`dept_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '部门表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_mdm_dept
-- ----------------------------

-- ----------------------------
-- Table structure for incloud_base_mdm_duty
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_mdm_duty`;
CREATE TABLE `incloud_base_mdm_duty`  (
  `id` bigint NOT NULL COMMENT '主键',
  `duty_code` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '职务编码',
  `duty_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '职务名称',
  `sort` int NOT NULL COMMENT '排序',
  `is_ref` int NOT NULL COMMENT '是否被引用',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  `org_full_id` varchar(4000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '父级组织全路径ID',
  `org_full_name` varchar(4000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '父级组织全路径名称',
  `status` int NOT NULL COMMENT '状态标识',
  `version` int NULL DEFAULT NULL COMMENT 'version',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  `org_id` bigint NULL DEFAULT NULL COMMENT '机构ID',
  `org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '机构名称',
  `institution_id` bigint NOT NULL COMMENT '机构ID',
  `institution_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '机构名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '职务' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_mdm_duty
-- ----------------------------

-- ----------------------------
-- Table structure for incloud_base_mdm_duty_user
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_mdm_duty_user`;
CREATE TABLE `incloud_base_mdm_duty_user`  (
  `id` bigint NOT NULL COMMENT '主键',
  `org_full_duty_id` varchar(4000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '组织全路径职务ID',
  `org_full_duty_name` varchar(4000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '组织全路径职务名称',
  `duty_id` bigint NOT NULL COMMENT '职务ID',
  `duty_code` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '职务code',
  `duty_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '职务名称',
  `user_id` bigint NOT NULL COMMENT '用户ID',
  `user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '用户名称',
  `user_name_ch` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '用户中文名称',
  `is_master` int NOT NULL COMMENT '是否主岗',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '职务与用户关系' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_mdm_duty_user
-- ----------------------------

-- ----------------------------
-- Table structure for incloud_base_mdm_duty_version
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_mdm_duty_version`;
CREATE TABLE `incloud_base_mdm_duty_version`  (
  `id` bigint NOT NULL COMMENT '主键',
  `is_main_version` int NULL DEFAULT NULL COMMENT '是否主版本',
  `version` int NULL DEFAULT NULL COMMENT 'version',
  `old_duty_id` bigint NULL DEFAULT NULL COMMENT '原职务Id',
  `duty_code` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '职务编码',
  `duty_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '职务名称',
  `sort` int NOT NULL COMMENT '排序',
  `is_ref` int NOT NULL COMMENT '是否被引用',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  `org_full_id` varchar(4000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '父级组织全路径ID',
  `org_full_name` varchar(4000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '父级组织全路径名称',
  `status` int NOT NULL COMMENT '状态标识',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  `org_id` bigint NULL DEFAULT NULL COMMENT '所属机构ID',
  `org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '所属机构名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '职务（历史表）' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_mdm_duty_version
-- ----------------------------

-- ----------------------------
-- Table structure for incloud_base_mdm_front_operate_log
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_mdm_front_operate_log`;
CREATE TABLE `incloud_base_mdm_front_operate_log`  (
  `id` bigint NOT NULL COMMENT '主键',
  `operate_type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '操作类型',
  `content` varchar(1024) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '操作内容',
  `user_ip` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT 'IP',
  `create_user_id` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '操作人',
  `create_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '操作人',
  `user_agent` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '浏览器类型',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '前端操作日志' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_mdm_front_operate_log
-- ----------------------------

-- ----------------------------
-- Table structure for incloud_base_mdm_hierarchy_org_user
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_mdm_hierarchy_org_user`;
CREATE TABLE `incloud_base_mdm_hierarchy_org_user`  (
  `id` bigint NOT NULL COMMENT '主键',
  `manage_org_id` bigint NOT NULL COMMENT '管理机构ID',
  `manage_org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '机构名称',
  `org_id` bigint NOT NULL COMMENT '机构ID',
  `org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '机构名称',
  `org_full_id` varchar(4000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '组织全路径ID',
  `org_full_name` varchar(4000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '组织全路径名称',
  `user_id` bigint NOT NULL COMMENT '用户Id',
  `user_name` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '用户名',
  `user_name_ch` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '用户中文姓名',
  `is_include_sub` int NOT NULL DEFAULT 0 COMMENT '是否包含下级',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '分级组织用户' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_mdm_hierarchy_org_user
-- ----------------------------

-- ----------------------------
-- Table structure for incloud_base_mdm_hierarchy_user
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_mdm_hierarchy_user`;
CREATE TABLE `incloud_base_mdm_hierarchy_user`  (
  `id` bigint NOT NULL COMMENT '主键',
  `org_id` bigint NOT NULL COMMENT '机构ID',
  `org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '机构名称',
  `org_full_id` varchar(4000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '组织全路径ID',
  `org_full_name` varchar(4000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '组织全路径名称',
  `user_id` bigint NOT NULL COMMENT '用户Id',
  `user_name` varchar(64) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '用户名',
  `user_name_ch` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '用户中文姓名',
  `is_include_sub` int NOT NULL DEFAULT 0 COMMENT '是否包含下级',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改日期',
  `create_user_id` bigint NULL DEFAULT NULL COMMENT '创建人ID',
  `create_user_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_user_org_id` bigint NULL DEFAULT NULL COMMENT '创建人父级机构ID',
  `create_user_org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级机构名称',
  `create_user_org_full_id` varchar(2000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '创建人父级组织全路径ID',
  `manage_org_id` bigint NOT NULL COMMENT '管理机构ID',
  `manage_org_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '机构名称',
  `app_id` bigint NOT NULL COMMENT 'AppId',
  `app_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT 'AppName',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = '分级用户' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_mdm_hierarchy_user
-- ----------------------------

-- ----------------------------
-- Table structure for incloud_base_mdm_openapi
-- ----------------------------
DROP TABLE IF EXISTS `incloud_base_mdm_openapi`;
CREATE TABLE `incloud_base_mdm_openapi`  (
  `id` bigint NOT NULL COMMENT '主键',
  `method` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '方法名',
  `operation_id` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL COMMENT '接口唯一Id',
  `summary` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '总结概要说明',
  `path` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '接口路径',
  `class_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '类名称',
  `contents` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL COMMENT '接口内容',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '接口类型',
  `route_id` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '接口路由ID',
  `service_code` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT 'serviceCode',
  `app_code` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT 'appCode',
  `biz_type` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '接口类型',
  `class_desc` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '类描述',
  `api_code` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT 'api编码',
  `method_name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '方法名称',
  `return_type` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL COMMENT '返回类型',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `operation_id`(`operation_id` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb3 COLLATE = utf8mb3_general_ci COMMENT = 'openApi接口列表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of incloud_base_mdm_openapi
-- ----------------------------
INSERT INTO `incloud_base_mdm_openapi` VALUES (1727631641141932033, 'POST', 'UE9TVCAvbWFpbi9tb2RlbGluZ0VudGl0eS9keW5hbWlj', '动态接口生成', '/main/modelingEntity/dynamic', 'ModelingEntityController', '{\"openapi\":\"3.0.1\",\"info\":{\"title\":\"主模块\",\"description\":\"主模块\",\"termsOfService\":\"http://www.netwisd.com\",\"license\":{\"name\":\"云数网讯\",\"url\":\"http://www.netwisd.com\"},\"version\":\"5.0\"},\"servers\":[{\"url\":\"http://192.168.10.58:8001\",\"description\":\"Generated server url\"}],\"tags\":[{\"name\":\"数据建模\",\"description\":\"数据建模Controller\"}],\"paths\":{\"/modelingEntity/dynamic\":{\"post\":{\"tags\":[\"数据建模\"],\"summary\":\"动态接口生成\",\"operationId\":\"09800818\",\"parameters\":[{\"name\":\"id\",\"in\":\"query\",\"required\":true,\"schema\":{\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":false,\"specVersion\":\"V30\",\"types\":[\"integer\"]}}],\"responses\":{\"500\":{\"description\":\"Internal Server Error\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"404\":{\"description\":\"Not Found\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"200\":{\"description\":\"OK\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/ResultBoolean\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}}},\"extensions\":{\"methodName\":\"createDynamic\",\"className\":\"ModelingEntityController\",\"class\":\"class com.netwisd.base.model.controller.ModelingEntityController\",\"returnType\":\"Result\"}}}},\"components\":{\"schemas\":{\"ResultBoolean\":{\"name\":\"ResultBoolean\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"boolean\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result\":{\"name\":\"Result\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"object\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}}},\"specVersion\":\"V30\"}', '2023-11-23 18:14:16', 'offline', 'main-modelingEntity', 'incloud-base-main', 'main', 'baseApi', '数据建模', 'ModelingEntity', 'createDynamic', 'Result');
INSERT INTO `incloud_base_mdm_openapi` VALUES (1727631641146126337, 'GET', 'R0VUIC9tYWluL21vZGVsaW5nRW50aXR5L2R5bmFtaWM', '动态接口生成', '/main/modelingEntity/dynamic', 'ModelingEntityController', '{\"openapi\":\"3.0.1\",\"info\":{\"title\":\"主模块\",\"description\":\"主模块\",\"termsOfService\":\"http://www.netwisd.com\",\"license\":{\"name\":\"云数网讯\",\"url\":\"http://www.netwisd.com\"},\"version\":\"5.0\"},\"servers\":[{\"url\":\"http://192.168.10.58:8001\",\"description\":\"Generated server url\"}],\"tags\":[{\"name\":\"数据建模\",\"description\":\"数据建模Controller\"}],\"paths\":{\"/modelingEntity/dynamic\":{\"get\":{\"tags\":[\"数据建模\"],\"summary\":\"动态接口生成\",\"operationId\":\"09776524\",\"parameters\":[{\"name\":\"id\",\"in\":\"query\",\"required\":true,\"schema\":{\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":false,\"specVersion\":\"V30\",\"types\":[\"integer\"]}}],\"responses\":{\"500\":{\"description\":\"Internal Server Error\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"404\":{\"description\":\"Not Found\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"200\":{\"description\":\"OK\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/ResultBoolean\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}}},\"extensions\":{\"methodName\":\"createDynamic\",\"className\":\"ModelingEntityController\",\"class\":\"class com.netwisd.base.model.controller.ModelingEntityController\",\"returnType\":\"Result\"}}}},\"components\":{\"schemas\":{\"ResultBoolean\":{\"name\":\"ResultBoolean\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"boolean\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result\":{\"name\":\"Result\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"object\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}}},\"specVersion\":\"V30\"}', '2023-11-23 18:14:16', 'offline', 'main-modelingEntity', 'incloud-base-main', 'main', 'baseApi', '数据建模', 'ModelingEntity', 'createDynamic', 'Result');
INSERT INTO `incloud_base_mdm_openapi` VALUES (1727631641146126338, 'POST', 'UE9TVCAvbWFpbi9tb2RlbGluZ0VudGl0eS9kb3dubG9hZENvZGU', '代码下载', '/main/modelingEntity/downloadCode', 'ModelingEntityController', '{\"openapi\":\"3.0.1\",\"info\":{\"title\":\"主模块\",\"description\":\"主模块\",\"termsOfService\":\"http://www.netwisd.com\",\"license\":{\"name\":\"云数网讯\",\"url\":\"http://www.netwisd.com\"},\"version\":\"5.0\"},\"servers\":[{\"url\":\"http://192.168.10.58:8001\",\"description\":\"Generated server url\"}],\"tags\":[{\"name\":\"数据建模\",\"description\":\"数据建模Controller\"}],\"paths\":{\"/modelingEntity/downloadCode\":{\"post\":{\"tags\":[\"数据建模\"],\"summary\":\"代码下载\",\"operationId\":\"09834852\",\"parameters\":[{\"name\":\"id\",\"in\":\"query\",\"required\":true,\"schema\":{\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":false,\"specVersion\":\"V30\",\"types\":[\"integer\"]}}],\"responses\":{\"500\":{\"description\":\"Internal Server Error\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"404\":{\"description\":\"Not Found\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"200\":{\"description\":\"OK\"}},\"extensions\":{\"methodName\":\"downloadCode\",\"className\":\"ModelingEntityController\",\"class\":\"class com.netwisd.base.model.controller.ModelingEntityController\",\"returnType\":\"void\"}}}},\"components\":{\"schemas\":{\"Result\":{\"name\":\"Result\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"object\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}}},\"specVersion\":\"V30\"}', '2023-11-23 18:14:16', 'offline', 'main-modelingEntity', 'incloud-base-main', 'main', 'baseApi', '数据建模', 'ModelingEntity', 'downloadCode', 'void');
INSERT INTO `incloud_base_mdm_openapi` VALUES (1727631641146126339, 'GET', 'R0VUIC9tYWluL21vZGVsaW5nRW50aXR5L2Rvd25sb2FkQ29kZQ', '代码下载', '/main/modelingEntity/downloadCode', 'ModelingEntityController', '{\"openapi\":\"3.0.1\",\"info\":{\"title\":\"主模块\",\"description\":\"主模块\",\"termsOfService\":\"http://www.netwisd.com\",\"license\":{\"name\":\"云数网讯\",\"url\":\"http://www.netwisd.com\"},\"version\":\"5.0\"},\"servers\":[{\"url\":\"http://192.168.10.58:8001\",\"description\":\"Generated server url\"}],\"tags\":[{\"name\":\"数据建模\",\"description\":\"数据建模Controller\"}],\"paths\":{\"/modelingEntity/downloadCode\":{\"get\":{\"tags\":[\"数据建模\"],\"summary\":\"代码下载\",\"operationId\":\"09821775\",\"parameters\":[{\"name\":\"id\",\"in\":\"query\",\"required\":true,\"schema\":{\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":false,\"specVersion\":\"V30\",\"types\":[\"integer\"]}}],\"responses\":{\"500\":{\"description\":\"Internal Server Error\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"404\":{\"description\":\"Not Found\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"200\":{\"description\":\"OK\"}},\"extensions\":{\"methodName\":\"downloadCode\",\"className\":\"ModelingEntityController\",\"class\":\"class com.netwisd.base.model.controller.ModelingEntityController\",\"returnType\":\"void\"}}}},\"components\":{\"schemas\":{\"Result\":{\"name\":\"Result\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"object\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}}},\"specVersion\":\"V30\"}', '2023-11-23 18:14:16', 'offline', 'main-modelingEntity', 'incloud-base-main', 'main', 'baseApi', '数据建模', 'ModelingEntity', 'downloadCode', 'void');
INSERT INTO `incloud_base_mdm_openapi` VALUES (1727631641146126340, 'POST', 'UE9TVCAvbWFpbi90cmlwYXJ0aXRlQXV0aGVudGljYXRpb24', '新增三方认证管理', '/main/tripartiteAuthentication', 'TripartiteAuthManageController', '{\"openapi\":\"3.0.1\",\"info\":{\"title\":\"主模块\",\"description\":\"主模块\",\"termsOfService\":\"http://www.netwisd.com\",\"license\":{\"name\":\"云数网讯\",\"url\":\"http://www.netwisd.com\"},\"version\":\"5.0\"},\"servers\":[{\"url\":\"http://192.168.10.58:8001\",\"description\":\"Generated server url\"}],\"tags\":[{\"name\":\"tripartiteAuthentication\",\"description\":\"三方认证管理Controller\"}],\"paths\":{\"/tripartiteAuthentication\":{\"post\":{\"tags\":[\"tripartiteAuthentication\"],\"summary\":\"新增三方认证管理\",\"operationId\":\"10250792\",\"requestBody\":{\"content\":{\"application/json\":{\"schema\":{\"$ref\":\"#/components/schemas/三方认证管理 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}},\"required\":true},\"responses\":{\"500\":{\"description\":\"Internal Server Error\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"404\":{\"description\":\"Not Found\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"200\":{\"description\":\"OK\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result三方认证管理 Vo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}}},\"extensions\":{\"methodName\":\"save\",\"className\":\"TripartiteAuthManageController\",\"class\":\"class com.netwisd.base.security.controller.TripartiteAuthManageController\",\"returnType\":\"Result\"}}}},\"components\":{\"schemas\":{\"三方认证管理 Dto\":{\"name\":\"三方认证管理 Dto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"authenticatorName\":{\"name\":\"authenticatorName\",\"type\":\"string\",\"description\":\"认证器名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"authenticatorAddress\":{\"name\":\"authenticatorAddress\",\"type\":\"string\",\"description\":\"认证器地址\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"type\":{\"name\":\"type\",\"type\":\"string\",\"description\":\"类型\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientId\":{\"name\":\"clientId\",\"type\":\"integer\",\"description\":\"client_id\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"responseType\":{\"name\":\"responseType\",\"type\":\"string\",\"description\":\"响应类型\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"redirectUri\":{\"name\":\"redirectUri\",\"type\":\"string\",\"description\":\"重定向uri\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"credentialsRequestType\":{\"name\":\"credentialsRequestType\",\"type\":\"string\",\"description\":\"凭证请求类型\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientSecret\":{\"name\":\"clientSecret\",\"type\":\"string\",\"description\":\"客户端凭证\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"scope\":{\"name\":\"scope\",\"type\":\"string\",\"description\":\"范围\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"credentialsExpires\":{\"name\":\"credentialsExpires\",\"type\":\"string\",\"description\":\"凭证过期时间\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"tokenExpires\":{\"name\":\"tokenExpires\",\"type\":\"integer\",\"description\":\"token过期时间\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isEnable\":{\"name\":\"isEnable\",\"type\":\"integer\",\"description\":\"是否启用\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"containsUserInfo\":{\"name\":\"containsUserInfo\",\"type\":\"integer\",\"description\":\"是否包含用户信息\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"fieldName\":{\"name\":\"fieldName\",\"type\":\"string\",\"description\":\"用户字段名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"transferMode\":{\"name\":\"transferMode\",\"type\":\"string\",\"description\":\"用户信息传输方式\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"fieldValueSource\":{\"name\":\"fieldValueSource\",\"type\":\"string\",\"description\":\"用户字段取值来源\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"containsPasswordInfo\":{\"name\":\"containsPasswordInfo\",\"type\":\"integer\",\"description\":\"是否有密码信息\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"passwordFieldName\":{\"name\":\"passwordFieldName\",\"type\":\"string\",\"description\":\"密码字段名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"encryptionWay\":{\"name\":\"encryptionWay\",\"type\":\"string\",\"description\":\"密码加密方式(RSA,MD5)\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"secretKey\":{\"name\":\"secretKey\",\"type\":\"string\",\"description\":\"密钥\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"passwordTransferMode\":{\"name\":\"passwordTransferMode\",\"type\":\"string\",\"description\":\"密码传输方式\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"array\",\"description\":\"接收范围的\",\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/ScopeDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"specialTag\":{\"name\":\"specialTag\",\"type\":\"boolean\",\"description\":\"是否是选择特殊认证器（true）\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"ScopeDto\":{\"name\":\"ScopeDto\",\"type\":\"object\",\"properties\":{\"scope\":{\"name\":\"scope\",\"type\":\"array\",\"exampleSetFlag\":true,\"items\":{\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]}},\"description\":\"接收范围的\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"OrderItem\":{\"name\":\"OrderItem\",\"type\":\"object\",\"properties\":{\"column\":{\"name\":\"column\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"asc\":{\"name\":\"asc\",\"type\":\"boolean\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Page\":{\"name\":\"Page\",\"type\":\"object\",\"properties\":{\"records\":{\"name\":\"records\",\"type\":\"array\",\"exampleSetFlag\":true,\"items\":{\"type\":\"object\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"total\":{\"name\":\"total\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"size\":{\"name\":\"size\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"current\":{\"name\":\"current\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orders\":{\"name\":\"orders\",\"type\":\"array\",\"deprecated\":true,\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/OrderItem\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"optimizeCountSql\":{\"name\":\"optimizeCountSql\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"searchCount\":{\"name\":\"searchCount\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"optimizeJoinOfCountSql\":{\"name\":\"optimizeJoinOfCountSql\",\"type\":\"boolean\",\"writeOnly\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"maxLimit\":{\"name\":\"maxLimit\",\"type\":\"integer\",\"format\":\"int64\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"countId\":{\"name\":\"countId\",\"type\":\"string\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pages\":{\"name\":\"pages\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"三方认证管理 Vo\":{\"name\":\"三方认证管理 Vo\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"认证器名称\":{\"name\":\"认证器名称\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"authenticatorAddress\":{\"name\":\"authenticatorAddress\",\"type\":\"string\",\"description\":\"认证器地址\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"类型\":{\"name\":\"类型\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"client_id\":{\"name\":\"client_id\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"响应类型\":{\"name\":\"响应类型\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"重定向uri\":{\"name\":\"重定向uri\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"凭证请求类型\":{\"name\":\"凭证请求类型\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"客户端凭证\":{\"name\":\"客户端凭证\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"范围\":{\"name\":\"范围\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"凭证过期时间\":{\"name\":\"凭证过期时间\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"token过期时间\":{\"name\":\"token过期时间\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isEnable\":{\"name\":\"isEnable\",\"type\":\"integer\",\"description\":\"是否启用\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"containsUserInfo\":{\"name\":\"containsUserInfo\",\"type\":\"integer\",\"description\":\"是否包含用户信息\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"fieldName\":{\"name\":\"fieldName\",\"type\":\"string\",\"description\":\"用户字段名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"transferMode\":{\"name\":\"transferMode\",\"type\":\"string\",\"description\":\"用户信息传输方式\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"fieldValueSource\":{\"name\":\"fieldValueSource\",\"type\":\"string\",\"description\":\"用户字段取值来源\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"containsPasswordInfo\":{\"name\":\"containsPasswordInfo\",\"type\":\"integer\",\"description\":\"是否有密码信息\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"passwordFieldName\":{\"name\":\"passwordFieldName\",\"type\":\"string\",\"description\":\"密码字段名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"encryptionWay\":{\"name\":\"encryptionWay\",\"type\":\"string\",\"description\":\"密码加密方式(RSA,MD5)\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"secretKey\":{\"name\":\"secretKey\",\"type\":\"string\",\"description\":\"密钥\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"passwordTransferMode\":{\"name\":\"passwordTransferMode\",\"type\":\"string\",\"description\":\"密码传输方式\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"array\",\"description\":\"接收范围的\",\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/ScopeDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]}},\"description\":\"返回数据\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result\":{\"name\":\"Result\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"object\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result三方认证管理 Vo\":{\"name\":\"Result三方认证管理 Vo\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"$ref\":\"#/components/schemas/三方认证管理 Vo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}}},\"specVersion\":\"V30\"}', '2023-11-23 18:14:16', 'offline', 'main-tripartiteAuthentication', 'incloud-base-main', 'main', 'baseApi', 'tripartiteAuthentication', 'TripartiteAuthManage', 'save', 'Result');
INSERT INTO `incloud_base_mdm_openapi` VALUES (1727631641146126341, 'PUT', 'UFVUIC9tYWluL3RyaXBhcnRpdGVBdXRoZW50aWNhdGlvbg', '修改三方认证管理', '/main/tripartiteAuthentication', 'TripartiteAuthManageController', '{\"openapi\":\"3.0.1\",\"info\":{\"title\":\"主模块\",\"description\":\"主模块\",\"termsOfService\":\"http://www.netwisd.com\",\"license\":{\"name\":\"云数网讯\",\"url\":\"http://www.netwisd.com\"},\"version\":\"5.0\"},\"servers\":[{\"url\":\"http://192.168.10.58:8001\",\"description\":\"Generated server url\"}],\"tags\":[{\"name\":\"tripartiteAuthentication\",\"description\":\"三方认证管理Controller\"}],\"paths\":{\"/tripartiteAuthentication\":{\"put\":{\"tags\":[\"tripartiteAuthentication\"],\"summary\":\"修改三方认证管理\",\"operationId\":\"09418304\",\"requestBody\":{\"content\":{\"application/json\":{\"schema\":{\"$ref\":\"#/components/schemas/三方认证管理 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}},\"required\":true},\"responses\":{\"500\":{\"description\":\"Internal Server Error\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"404\":{\"description\":\"Not Found\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"200\":{\"description\":\"OK\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result三方认证管理 Vo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}}},\"extensions\":{\"methodName\":\"update\",\"className\":\"TripartiteAuthManageController\",\"class\":\"class com.netwisd.base.security.controller.TripartiteAuthManageController\",\"returnType\":\"Result\"}}}},\"components\":{\"schemas\":{\"三方认证管理 Dto\":{\"name\":\"三方认证管理 Dto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"authenticatorName\":{\"name\":\"authenticatorName\",\"type\":\"string\",\"description\":\"认证器名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"authenticatorAddress\":{\"name\":\"authenticatorAddress\",\"type\":\"string\",\"description\":\"认证器地址\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"type\":{\"name\":\"type\",\"type\":\"string\",\"description\":\"类型\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientId\":{\"name\":\"clientId\",\"type\":\"integer\",\"description\":\"client_id\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"responseType\":{\"name\":\"responseType\",\"type\":\"string\",\"description\":\"响应类型\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"redirectUri\":{\"name\":\"redirectUri\",\"type\":\"string\",\"description\":\"重定向uri\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"credentialsRequestType\":{\"name\":\"credentialsRequestType\",\"type\":\"string\",\"description\":\"凭证请求类型\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientSecret\":{\"name\":\"clientSecret\",\"type\":\"string\",\"description\":\"客户端凭证\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"scope\":{\"name\":\"scope\",\"type\":\"string\",\"description\":\"范围\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"credentialsExpires\":{\"name\":\"credentialsExpires\",\"type\":\"string\",\"description\":\"凭证过期时间\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"tokenExpires\":{\"name\":\"tokenExpires\",\"type\":\"integer\",\"description\":\"token过期时间\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isEnable\":{\"name\":\"isEnable\",\"type\":\"integer\",\"description\":\"是否启用\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"containsUserInfo\":{\"name\":\"containsUserInfo\",\"type\":\"integer\",\"description\":\"是否包含用户信息\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"fieldName\":{\"name\":\"fieldName\",\"type\":\"string\",\"description\":\"用户字段名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"transferMode\":{\"name\":\"transferMode\",\"type\":\"string\",\"description\":\"用户信息传输方式\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"fieldValueSource\":{\"name\":\"fieldValueSource\",\"type\":\"string\",\"description\":\"用户字段取值来源\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"containsPasswordInfo\":{\"name\":\"containsPasswordInfo\",\"type\":\"integer\",\"description\":\"是否有密码信息\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"passwordFieldName\":{\"name\":\"passwordFieldName\",\"type\":\"string\",\"description\":\"密码字段名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"encryptionWay\":{\"name\":\"encryptionWay\",\"type\":\"string\",\"description\":\"密码加密方式(RSA,MD5)\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"secretKey\":{\"name\":\"secretKey\",\"type\":\"string\",\"description\":\"密钥\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"passwordTransferMode\":{\"name\":\"passwordTransferMode\",\"type\":\"string\",\"description\":\"密码传输方式\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"array\",\"description\":\"接收范围的\",\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/ScopeDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"specialTag\":{\"name\":\"specialTag\",\"type\":\"boolean\",\"description\":\"是否是选择特殊认证器（true）\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"ScopeDto\":{\"name\":\"ScopeDto\",\"type\":\"object\",\"properties\":{\"scope\":{\"name\":\"scope\",\"type\":\"array\",\"exampleSetFlag\":true,\"items\":{\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]}},\"description\":\"接收范围的\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"OrderItem\":{\"name\":\"OrderItem\",\"type\":\"object\",\"properties\":{\"column\":{\"name\":\"column\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"asc\":{\"name\":\"asc\",\"type\":\"boolean\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Page\":{\"name\":\"Page\",\"type\":\"object\",\"properties\":{\"records\":{\"name\":\"records\",\"type\":\"array\",\"exampleSetFlag\":true,\"items\":{\"type\":\"object\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"total\":{\"name\":\"total\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"size\":{\"name\":\"size\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"current\":{\"name\":\"current\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orders\":{\"name\":\"orders\",\"type\":\"array\",\"deprecated\":true,\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/OrderItem\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"optimizeCountSql\":{\"name\":\"optimizeCountSql\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"searchCount\":{\"name\":\"searchCount\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"optimizeJoinOfCountSql\":{\"name\":\"optimizeJoinOfCountSql\",\"type\":\"boolean\",\"writeOnly\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"maxLimit\":{\"name\":\"maxLimit\",\"type\":\"integer\",\"format\":\"int64\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"countId\":{\"name\":\"countId\",\"type\":\"string\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pages\":{\"name\":\"pages\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"三方认证管理 Vo\":{\"name\":\"三方认证管理 Vo\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"认证器名称\":{\"name\":\"认证器名称\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"authenticatorAddress\":{\"name\":\"authenticatorAddress\",\"type\":\"string\",\"description\":\"认证器地址\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"类型\":{\"name\":\"类型\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"client_id\":{\"name\":\"client_id\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"响应类型\":{\"name\":\"响应类型\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"重定向uri\":{\"name\":\"重定向uri\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"凭证请求类型\":{\"name\":\"凭证请求类型\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"客户端凭证\":{\"name\":\"客户端凭证\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"范围\":{\"name\":\"范围\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"凭证过期时间\":{\"name\":\"凭证过期时间\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"token过期时间\":{\"name\":\"token过期时间\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isEnable\":{\"name\":\"isEnable\",\"type\":\"integer\",\"description\":\"是否启用\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"containsUserInfo\":{\"name\":\"containsUserInfo\",\"type\":\"integer\",\"description\":\"是否包含用户信息\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"fieldName\":{\"name\":\"fieldName\",\"type\":\"string\",\"description\":\"用户字段名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"transferMode\":{\"name\":\"transferMode\",\"type\":\"string\",\"description\":\"用户信息传输方式\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"fieldValueSource\":{\"name\":\"fieldValueSource\",\"type\":\"string\",\"description\":\"用户字段取值来源\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"containsPasswordInfo\":{\"name\":\"containsPasswordInfo\",\"type\":\"integer\",\"description\":\"是否有密码信息\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"passwordFieldName\":{\"name\":\"passwordFieldName\",\"type\":\"string\",\"description\":\"密码字段名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"encryptionWay\":{\"name\":\"encryptionWay\",\"type\":\"string\",\"description\":\"密码加密方式(RSA,MD5)\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"secretKey\":{\"name\":\"secretKey\",\"type\":\"string\",\"description\":\"密钥\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"passwordTransferMode\":{\"name\":\"passwordTransferMode\",\"type\":\"string\",\"description\":\"密码传输方式\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"array\",\"description\":\"接收范围的\",\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/ScopeDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]}},\"description\":\"返回数据\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result\":{\"name\":\"Result\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"object\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result三方认证管理 Vo\":{\"name\":\"Result三方认证管理 Vo\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"$ref\":\"#/components/schemas/三方认证管理 Vo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}}},\"specVersion\":\"V30\"}', '2023-11-23 18:14:16', 'offline', 'main-tripartiteAuthentication', 'incloud-base-main', 'main', 'baseApi', 'tripartiteAuthentication', 'TripartiteAuthManage', 'update', 'Result');
INSERT INTO `incloud_base_mdm_openapi` VALUES (1727631641146126342, 'POST', 'UE9TVCAvbWFpbi90bXA', '消息模板新增', '/main/tmp', 'MsgTemplateController', '{\"openapi\":\"3.0.1\",\"info\":{\"title\":\"主模块\",\"description\":\"主模块\",\"termsOfService\":\"http://www.netwisd.com\",\"license\":{\"name\":\"云数网讯\",\"url\":\"http://www.netwisd.com\"},\"version\":\"5.0\"},\"servers\":[{\"url\":\"http://192.168.10.58:8001\",\"description\":\"Generated server url\"}],\"tags\":[{\"name\":\"消息模板\",\"description\":\"消息模板Controller\"}],\"paths\":{\"/tmp\":{\"post\":{\"tags\":[\"消息模板\"],\"summary\":\"消息模板新增\",\"operationId\":\"10622886\",\"requestBody\":{\"content\":{\"application/json\":{\"schema\":{\"$ref\":\"#/components/schemas/消息模板Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}},\"required\":true},\"responses\":{\"500\":{\"description\":\"Internal Server Error\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"404\":{\"description\":\"Not Found\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"200\":{\"description\":\"OK\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/ResultBoolean\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}}},\"extensions\":{\"methodName\":\"addMsgTemplate\",\"className\":\"MsgTemplateController\",\"class\":\"class com.netwisd.base.msg.controller.MsgTemplateController\",\"returnType\":\"Result\"}}}},\"components\":{\"schemas\":{\"消息模板Dto\":{\"name\":\"消息模板Dto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"tmpCode\":{\"name\":\"tmpCode\",\"type\":\"string\",\"description\":\"模板Code\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"tmpName\":{\"name\":\"tmpName\",\"type\":\"string\",\"description\":\"模板名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"tmpContent\":{\"name\":\"tmpContent\",\"type\":\"string\",\"description\":\"模板内容\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"tmpTitle\":{\"name\":\"tmpTitle\",\"type\":\"string\",\"description\":\"模板标题\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"OrderItem\":{\"name\":\"OrderItem\",\"type\":\"object\",\"properties\":{\"column\":{\"name\":\"column\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"asc\":{\"name\":\"asc\",\"type\":\"boolean\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Page\":{\"name\":\"Page\",\"type\":\"object\",\"properties\":{\"records\":{\"name\":\"records\",\"type\":\"array\",\"exampleSetFlag\":true,\"items\":{\"type\":\"object\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"total\":{\"name\":\"total\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"size\":{\"name\":\"size\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"current\":{\"name\":\"current\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orders\":{\"name\":\"orders\",\"type\":\"array\",\"deprecated\":true,\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/OrderItem\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"optimizeCountSql\":{\"name\":\"optimizeCountSql\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"searchCount\":{\"name\":\"searchCount\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"optimizeJoinOfCountSql\":{\"name\":\"optimizeJoinOfCountSql\",\"type\":\"boolean\",\"writeOnly\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"maxLimit\":{\"name\":\"maxLimit\",\"type\":\"integer\",\"format\":\"int64\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"countId\":{\"name\":\"countId\",\"type\":\"string\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pages\":{\"name\":\"pages\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"ResultBoolean\":{\"name\":\"ResultBoolean\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"boolean\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result\":{\"name\":\"Result\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"object\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}}},\"specVersion\":\"V30\"}', '2023-11-23 18:14:16', 'offline', 'main-tmp', 'incloud-base-main', 'main', 'baseApi', '消息模板', 'MsgTemplate', 'addMsgTemplate', 'Result');
INSERT INTO `incloud_base_mdm_openapi` VALUES (1727631641146126343, 'PUT', 'UFVUIC9tYWluL3RtcA', '消息模板编辑', '/main/tmp', 'MsgTemplateController', '{\"openapi\":\"3.0.1\",\"info\":{\"title\":\"主模块\",\"description\":\"主模块\",\"termsOfService\":\"http://www.netwisd.com\",\"license\":{\"name\":\"云数网讯\",\"url\":\"http://www.netwisd.com\"},\"version\":\"5.0\"},\"servers\":[{\"url\":\"http://192.168.10.58:8001\",\"description\":\"Generated server url\"}],\"tags\":[{\"name\":\"消息模板\",\"description\":\"消息模板Controller\"}],\"paths\":{\"/tmp\":{\"put\":{\"tags\":[\"消息模板\"],\"summary\":\"消息模板编辑\",\"operationId\":\"09552524\",\"requestBody\":{\"content\":{\"application/json\":{\"schema\":{\"$ref\":\"#/components/schemas/消息模板Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}},\"required\":true},\"responses\":{\"500\":{\"description\":\"Internal Server Error\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"404\":{\"description\":\"Not Found\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"200\":{\"description\":\"OK\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/ResultBoolean\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}}},\"extensions\":{\"methodName\":\"editMsgTemplate\",\"className\":\"MsgTemplateController\",\"class\":\"class com.netwisd.base.msg.controller.MsgTemplateController\",\"returnType\":\"Result\"}}}},\"components\":{\"schemas\":{\"消息模板Dto\":{\"name\":\"消息模板Dto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"tmpCode\":{\"name\":\"tmpCode\",\"type\":\"string\",\"description\":\"模板Code\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"tmpName\":{\"name\":\"tmpName\",\"type\":\"string\",\"description\":\"模板名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"tmpContent\":{\"name\":\"tmpContent\",\"type\":\"string\",\"description\":\"模板内容\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"tmpTitle\":{\"name\":\"tmpTitle\",\"type\":\"string\",\"description\":\"模板标题\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"OrderItem\":{\"name\":\"OrderItem\",\"type\":\"object\",\"properties\":{\"column\":{\"name\":\"column\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"asc\":{\"name\":\"asc\",\"type\":\"boolean\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Page\":{\"name\":\"Page\",\"type\":\"object\",\"properties\":{\"records\":{\"name\":\"records\",\"type\":\"array\",\"exampleSetFlag\":true,\"items\":{\"type\":\"object\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"total\":{\"name\":\"total\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"size\":{\"name\":\"size\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"current\":{\"name\":\"current\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orders\":{\"name\":\"orders\",\"type\":\"array\",\"deprecated\":true,\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/OrderItem\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"optimizeCountSql\":{\"name\":\"optimizeCountSql\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"searchCount\":{\"name\":\"searchCount\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"optimizeJoinOfCountSql\":{\"name\":\"optimizeJoinOfCountSql\",\"type\":\"boolean\",\"writeOnly\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"maxLimit\":{\"name\":\"maxLimit\",\"type\":\"integer\",\"format\":\"int64\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"countId\":{\"name\":\"countId\",\"type\":\"string\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pages\":{\"name\":\"pages\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"ResultBoolean\":{\"name\":\"ResultBoolean\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"boolean\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result\":{\"name\":\"Result\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"object\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}}},\"specVersion\":\"V30\"}', '2023-11-23 18:14:16', 'offline', 'main-tmp', 'incloud-base-main', 'main', 'baseApi', '消息模板', 'MsgTemplate', 'editMsgTemplate', 'Result');
INSERT INTO `incloud_base_mdm_openapi` VALUES (1727631641146126344, 'POST', 'UE9TVCAvbWFpbi9yZWdpc3RlcmVkQ2xpZW50', '新增客户端注册', '/main/registeredClient', 'RegisteredClientController', '{\"openapi\":\"3.0.1\",\"info\":{\"title\":\"主模块\",\"description\":\"主模块\",\"termsOfService\":\"http://www.netwisd.com\",\"license\":{\"name\":\"云数网讯\",\"url\":\"http://www.netwisd.com\"},\"version\":\"5.0\"},\"servers\":[{\"url\":\"http://192.168.10.58:8001\",\"description\":\"Generated server url\"}],\"tags\":[{\"name\":\"客户端注册管理\",\"description\":\"客户端注册管理\",\"extensions\":{\"x-netwisd\":{\"app-code\":\"main\",\"module-code\":\"registeredClient\"}}}],\"paths\":{\"/registeredClient\":{\"post\":{\"tags\":[\"客户端注册管理\"],\"summary\":\"新增客户端注册\",\"operationId\":\"10333647\",\"requestBody\":{\"content\":{\"application/json\":{\"schema\":{\"$ref\":\"#/components/schemas/客户端注册管理 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}},\"required\":true},\"responses\":{\"500\":{\"description\":\"Internal Server Error\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"404\":{\"description\":\"Not Found\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"200\":{\"description\":\"OK\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result客户端注册管理 Vo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}}},\"extensions\":{\"methodName\":\"save\",\"className\":\"RegisteredClientController\",\"class\":\"class com.netwisd.base.security.controller.RegisteredClientController\",\"returnType\":\"Result\"}}}},\"components\":{\"schemas\":{\"客户端注册管理 Dto\":{\"name\":\"客户端注册管理 Dto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"clientId\":{\"name\":\"clientId\",\"type\":\"string\",\"description\":\"客户端id\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientName\":{\"name\":\"clientName\",\"type\":\"string\",\"description\":\"客户端名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientAuthenticationMethods\":{\"name\":\"clientAuthenticationMethods\",\"type\":\"string\",\"description\":\"客户端认证方法\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"authorizationGrantTypes\":{\"name\":\"authorizationGrantTypes\",\"type\":\"string\",\"description\":\"客户端认证类型\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientSecret\":{\"name\":\"clientSecret\",\"type\":\"string\",\"description\":\"客户端凭证\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientSecretEncode\":{\"name\":\"clientSecretEncode\",\"type\":\"string\",\"description\":\"客户端密钥加密串\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientSecretExpiresAt\":{\"name\":\"clientSecretExpiresAt\",\"type\":\"string\",\"description\":\"客户端密钥过期时间\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientTokenExpiresAt\":{\"name\":\"clientTokenExpiresAt\",\"type\":\"string\",\"description\":\"客户端获取token过期时间\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"isClientSecretEncryptRequired\":{\"name\":\"isClientSecretEncryptRequired\",\"type\":\"integer\",\"description\":\"是否需要客户端凭证加密\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"encryptionPublicKey4ClientSecret\":{\"name\":\"encryptionPublicKey4ClientSecret\",\"type\":\"string\",\"description\":\"客户端凭证的加密公钥\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"encryptionPrivateKey4ClientSecret\":{\"name\":\"encryptionPrivateKey4ClientSecret\",\"type\":\"string\",\"description\":\"客户端凭证的加密私钥\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"isPwdRequired\":{\"name\":\"isPwdRequired\",\"type\":\"integer\",\"description\":\"是否需要验证密码\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"encryptionPublicKey4Pwd\":{\"name\":\"encryptionPublicKey4Pwd\",\"type\":\"string\",\"description\":\"密码的加密公钥\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"encryptionPrivateKey4Pwd\":{\"name\":\"encryptionPrivateKey4Pwd\",\"type\":\"string\",\"description\":\"密码的加密私钥\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"isEnable\":{\"name\":\"isEnable\",\"type\":\"integer\",\"description\":\"是否启用\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"OrderItem\":{\"name\":\"OrderItem\",\"type\":\"object\",\"properties\":{\"column\":{\"name\":\"column\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"asc\":{\"name\":\"asc\",\"type\":\"boolean\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Page\":{\"name\":\"Page\",\"type\":\"object\",\"properties\":{\"records\":{\"name\":\"records\",\"type\":\"array\",\"exampleSetFlag\":true,\"items\":{\"type\":\"object\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"total\":{\"name\":\"total\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"size\":{\"name\":\"size\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"current\":{\"name\":\"current\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orders\":{\"name\":\"orders\",\"type\":\"array\",\"deprecated\":true,\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/OrderItem\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"optimizeCountSql\":{\"name\":\"optimizeCountSql\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"searchCount\":{\"name\":\"searchCount\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"optimizeJoinOfCountSql\":{\"name\":\"optimizeJoinOfCountSql\",\"type\":\"boolean\",\"writeOnly\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"maxLimit\":{\"name\":\"maxLimit\",\"type\":\"integer\",\"format\":\"int64\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"countId\":{\"name\":\"countId\",\"type\":\"string\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pages\":{\"name\":\"pages\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result客户端注册管理 Vo\":{\"name\":\"Result客户端注册管理 Vo\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"$ref\":\"#/components/schemas/客户端注册管理 Vo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"客户端注册管理 Vo\":{\"name\":\"客户端注册管理 Vo\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientId\":{\"name\":\"clientId\",\"type\":\"string\",\"description\":\"客户端id\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientName\":{\"name\":\"clientName\",\"type\":\"string\",\"description\":\"客户端名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientAuthenticationMethods\":{\"name\":\"clientAuthenticationMethods\",\"type\":\"string\",\"description\":\"客户端认证方法\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"authorizationGrantTypes\":{\"name\":\"authorizationGrantTypes\",\"type\":\"string\",\"description\":\"客户端认证类型\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientSecret\":{\"name\":\"clientSecret\",\"type\":\"string\",\"description\":\"客户端凭证\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientSecretExpiresAt\":{\"name\":\"clientSecretExpiresAt\",\"type\":\"string\",\"description\":\"客户端密钥过期时间\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientTokenExpiresAt\":{\"name\":\"clientTokenExpiresAt\",\"type\":\"string\",\"description\":\"客户端获取token过期时间\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientSecretExpiresTimeAt\":{\"name\":\"clientSecretExpiresTimeAt\",\"type\":\"integer\",\"description\":\"客户端密钥过期时间\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"clientTokenExpiresTimeAt\":{\"name\":\"clientTokenExpiresTimeAt\",\"type\":\"integer\",\"description\":\"客户端获取token过期时间\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isClientSecretEncryptRequired\":{\"name\":\"isClientSecretEncryptRequired\",\"type\":\"integer\",\"description\":\"是否需要客户端凭证加密\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"encryptionPublicKey4ClientSecret\":{\"name\":\"encryptionPublicKey4ClientSecret\",\"type\":\"string\",\"description\":\"客户端凭证的加密公钥\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"isPwdRequired\":{\"name\":\"isPwdRequired\",\"type\":\"integer\",\"description\":\"是否需要验证密码\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"encryptionPublicKey4Pwd\":{\"name\":\"encryptionPublicKey4Pwd\",\"type\":\"string\",\"description\":\"密码的加密公钥\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"isEnable\":{\"name\":\"isEnable\",\"type\":\"integer\",\"description\":\"是否启用\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"返回数据\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result\":{\"name\":\"Result\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"object\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}}},\"specVersion\":\"V30\"}', '2023-11-23 18:14:16', 'offline', 'main-registeredClient', 'incloud-base-main', 'main', 'baseApi', '客户端注册管理', 'RegisteredClient', 'save', 'Result');
INSERT INTO `incloud_base_mdm_openapi` VALUES (1727631641146126345, 'PUT', 'UFVUIC9tYWluL3JlZ2lzdGVyZWRDbGllbnQ', '修改客户端注册', '/main/registeredClient', 'RegisteredClientController', '{\"openapi\":\"3.0.1\",\"info\":{\"title\":\"主模块\",\"description\":\"主模块\",\"termsOfService\":\"http://www.netwisd.com\",\"license\":{\"name\":\"云数网讯\",\"url\":\"http://www.netwisd.com\"},\"version\":\"5.0\"},\"servers\":[{\"url\":\"http://192.168.10.58:8001\",\"description\":\"Generated server url\"}],\"tags\":[{\"name\":\"客户端注册管理\",\"description\":\"客户端注册管理\",\"extensions\":{\"x-netwisd\":{\"app-code\":\"main\",\"module-code\":\"registeredClient\"}}}],\"paths\":{\"/registeredClient\":{\"put\":{\"tags\":[\"客户端注册管理\"],\"summary\":\"修改客户端注册\",\"operationId\":\"09763727\",\"requestBody\":{\"content\":{\"application/json\":{\"schema\":{\"$ref\":\"#/components/schemas/客户端注册管理 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}},\"required\":true},\"responses\":{\"500\":{\"description\":\"Internal Server Error\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"404\":{\"description\":\"Not Found\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"200\":{\"description\":\"OK\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result客户端注册管理 Vo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}}},\"extensions\":{\"methodName\":\"update\",\"className\":\"RegisteredClientController\",\"class\":\"class com.netwisd.base.security.controller.RegisteredClientController\",\"returnType\":\"Result\"}}}},\"components\":{\"schemas\":{\"客户端注册管理 Dto\":{\"name\":\"客户端注册管理 Dto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"clientId\":{\"name\":\"clientId\",\"type\":\"string\",\"description\":\"客户端id\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientName\":{\"name\":\"clientName\",\"type\":\"string\",\"description\":\"客户端名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientAuthenticationMethods\":{\"name\":\"clientAuthenticationMethods\",\"type\":\"string\",\"description\":\"客户端认证方法\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"authorizationGrantTypes\":{\"name\":\"authorizationGrantTypes\",\"type\":\"string\",\"description\":\"客户端认证类型\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientSecret\":{\"name\":\"clientSecret\",\"type\":\"string\",\"description\":\"客户端凭证\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientSecretEncode\":{\"name\":\"clientSecretEncode\",\"type\":\"string\",\"description\":\"客户端密钥加密串\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientSecretExpiresAt\":{\"name\":\"clientSecretExpiresAt\",\"type\":\"string\",\"description\":\"客户端密钥过期时间\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientTokenExpiresAt\":{\"name\":\"clientTokenExpiresAt\",\"type\":\"string\",\"description\":\"客户端获取token过期时间\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"isClientSecretEncryptRequired\":{\"name\":\"isClientSecretEncryptRequired\",\"type\":\"integer\",\"description\":\"是否需要客户端凭证加密\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"encryptionPublicKey4ClientSecret\":{\"name\":\"encryptionPublicKey4ClientSecret\",\"type\":\"string\",\"description\":\"客户端凭证的加密公钥\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"encryptionPrivateKey4ClientSecret\":{\"name\":\"encryptionPrivateKey4ClientSecret\",\"type\":\"string\",\"description\":\"客户端凭证的加密私钥\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"isPwdRequired\":{\"name\":\"isPwdRequired\",\"type\":\"integer\",\"description\":\"是否需要验证密码\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"encryptionPublicKey4Pwd\":{\"name\":\"encryptionPublicKey4Pwd\",\"type\":\"string\",\"description\":\"密码的加密公钥\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"encryptionPrivateKey4Pwd\":{\"name\":\"encryptionPrivateKey4Pwd\",\"type\":\"string\",\"description\":\"密码的加密私钥\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"isEnable\":{\"name\":\"isEnable\",\"type\":\"integer\",\"description\":\"是否启用\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"OrderItem\":{\"name\":\"OrderItem\",\"type\":\"object\",\"properties\":{\"column\":{\"name\":\"column\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"asc\":{\"name\":\"asc\",\"type\":\"boolean\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Page\":{\"name\":\"Page\",\"type\":\"object\",\"properties\":{\"records\":{\"name\":\"records\",\"type\":\"array\",\"exampleSetFlag\":true,\"items\":{\"type\":\"object\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"total\":{\"name\":\"total\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"size\":{\"name\":\"size\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"current\":{\"name\":\"current\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orders\":{\"name\":\"orders\",\"type\":\"array\",\"deprecated\":true,\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/OrderItem\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"optimizeCountSql\":{\"name\":\"optimizeCountSql\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"searchCount\":{\"name\":\"searchCount\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"optimizeJoinOfCountSql\":{\"name\":\"optimizeJoinOfCountSql\",\"type\":\"boolean\",\"writeOnly\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"maxLimit\":{\"name\":\"maxLimit\",\"type\":\"integer\",\"format\":\"int64\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"countId\":{\"name\":\"countId\",\"type\":\"string\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pages\":{\"name\":\"pages\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result客户端注册管理 Vo\":{\"name\":\"Result客户端注册管理 Vo\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"$ref\":\"#/components/schemas/客户端注册管理 Vo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"客户端注册管理 Vo\":{\"name\":\"客户端注册管理 Vo\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientId\":{\"name\":\"clientId\",\"type\":\"string\",\"description\":\"客户端id\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientName\":{\"name\":\"clientName\",\"type\":\"string\",\"description\":\"客户端名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientAuthenticationMethods\":{\"name\":\"clientAuthenticationMethods\",\"type\":\"string\",\"description\":\"客户端认证方法\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"authorizationGrantTypes\":{\"name\":\"authorizationGrantTypes\",\"type\":\"string\",\"description\":\"客户端认证类型\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientSecret\":{\"name\":\"clientSecret\",\"type\":\"string\",\"description\":\"客户端凭证\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientSecretExpiresAt\":{\"name\":\"clientSecretExpiresAt\",\"type\":\"string\",\"description\":\"客户端密钥过期时间\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientTokenExpiresAt\":{\"name\":\"clientTokenExpiresAt\",\"type\":\"string\",\"description\":\"客户端获取token过期时间\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"clientSecretExpiresTimeAt\":{\"name\":\"clientSecretExpiresTimeAt\",\"type\":\"integer\",\"description\":\"客户端密钥过期时间\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"clientTokenExpiresTimeAt\":{\"name\":\"clientTokenExpiresTimeAt\",\"type\":\"integer\",\"description\":\"客户端获取token过期时间\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isClientSecretEncryptRequired\":{\"name\":\"isClientSecretEncryptRequired\",\"type\":\"integer\",\"description\":\"是否需要客户端凭证加密\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"encryptionPublicKey4ClientSecret\":{\"name\":\"encryptionPublicKey4ClientSecret\",\"type\":\"string\",\"description\":\"客户端凭证的加密公钥\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"isPwdRequired\":{\"name\":\"isPwdRequired\",\"type\":\"integer\",\"description\":\"是否需要验证密码\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"encryptionPublicKey4Pwd\":{\"name\":\"encryptionPublicKey4Pwd\",\"type\":\"string\",\"description\":\"密码的加密公钥\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"isEnable\":{\"name\":\"isEnable\",\"type\":\"integer\",\"description\":\"是否启用\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"返回数据\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result\":{\"name\":\"Result\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"object\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}}},\"specVersion\":\"V30\"}', '2023-11-23 18:14:16', 'offline', 'main-registeredClient', 'incloud-base-main', 'main', 'baseApi', '客户端注册管理', 'RegisteredClient', 'update', 'Result');
INSERT INTO `incloud_base_mdm_openapi` VALUES (1727631641146126346, 'DELETE', 'REVMRVRFIC9tYWluL3JlY2VpdmUve2lkc30', NULL, '/main/receive/{ids}', 'MessageReceiveController', '{\"openapi\":\"3.0.1\",\"info\":{\"title\":\"主模块\",\"description\":\"主模块\",\"termsOfService\":\"http://www.netwisd.com\",\"license\":{\"name\":\"云数网讯\",\"url\":\"http://www.netwisd.com\"},\"version\":\"5.0\"},\"servers\":[{\"url\":\"http://192.168.10.58:8001\",\"description\":\"Generated server url\"}],\"tags\":[],\"paths\":{\"/receive/{ids}\":{\"delete\":{\"tags\":[\"message-receive-controller\"],\"operationId\":\"13653286\",\"parameters\":[{\"name\":\"ids\",\"in\":\"path\",\"required\":true,\"schema\":{\"type\":\"string\",\"exampleSetFlag\":false,\"specVersion\":\"V30\",\"types\":[\"string\"]}}],\"responses\":{\"500\":{\"description\":\"Internal Server Error\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"404\":{\"description\":\"Not Found\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"200\":{\"description\":\"OK\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/ResultBoolean\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}}},\"extensions\":{\"methodName\":\"delMsg\",\"className\":\"MessageReceiveController\",\"class\":\"class com.netwisd.base.msg.controller.receive.MessageReceiveController\",\"returnType\":\"Result\"}}}},\"components\":{\"schemas\":{\"ResultBoolean\":{\"name\":\"ResultBoolean\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"boolean\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result\":{\"name\":\"Result\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"object\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}}},\"specVersion\":\"V30\"}', '2023-11-23 18:14:16', 'offline', 'main-receive', 'incloud-base-main', 'null', 'baseApi', 'message-receive-controller', 'MessageReceive', 'delMsg', 'Result');
INSERT INTO `incloud_base_mdm_openapi` VALUES (1727631641146126347, 'PUT', 'UFVUIC9tYWluL3JlY2VpdmUve2lkc30', NULL, '/main/receive/{ids}', 'MessageReceiveController', '{\"openapi\":\"3.0.1\",\"info\":{\"title\":\"主模块\",\"description\":\"主模块\",\"termsOfService\":\"http://www.netwisd.com\",\"license\":{\"name\":\"云数网讯\",\"url\":\"http://www.netwisd.com\"},\"version\":\"5.0\"},\"servers\":[{\"url\":\"http://192.168.10.58:8001\",\"description\":\"Generated server url\"}],\"tags\":[],\"paths\":{\"/receive/{ids}\":{\"put\":{\"tags\":[\"message-receive-controller\"],\"operationId\":\"09799392\",\"parameters\":[{\"name\":\"ids\",\"in\":\"path\",\"required\":true,\"schema\":{\"type\":\"string\",\"exampleSetFlag\":false,\"specVersion\":\"V30\",\"types\":[\"string\"]}}],\"responses\":{\"500\":{\"description\":\"Internal Server Error\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"404\":{\"description\":\"Not Found\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"200\":{\"description\":\"OK\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/ResultBoolean\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}}},\"extensions\":{\"methodName\":\"upRead\",\"className\":\"MessageReceiveController\",\"class\":\"class com.netwisd.base.msg.controller.receive.MessageReceiveController\",\"returnType\":\"Result\"}}}},\"components\":{\"schemas\":{\"ResultBoolean\":{\"name\":\"ResultBoolean\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"boolean\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result\":{\"name\":\"Result\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"object\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}}},\"specVersion\":\"V30\"}', '2023-11-23 18:14:16', 'offline', 'main-receive', 'incloud-base-main', 'null', 'baseApi', 'message-receive-controller', 'MessageReceive', 'upRead', 'Result');
INSERT INTO `incloud_base_mdm_openapi` VALUES (1727631641146126348, 'POST', 'UE9TVCAvbWFpbi9wcm9kdWNlcg', 'Producer新增', '/main/producer', 'MqProducerController', '{\"openapi\":\"3.0.1\",\"info\":{\"title\":\"主模块\",\"description\":\"主模块\",\"termsOfService\":\"http://www.netwisd.com\",\"license\":{\"name\":\"云数网讯\",\"url\":\"http://www.netwisd.com\"},\"version\":\"5.0\"},\"servers\":[{\"url\":\"http://192.168.10.58:8001\",\"description\":\"Generated server url\"}],\"tags\":[{\"name\":\"MQ生产者\",\"description\":\"Producer Controller\"}],\"paths\":{\"/producer\":{\"post\":{\"tags\":[\"MQ生产者\"],\"summary\":\"Producer新增\",\"operationId\":\"10910915\",\"requestBody\":{\"content\":{\"application/json\":{\"schema\":{\"$ref\":\"#/components/schemas/生产者 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}},\"required\":true},\"responses\":{\"500\":{\"description\":\"Internal Server Error\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"404\":{\"description\":\"Not Found\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"200\":{\"description\":\"OK\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/ResultBoolean\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}}},\"extensions\":{\"methodName\":\"saveProducer\",\"className\":\"MqProducerController\",\"class\":\"class com.netwisd.base.msg.controller.MqProducerController\",\"returnType\":\"Result\"}}}},\"components\":{\"schemas\":{\"OrderItem\":{\"name\":\"OrderItem\",\"type\":\"object\",\"properties\":{\"column\":{\"name\":\"column\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"asc\":{\"name\":\"asc\",\"type\":\"boolean\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"生产者 Dto\":{\"name\":\"生产者 Dto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"mq\":{\"name\":\"mq\",\"type\":\"string\",\"description\":\"mq类型\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"host\":{\"name\":\"host\",\"type\":\"string\",\"description\":\"host\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"port\":{\"name\":\"port\",\"type\":\"integer\",\"description\":\"port\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"username\":{\"name\":\"username\",\"type\":\"string\",\"description\":\"username\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"password\":{\"name\":\"password\",\"type\":\"string\",\"description\":\"password\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"virtualHost\":{\"name\":\"virtualHost\",\"type\":\"string\",\"description\":\"virtual_host\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"queueName\":{\"name\":\"queueName\",\"type\":\"string\",\"description\":\"queue_name\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"producerGroup\":{\"name\":\"producerGroup\",\"type\":\"string\",\"description\":\"生产者组名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"topic\":{\"name\":\"topic\",\"type\":\"string\",\"description\":\"topic\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"tag\":{\"name\":\"tag\",\"type\":\"string\",\"description\":\"tag\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"sendMsgTimeout\":{\"name\":\"sendMsgTimeout\",\"type\":\"integer\",\"description\":\"发送消息超时时间\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msgSource\":{\"name\":\"msgSource\",\"type\":\"string\",\"description\":\"消息来源\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"msgTmpId\":{\"name\":\"msgTmpId\",\"type\":\"integer\",\"description\":\"消息模板Id\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msgTmpCode\":{\"name\":\"msgTmpCode\",\"type\":\"string\",\"description\":\"消息模板Code\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dbDsId\":{\"name\":\"dbDsId\",\"type\":\"integer\",\"description\":\"数据源Id\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"dbDs\":{\"name\":\"dbDs\",\"type\":\"string\",\"description\":\"数据源\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"mqSourceContent\":{\"name\":\"mqSourceContent\",\"type\":\"string\",\"description\":\"消息源内容\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"restfulAddr\":{\"name\":\"restfulAddr\",\"type\":\"string\",\"description\":\"接口地址\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"restfulDesc\":{\"name\":\"restfulDesc\",\"type\":\"string\",\"description\":\"接口描述\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"method\":{\"name\":\"method\",\"type\":\"string\",\"description\":\"接口类型\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"restfulHeder\":{\"name\":\"restfulHeder\",\"type\":\"string\",\"description\":\"接口请求头\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"restfulParam\":{\"name\":\"restfulParam\",\"type\":\"string\",\"description\":\"接口请求参数\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"isEnable\":{\"name\":\"isEnable\",\"type\":\"integer\",\"description\":\"是否启用\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"description\":{\"name\":\"description\",\"type\":\"string\",\"description\":\"描述\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"tmpParams\":{\"name\":\"tmpParams\",\"type\":\"string\",\"description\":\"模板参数\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"producerId\":{\"name\":\"producerId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Page\":{\"name\":\"Page\",\"type\":\"object\",\"properties\":{\"records\":{\"name\":\"records\",\"type\":\"array\",\"exampleSetFlag\":true,\"items\":{\"type\":\"object\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"total\":{\"name\":\"total\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"size\":{\"name\":\"size\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"current\":{\"name\":\"current\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orders\":{\"name\":\"orders\",\"type\":\"array\",\"deprecated\":true,\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/OrderItem\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"optimizeCountSql\":{\"name\":\"optimizeCountSql\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"searchCount\":{\"name\":\"searchCount\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"optimizeJoinOfCountSql\":{\"name\":\"optimizeJoinOfCountSql\",\"type\":\"boolean\",\"writeOnly\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"maxLimit\":{\"name\":\"maxLimit\",\"type\":\"integer\",\"format\":\"int64\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"countId\":{\"name\":\"countId\",\"type\":\"string\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pages\":{\"name\":\"pages\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"ResultBoolean\":{\"name\":\"ResultBoolean\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"boolean\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result\":{\"name\":\"Result\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"object\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}}},\"specVersion\":\"V30\"}', '2023-11-23 18:14:16', 'offline', 'main-producer', 'incloud-base-main', 'main', 'baseApi', 'MQ生产者', 'MqProducer', 'saveProducer', 'Result');
INSERT INTO `incloud_base_mdm_openapi` VALUES (1727631641146126349, 'PUT', 'UFVUIC9tYWluL3Byb2R1Y2Vy', 'Producer编辑', '/main/producer', 'MqProducerController', '{\"openapi\":\"3.0.1\",\"info\":{\"title\":\"主模块\",\"description\":\"主模块\",\"termsOfService\":\"http://www.netwisd.com\",\"license\":{\"name\":\"云数网讯\",\"url\":\"http://www.netwisd.com\"},\"version\":\"5.0\"},\"servers\":[{\"url\":\"http://192.168.10.58:8001\",\"description\":\"Generated server url\"}],\"tags\":[{\"name\":\"MQ生产者\",\"description\":\"Producer Controller\"}],\"paths\":{\"/producer\":{\"put\":{\"tags\":[\"MQ生产者\"],\"summary\":\"Producer编辑\",\"operationId\":\"09010105\",\"requestBody\":{\"content\":{\"application/json\":{\"schema\":{\"$ref\":\"#/components/schemas/生产者 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}},\"required\":true},\"responses\":{\"500\":{\"description\":\"Internal Server Error\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"404\":{\"description\":\"Not Found\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"200\":{\"description\":\"OK\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/ResultBoolean\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}}},\"extensions\":{\"methodName\":\"upProducer\",\"className\":\"MqProducerController\",\"class\":\"class com.netwisd.base.msg.controller.MqProducerController\",\"returnType\":\"Result\"}}}},\"components\":{\"schemas\":{\"OrderItem\":{\"name\":\"OrderItem\",\"type\":\"object\",\"properties\":{\"column\":{\"name\":\"column\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"asc\":{\"name\":\"asc\",\"type\":\"boolean\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"生产者 Dto\":{\"name\":\"生产者 Dto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"mq\":{\"name\":\"mq\",\"type\":\"string\",\"description\":\"mq类型\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"host\":{\"name\":\"host\",\"type\":\"string\",\"description\":\"host\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"port\":{\"name\":\"port\",\"type\":\"integer\",\"description\":\"port\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"username\":{\"name\":\"username\",\"type\":\"string\",\"description\":\"username\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"password\":{\"name\":\"password\",\"type\":\"string\",\"description\":\"password\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"virtualHost\":{\"name\":\"virtualHost\",\"type\":\"string\",\"description\":\"virtual_host\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"queueName\":{\"name\":\"queueName\",\"type\":\"string\",\"description\":\"queue_name\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"producerGroup\":{\"name\":\"producerGroup\",\"type\":\"string\",\"description\":\"生产者组名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"topic\":{\"name\":\"topic\",\"type\":\"string\",\"description\":\"topic\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"tag\":{\"name\":\"tag\",\"type\":\"string\",\"description\":\"tag\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"sendMsgTimeout\":{\"name\":\"sendMsgTimeout\",\"type\":\"integer\",\"description\":\"发送消息超时时间\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msgSource\":{\"name\":\"msgSource\",\"type\":\"string\",\"description\":\"消息来源\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"msgTmpId\":{\"name\":\"msgTmpId\",\"type\":\"integer\",\"description\":\"消息模板Id\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msgTmpCode\":{\"name\":\"msgTmpCode\",\"type\":\"string\",\"description\":\"消息模板Code\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dbDsId\":{\"name\":\"dbDsId\",\"type\":\"integer\",\"description\":\"数据源Id\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"dbDs\":{\"name\":\"dbDs\",\"type\":\"string\",\"description\":\"数据源\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"mqSourceContent\":{\"name\":\"mqSourceContent\",\"type\":\"string\",\"description\":\"消息源内容\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"restfulAddr\":{\"name\":\"restfulAddr\",\"type\":\"string\",\"description\":\"接口地址\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"restfulDesc\":{\"name\":\"restfulDesc\",\"type\":\"string\",\"description\":\"接口描述\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"method\":{\"name\":\"method\",\"type\":\"string\",\"description\":\"接口类型\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"restfulHeder\":{\"name\":\"restfulHeder\",\"type\":\"string\",\"description\":\"接口请求头\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"restfulParam\":{\"name\":\"restfulParam\",\"type\":\"string\",\"description\":\"接口请求参数\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"isEnable\":{\"name\":\"isEnable\",\"type\":\"integer\",\"description\":\"是否启用\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"description\":{\"name\":\"description\",\"type\":\"string\",\"description\":\"描述\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"tmpParams\":{\"name\":\"tmpParams\",\"type\":\"string\",\"description\":\"模板参数\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"producerId\":{\"name\":\"producerId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Page\":{\"name\":\"Page\",\"type\":\"object\",\"properties\":{\"records\":{\"name\":\"records\",\"type\":\"array\",\"exampleSetFlag\":true,\"items\":{\"type\":\"object\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"total\":{\"name\":\"total\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"size\":{\"name\":\"size\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"current\":{\"name\":\"current\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orders\":{\"name\":\"orders\",\"type\":\"array\",\"deprecated\":true,\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/OrderItem\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"optimizeCountSql\":{\"name\":\"optimizeCountSql\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"searchCount\":{\"name\":\"searchCount\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"optimizeJoinOfCountSql\":{\"name\":\"optimizeJoinOfCountSql\",\"type\":\"boolean\",\"writeOnly\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"maxLimit\":{\"name\":\"maxLimit\",\"type\":\"integer\",\"format\":\"int64\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"countId\":{\"name\":\"countId\",\"type\":\"string\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pages\":{\"name\":\"pages\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"ResultBoolean\":{\"name\":\"ResultBoolean\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"boolean\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result\":{\"name\":\"Result\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"object\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}}},\"specVersion\":\"V30\"}', '2023-11-23 18:14:16', 'offline', 'main-producer', 'incloud-base-main', 'main', 'baseApi', 'MQ生产者', 'MqProducer', 'upProducer', 'Result');
INSERT INTO `incloud_base_mdm_openapi` VALUES (1727631641146126350, 'POST', 'UE9TVCAvbWFpbi9tb2RlbGluZ0VudGl0eQ', '模型实体树新增', '/main/modelingEntity', 'ModelingEntityController', '{\"openapi\":\"3.0.1\",\"info\":{\"title\":\"主模块\",\"description\":\"主模块\",\"termsOfService\":\"http://www.netwisd.com\",\"license\":{\"name\":\"云数网讯\",\"url\":\"http://www.netwisd.com\"},\"version\":\"5.0\"},\"servers\":[{\"url\":\"http://192.168.10.58:8001\",\"description\":\"Generated server url\"}],\"tags\":[{\"name\":\"数据建模\",\"description\":\"数据建模Controller\"}],\"paths\":{\"/modelingEntity\":{\"post\":{\"tags\":[\"数据建模\"],\"summary\":\"模型实体树新增\",\"operationId\":\"10017998\",\"requestBody\":{\"content\":{\"application/json\":{\"schema\":{\"$ref\":\"#/components/schemas/数据建模实体 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}},\"required\":true},\"responses\":{\"500\":{\"description\":\"Internal Server Error\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"404\":{\"description\":\"Not Found\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"200\":{\"description\":\"OK\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result数据建模实体 Vo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}}},\"extensions\":{\"methodName\":\"save\",\"className\":\"ModelingEntityController\",\"class\":\"class com.netwisd.base.model.controller.ModelingEntityController\",\"returnType\":\"Result\"}}}},\"components\":{\"schemas\":{\"数据建模实体 Vo\":{\"name\":\"数据建模实体 Vo\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appId\":{\"name\":\"appId\",\"type\":\"integer\",\"description\":\"app_id\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"appName\":{\"name\":\"appName\",\"type\":\"string\",\"description\":\"app_name\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appCode\":{\"name\":\"appCode\",\"type\":\"string\",\"description\":\"app_code\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dbSourceId\":{\"name\":\"dbSourceId\",\"type\":\"integer\",\"description\":\"数据源\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"dbSource\":{\"name\":\"dbSource\",\"type\":\"string\",\"description\":\"数据源\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dbSourceType\":{\"name\":\"dbSourceType\",\"type\":\"string\",\"description\":\"类型\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"modelingName\":{\"name\":\"modelingName\",\"type\":\"string\",\"description\":\"模型名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"modelingCode\":{\"name\":\"modelingCode\",\"type\":\"string\",\"description\":\"模型编码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createType\":{\"name\":\"createType\",\"type\":\"integer\",\"description\":\"创建类型0 创建新表，1选现有表\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"tableName\":{\"name\":\"tableName\",\"type\":\"string\",\"description\":\"表名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"tableNameCh\":{\"name\":\"tableNameCh\",\"type\":\"string\",\"description\":\"表中文名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"packageName\":{\"name\":\"packageName\",\"type\":\"string\",\"description\":\"基本包路径\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"tablePrefix\":{\"name\":\"tablePrefix\",\"type\":\"string\",\"description\":\"表前缀\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"moduleName\":{\"name\":\"moduleName\",\"type\":\"string\",\"description\":\"模块名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"subModuleName\":{\"name\":\"subModuleName\",\"type\":\"string\",\"description\":\"二级模块名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"author\":{\"name\":\"author\",\"type\":\"string\",\"description\":\"作者\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"grade\":{\"name\":\"grade\",\"type\":\"integer\",\"description\":\"级别\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"ancestorId\":{\"name\":\"ancestorId\",\"type\":\"integer\",\"description\":\"祖级Id\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"parentId\":{\"name\":\"parentId\",\"type\":\"integer\",\"description\":\"父节点\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"parentTableName\":{\"name\":\"parentTableName\",\"type\":\"string\",\"description\":\"父节点表名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"interfaceReleaseStatus\":{\"name\":\"interfaceReleaseStatus\",\"type\":\"integer\",\"description\":\"接口发布状态\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"routeId\":{\"name\":\"routeId\",\"type\":\"string\",\"description\":\"ruteId\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"ddl\":{\"name\":\"ddl\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]}},\"description\":\"返回数据\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"数据建模实体字段 Dto\":{\"name\":\"数据建模实体字段 Dto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"entityId\":{\"name\":\"entityId\",\"type\":\"integer\",\"description\":\"实体Id\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"fieldName\":{\"name\":\"fieldName\",\"type\":\"string\",\"description\":\"字段名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"fieldNameCh\":{\"name\":\"fieldNameCh\",\"type\":\"string\",\"description\":\"字段名称注释\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"javaName\":{\"name\":\"javaName\",\"type\":\"string\",\"description\":\"java字段\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dbType\":{\"name\":\"dbType\",\"type\":\"string\",\"description\":\"数据库类型\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"length\":{\"name\":\"length\",\"type\":\"integer\",\"description\":\"长度\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"precision\":{\"name\":\"precision\",\"type\":\"integer\",\"description\":\"精度\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isNotNull\":{\"name\":\"isNotNull\",\"type\":\"integer\",\"description\":\"是否不为空\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isKey\":{\"name\":\"isKey\",\"type\":\"integer\",\"description\":\"是否主键\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isUnique\":{\"name\":\"isUnique\",\"type\":\"integer\",\"description\":\"是否唯一\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"defaultValue\":{\"name\":\"defaultValue\",\"type\":\"string\",\"description\":\"默认值\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"fkTableId\":{\"name\":\"fkTableId\",\"type\":\"integer\",\"description\":\"关联表ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"fkTableName\":{\"name\":\"fkTableName\",\"type\":\"string\",\"description\":\"关联表名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"fkFieldId\":{\"name\":\"fkFieldId\",\"type\":\"integer\",\"description\":\"关联表字段ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"fkFieldName\":{\"name\":\"fkFieldName\",\"type\":\"string\",\"description\":\"关联表字段名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"sort\":{\"name\":\"sort\",\"type\":\"integer\",\"description\":\"排序\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"实体对应的字段信息\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"数据建模实体 Dto\":{\"name\":\"数据建模实体 Dto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"appId\":{\"name\":\"appId\",\"type\":\"integer\",\"description\":\"AppId\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"appName\":{\"name\":\"appName\",\"type\":\"string\",\"description\":\"AppName\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appCode\":{\"name\":\"appCode\",\"type\":\"string\",\"description\":\"AppCode\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dbSourceId\":{\"name\":\"dbSourceId\",\"type\":\"integer\",\"description\":\"数据源\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"dbSource\":{\"name\":\"dbSource\",\"type\":\"string\",\"description\":\"数据源\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dbSourceType\":{\"name\":\"dbSourceType\",\"type\":\"string\",\"description\":\"类型\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"modelingName\":{\"name\":\"modelingName\",\"type\":\"string\",\"description\":\"模型名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"modelingCode\":{\"name\":\"modelingCode\",\"type\":\"string\",\"description\":\"模型编码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createType\":{\"name\":\"createType\",\"type\":\"integer\",\"description\":\"创建类型0 创建新表，1选现有表\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"tableName\":{\"name\":\"tableName\",\"type\":\"string\",\"description\":\"表名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"tableNameCh\":{\"name\":\"tableNameCh\",\"type\":\"string\",\"description\":\"表中文名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"packageName\":{\"name\":\"packageName\",\"type\":\"string\",\"description\":\"基本包路径\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"tablePrefix\":{\"name\":\"tablePrefix\",\"type\":\"string\",\"description\":\"表前缀\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"moduleName\":{\"name\":\"moduleName\",\"type\":\"string\",\"description\":\"模块名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"subModuleName\":{\"name\":\"subModuleName\",\"type\":\"string\",\"description\":\"二级模块名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"author\":{\"name\":\"author\",\"type\":\"string\",\"description\":\"作者\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"grade\":{\"name\":\"grade\",\"type\":\"integer\",\"description\":\"级别\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"parentId\":{\"name\":\"parentId\",\"type\":\"integer\",\"description\":\"父节点\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"parentTableName\":{\"name\":\"parentTableName\",\"type\":\"string\",\"description\":\"父节点表名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"interfaceReleaseStatus\":{\"name\":\"interfaceReleaseStatus\",\"type\":\"integer\",\"description\":\"接口发布状态\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"routeId\":{\"name\":\"routeId\",\"type\":\"string\",\"description\":\"ruteId\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"fieldList\":{\"name\":\"fieldList\",\"type\":\"array\",\"description\":\"实体对应的字段信息\",\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/数据建模实体字段 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"OrderItem\":{\"name\":\"OrderItem\",\"type\":\"object\",\"properties\":{\"column\":{\"name\":\"column\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"asc\":{\"name\":\"asc\",\"type\":\"boolean\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result数据建模实体 Vo\":{\"name\":\"Result数据建模实体 Vo\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"$ref\":\"#/components/schemas/数据建模实体 Vo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Page\":{\"name\":\"Page\",\"type\":\"object\",\"properties\":{\"records\":{\"name\":\"records\",\"type\":\"array\",\"exampleSetFlag\":true,\"items\":{\"type\":\"object\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"total\":{\"name\":\"total\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"size\":{\"name\":\"size\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"current\":{\"name\":\"current\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orders\":{\"name\":\"orders\",\"type\":\"array\",\"deprecated\":true,\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/OrderItem\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"optimizeCountSql\":{\"name\":\"optimizeCountSql\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"searchCount\":{\"name\":\"searchCount\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"optimizeJoinOfCountSql\":{\"name\":\"optimizeJoinOfCountSql\",\"type\":\"boolean\",\"writeOnly\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"maxLimit\":{\"name\":\"maxLimit\",\"type\":\"integer\",\"format\":\"int64\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"countId\":{\"name\":\"countId\",\"type\":\"string\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pages\":{\"name\":\"pages\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result\":{\"name\":\"Result\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"object\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}}},\"specVersion\":\"V30\"}', '2023-11-23 18:14:16', 'offline', 'main-modelingEntity', 'incloud-base-main', 'main', 'baseApi', '数据建模', 'ModelingEntity', 'save', 'Result');
INSERT INTO `incloud_base_mdm_openapi` VALUES (1727631641146126351, 'PUT', 'UFVUIC9tYWluL21vZGVsaW5nRW50aXR5', '模型实体树修改', '/main/modelingEntity', 'ModelingEntityController', '{\"openapi\":\"3.0.1\",\"info\":{\"title\":\"主模块\",\"description\":\"主模块\",\"termsOfService\":\"http://www.netwisd.com\",\"license\":{\"name\":\"云数网讯\",\"url\":\"http://www.netwisd.com\"},\"version\":\"5.0\"},\"servers\":[{\"url\":\"http://192.168.10.58:8001\",\"description\":\"Generated server url\"}],\"tags\":[{\"name\":\"数据建模\",\"description\":\"数据建模Controller\"}],\"paths\":{\"/modelingEntity\":{\"put\":{\"tags\":[\"数据建模\"],\"summary\":\"模型实体树修改\",\"operationId\":\"09281718\",\"requestBody\":{\"content\":{\"application/json\":{\"schema\":{\"$ref\":\"#/components/schemas/数据建模实体 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}},\"required\":true},\"responses\":{\"500\":{\"description\":\"Internal Server Error\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"404\":{\"description\":\"Not Found\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"200\":{\"description\":\"OK\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result数据建模实体 Vo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}}},\"extensions\":{\"methodName\":\"edit\",\"className\":\"ModelingEntityController\",\"class\":\"class com.netwisd.base.model.controller.ModelingEntityController\",\"returnType\":\"Result\"}}}},\"components\":{\"schemas\":{\"数据建模实体 Vo\":{\"name\":\"数据建模实体 Vo\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appId\":{\"name\":\"appId\",\"type\":\"integer\",\"description\":\"app_id\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"appName\":{\"name\":\"appName\",\"type\":\"string\",\"description\":\"app_name\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appCode\":{\"name\":\"appCode\",\"type\":\"string\",\"description\":\"app_code\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dbSourceId\":{\"name\":\"dbSourceId\",\"type\":\"integer\",\"description\":\"数据源\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"dbSource\":{\"name\":\"dbSource\",\"type\":\"string\",\"description\":\"数据源\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dbSourceType\":{\"name\":\"dbSourceType\",\"type\":\"string\",\"description\":\"类型\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"modelingName\":{\"name\":\"modelingName\",\"type\":\"string\",\"description\":\"模型名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"modelingCode\":{\"name\":\"modelingCode\",\"type\":\"string\",\"description\":\"模型编码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createType\":{\"name\":\"createType\",\"type\":\"integer\",\"description\":\"创建类型0 创建新表，1选现有表\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"tableName\":{\"name\":\"tableName\",\"type\":\"string\",\"description\":\"表名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"tableNameCh\":{\"name\":\"tableNameCh\",\"type\":\"string\",\"description\":\"表中文名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"packageName\":{\"name\":\"packageName\",\"type\":\"string\",\"description\":\"基本包路径\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"tablePrefix\":{\"name\":\"tablePrefix\",\"type\":\"string\",\"description\":\"表前缀\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"moduleName\":{\"name\":\"moduleName\",\"type\":\"string\",\"description\":\"模块名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"subModuleName\":{\"name\":\"subModuleName\",\"type\":\"string\",\"description\":\"二级模块名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"author\":{\"name\":\"author\",\"type\":\"string\",\"description\":\"作者\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"grade\":{\"name\":\"grade\",\"type\":\"integer\",\"description\":\"级别\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"ancestorId\":{\"name\":\"ancestorId\",\"type\":\"integer\",\"description\":\"祖级Id\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"parentId\":{\"name\":\"parentId\",\"type\":\"integer\",\"description\":\"父节点\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"parentTableName\":{\"name\":\"parentTableName\",\"type\":\"string\",\"description\":\"父节点表名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"interfaceReleaseStatus\":{\"name\":\"interfaceReleaseStatus\",\"type\":\"integer\",\"description\":\"接口发布状态\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"routeId\":{\"name\":\"routeId\",\"type\":\"string\",\"description\":\"ruteId\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"ddl\":{\"name\":\"ddl\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]}},\"description\":\"返回数据\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"数据建模实体字段 Dto\":{\"name\":\"数据建模实体字段 Dto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"entityId\":{\"name\":\"entityId\",\"type\":\"integer\",\"description\":\"实体Id\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"fieldName\":{\"name\":\"fieldName\",\"type\":\"string\",\"description\":\"字段名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"fieldNameCh\":{\"name\":\"fieldNameCh\",\"type\":\"string\",\"description\":\"字段名称注释\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"javaName\":{\"name\":\"javaName\",\"type\":\"string\",\"description\":\"java字段\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dbType\":{\"name\":\"dbType\",\"type\":\"string\",\"description\":\"数据库类型\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"length\":{\"name\":\"length\",\"type\":\"integer\",\"description\":\"长度\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"precision\":{\"name\":\"precision\",\"type\":\"integer\",\"description\":\"精度\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isNotNull\":{\"name\":\"isNotNull\",\"type\":\"integer\",\"description\":\"是否不为空\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isKey\":{\"name\":\"isKey\",\"type\":\"integer\",\"description\":\"是否主键\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isUnique\":{\"name\":\"isUnique\",\"type\":\"integer\",\"description\":\"是否唯一\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"defaultValue\":{\"name\":\"defaultValue\",\"type\":\"string\",\"description\":\"默认值\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"fkTableId\":{\"name\":\"fkTableId\",\"type\":\"integer\",\"description\":\"关联表ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"fkTableName\":{\"name\":\"fkTableName\",\"type\":\"string\",\"description\":\"关联表名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"fkFieldId\":{\"name\":\"fkFieldId\",\"type\":\"integer\",\"description\":\"关联表字段ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"fkFieldName\":{\"name\":\"fkFieldName\",\"type\":\"string\",\"description\":\"关联表字段名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"sort\":{\"name\":\"sort\",\"type\":\"integer\",\"description\":\"排序\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"实体对应的字段信息\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"数据建模实体 Dto\":{\"name\":\"数据建模实体 Dto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"appId\":{\"name\":\"appId\",\"type\":\"integer\",\"description\":\"AppId\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"appName\":{\"name\":\"appName\",\"type\":\"string\",\"description\":\"AppName\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appCode\":{\"name\":\"appCode\",\"type\":\"string\",\"description\":\"AppCode\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dbSourceId\":{\"name\":\"dbSourceId\",\"type\":\"integer\",\"description\":\"数据源\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"dbSource\":{\"name\":\"dbSource\",\"type\":\"string\",\"description\":\"数据源\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dbSourceType\":{\"name\":\"dbSourceType\",\"type\":\"string\",\"description\":\"类型\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"modelingName\":{\"name\":\"modelingName\",\"type\":\"string\",\"description\":\"模型名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"modelingCode\":{\"name\":\"modelingCode\",\"type\":\"string\",\"description\":\"模型编码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createType\":{\"name\":\"createType\",\"type\":\"integer\",\"description\":\"创建类型0 创建新表，1选现有表\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"tableName\":{\"name\":\"tableName\",\"type\":\"string\",\"description\":\"表名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"tableNameCh\":{\"name\":\"tableNameCh\",\"type\":\"string\",\"description\":\"表中文名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"packageName\":{\"name\":\"packageName\",\"type\":\"string\",\"description\":\"基本包路径\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"tablePrefix\":{\"name\":\"tablePrefix\",\"type\":\"string\",\"description\":\"表前缀\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"moduleName\":{\"name\":\"moduleName\",\"type\":\"string\",\"description\":\"模块名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"subModuleName\":{\"name\":\"subModuleName\",\"type\":\"string\",\"description\":\"二级模块名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"author\":{\"name\":\"author\",\"type\":\"string\",\"description\":\"作者\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"grade\":{\"name\":\"grade\",\"type\":\"integer\",\"description\":\"级别\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"parentId\":{\"name\":\"parentId\",\"type\":\"integer\",\"description\":\"父节点\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"parentTableName\":{\"name\":\"parentTableName\",\"type\":\"string\",\"description\":\"父节点表名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"interfaceReleaseStatus\":{\"name\":\"interfaceReleaseStatus\",\"type\":\"integer\",\"description\":\"接口发布状态\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"routeId\":{\"name\":\"routeId\",\"type\":\"string\",\"description\":\"ruteId\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"fieldList\":{\"name\":\"fieldList\",\"type\":\"array\",\"description\":\"实体对应的字段信息\",\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/数据建模实体字段 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"OrderItem\":{\"name\":\"OrderItem\",\"type\":\"object\",\"properties\":{\"column\":{\"name\":\"column\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"asc\":{\"name\":\"asc\",\"type\":\"boolean\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result数据建模实体 Vo\":{\"name\":\"Result数据建模实体 Vo\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"$ref\":\"#/components/schemas/数据建模实体 Vo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Page\":{\"name\":\"Page\",\"type\":\"object\",\"properties\":{\"records\":{\"name\":\"records\",\"type\":\"array\",\"exampleSetFlag\":true,\"items\":{\"type\":\"object\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"total\":{\"name\":\"total\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"size\":{\"name\":\"size\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"current\":{\"name\":\"current\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orders\":{\"name\":\"orders\",\"type\":\"array\",\"deprecated\":true,\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/OrderItem\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"optimizeCountSql\":{\"name\":\"optimizeCountSql\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"searchCount\":{\"name\":\"searchCount\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"optimizeJoinOfCountSql\":{\"name\":\"optimizeJoinOfCountSql\",\"type\":\"boolean\",\"writeOnly\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"maxLimit\":{\"name\":\"maxLimit\",\"type\":\"integer\",\"format\":\"int64\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"countId\":{\"name\":\"countId\",\"type\":\"string\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pages\":{\"name\":\"pages\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result\":{\"name\":\"Result\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"object\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}}},\"specVersion\":\"V30\"}', '2023-11-23 18:14:16', 'offline', 'main-modelingEntity', 'incloud-base-main', 'main', 'baseApi', '数据建模', 'ModelingEntity', 'edit', 'Result');
INSERT INTO `incloud_base_mdm_openapi` VALUES (1727631641146126352, 'POST', 'UE9TVCAvbWFpbi9tb2RlbEN1c3RvbVF1ZXJ5', '新增', '/main/modelCustomQuery', 'ModelCustomQueryController', '{\"openapi\":\"3.0.1\",\"info\":{\"title\":\"主模块\",\"description\":\"主模块\",\"termsOfService\":\"http://www.netwisd.com\",\"license\":{\"name\":\"云数网讯\",\"url\":\"http://www.netwisd.com\"},\"version\":\"5.0\"},\"servers\":[{\"url\":\"http://192.168.10.58:8001\",\"description\":\"Generated server url\"}],\"tags\":[{\"name\":\"自定义查询\",\"description\":\"表单Controller\"}],\"paths\":{\"/modelCustomQuery\":{\"post\":{\"tags\":[\"自定义查询\"],\"summary\":\"新增\",\"operationId\":\"10624892\",\"requestBody\":{\"content\":{\"application/json\":{\"schema\":{\"$ref\":\"#/components/schemas/自定义查询 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}},\"required\":true},\"responses\":{\"500\":{\"description\":\"Internal Server Error\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"404\":{\"description\":\"Not Found\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"200\":{\"description\":\"OK\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result自定义查询 Vo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}}},\"extensions\":{\"methodName\":\"save\",\"className\":\"ModelCustomQueryController\",\"class\":\"class com.netwisd.base.model.controller.ModelCustomQueryController\",\"returnType\":\"Result\"}}}},\"components\":{\"schemas\":{\"Result自定义查询 Vo\":{\"name\":\"Result自定义查询 Vo\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"$ref\":\"#/components/schemas/自定义查询 Vo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"OrderItem\":{\"name\":\"OrderItem\",\"type\":\"object\",\"properties\":{\"column\":{\"name\":\"column\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"asc\":{\"name\":\"asc\",\"type\":\"boolean\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Page\":{\"name\":\"Page\",\"type\":\"object\",\"properties\":{\"records\":{\"name\":\"records\",\"type\":\"array\",\"exampleSetFlag\":true,\"items\":{\"type\":\"object\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"total\":{\"name\":\"total\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"size\":{\"name\":\"size\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"current\":{\"name\":\"current\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orders\":{\"name\":\"orders\",\"type\":\"array\",\"deprecated\":true,\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/OrderItem\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"optimizeCountSql\":{\"name\":\"optimizeCountSql\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"searchCount\":{\"name\":\"searchCount\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"optimizeJoinOfCountSql\":{\"name\":\"optimizeJoinOfCountSql\",\"type\":\"boolean\",\"writeOnly\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"maxLimit\":{\"name\":\"maxLimit\",\"type\":\"integer\",\"format\":\"int64\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"countId\":{\"name\":\"countId\",\"type\":\"string\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pages\":{\"name\":\"pages\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"自定义查询 Vo\":{\"name\":\"自定义查询 Vo\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appId\":{\"name\":\"appId\",\"type\":\"integer\",\"description\":\"AppId\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"appName\":{\"name\":\"appName\",\"type\":\"string\",\"description\":\"AppName\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appCode\":{\"name\":\"appCode\",\"type\":\"string\",\"description\":\"AppCode\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"name\":{\"name\":\"name\",\"type\":\"string\",\"description\":\"名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"code\":{\"name\":\"code\",\"type\":\"string\",\"description\":\"编码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dsType\":{\"name\":\"dsType\",\"type\":\"string\",\"description\":\"数据来源\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"requestType\":{\"name\":\"requestType\",\"type\":\"string\",\"description\":\"请求类型\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dataParam\":{\"name\":\"dataParam\",\"type\":\"string\",\"description\":\"数据参数\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"operationId\":{\"name\":\"operationId\",\"type\":\"string\",\"description\":\"OpenApi接口唯一ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"openapiUrl\":{\"name\":\"openapiUrl\",\"type\":\"string\",\"description\":\"接口地址\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"openapiName\":{\"name\":\"openapiName\",\"type\":\"string\",\"description\":\"接口名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"listKey\":{\"name\":\"listKey\",\"type\":\"string\",\"description\":\"列表Key\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"resultField\":{\"name\":\"resultField\",\"type\":\"string\",\"description\":\"返回字段\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"conditionField\":{\"name\":\"conditionField\",\"type\":\"string\",\"description\":\"条件字段\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"displayField\":{\"name\":\"displayField\",\"type\":\"string\",\"description\":\"显示字段\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"needPage\":{\"name\":\"needPage\",\"type\":\"integer\",\"description\":\"是否分页\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"pageCurrentKey\":{\"name\":\"pageCurrentKey\",\"type\":\"string\",\"description\":\"当前页号\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pageSizeKey\":{\"name\":\"pageSizeKey\",\"type\":\"string\",\"description\":\"分页大小\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pageTotalKey\":{\"name\":\"pageTotalKey\",\"type\":\"string\",\"description\":\"总条数\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"customQueryContent\":{\"name\":\"customQueryContent\",\"type\":\"string\",\"description\":\"自定义查询内容\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]}},\"description\":\"返回数据\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"自定义查询 Dto\":{\"name\":\"自定义查询 Dto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"appId\":{\"name\":\"appId\",\"type\":\"integer\",\"description\":\"AppId\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"appName\":{\"name\":\"appName\",\"type\":\"string\",\"description\":\"AppName\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appCode\":{\"name\":\"appCode\",\"type\":\"string\",\"description\":\"AppCode\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"name\":{\"name\":\"name\",\"type\":\"string\",\"description\":\"名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"code\":{\"name\":\"code\",\"type\":\"string\",\"description\":\"编码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dsType\":{\"name\":\"dsType\",\"type\":\"string\",\"description\":\"数据来源\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"requestType\":{\"name\":\"requestType\",\"type\":\"string\",\"description\":\"请求类型\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dataParam\":{\"name\":\"dataParam\",\"type\":\"string\",\"description\":\"数据参数\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"operationId\":{\"name\":\"operationId\",\"type\":\"string\",\"description\":\"OpenApi接口唯一ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"openapiUrl\":{\"name\":\"openapiUrl\",\"type\":\"string\",\"description\":\"接口地址\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"openapiName\":{\"name\":\"openapiName\",\"type\":\"string\",\"description\":\"接口名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"listKey\":{\"name\":\"listKey\",\"type\":\"string\",\"description\":\"列表Key\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"resultField\":{\"name\":\"resultField\",\"type\":\"string\",\"description\":\"返回字段\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"conditionField\":{\"name\":\"conditionField\",\"type\":\"string\",\"description\":\"条件字段\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"displayField\":{\"name\":\"displayField\",\"type\":\"string\",\"description\":\"显示字段\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"needPage\":{\"name\":\"needPage\",\"type\":\"integer\",\"description\":\"是否分页\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"pageCurrentKey\":{\"name\":\"pageCurrentKey\",\"type\":\"string\",\"description\":\"当前页号\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pageSizeKey\":{\"name\":\"pageSizeKey\",\"type\":\"string\",\"description\":\"分页大小\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pageTotalKey\":{\"name\":\"pageTotalKey\",\"type\":\"string\",\"description\":\"总条数\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"customQueryContent\":{\"name\":\"customQueryContent\",\"type\":\"string\",\"description\":\"自定义查询内容\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result\":{\"name\":\"Result\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"object\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}}},\"specVersion\":\"V30\"}', '2023-11-23 18:14:16', 'offline', 'main-modelCustomQuery', 'incloud-base-main', 'main', 'baseApi', '自定义查询', 'ModelCustomQuery', 'save', 'Result');
INSERT INTO `incloud_base_mdm_openapi` VALUES (1727631641146126353, 'PUT', 'UFVUIC9tYWluL21vZGVsQ3VzdG9tUXVlcnk', '修改', '/main/modelCustomQuery', 'ModelCustomQueryController', '{\"openapi\":\"3.0.1\",\"info\":{\"title\":\"主模块\",\"description\":\"主模块\",\"termsOfService\":\"http://www.netwisd.com\",\"license\":{\"name\":\"云数网讯\",\"url\":\"http://www.netwisd.com\"},\"version\":\"5.0\"},\"servers\":[{\"url\":\"http://192.168.10.58:8001\",\"description\":\"Generated server url\"}],\"tags\":[{\"name\":\"自定义查询\",\"description\":\"表单Controller\"}],\"paths\":{\"/modelCustomQuery\":{\"put\":{\"tags\":[\"自定义查询\"],\"summary\":\"修改\",\"operationId\":\"09455851\",\"requestBody\":{\"content\":{\"application/json\":{\"schema\":{\"$ref\":\"#/components/schemas/自定义查询 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}},\"required\":true},\"responses\":{\"500\":{\"description\":\"Internal Server Error\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"404\":{\"description\":\"Not Found\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"200\":{\"description\":\"OK\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result自定义查询 Vo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}}},\"extensions\":{\"methodName\":\"edit\",\"className\":\"ModelCustomQueryController\",\"class\":\"class com.netwisd.base.model.controller.ModelCustomQueryController\",\"returnType\":\"Result\"}}}},\"components\":{\"schemas\":{\"Result自定义查询 Vo\":{\"name\":\"Result自定义查询 Vo\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"$ref\":\"#/components/schemas/自定义查询 Vo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"OrderItem\":{\"name\":\"OrderItem\",\"type\":\"object\",\"properties\":{\"column\":{\"name\":\"column\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"asc\":{\"name\":\"asc\",\"type\":\"boolean\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Page\":{\"name\":\"Page\",\"type\":\"object\",\"properties\":{\"records\":{\"name\":\"records\",\"type\":\"array\",\"exampleSetFlag\":true,\"items\":{\"type\":\"object\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"total\":{\"name\":\"total\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"size\":{\"name\":\"size\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"current\":{\"name\":\"current\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orders\":{\"name\":\"orders\",\"type\":\"array\",\"deprecated\":true,\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/OrderItem\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"optimizeCountSql\":{\"name\":\"optimizeCountSql\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"searchCount\":{\"name\":\"searchCount\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"optimizeJoinOfCountSql\":{\"name\":\"optimizeJoinOfCountSql\",\"type\":\"boolean\",\"writeOnly\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"maxLimit\":{\"name\":\"maxLimit\",\"type\":\"integer\",\"format\":\"int64\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"countId\":{\"name\":\"countId\",\"type\":\"string\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pages\":{\"name\":\"pages\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"自定义查询 Vo\":{\"name\":\"自定义查询 Vo\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appId\":{\"name\":\"appId\",\"type\":\"integer\",\"description\":\"AppId\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"appName\":{\"name\":\"appName\",\"type\":\"string\",\"description\":\"AppName\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appCode\":{\"name\":\"appCode\",\"type\":\"string\",\"description\":\"AppCode\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"name\":{\"name\":\"name\",\"type\":\"string\",\"description\":\"名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"code\":{\"name\":\"code\",\"type\":\"string\",\"description\":\"编码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dsType\":{\"name\":\"dsType\",\"type\":\"string\",\"description\":\"数据来源\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"requestType\":{\"name\":\"requestType\",\"type\":\"string\",\"description\":\"请求类型\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dataParam\":{\"name\":\"dataParam\",\"type\":\"string\",\"description\":\"数据参数\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"operationId\":{\"name\":\"operationId\",\"type\":\"string\",\"description\":\"OpenApi接口唯一ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"openapiUrl\":{\"name\":\"openapiUrl\",\"type\":\"string\",\"description\":\"接口地址\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"openapiName\":{\"name\":\"openapiName\",\"type\":\"string\",\"description\":\"接口名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"listKey\":{\"name\":\"listKey\",\"type\":\"string\",\"description\":\"列表Key\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"resultField\":{\"name\":\"resultField\",\"type\":\"string\",\"description\":\"返回字段\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"conditionField\":{\"name\":\"conditionField\",\"type\":\"string\",\"description\":\"条件字段\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"displayField\":{\"name\":\"displayField\",\"type\":\"string\",\"description\":\"显示字段\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"needPage\":{\"name\":\"needPage\",\"type\":\"integer\",\"description\":\"是否分页\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"pageCurrentKey\":{\"name\":\"pageCurrentKey\",\"type\":\"string\",\"description\":\"当前页号\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pageSizeKey\":{\"name\":\"pageSizeKey\",\"type\":\"string\",\"description\":\"分页大小\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pageTotalKey\":{\"name\":\"pageTotalKey\",\"type\":\"string\",\"description\":\"总条数\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"customQueryContent\":{\"name\":\"customQueryContent\",\"type\":\"string\",\"description\":\"自定义查询内容\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]}},\"description\":\"返回数据\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"自定义查询 Dto\":{\"name\":\"自定义查询 Dto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"appId\":{\"name\":\"appId\",\"type\":\"integer\",\"description\":\"AppId\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"appName\":{\"name\":\"appName\",\"type\":\"string\",\"description\":\"AppName\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appCode\":{\"name\":\"appCode\",\"type\":\"string\",\"description\":\"AppCode\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"name\":{\"name\":\"name\",\"type\":\"string\",\"description\":\"名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"code\":{\"name\":\"code\",\"type\":\"string\",\"description\":\"编码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dsType\":{\"name\":\"dsType\",\"type\":\"string\",\"description\":\"数据来源\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"requestType\":{\"name\":\"requestType\",\"type\":\"string\",\"description\":\"请求类型\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dataParam\":{\"name\":\"dataParam\",\"type\":\"string\",\"description\":\"数据参数\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"operationId\":{\"name\":\"operationId\",\"type\":\"string\",\"description\":\"OpenApi接口唯一ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"openapiUrl\":{\"name\":\"openapiUrl\",\"type\":\"string\",\"description\":\"接口地址\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"openapiName\":{\"name\":\"openapiName\",\"type\":\"string\",\"description\":\"接口名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"listKey\":{\"name\":\"listKey\",\"type\":\"string\",\"description\":\"列表Key\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"resultField\":{\"name\":\"resultField\",\"type\":\"string\",\"description\":\"返回字段\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"conditionField\":{\"name\":\"conditionField\",\"type\":\"string\",\"description\":\"条件字段\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"displayField\":{\"name\":\"displayField\",\"type\":\"string\",\"description\":\"显示字段\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"needPage\":{\"name\":\"needPage\",\"type\":\"integer\",\"description\":\"是否分页\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"pageCurrentKey\":{\"name\":\"pageCurrentKey\",\"type\":\"string\",\"description\":\"当前页号\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pageSizeKey\":{\"name\":\"pageSizeKey\",\"type\":\"string\",\"description\":\"分页大小\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pageTotalKey\":{\"name\":\"pageTotalKey\",\"type\":\"string\",\"description\":\"总条数\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"customQueryContent\":{\"name\":\"customQueryContent\",\"type\":\"string\",\"description\":\"自定义查询内容\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result\":{\"name\":\"Result\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"object\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}}},\"specVersion\":\"V30\"}', '2023-11-23 18:14:16', 'offline', 'main-modelCustomQuery', 'incloud-base-main', 'main', 'baseApi', '自定义查询', 'ModelCustomQuery', 'edit', 'Result');
INSERT INTO `incloud_base_mdm_openapi` VALUES (1727631641146126354, 'POST', 'UE9TVCAvbWFpbi9tZG1WaWV3', '新增', '/main/mdmView', 'ModelViewController', '{\"openapi\":\"3.0.1\",\"info\":{\"title\":\"主模块\",\"description\":\"主模块\",\"termsOfService\":\"http://www.netwisd.com\",\"license\":{\"name\":\"云数网讯\",\"url\":\"http://www.netwisd.com\"},\"version\":\"5.0\"},\"servers\":[{\"url\":\"http://192.168.10.58:8001\",\"description\":\"Generated server url\"}],\"tags\":[{\"name\":\"视图\",\"description\":\"视图Controller\"}],\"paths\":{\"/mdmView\":{\"post\":{\"tags\":[\"视图\"],\"summary\":\"新增\",\"operationId\":\"10928263\",\"requestBody\":{\"content\":{\"application/json\":{\"schema\":{\"$ref\":\"#/components/schemas/ModelViewDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}},\"required\":true},\"responses\":{\"500\":{\"description\":\"Internal Server Error\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"404\":{\"description\":\"Not Found\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"200\":{\"description\":\"OK\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/ResultModelViewVo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}}},\"extensions\":{\"methodName\":\"save\",\"className\":\"ModelViewController\",\"class\":\"class com.netwisd.base.model.controller.ModelViewController\",\"returnType\":\"Result\"}}}},\"components\":{\"schemas\":{\"ModelViewDto\":{\"name\":\"ModelViewDto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"viewCode\":{\"name\":\"viewCode\",\"type\":\"string\",\"description\":\"视图编码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"viewName\":{\"name\":\"viewName\",\"type\":\"string\",\"description\":\"视图名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"openApiOperationId\":{\"name\":\"openApiOperationId\",\"type\":\"string\",\"description\":\"OpenApiOperationId\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"openApiUrl\":{\"name\":\"openApiUrl\",\"type\":\"string\",\"description\":\"OpenApiUrl\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"viewType\":{\"name\":\"viewType\",\"type\":\"string\",\"description\":\"视图类型offline/online\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"onLineUrl\":{\"name\":\"onLineUrl\",\"type\":\"string\",\"description\":\"在线url\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"offLineUrl\":{\"name\":\"offLineUrl\",\"type\":\"string\",\"description\":\"离线url\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appId\":{\"name\":\"appId\",\"type\":\"integer\",\"description\":\"AppId\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"appName\":{\"name\":\"appName\",\"type\":\"string\",\"description\":\"AppName\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appCode\":{\"name\":\"appCode\",\"type\":\"string\",\"description\":\"AppCode\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"视图 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"OrderItem\":{\"name\":\"OrderItem\",\"type\":\"object\",\"properties\":{\"column\":{\"name\":\"column\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"asc\":{\"name\":\"asc\",\"type\":\"boolean\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Page\":{\"name\":\"Page\",\"type\":\"object\",\"properties\":{\"records\":{\"name\":\"records\",\"type\":\"array\",\"exampleSetFlag\":true,\"items\":{\"type\":\"object\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"total\":{\"name\":\"total\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"size\":{\"name\":\"size\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"current\":{\"name\":\"current\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orders\":{\"name\":\"orders\",\"type\":\"array\",\"deprecated\":true,\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/OrderItem\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"optimizeCountSql\":{\"name\":\"optimizeCountSql\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"searchCount\":{\"name\":\"searchCount\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"optimizeJoinOfCountSql\":{\"name\":\"optimizeJoinOfCountSql\",\"type\":\"boolean\",\"writeOnly\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"maxLimit\":{\"name\":\"maxLimit\",\"type\":\"integer\",\"format\":\"int64\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"countId\":{\"name\":\"countId\",\"type\":\"string\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pages\":{\"name\":\"pages\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"ModelViewVo\":{\"name\":\"ModelViewVo\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"viewCode\":{\"name\":\"viewCode\",\"type\":\"string\",\"description\":\"视图编码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"viewName\":{\"name\":\"viewName\",\"type\":\"string\",\"description\":\"视图名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"openApiOperationId\":{\"name\":\"openApiOperationId\",\"type\":\"string\",\"description\":\"OpenApiOperationId\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"openApiUrl\":{\"name\":\"openApiUrl\",\"type\":\"string\",\"description\":\"OpenApiUrl\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"viewType\":{\"name\":\"viewType\",\"type\":\"string\",\"description\":\"视图类型离线/在线\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"onLineUrl\":{\"name\":\"onLineUrl\",\"type\":\"string\",\"description\":\"在线url\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"offLineUrl\":{\"name\":\"offLineUrl\",\"type\":\"string\",\"description\":\"离线url\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appId\":{\"name\":\"appId\",\"type\":\"integer\",\"description\":\"AppId\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"appName\":{\"name\":\"appName\",\"type\":\"string\",\"description\":\"AppName\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appCode\":{\"name\":\"appCode\",\"type\":\"string\",\"description\":\"AppCode\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]}},\"description\":\"视图 Vo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"ResultModelViewVo\":{\"name\":\"ResultModelViewVo\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"$ref\":\"#/components/schemas/ModelViewVo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result\":{\"name\":\"Result\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"object\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}}},\"specVersion\":\"V30\"}', '2023-11-23 18:14:16', 'offline', 'main-mdmView', 'incloud-base-main', 'main', 'baseApi', '视图', 'ModelView', 'save', 'Result');
INSERT INTO `incloud_base_mdm_openapi` VALUES (1727631641146126355, 'PUT', 'UFVUIC9tYWluL21kbVZpZXc', '修改', '/main/mdmView', 'ModelViewController', '{\"openapi\":\"3.0.1\",\"info\":{\"title\":\"主模块\",\"description\":\"主模块\",\"termsOfService\":\"http://www.netwisd.com\",\"license\":{\"name\":\"云数网讯\",\"url\":\"http://www.netwisd.com\"},\"version\":\"5.0\"},\"servers\":[{\"url\":\"http://192.168.10.58:8001\",\"description\":\"Generated server url\"}],\"tags\":[{\"name\":\"视图\",\"description\":\"视图Controller\"}],\"paths\":{\"/mdmView\":{\"put\":{\"tags\":[\"视图\"],\"summary\":\"修改\",\"operationId\":\"09559151\",\"requestBody\":{\"content\":{\"application/json\":{\"schema\":{\"$ref\":\"#/components/schemas/ModelViewDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}},\"required\":true},\"responses\":{\"500\":{\"description\":\"Internal Server Error\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"404\":{\"description\":\"Not Found\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"200\":{\"description\":\"OK\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/ResultModelViewVo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}}},\"extensions\":{\"methodName\":\"edit\",\"className\":\"ModelViewController\",\"class\":\"class com.netwisd.base.model.controller.ModelViewController\",\"returnType\":\"Result\"}}}},\"components\":{\"schemas\":{\"ModelViewDto\":{\"name\":\"ModelViewDto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"viewCode\":{\"name\":\"viewCode\",\"type\":\"string\",\"description\":\"视图编码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"viewName\":{\"name\":\"viewName\",\"type\":\"string\",\"description\":\"视图名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"openApiOperationId\":{\"name\":\"openApiOperationId\",\"type\":\"string\",\"description\":\"OpenApiOperationId\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"openApiUrl\":{\"name\":\"openApiUrl\",\"type\":\"string\",\"description\":\"OpenApiUrl\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"viewType\":{\"name\":\"viewType\",\"type\":\"string\",\"description\":\"视图类型offline/online\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"onLineUrl\":{\"name\":\"onLineUrl\",\"type\":\"string\",\"description\":\"在线url\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"offLineUrl\":{\"name\":\"offLineUrl\",\"type\":\"string\",\"description\":\"离线url\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appId\":{\"name\":\"appId\",\"type\":\"integer\",\"description\":\"AppId\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"appName\":{\"name\":\"appName\",\"type\":\"string\",\"description\":\"AppName\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appCode\":{\"name\":\"appCode\",\"type\":\"string\",\"description\":\"AppCode\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"视图 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"OrderItem\":{\"name\":\"OrderItem\",\"type\":\"object\",\"properties\":{\"column\":{\"name\":\"column\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"asc\":{\"name\":\"asc\",\"type\":\"boolean\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Page\":{\"name\":\"Page\",\"type\":\"object\",\"properties\":{\"records\":{\"name\":\"records\",\"type\":\"array\",\"exampleSetFlag\":true,\"items\":{\"type\":\"object\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"total\":{\"name\":\"total\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"size\":{\"name\":\"size\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"current\":{\"name\":\"current\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orders\":{\"name\":\"orders\",\"type\":\"array\",\"deprecated\":true,\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/OrderItem\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"optimizeCountSql\":{\"name\":\"optimizeCountSql\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"searchCount\":{\"name\":\"searchCount\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"optimizeJoinOfCountSql\":{\"name\":\"optimizeJoinOfCountSql\",\"type\":\"boolean\",\"writeOnly\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"maxLimit\":{\"name\":\"maxLimit\",\"type\":\"integer\",\"format\":\"int64\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"countId\":{\"name\":\"countId\",\"type\":\"string\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pages\":{\"name\":\"pages\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"ModelViewVo\":{\"name\":\"ModelViewVo\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"viewCode\":{\"name\":\"viewCode\",\"type\":\"string\",\"description\":\"视图编码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"viewName\":{\"name\":\"viewName\",\"type\":\"string\",\"description\":\"视图名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"openApiOperationId\":{\"name\":\"openApiOperationId\",\"type\":\"string\",\"description\":\"OpenApiOperationId\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"openApiUrl\":{\"name\":\"openApiUrl\",\"type\":\"string\",\"description\":\"OpenApiUrl\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"viewType\":{\"name\":\"viewType\",\"type\":\"string\",\"description\":\"视图类型离线/在线\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"onLineUrl\":{\"name\":\"onLineUrl\",\"type\":\"string\",\"description\":\"在线url\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"offLineUrl\":{\"name\":\"offLineUrl\",\"type\":\"string\",\"description\":\"离线url\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appId\":{\"name\":\"appId\",\"type\":\"integer\",\"description\":\"AppId\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"appName\":{\"name\":\"appName\",\"type\":\"string\",\"description\":\"AppName\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appCode\":{\"name\":\"appCode\",\"type\":\"string\",\"description\":\"AppCode\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]}},\"description\":\"视图 Vo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"ResultModelViewVo\":{\"name\":\"ResultModelViewVo\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"$ref\":\"#/components/schemas/ModelViewVo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result\":{\"name\":\"Result\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"object\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}}},\"specVersion\":\"V30\"}', '2023-11-23 18:14:16', 'offline', 'main-mdmView', 'incloud-base-main', 'main', 'baseApi', '视图', 'ModelView', 'edit', 'Result');
INSERT INTO `incloud_base_mdm_openapi` VALUES (1727631641146126356, 'POST', 'UE9TVCAvbWFpbi9tZG1WaWV3VG1w', '新增', '/main/mdmViewTmp', 'ModelViewTmpController', '{\"openapi\":\"3.0.1\",\"info\":{\"title\":\"主模块\",\"description\":\"主模块\",\"termsOfService\":\"http://www.netwisd.com\",\"license\":{\"name\":\"云数网讯\",\"url\":\"http://www.netwisd.com\"},\"version\":\"5.0\"},\"servers\":[{\"url\":\"http://192.168.10.58:8001\",\"description\":\"Generated server url\"}],\"tags\":[{\"name\":\"在线视图模板\",\"description\":\"在线视图模板Controller\"},{\"name\":\"在线视图模板\",\"description\":\"在线表单模板Controller\"}],\"paths\":{\"/mdmViewTmp\":{\"post\":{\"tags\":[\"在线视图模板\"],\"summary\":\"新增\",\"operationId\":\"10972229\",\"requestBody\":{\"content\":{\"application/json\":{\"schema\":{\"$ref\":\"#/components/schemas/ModelViewTmpDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}},\"required\":true},\"responses\":{\"500\":{\"description\":\"Internal Server Error\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"404\":{\"description\":\"Not Found\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"200\":{\"description\":\"OK\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/ResultModelViewTmpVo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}}},\"extensions\":{\"methodName\":\"save\",\"className\":\"ModelViewTmpController\",\"class\":\"class com.netwisd.base.model.controller.ModelViewTmpController\",\"returnType\":\"Result\"}}}},\"components\":{\"schemas\":{\"ModelViewTmpVo\":{\"name\":\"ModelViewTmpVo\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"viewCode\":{\"name\":\"viewCode\",\"type\":\"string\",\"description\":\"视图编码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"viewName\":{\"name\":\"viewName\",\"type\":\"string\",\"description\":\"视图名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"viewContent\":{\"name\":\"viewContent\",\"type\":\"string\",\"description\":\"视图内容\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appId\":{\"name\":\"appId\",\"type\":\"integer\",\"description\":\"AppId\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"appName\":{\"name\":\"appName\",\"type\":\"string\",\"description\":\"AppName\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appCode\":{\"name\":\"appCode\",\"type\":\"string\",\"description\":\"AppCode\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]}},\"description\":\"在线视图模板 Vo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"OrderItem\":{\"name\":\"OrderItem\",\"type\":\"object\",\"properties\":{\"column\":{\"name\":\"column\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"asc\":{\"name\":\"asc\",\"type\":\"boolean\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"ModelViewTmpDto\":{\"name\":\"ModelViewTmpDto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"viewCode\":{\"name\":\"viewCode\",\"type\":\"string\",\"description\":\"视图编码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"viewName\":{\"name\":\"viewName\",\"type\":\"string\",\"description\":\"视图名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"viewContent\":{\"name\":\"viewContent\",\"type\":\"string\",\"description\":\"视图内容\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appId\":{\"name\":\"appId\",\"type\":\"integer\",\"description\":\"AppId\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"appName\":{\"name\":\"appName\",\"type\":\"string\",\"description\":\"AppName\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appCode\":{\"name\":\"appCode\",\"type\":\"string\",\"description\":\"AppCode\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"在线视图模板 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Page\":{\"name\":\"Page\",\"type\":\"object\",\"properties\":{\"records\":{\"name\":\"records\",\"type\":\"array\",\"exampleSetFlag\":true,\"items\":{\"type\":\"object\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"total\":{\"name\":\"total\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"size\":{\"name\":\"size\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"current\":{\"name\":\"current\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orders\":{\"name\":\"orders\",\"type\":\"array\",\"deprecated\":true,\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/OrderItem\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"optimizeCountSql\":{\"name\":\"optimizeCountSql\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"searchCount\":{\"name\":\"searchCount\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"optimizeJoinOfCountSql\":{\"name\":\"optimizeJoinOfCountSql\",\"type\":\"boolean\",\"writeOnly\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"maxLimit\":{\"name\":\"maxLimit\",\"type\":\"integer\",\"format\":\"int64\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"countId\":{\"name\":\"countId\",\"type\":\"string\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pages\":{\"name\":\"pages\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"ResultModelViewTmpVo\":{\"name\":\"ResultModelViewTmpVo\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"$ref\":\"#/components/schemas/ModelViewTmpVo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result\":{\"name\":\"Result\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"object\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}}},\"specVersion\":\"V30\"}', '2023-11-23 18:14:16', 'offline', 'main-mdmViewTmp', 'incloud-base-main', 'main', 'baseApi', '在线视图模板', 'ModelViewTmp', 'save', 'Result');
INSERT INTO `incloud_base_mdm_openapi` VALUES (1727631641146126357, 'PUT', 'UFVUIC9tYWluL21kbVZpZXdUbXA', '修改', '/main/mdmViewTmp', 'ModelViewTmpController', '{\"openapi\":\"3.0.1\",\"info\":{\"title\":\"主模块\",\"description\":\"主模块\",\"termsOfService\":\"http://www.netwisd.com\",\"license\":{\"name\":\"云数网讯\",\"url\":\"http://www.netwisd.com\"},\"version\":\"5.0\"},\"servers\":[{\"url\":\"http://192.168.10.58:8001\",\"description\":\"Generated server url\"}],\"tags\":[{\"name\":\"在线视图模板\",\"description\":\"在线视图模板Controller\"},{\"name\":\"在线视图模板\",\"description\":\"在线表单模板Controller\"}],\"paths\":{\"/mdmViewTmp\":{\"put\":{\"tags\":[\"在线视图模板\"],\"summary\":\"修改\",\"operationId\":\"09730547\",\"requestBody\":{\"content\":{\"application/json\":{\"schema\":{\"$ref\":\"#/components/schemas/ModelViewTmpDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}},\"required\":true},\"responses\":{\"500\":{\"description\":\"Internal Server Error\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"404\":{\"description\":\"Not Found\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"200\":{\"description\":\"OK\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/ResultModelViewTmpVo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}}},\"extensions\":{\"methodName\":\"edit\",\"className\":\"ModelViewTmpController\",\"class\":\"class com.netwisd.base.model.controller.ModelViewTmpController\",\"returnType\":\"Result\"}}}},\"components\":{\"schemas\":{\"ModelViewTmpVo\":{\"name\":\"ModelViewTmpVo\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"viewCode\":{\"name\":\"viewCode\",\"type\":\"string\",\"description\":\"视图编码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"viewName\":{\"name\":\"viewName\",\"type\":\"string\",\"description\":\"视图名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"viewContent\":{\"name\":\"viewContent\",\"type\":\"string\",\"description\":\"视图内容\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appId\":{\"name\":\"appId\",\"type\":\"integer\",\"description\":\"AppId\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"appName\":{\"name\":\"appName\",\"type\":\"string\",\"description\":\"AppName\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appCode\":{\"name\":\"appCode\",\"type\":\"string\",\"description\":\"AppCode\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]}},\"description\":\"在线视图模板 Vo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"OrderItem\":{\"name\":\"OrderItem\",\"type\":\"object\",\"properties\":{\"column\":{\"name\":\"column\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"asc\":{\"name\":\"asc\",\"type\":\"boolean\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"ModelViewTmpDto\":{\"name\":\"ModelViewTmpDto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"viewCode\":{\"name\":\"viewCode\",\"type\":\"string\",\"description\":\"视图编码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"viewName\":{\"name\":\"viewName\",\"type\":\"string\",\"description\":\"视图名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"viewContent\":{\"name\":\"viewContent\",\"type\":\"string\",\"description\":\"视图内容\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appId\":{\"name\":\"appId\",\"type\":\"integer\",\"description\":\"AppId\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"appName\":{\"name\":\"appName\",\"type\":\"string\",\"description\":\"AppName\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appCode\":{\"name\":\"appCode\",\"type\":\"string\",\"description\":\"AppCode\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"在线视图模板 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Page\":{\"name\":\"Page\",\"type\":\"object\",\"properties\":{\"records\":{\"name\":\"records\",\"type\":\"array\",\"exampleSetFlag\":true,\"items\":{\"type\":\"object\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"total\":{\"name\":\"total\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"size\":{\"name\":\"size\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"current\":{\"name\":\"current\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orders\":{\"name\":\"orders\",\"type\":\"array\",\"deprecated\":true,\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/OrderItem\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"optimizeCountSql\":{\"name\":\"optimizeCountSql\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"searchCount\":{\"name\":\"searchCount\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"optimizeJoinOfCountSql\":{\"name\":\"optimizeJoinOfCountSql\",\"type\":\"boolean\",\"writeOnly\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"maxLimit\":{\"name\":\"maxLimit\",\"type\":\"integer\",\"format\":\"int64\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"countId\":{\"name\":\"countId\",\"type\":\"string\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pages\":{\"name\":\"pages\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"ResultModelViewTmpVo\":{\"name\":\"ResultModelViewTmpVo\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"$ref\":\"#/components/schemas/ModelViewTmpVo\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result\":{\"name\":\"Result\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"object\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}}},\"specVersion\":\"V30\"}', '2023-11-23 18:14:16', 'offline', 'main-mdmViewTmp', 'incloud-base-main', 'main', 'baseApi', '在线视图模板', 'ModelViewTmp', 'edit', 'Result');
INSERT INTO `incloud_base_mdm_openapi` VALUES (1727631641146126358, 'POST', 'UE9TVCAvbWFpbi9tZG1Vc2Vy', '新增用户信息', '/main/mdmUser', 'MdmUserController', '{\"openapi\":\"3.0.1\",\"info\":{\"title\":\"主模块\",\"description\":\"主模块\",\"termsOfService\":\"http://www.netwisd.com\",\"license\":{\"name\":\"云数网讯\",\"url\":\"http://www.netwisd.com\"},\"version\":\"5.0\"},\"servers\":[{\"url\":\"http://192.168.10.58:8001\",\"description\":\"Generated server url\"}],\"tags\":[{\"name\":\"用户\",\"description\":\"用户Controller\"}],\"paths\":{\"/mdmUser\":{\"post\":{\"tags\":[\"用户\"],\"summary\":\"新增用户信息\",\"operationId\":\"10555481\",\"requestBody\":{\"content\":{\"application/json\":{\"schema\":{\"$ref\":\"#/components/schemas/MdmUserDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}},\"required\":true},\"responses\":{\"500\":{\"description\":\"Internal Server Error\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"404\":{\"description\":\"Not Found\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"200\":{\"description\":\"OK\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/ResultBoolean\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}}},\"extensions\":{\"methodName\":\"save\",\"className\":\"MdmUserController\",\"class\":\"class com.netwisd.base.mdm.controller.MdmUserController\",\"returnType\":\"Result\"}}}},\"components\":{\"schemas\":{\"MdmDutyUserDto\":{\"name\":\"MdmDutyUserDto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"orgFullDutyId\":{\"name\":\"orgFullDutyId\",\"type\":\"string\",\"description\":\"组织全路径职务ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"orgFullDutyName\":{\"name\":\"orgFullDutyName\",\"type\":\"string\",\"description\":\"组织全路径职务名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dutyId\":{\"name\":\"dutyId\",\"type\":\"integer\",\"description\":\"职务ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"dutyCode\":{\"name\":\"dutyCode\",\"type\":\"string\",\"description\":\"职务code\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dutyName\":{\"name\":\"dutyName\",\"type\":\"string\",\"description\":\"职务名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"userId\":{\"name\":\"userId\",\"type\":\"integer\",\"description\":\"用户ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"userName\":{\"name\":\"userName\",\"type\":\"string\",\"description\":\"用户名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"userNameCh\":{\"name\":\"userNameCh\",\"type\":\"string\",\"description\":\"用户中文名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"isMaster\":{\"name\":\"isMaster\",\"type\":\"integer\",\"description\":\"是否主岗\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"dutys\":{\"name\":\"dutys\",\"type\":\"array\",\"description\":\"职务\",\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/MdmDutyUserDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"职务与用户关系 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"OrderItem\":{\"name\":\"OrderItem\",\"type\":\"object\",\"properties\":{\"column\":{\"name\":\"column\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"asc\":{\"name\":\"asc\",\"type\":\"boolean\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Page\":{\"name\":\"Page\",\"type\":\"object\",\"properties\":{\"records\":{\"name\":\"records\",\"type\":\"array\",\"exampleSetFlag\":true,\"items\":{\"type\":\"object\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"total\":{\"name\":\"total\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"size\":{\"name\":\"size\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"current\":{\"name\":\"current\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orders\":{\"name\":\"orders\",\"type\":\"array\",\"deprecated\":true,\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/OrderItem\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"optimizeCountSql\":{\"name\":\"optimizeCountSql\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"searchCount\":{\"name\":\"searchCount\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"optimizeJoinOfCountSql\":{\"name\":\"optimizeJoinOfCountSql\",\"type\":\"boolean\",\"writeOnly\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"maxLimit\":{\"name\":\"maxLimit\",\"type\":\"integer\",\"format\":\"int64\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"countId\":{\"name\":\"countId\",\"type\":\"string\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pages\":{\"name\":\"pages\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"MdmUserDto\":{\"name\":\"MdmUserDto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"institutionId\":{\"name\":\"institutionId\",\"type\":\"integer\",\"description\":\"机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"institutionName\":{\"name\":\"institutionName\",\"type\":\"string\",\"description\":\"机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"orgId\":{\"name\":\"orgId\",\"type\":\"integer\",\"description\":\"机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orgName\":{\"name\":\"orgName\",\"type\":\"string\",\"description\":\"机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"orgType\":{\"name\":\"orgType\",\"type\":\"integer\",\"description\":\"组织类型\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orgFullId\":{\"name\":\"orgFullId\",\"type\":\"string\",\"description\":\"组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"orgFullName\":{\"name\":\"orgFullName\",\"type\":\"string\",\"description\":\"组织全路径名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"sort\":{\"name\":\"sort\",\"type\":\"integer\",\"description\":\"排序字段\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"userName\":{\"name\":\"userName\",\"type\":\"string\",\"description\":\"用户名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"userCode\":{\"name\":\"userCode\",\"type\":\"string\",\"description\":\"用户Code\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"userRank\":{\"name\":\"userRank\",\"type\":\"string\",\"description\":\"用户职级\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"oidPassWord\":{\"name\":\"oidPassWord\",\"type\":\"string\",\"description\":\"用户密码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"passWord\":{\"name\":\"passWord\",\"type\":\"string\",\"description\":\"用户密码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"userNameCh\":{\"name\":\"userNameCh\",\"type\":\"string\",\"description\":\"用户中文姓名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"cardType\":{\"name\":\"cardType\",\"type\":\"integer\",\"description\":\"证件类型：0居民身份证；1港澳居民来往内地通信证；2港澳居民居住证；3台湾居民来往大陆通行证；4台湾居民居住证；5外国护照；6外国人永久居留身份证；7外国人居留证；\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"sex\":{\"name\":\"sex\",\"type\":\"integer\",\"description\":\"性别\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"idCard\":{\"name\":\"idCard\",\"type\":\"string\",\"description\":\"证件号;0居民身份证；1港澳居民来往内地通信证；2港澳居民居住证；3台湾居民来往大陆通行证；4台湾居民居住证；5外国护照；6外国人永久居留身份证；7外国人居留证；\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"phoneNum\":{\"name\":\"phoneNum\",\"type\":\"string\",\"description\":\"手机号\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"officePhone\":{\"name\":\"officePhone\",\"type\":\"string\",\"description\":\"办公电话\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"email\":{\"name\":\"email\",\"type\":\"string\",\"description\":\"邮箱\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"instantMessenger\":{\"name\":\"instantMessenger\",\"type\":\"string\",\"description\":\"即时通信\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"employmentForm\":{\"name\":\"employmentForm\",\"type\":\"integer\",\"description\":\"用工形式;0试用；1正式；\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"employmentType\":{\"name\":\"employmentType\",\"type\":\"integer\",\"description\":\"用工类别;0合同制（正式员工）；1派遣制；2外包制（外协员工）；3临时工；4实习生；\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"status\":{\"name\":\"status\",\"type\":\"integer\",\"description\":\"状态;0禁用1启用\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"statusReason\":{\"name\":\"statusReason\",\"type\":\"string\",\"description\":\"状态原因\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"globalSort\":{\"name\":\"globalSort\",\"type\":\"integer\",\"description\":\"全局排序\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"globalSortSecond\":{\"name\":\"globalSortSecond\",\"type\":\"integer\",\"description\":\"辅助全局排序\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"hasKids\":{\"name\":\"hasKids\",\"type\":\"integer\",\"description\":\"是否有子集\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"dutyIds\":{\"name\":\"dutyIds\",\"type\":\"string\",\"description\":\"设置主职、兼职传的职位ids\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"photoFileId\":{\"name\":\"photoFileId\",\"type\":\"string\",\"description\":\"用户头像-上传的文件id\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"version\":{\"name\":\"version\",\"type\":\"integer\",\"description\":\"版本\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"ctsOwnerId\":{\"name\":\"ctsOwnerId\",\"type\":\"integer\",\"description\":\"查询条件 通讯录 所属人id\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"postUser\":{\"name\":\"postUser\",\"$ref\":\"#/components/schemas/MdmPostUserDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"dutyUser\":{\"name\":\"dutyUser\",\"$ref\":\"#/components/schemas/MdmDutyUserDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"isIncludeSub\":{\"name\":\"isIncludeSub\",\"type\":\"integer\",\"description\":\"是否包含子集\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"appId\":{\"name\":\"appId\",\"type\":\"integer\",\"description\":\"appId\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"contactGroupId\":{\"name\":\"contactGroupId\",\"type\":\"integer\",\"description\":\"常用联系人组ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"queryStartUpdateTime\":{\"name\":\"queryStartUpdateTime\",\"type\":\"string\",\"description\":\"根据修改时间之后查询\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"userIdIn\":{\"name\":\"userIdIn\",\"type\":\"array\",\"description\":\"通过用户ID集合，与其他查询条件联查\",\"exampleSetFlag\":true,\"items\":{\"type\":\"string\",\"description\":\"通过用户ID集合，与其他查询条件联查\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"userIdNotIn\":{\"name\":\"userIdNotIn\",\"type\":\"array\",\"description\":\"通过用户ID集合，与其他查询条件联查\",\"exampleSetFlag\":true,\"items\":{\"type\":\"string\",\"description\":\"通过用户ID集合，与其他查询条件联查\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"theme\":{\"name\":\"theme\",\"type\":\"string\",\"description\":\"主题\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"bizTheme\":{\"name\":\"bizTheme\",\"type\":\"string\",\"description\":\"业务端主题\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"用户 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"ResultBoolean\":{\"name\":\"ResultBoolean\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"boolean\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"MdmPostUserDto\":{\"name\":\"MdmPostUserDto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"orgFullPostId\":{\"name\":\"orgFullPostId\",\"type\":\"string\",\"description\":\"组织全路径岗位ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"orgFullPostName\":{\"name\":\"orgFullPostName\",\"type\":\"string\",\"description\":\"组织全路径岗位名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"postId\":{\"name\":\"postId\",\"type\":\"integer\",\"description\":\"岗位ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"postCode\":{\"name\":\"postCode\",\"type\":\"string\",\"description\":\"岗位code\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"postName\":{\"name\":\"postName\",\"type\":\"string\",\"description\":\"岗位名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"userId\":{\"name\":\"userId\",\"type\":\"integer\",\"description\":\"用户ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"userName\":{\"name\":\"userName\",\"type\":\"string\",\"description\":\"用户名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"userNameCh\":{\"name\":\"userNameCh\",\"type\":\"string\",\"description\":\"用户中文名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"isMaster\":{\"name\":\"isMaster\",\"type\":\"integer\",\"description\":\"是否主岗\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"posts\":{\"name\":\"posts\",\"type\":\"array\",\"description\":\"岗位Ids\",\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/MdmPostUserDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"岗位与用户关系 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result\":{\"name\":\"Result\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"object\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}}},\"specVersion\":\"V30\"}', '2023-11-23 18:14:16', 'offline', 'main-mdmUser', 'incloud-base-main', 'main', 'baseApi', '用户', 'MdmUser', 'save', 'Result');
INSERT INTO `incloud_base_mdm_openapi` VALUES (1727631641146126359, 'PUT', 'UFVUIC9tYWluL21kbVVzZXI', '修改用户信息', '/main/mdmUser', 'MdmUserController', '{\"openapi\":\"3.0.1\",\"info\":{\"title\":\"主模块\",\"description\":\"主模块\",\"termsOfService\":\"http://www.netwisd.com\",\"license\":{\"name\":\"云数网讯\",\"url\":\"http://www.netwisd.com\"},\"version\":\"5.0\"},\"servers\":[{\"url\":\"http://192.168.10.58:8001\",\"description\":\"Generated server url\"}],\"tags\":[{\"name\":\"用户\",\"description\":\"用户Controller\"}],\"paths\":{\"/mdmUser\":{\"put\":{\"tags\":[\"用户\"],\"summary\":\"修改用户信息\",\"operationId\":\"09095055\",\"requestBody\":{\"content\":{\"application/json\":{\"schema\":{\"$ref\":\"#/components/schemas/MdmUserDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}},\"required\":true},\"responses\":{\"500\":{\"description\":\"Internal Server Error\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"404\":{\"description\":\"Not Found\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"200\":{\"description\":\"OK\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/ResultBoolean\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}}},\"extensions\":{\"methodName\":\"update\",\"className\":\"MdmUserController\",\"class\":\"class com.netwisd.base.mdm.controller.MdmUserController\",\"returnType\":\"Result\"}}}},\"components\":{\"schemas\":{\"MdmDutyUserDto\":{\"name\":\"MdmDutyUserDto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"orgFullDutyId\":{\"name\":\"orgFullDutyId\",\"type\":\"string\",\"description\":\"组织全路径职务ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"orgFullDutyName\":{\"name\":\"orgFullDutyName\",\"type\":\"string\",\"description\":\"组织全路径职务名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dutyId\":{\"name\":\"dutyId\",\"type\":\"integer\",\"description\":\"职务ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"dutyCode\":{\"name\":\"dutyCode\",\"type\":\"string\",\"description\":\"职务code\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dutyName\":{\"name\":\"dutyName\",\"type\":\"string\",\"description\":\"职务名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"userId\":{\"name\":\"userId\",\"type\":\"integer\",\"description\":\"用户ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"userName\":{\"name\":\"userName\",\"type\":\"string\",\"description\":\"用户名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"userNameCh\":{\"name\":\"userNameCh\",\"type\":\"string\",\"description\":\"用户中文名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"isMaster\":{\"name\":\"isMaster\",\"type\":\"integer\",\"description\":\"是否主岗\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"dutys\":{\"name\":\"dutys\",\"type\":\"array\",\"description\":\"职务\",\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/MdmDutyUserDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"职务与用户关系 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"OrderItem\":{\"name\":\"OrderItem\",\"type\":\"object\",\"properties\":{\"column\":{\"name\":\"column\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"asc\":{\"name\":\"asc\",\"type\":\"boolean\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Page\":{\"name\":\"Page\",\"type\":\"object\",\"properties\":{\"records\":{\"name\":\"records\",\"type\":\"array\",\"exampleSetFlag\":true,\"items\":{\"type\":\"object\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"total\":{\"name\":\"total\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"size\":{\"name\":\"size\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"current\":{\"name\":\"current\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orders\":{\"name\":\"orders\",\"type\":\"array\",\"deprecated\":true,\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/OrderItem\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"optimizeCountSql\":{\"name\":\"optimizeCountSql\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"searchCount\":{\"name\":\"searchCount\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"optimizeJoinOfCountSql\":{\"name\":\"optimizeJoinOfCountSql\",\"type\":\"boolean\",\"writeOnly\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"maxLimit\":{\"name\":\"maxLimit\",\"type\":\"integer\",\"format\":\"int64\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"countId\":{\"name\":\"countId\",\"type\":\"string\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pages\":{\"name\":\"pages\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"MdmUserDto\":{\"name\":\"MdmUserDto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"institutionId\":{\"name\":\"institutionId\",\"type\":\"integer\",\"description\":\"机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"institutionName\":{\"name\":\"institutionName\",\"type\":\"string\",\"description\":\"机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"orgId\":{\"name\":\"orgId\",\"type\":\"integer\",\"description\":\"机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orgName\":{\"name\":\"orgName\",\"type\":\"string\",\"description\":\"机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"orgType\":{\"name\":\"orgType\",\"type\":\"integer\",\"description\":\"组织类型\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orgFullId\":{\"name\":\"orgFullId\",\"type\":\"string\",\"description\":\"组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"orgFullName\":{\"name\":\"orgFullName\",\"type\":\"string\",\"description\":\"组织全路径名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"sort\":{\"name\":\"sort\",\"type\":\"integer\",\"description\":\"排序字段\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"userName\":{\"name\":\"userName\",\"type\":\"string\",\"description\":\"用户名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"userCode\":{\"name\":\"userCode\",\"type\":\"string\",\"description\":\"用户Code\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"userRank\":{\"name\":\"userRank\",\"type\":\"string\",\"description\":\"用户职级\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"oidPassWord\":{\"name\":\"oidPassWord\",\"type\":\"string\",\"description\":\"用户密码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"passWord\":{\"name\":\"passWord\",\"type\":\"string\",\"description\":\"用户密码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"userNameCh\":{\"name\":\"userNameCh\",\"type\":\"string\",\"description\":\"用户中文姓名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"cardType\":{\"name\":\"cardType\",\"type\":\"integer\",\"description\":\"证件类型：0居民身份证；1港澳居民来往内地通信证；2港澳居民居住证；3台湾居民来往大陆通行证；4台湾居民居住证；5外国护照；6外国人永久居留身份证；7外国人居留证；\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"sex\":{\"name\":\"sex\",\"type\":\"integer\",\"description\":\"性别\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"idCard\":{\"name\":\"idCard\",\"type\":\"string\",\"description\":\"证件号;0居民身份证；1港澳居民来往内地通信证；2港澳居民居住证；3台湾居民来往大陆通行证；4台湾居民居住证；5外国护照；6外国人永久居留身份证；7外国人居留证；\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"phoneNum\":{\"name\":\"phoneNum\",\"type\":\"string\",\"description\":\"手机号\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"officePhone\":{\"name\":\"officePhone\",\"type\":\"string\",\"description\":\"办公电话\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"email\":{\"name\":\"email\",\"type\":\"string\",\"description\":\"邮箱\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"instantMessenger\":{\"name\":\"instantMessenger\",\"type\":\"string\",\"description\":\"即时通信\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"employmentForm\":{\"name\":\"employmentForm\",\"type\":\"integer\",\"description\":\"用工形式;0试用；1正式；\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"employmentType\":{\"name\":\"employmentType\",\"type\":\"integer\",\"description\":\"用工类别;0合同制（正式员工）；1派遣制；2外包制（外协员工）；3临时工；4实习生；\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"status\":{\"name\":\"status\",\"type\":\"integer\",\"description\":\"状态;0禁用1启用\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"statusReason\":{\"name\":\"statusReason\",\"type\":\"string\",\"description\":\"状态原因\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"globalSort\":{\"name\":\"globalSort\",\"type\":\"integer\",\"description\":\"全局排序\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"globalSortSecond\":{\"name\":\"globalSortSecond\",\"type\":\"integer\",\"description\":\"辅助全局排序\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"hasKids\":{\"name\":\"hasKids\",\"type\":\"integer\",\"description\":\"是否有子集\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"dutyIds\":{\"name\":\"dutyIds\",\"type\":\"string\",\"description\":\"设置主职、兼职传的职位ids\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"photoFileId\":{\"name\":\"photoFileId\",\"type\":\"string\",\"description\":\"用户头像-上传的文件id\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"version\":{\"name\":\"version\",\"type\":\"integer\",\"description\":\"版本\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"ctsOwnerId\":{\"name\":\"ctsOwnerId\",\"type\":\"integer\",\"description\":\"查询条件 通讯录 所属人id\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"postUser\":{\"name\":\"postUser\",\"$ref\":\"#/components/schemas/MdmPostUserDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"dutyUser\":{\"name\":\"dutyUser\",\"$ref\":\"#/components/schemas/MdmDutyUserDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"isIncludeSub\":{\"name\":\"isIncludeSub\",\"type\":\"integer\",\"description\":\"是否包含子集\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"appId\":{\"name\":\"appId\",\"type\":\"integer\",\"description\":\"appId\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"contactGroupId\":{\"name\":\"contactGroupId\",\"type\":\"integer\",\"description\":\"常用联系人组ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"queryStartUpdateTime\":{\"name\":\"queryStartUpdateTime\",\"type\":\"string\",\"description\":\"根据修改时间之后查询\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"userIdIn\":{\"name\":\"userIdIn\",\"type\":\"array\",\"description\":\"通过用户ID集合，与其他查询条件联查\",\"exampleSetFlag\":true,\"items\":{\"type\":\"string\",\"description\":\"通过用户ID集合，与其他查询条件联查\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"userIdNotIn\":{\"name\":\"userIdNotIn\",\"type\":\"array\",\"description\":\"通过用户ID集合，与其他查询条件联查\",\"exampleSetFlag\":true,\"items\":{\"type\":\"string\",\"description\":\"通过用户ID集合，与其他查询条件联查\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"theme\":{\"name\":\"theme\",\"type\":\"string\",\"description\":\"主题\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"bizTheme\":{\"name\":\"bizTheme\",\"type\":\"string\",\"description\":\"业务端主题\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"用户 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"ResultBoolean\":{\"name\":\"ResultBoolean\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"boolean\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"MdmPostUserDto\":{\"name\":\"MdmPostUserDto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"orgFullPostId\":{\"name\":\"orgFullPostId\",\"type\":\"string\",\"description\":\"组织全路径岗位ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"orgFullPostName\":{\"name\":\"orgFullPostName\",\"type\":\"string\",\"description\":\"组织全路径岗位名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"postId\":{\"name\":\"postId\",\"type\":\"integer\",\"description\":\"岗位ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"postCode\":{\"name\":\"postCode\",\"type\":\"string\",\"description\":\"岗位code\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"postName\":{\"name\":\"postName\",\"type\":\"string\",\"description\":\"岗位名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"userId\":{\"name\":\"userId\",\"type\":\"integer\",\"description\":\"用户ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"userName\":{\"name\":\"userName\",\"type\":\"string\",\"description\":\"用户名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"userNameCh\":{\"name\":\"userNameCh\",\"type\":\"string\",\"description\":\"用户中文名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"isMaster\":{\"name\":\"isMaster\",\"type\":\"integer\",\"description\":\"是否主岗\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"posts\":{\"name\":\"posts\",\"type\":\"array\",\"description\":\"岗位Ids\",\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/MdmPostUserDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"岗位与用户关系 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result\":{\"name\":\"Result\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"object\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}}},\"specVersion\":\"V30\"}', '2023-11-23 18:14:16', 'offline', 'main-mdmUser', 'incloud-base-main', 'main', 'baseApi', '用户', 'MdmUser', 'update', 'Result');
INSERT INTO `incloud_base_mdm_openapi` VALUES (1727631641146126360, 'PUT', 'UFVUIC9tYWluL21kbVVzZXIvY2VudGVyL3VwSW5mbw', '个人中心修改基本信息', '/main/mdmUser/center/upInfo', 'MdmUserController', '{\"openapi\":\"3.0.1\",\"info\":{\"title\":\"主模块\",\"description\":\"主模块\",\"termsOfService\":\"http://www.netwisd.com\",\"license\":{\"name\":\"云数网讯\",\"url\":\"http://www.netwisd.com\"},\"version\":\"5.0\"},\"servers\":[{\"url\":\"http://192.168.10.58:8001\",\"description\":\"Generated server url\"}],\"tags\":[{\"name\":\"用户\",\"description\":\"用户Controller\"}],\"paths\":{\"/mdmUser/center/upInfo\":{\"put\":{\"tags\":[\"用户\"],\"summary\":\"个人中心修改基本信息\",\"operationId\":\"09463135\",\"requestBody\":{\"content\":{\"application/json\":{\"schema\":{\"$ref\":\"#/components/schemas/MdmUserDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}},\"required\":true},\"responses\":{\"500\":{\"description\":\"Internal Server Error\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"404\":{\"description\":\"Not Found\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"200\":{\"description\":\"OK\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/ResultBoolean\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}}},\"extensions\":{\"methodName\":\"centerUpInfo\",\"className\":\"MdmUserController\",\"class\":\"class com.netwisd.base.mdm.controller.MdmUserController\",\"returnType\":\"Result\"}}}},\"components\":{\"schemas\":{\"MdmDutyUserDto\":{\"name\":\"MdmDutyUserDto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"orgFullDutyId\":{\"name\":\"orgFullDutyId\",\"type\":\"string\",\"description\":\"组织全路径职务ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"orgFullDutyName\":{\"name\":\"orgFullDutyName\",\"type\":\"string\",\"description\":\"组织全路径职务名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dutyId\":{\"name\":\"dutyId\",\"type\":\"integer\",\"description\":\"职务ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"dutyCode\":{\"name\":\"dutyCode\",\"type\":\"string\",\"description\":\"职务code\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dutyName\":{\"name\":\"dutyName\",\"type\":\"string\",\"description\":\"职务名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"userId\":{\"name\":\"userId\",\"type\":\"integer\",\"description\":\"用户ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"userName\":{\"name\":\"userName\",\"type\":\"string\",\"description\":\"用户名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"userNameCh\":{\"name\":\"userNameCh\",\"type\":\"string\",\"description\":\"用户中文名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"isMaster\":{\"name\":\"isMaster\",\"type\":\"integer\",\"description\":\"是否主岗\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"dutys\":{\"name\":\"dutys\",\"type\":\"array\",\"description\":\"职务\",\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/MdmDutyUserDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"职务与用户关系 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"OrderItem\":{\"name\":\"OrderItem\",\"type\":\"object\",\"properties\":{\"column\":{\"name\":\"column\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"asc\":{\"name\":\"asc\",\"type\":\"boolean\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Page\":{\"name\":\"Page\",\"type\":\"object\",\"properties\":{\"records\":{\"name\":\"records\",\"type\":\"array\",\"exampleSetFlag\":true,\"items\":{\"type\":\"object\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"total\":{\"name\":\"total\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"size\":{\"name\":\"size\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"current\":{\"name\":\"current\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orders\":{\"name\":\"orders\",\"type\":\"array\",\"deprecated\":true,\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/OrderItem\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"optimizeCountSql\":{\"name\":\"optimizeCountSql\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"searchCount\":{\"name\":\"searchCount\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"optimizeJoinOfCountSql\":{\"name\":\"optimizeJoinOfCountSql\",\"type\":\"boolean\",\"writeOnly\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"maxLimit\":{\"name\":\"maxLimit\",\"type\":\"integer\",\"format\":\"int64\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"countId\":{\"name\":\"countId\",\"type\":\"string\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pages\":{\"name\":\"pages\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"MdmUserDto\":{\"name\":\"MdmUserDto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"institutionId\":{\"name\":\"institutionId\",\"type\":\"integer\",\"description\":\"机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"institutionName\":{\"name\":\"institutionName\",\"type\":\"string\",\"description\":\"机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"orgId\":{\"name\":\"orgId\",\"type\":\"integer\",\"description\":\"机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orgName\":{\"name\":\"orgName\",\"type\":\"string\",\"description\":\"机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"orgType\":{\"name\":\"orgType\",\"type\":\"integer\",\"description\":\"组织类型\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orgFullId\":{\"name\":\"orgFullId\",\"type\":\"string\",\"description\":\"组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"orgFullName\":{\"name\":\"orgFullName\",\"type\":\"string\",\"description\":\"组织全路径名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"sort\":{\"name\":\"sort\",\"type\":\"integer\",\"description\":\"排序字段\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"userName\":{\"name\":\"userName\",\"type\":\"string\",\"description\":\"用户名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"userCode\":{\"name\":\"userCode\",\"type\":\"string\",\"description\":\"用户Code\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"userRank\":{\"name\":\"userRank\",\"type\":\"string\",\"description\":\"用户职级\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"oidPassWord\":{\"name\":\"oidPassWord\",\"type\":\"string\",\"description\":\"用户密码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"passWord\":{\"name\":\"passWord\",\"type\":\"string\",\"description\":\"用户密码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"userNameCh\":{\"name\":\"userNameCh\",\"type\":\"string\",\"description\":\"用户中文姓名\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"cardType\":{\"name\":\"cardType\",\"type\":\"integer\",\"description\":\"证件类型：0居民身份证；1港澳居民来往内地通信证；2港澳居民居住证；3台湾居民来往大陆通行证；4台湾居民居住证；5外国护照；6外国人永久居留身份证；7外国人居留证；\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"sex\":{\"name\":\"sex\",\"type\":\"integer\",\"description\":\"性别\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"idCard\":{\"name\":\"idCard\",\"type\":\"string\",\"description\":\"证件号;0居民身份证；1港澳居民来往内地通信证；2港澳居民居住证；3台湾居民来往大陆通行证；4台湾居民居住证；5外国护照；6外国人永久居留身份证；7外国人居留证；\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"phoneNum\":{\"name\":\"phoneNum\",\"type\":\"string\",\"description\":\"手机号\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"officePhone\":{\"name\":\"officePhone\",\"type\":\"string\",\"description\":\"办公电话\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"email\":{\"name\":\"email\",\"type\":\"string\",\"description\":\"邮箱\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"instantMessenger\":{\"name\":\"instantMessenger\",\"type\":\"string\",\"description\":\"即时通信\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"employmentForm\":{\"name\":\"employmentForm\",\"type\":\"integer\",\"description\":\"用工形式;0试用；1正式；\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"employmentType\":{\"name\":\"employmentType\",\"type\":\"integer\",\"description\":\"用工类别;0合同制（正式员工）；1派遣制；2外包制（外协员工）；3临时工；4实习生；\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"status\":{\"name\":\"status\",\"type\":\"integer\",\"description\":\"状态;0禁用1启用\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"statusReason\":{\"name\":\"statusReason\",\"type\":\"string\",\"description\":\"状态原因\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"globalSort\":{\"name\":\"globalSort\",\"type\":\"integer\",\"description\":\"全局排序\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"globalSortSecond\":{\"name\":\"globalSortSecond\",\"type\":\"integer\",\"description\":\"辅助全局排序\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"hasKids\":{\"name\":\"hasKids\",\"type\":\"integer\",\"description\":\"是否有子集\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"dutyIds\":{\"name\":\"dutyIds\",\"type\":\"string\",\"description\":\"设置主职、兼职传的职位ids\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"photoFileId\":{\"name\":\"photoFileId\",\"type\":\"string\",\"description\":\"用户头像-上传的文件id\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"version\":{\"name\":\"version\",\"type\":\"integer\",\"description\":\"版本\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"ctsOwnerId\":{\"name\":\"ctsOwnerId\",\"type\":\"integer\",\"description\":\"查询条件 通讯录 所属人id\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"postUser\":{\"name\":\"postUser\",\"$ref\":\"#/components/schemas/MdmPostUserDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"dutyUser\":{\"name\":\"dutyUser\",\"$ref\":\"#/components/schemas/MdmDutyUserDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"isIncludeSub\":{\"name\":\"isIncludeSub\",\"type\":\"integer\",\"description\":\"是否包含子集\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"appId\":{\"name\":\"appId\",\"type\":\"integer\",\"description\":\"appId\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"contactGroupId\":{\"name\":\"contactGroupId\",\"type\":\"integer\",\"description\":\"常用联系人组ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"queryStartUpdateTime\":{\"name\":\"queryStartUpdateTime\",\"type\":\"string\",\"description\":\"根据修改时间之后查询\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"userIdIn\":{\"name\":\"userIdIn\",\"type\":\"array\",\"description\":\"通过用户ID集合，与其他查询条件联查\",\"exampleSetFlag\":true,\"items\":{\"type\":\"string\",\"description\":\"通过用户ID集合，与其他查询条件联查\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"userIdNotIn\":{\"name\":\"userIdNotIn\",\"type\":\"array\",\"description\":\"通过用户ID集合，与其他查询条件联查\",\"exampleSetFlag\":true,\"items\":{\"type\":\"string\",\"description\":\"通过用户ID集合，与其他查询条件联查\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"theme\":{\"name\":\"theme\",\"type\":\"string\",\"description\":\"主题\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"bizTheme\":{\"name\":\"bizTheme\",\"type\":\"string\",\"description\":\"业务端主题\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"用户 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"ResultBoolean\":{\"name\":\"ResultBoolean\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"boolean\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"MdmPostUserDto\":{\"name\":\"MdmPostUserDto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"orgFullPostId\":{\"name\":\"orgFullPostId\",\"type\":\"string\",\"description\":\"组织全路径岗位ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"orgFullPostName\":{\"name\":\"orgFullPostName\",\"type\":\"string\",\"description\":\"组织全路径岗位名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"postId\":{\"name\":\"postId\",\"type\":\"integer\",\"description\":\"岗位ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"postCode\":{\"name\":\"postCode\",\"type\":\"string\",\"description\":\"岗位code\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"postName\":{\"name\":\"postName\",\"type\":\"string\",\"description\":\"岗位名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"userId\":{\"name\":\"userId\",\"type\":\"integer\",\"description\":\"用户ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"userName\":{\"name\":\"userName\",\"type\":\"string\",\"description\":\"用户名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"userNameCh\":{\"name\":\"userNameCh\",\"type\":\"string\",\"description\":\"用户中文名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"isMaster\":{\"name\":\"isMaster\",\"type\":\"integer\",\"description\":\"是否主岗\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"posts\":{\"name\":\"posts\",\"type\":\"array\",\"description\":\"岗位Ids\",\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/MdmPostUserDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"岗位与用户关系 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result\":{\"name\":\"Result\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"object\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}}},\"specVersion\":\"V30\"}', '2023-11-23 18:14:16', 'offline', 'main-mdmUser', 'incloud-base-main', 'main', 'baseApi', '用户', 'MdmUser', 'centerUpInfo', 'Result');
INSERT INTO `incloud_base_mdm_openapi` VALUES (1727631641146126361, 'POST', 'UE9TVCAvbWFpbi9tZG1Sb2xl', '新增角色', '/main/mdmRole', 'MdmRoleController', '{\"openapi\":\"3.0.1\",\"info\":{\"title\":\"主模块\",\"description\":\"主模块\",\"termsOfService\":\"http://www.netwisd.com\",\"license\":{\"name\":\"云数网讯\",\"url\":\"http://www.netwisd.com\"},\"version\":\"5.0\"},\"servers\":[{\"url\":\"http://192.168.10.58:8001\",\"description\":\"Generated server url\"}],\"tags\":[{\"name\":\"角色\",\"description\":\"角色Controller\"}],\"paths\":{\"/mdmRole\":{\"post\":{\"tags\":[\"角色\"],\"summary\":\"新增角色\",\"operationId\":\"11854405\",\"requestBody\":{\"content\":{\"application/json\":{\"schema\":{\"$ref\":\"#/components/schemas/MdmRoleDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}},\"required\":true},\"responses\":{\"500\":{\"description\":\"Internal Server Error\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"404\":{\"description\":\"Not Found\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"200\":{\"description\":\"OK\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/ResultBoolean\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}}},\"extensions\":{\"methodName\":\"save\",\"className\":\"MdmRoleController\",\"class\":\"class com.netwisd.base.mdm.controller.MdmRoleController\",\"returnType\":\"Result\"}}}},\"components\":{\"schemas\":{\"OrderItem\":{\"name\":\"OrderItem\",\"type\":\"object\",\"properties\":{\"column\":{\"name\":\"column\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"asc\":{\"name\":\"asc\",\"type\":\"boolean\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"MdmRoleAuthorityDetailDto\":{\"name\":\"MdmRoleAuthorityDetailDto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"authorityId\":{\"name\":\"authorityId\",\"type\":\"integer\",\"description\":\"角色授权Id\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"roleId\":{\"name\":\"roleId\",\"type\":\"integer\",\"description\":\"角色Id\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"roleCode\":{\"name\":\"roleCode\",\"type\":\"string\",\"description\":\"角色编码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dataId\":{\"name\":\"dataId\",\"type\":\"integer\",\"description\":\"数据ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"dataName\":{\"name\":\"dataName\",\"type\":\"string\",\"description\":\"数据名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dataOrgFullName\":{\"name\":\"dataOrgFullName\",\"type\":\"string\",\"description\":\"数据全路径名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"authType\":{\"name\":\"authType\",\"type\":\"integer\",\"description\":\"授权类型\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"角色 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Page\":{\"name\":\"Page\",\"type\":\"object\",\"properties\":{\"records\":{\"name\":\"records\",\"type\":\"array\",\"exampleSetFlag\":true,\"items\":{\"type\":\"object\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"total\":{\"name\":\"total\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"size\":{\"name\":\"size\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"current\":{\"name\":\"current\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orders\":{\"name\":\"orders\",\"type\":\"array\",\"deprecated\":true,\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/OrderItem\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"optimizeCountSql\":{\"name\":\"optimizeCountSql\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"searchCount\":{\"name\":\"searchCount\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"optimizeJoinOfCountSql\":{\"name\":\"optimizeJoinOfCountSql\",\"type\":\"boolean\",\"writeOnly\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"maxLimit\":{\"name\":\"maxLimit\",\"type\":\"integer\",\"format\":\"int64\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"countId\":{\"name\":\"countId\",\"type\":\"string\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pages\":{\"name\":\"pages\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"MdmRoleAuthorityDto\":{\"name\":\"MdmRoleAuthorityDto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"roleId\":{\"name\":\"roleId\",\"type\":\"integer\",\"description\":\"角色Id\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"roleCode\":{\"name\":\"roleCode\",\"type\":\"string\",\"description\":\"角色编码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"orgId\":{\"name\":\"orgId\",\"type\":\"integer\",\"description\":\"机构Id\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orgName\":{\"name\":\"orgName\",\"type\":\"string\",\"description\":\"机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"isIncludeSub\":{\"name\":\"isIncludeSub\",\"type\":\"integer\",\"description\":\"是否包含下级\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isAssignUser\":{\"name\":\"isAssignUser\",\"type\":\"integer\",\"description\":\"是否指定人员\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isAssignDept\":{\"name\":\"isAssignDept\",\"type\":\"integer\",\"description\":\"是否指定部门\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isAssignPost\":{\"name\":\"isAssignPost\",\"type\":\"integer\",\"description\":\"是否指定岗位\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isAssignDuty\":{\"name\":\"isAssignDuty\",\"type\":\"integer\",\"description\":\"是否指定职位\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"authorityDetailList\":{\"name\":\"authorityDetailList\",\"type\":\"array\",\"description\":\"角色授权详情\",\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/MdmRoleAuthorityDetailDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"角色 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"ResultBoolean\":{\"name\":\"ResultBoolean\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"boolean\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"MdmRoleDto\":{\"name\":\"MdmRoleDto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"roleCode\":{\"name\":\"roleCode\",\"type\":\"string\",\"description\":\"角色编码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"roleName\":{\"name\":\"roleName\",\"type\":\"string\",\"description\":\"角色名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"roleType\":{\"name\":\"roleType\",\"type\":\"integer\",\"description\":\"角色类型\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"sort\":{\"name\":\"sort\",\"type\":\"integer\",\"description\":\"排序字段\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"status\":{\"name\":\"status\",\"type\":\"integer\",\"description\":\"状态标识\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"version\":{\"name\":\"version\",\"type\":\"integer\",\"description\":\"version\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"roleDesc\":{\"name\":\"roleDesc\",\"type\":\"string\",\"description\":\"角色描述\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"roleId\":{\"name\":\"roleId\",\"type\":\"string\",\"description\":\"角色Id\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"bizResIds\":{\"name\":\"bizResIds\",\"type\":\"string\",\"description\":\"业务端资源ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"resIds\":{\"name\":\"resIds\",\"type\":\"string\",\"description\":\"管理端资源ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appId\":{\"name\":\"appId\",\"type\":\"integer\",\"description\":\"AppId\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"appName\":{\"name\":\"appName\",\"type\":\"string\",\"description\":\"AppName\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"isIncludeSub\":{\"name\":\"isIncludeSub\",\"type\":\"integer\",\"description\":\"是否包含下级\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isAssignUser\":{\"name\":\"isAssignUser\",\"type\":\"integer\",\"description\":\"是否指定人员\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isAssignDept\":{\"name\":\"isAssignDept\",\"type\":\"integer\",\"description\":\"是否指定部门\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isAssignPost\":{\"name\":\"isAssignPost\",\"type\":\"integer\",\"description\":\"是否指定岗位\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isAssignDuty\":{\"name\":\"isAssignDuty\",\"type\":\"integer\",\"description\":\"是否指定职位\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isGlobal\":{\"name\":\"isGlobal\",\"type\":\"integer\",\"description\":\"是否全局\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"authorityList\":{\"name\":\"authorityList\",\"type\":\"array\",\"description\":\"角色授权\",\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/MdmRoleAuthorityDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"角色 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Result\":{\"name\":\"Result\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"object\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"}}},\"specVersion\":\"V30\"}', '2023-11-23 18:14:16', 'offline', 'main-mdmRole', 'incloud-base-main', 'main', 'baseApi', '角色', 'MdmRole', 'save', 'Result');
INSERT INTO `incloud_base_mdm_openapi` VALUES (1727631641146126362, 'PUT', 'UFVUIC9tYWluL21kbVJvbGU', '修改角色', '/main/mdmRole', 'MdmRoleController', '{\"openapi\":\"3.0.1\",\"info\":{\"title\":\"主模块\",\"description\":\"主模块\",\"termsOfService\":\"http://www.netwisd.com\",\"license\":{\"name\":\"云数网讯\",\"url\":\"http://www.netwisd.com\"},\"version\":\"5.0\"},\"servers\":[{\"url\":\"http://192.168.10.58:8001\",\"description\":\"Generated server url\"}],\"tags\":[{\"name\":\"角色\",\"description\":\"角色Controller\"}],\"paths\":{\"/mdmRole\":{\"put\":{\"tags\":[\"角色\"],\"summary\":\"修改角色\",\"operationId\":\"09668476\",\"requestBody\":{\"content\":{\"application/json\":{\"schema\":{\"$ref\":\"#/components/schemas/MdmRoleDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}},\"required\":true},\"responses\":{\"500\":{\"description\":\"Internal Server Error\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"404\":{\"description\":\"Not Found\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/Result\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}},\"200\":{\"description\":\"OK\",\"content\":{\"*/*\":{\"schema\":{\"$ref\":\"#/components/schemas/ResultBoolean\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"exampleSetFlag\":false}}}},\"extensions\":{\"methodName\":\"update\",\"className\":\"MdmRoleController\",\"class\":\"class com.netwisd.base.mdm.controller.MdmRoleController\",\"returnType\":\"Result\"}}}},\"components\":{\"schemas\":{\"OrderItem\":{\"name\":\"OrderItem\",\"type\":\"object\",\"properties\":{\"column\":{\"name\":\"column\",\"type\":\"string\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"asc\":{\"name\":\"asc\",\"type\":\"boolean\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"MdmRoleAuthorityDetailDto\":{\"name\":\"MdmRoleAuthorityDetailDto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"authorityId\":{\"name\":\"authorityId\",\"type\":\"integer\",\"description\":\"角色授权Id\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"roleId\":{\"name\":\"roleId\",\"type\":\"integer\",\"description\":\"角色Id\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"roleCode\":{\"name\":\"roleCode\",\"type\":\"string\",\"description\":\"角色编码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dataId\":{\"name\":\"dataId\",\"type\":\"integer\",\"description\":\"数据ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"dataName\":{\"name\":\"dataName\",\"type\":\"string\",\"description\":\"数据名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"dataOrgFullName\":{\"name\":\"dataOrgFullName\",\"type\":\"string\",\"description\":\"数据全路径名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"authType\":{\"name\":\"authType\",\"type\":\"integer\",\"description\":\"授权类型\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"角色 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"Page\":{\"name\":\"Page\",\"type\":\"object\",\"properties\":{\"records\":{\"name\":\"records\",\"type\":\"array\",\"exampleSetFlag\":true,\"items\":{\"type\":\"object\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"object\"]},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"total\":{\"name\":\"total\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"size\":{\"name\":\"size\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"current\":{\"name\":\"current\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orders\":{\"name\":\"orders\",\"type\":\"array\",\"deprecated\":true,\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/OrderItem\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"optimizeCountSql\":{\"name\":\"optimizeCountSql\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"searchCount\":{\"name\":\"searchCount\",\"type\":\"boolean\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"optimizeJoinOfCountSql\":{\"name\":\"optimizeJoinOfCountSql\",\"type\":\"boolean\",\"writeOnly\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]},\"maxLimit\":{\"name\":\"maxLimit\",\"type\":\"integer\",\"format\":\"int64\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"countId\":{\"name\":\"countId\",\"type\":\"string\",\"deprecated\":true,\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"pages\":{\"name\":\"pages\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"MdmRoleAuthorityDto\":{\"name\":\"MdmRoleAuthorityDto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"roleId\":{\"name\":\"roleId\",\"type\":\"integer\",\"description\":\"角色Id\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"roleCode\":{\"name\":\"roleCode\",\"type\":\"string\",\"description\":\"角色编码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"orgId\":{\"name\":\"orgId\",\"type\":\"integer\",\"description\":\"机构Id\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"orgName\":{\"name\":\"orgName\",\"type\":\"string\",\"description\":\"机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"isIncludeSub\":{\"name\":\"isIncludeSub\",\"type\":\"integer\",\"description\":\"是否包含下级\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isAssignUser\":{\"name\":\"isAssignUser\",\"type\":\"integer\",\"description\":\"是否指定人员\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isAssignDept\":{\"name\":\"isAssignDept\",\"type\":\"integer\",\"description\":\"是否指定部门\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isAssignPost\":{\"name\":\"isAssignPost\",\"type\":\"integer\",\"description\":\"是否指定岗位\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isAssignDuty\":{\"name\":\"isAssignDuty\",\"type\":\"integer\",\"description\":\"是否指定职位\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"authorityDetailList\":{\"name\":\"authorityDetailList\",\"type\":\"array\",\"description\":\"角色授权详情\",\"exampleSetFlag\":true,\"items\":{\"$ref\":\"#/components/schemas/MdmRoleAuthorityDetailDto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"specVersion\":\"V30\",\"types\":[\"array\"]},\"generatorId\":{\"name\":\"generatorId\",\"type\":\"integer\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]}},\"description\":\"角色 Dto\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"ResultBoolean\":{\"name\":\"ResultBoolean\",\"type\":\"object\",\"properties\":{\"code\":{\"name\":\"code\",\"type\":\"integer\",\"description\":\"返回code\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"msg\":{\"name\":\"msg\",\"type\":\"string\",\"description\":\"返回msg\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"data\":{\"name\":\"data\",\"type\":\"boolean\",\"description\":\"返回数据\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"boolean\"]}},\"description\":\"统一返回结果集\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"MdmRoleDto\":{\"name\":\"MdmRoleDto\",\"type\":\"object\",\"properties\":{\"id\":{\"name\":\"id\",\"type\":\"integer\",\"description\":\"主键\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createTime\":{\"name\":\"createTime\",\"type\":\"string\",\"description\":\"create_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"updateTime\":{\"name\":\"updateTime\",\"type\":\"string\",\"description\":\"update_time\",\"format\":\"date-time\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserId\":{\"name\":\"createUserId\",\"type\":\"integer\",\"description\":\"创建人ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserName\":{\"name\":\"createUserName\",\"type\":\"string\",\"description\":\"创建人名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgId\":{\"name\":\"createUserOrgId\",\"type\":\"integer\",\"description\":\"父级机构ID\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"createUserOrgName\":{\"name\":\"createUserOrgName\",\"type\":\"string\",\"description\":\"父级机构名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"createUserOrgFullId\":{\"name\":\"createUserOrgFullId\",\"type\":\"string\",\"description\":\"父级组织全路径ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"page\":{\"name\":\"page\",\"$ref\":\"#/components/schemas/Page\",\"exampleSetFlag\":false,\"specVersion\":\"V30\"},\"roleCode\":{\"name\":\"roleCode\",\"type\":\"string\",\"description\":\"角色编码\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"roleName\":{\"name\":\"roleName\",\"type\":\"string\",\"description\":\"角色名称\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"roleType\":{\"name\":\"roleType\",\"type\":\"integer\",\"description\":\"角色类型\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"sort\":{\"name\":\"sort\",\"type\":\"integer\",\"description\":\"排序字段\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"status\":{\"name\":\"status\",\"type\":\"integer\",\"description\":\"状态标识\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"version\":{\"name\":\"version\",\"type\":\"integer\",\"description\":\"version\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"roleDesc\":{\"name\":\"roleDesc\",\"type\":\"string\",\"description\":\"角色描述\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"roleId\":{\"name\":\"roleId\",\"type\":\"string\",\"description\":\"角色Id\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"bizResIds\":{\"name\":\"bizResIds\",\"type\":\"string\",\"description\":\"业务端资源ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"resIds\":{\"name\":\"resIds\",\"type\":\"string\",\"description\":\"管理端资源ID\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"appId\":{\"name\":\"appId\",\"type\":\"integer\",\"description\":\"AppId\",\"format\":\"int64\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"appName\":{\"name\":\"appName\",\"type\":\"string\",\"description\":\"AppName\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"string\"]},\"isIncludeSub\":{\"name\":\"isIncludeSub\",\"type\":\"integer\",\"description\":\"是否包含下级\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isAssignUser\":{\"name\":\"isAssignUser\",\"type\":\"integer\",\"description\":\"是否指定人员\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isAssignDept\":{\"name\":\"isAssignDept\",\"type\":\"integer\",\"description\":\"是否指定部门\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isAssignPost\":{\"name\":\"isAssignPost\",\"type\":\"integer\",\"description\":\"是否指定岗位\",\"format\":\"int32\",\"exampleSetFlag\":true,\"specVersion\":\"V30\",\"types\":[\"integer\"]},\"isAssignDuty\":{\"name\":\"isAssignDuty\",\"type\":\"integer\",\"description\":\"是否指定职位\",\"format\"