/*
 Navicat Premium Data Transfer

 Source Server         : localhost_pg
 Source Server Type    : PostgreSQL
 Source Server Version : 160003 (160003)
 Source Host           : localhost:5432
 Source Catalog        : incloud5
 Source Schema         : incloud5

 Target Server Type    : PostgreSQL
 Target Server Version : 160003 (160003)
 File Encoding         : 65001

 Date: 01/08/2024 15:34:38
*/


-- ----------------------------
-- Table structure for incloud_base_app_application
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_app_application";
CREATE TABLE "incloud5"."incloud_base_app_application" (
  "id" int8 NOT NULL,
  "code" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "icon" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "sort" int4 NOT NULL,
  "description" varchar(255) COLLATE "pg_catalog"."default",
  "pool_name" varchar(500) COLLATE "pg_catalog"."default" NOT NULL,
  "create_time" timestamp(6),
  "update_time" timestamp(6),
  "create_user_id" int8,
  "create_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_full_id" varchar(2000) COLLATE "pg_catalog"."default",
  "create_user_org_id" int8,
  "create_user_org_name" varchar(255) COLLATE "pg_catalog"."default",
  "pool_id" int8 NOT NULL
)
;
ALTER TABLE "incloud5"."incloud_base_app_application" OWNER TO "root";
COMMENT ON COLUMN "incloud5"."incloud_base_app_application"."id" IS '主键';
COMMENT ON COLUMN "incloud5"."incloud_base_app_application"."code" IS '编码';
COMMENT ON COLUMN "incloud5"."incloud_base_app_application"."name" IS '名称';
COMMENT ON COLUMN "incloud5"."incloud_base_app_application"."icon" IS '图标';
COMMENT ON COLUMN "incloud5"."incloud_base_app_application"."sort" IS '排序';
COMMENT ON COLUMN "incloud5"."incloud_base_app_application"."description" IS '应用描述';
COMMENT ON COLUMN "incloud5"."incloud_base_app_application"."pool_name" IS '数据源';
COMMENT ON COLUMN "incloud5"."incloud_base_app_application"."create_time" IS '创建日期';
COMMENT ON COLUMN "incloud5"."incloud_base_app_application"."update_time" IS '修改日期';
COMMENT ON COLUMN "incloud5"."incloud_base_app_application"."create_user_id" IS '创建人ID';
COMMENT ON COLUMN "incloud5"."incloud_base_app_application"."create_user_name" IS '创建人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_app_application"."create_user_org_full_id" IS '创建人父级组织全路径ID';
COMMENT ON COLUMN "incloud5"."incloud_base_app_application"."create_user_org_id" IS '创建人父级机构ID';
COMMENT ON COLUMN "incloud5"."incloud_base_app_application"."create_user_org_name" IS '创建人父级机构名称';
COMMENT ON COLUMN "incloud5"."incloud_base_app_application"."pool_id" IS '数据源ID';
COMMENT ON TABLE "incloud5"."incloud_base_app_application" IS '微应用管理';

-- ----------------------------
-- Records of incloud_base_app_application
-- ----------------------------
BEGIN;
INSERT INTO "incloud5"."incloud_base_app_application" ("id", "code", "name", "icon", "sort", "description", "pool_name", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "create_user_org_id", "create_user_org_name", "pool_id") VALUES (1688812003631738882, 'taskManager', '任务中心', 'icon-n-n-shijianguanli', 2, NULL, 'master', '2023-08-08 15:18:53', '2023-08-08 15:18:53', 1, 'admin', '0', 0, 'root', 1661720027937050625);
INSERT INTO "incloud5"."incloud_base_app_application" ("id", "code", "name", "icon", "sort", "description", "pool_name", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "create_user_org_id", "create_user_org_name", "pool_id") VALUES (1727632910883581954, 'demo', '演示系统', 'icon-a-mainapplication', 1, NULL, 'master', '2023-11-23 18:19:18', '2023-11-23 18:19:18', 1, 'admin', '0', 0, 'root', 1690202859793518594);
COMMIT;

-- ----------------------------
-- Table structure for incloud_base_app_application_authority
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_app_application_authority";
CREATE TABLE "incloud5"."incloud_base_app_application_authority" (
  "id" int8 NOT NULL,
  "app_id" int8 NOT NULL,
  "user_id" int8 NOT NULL,
  "create_time" timestamp(6),
  "update_time" timestamp(6),
  "create_user_id" int8,
  "create_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_id" int8,
  "create_user_org_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_full_id" varchar(2000) COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "incloud5"."incloud_base_app_application_authority" OWNER TO "root";
COMMENT ON COLUMN "incloud5"."incloud_base_app_application_authority"."id" IS '主键';
COMMENT ON COLUMN "incloud5"."incloud_base_app_application_authority"."app_id" IS '应用id';
COMMENT ON COLUMN "incloud5"."incloud_base_app_application_authority"."user_id" IS '授权的用户ID';
COMMENT ON COLUMN "incloud5"."incloud_base_app_application_authority"."create_time" IS '创建日期';
COMMENT ON COLUMN "incloud5"."incloud_base_app_application_authority"."update_time" IS '修改日期';
COMMENT ON COLUMN "incloud5"."incloud_base_app_application_authority"."create_user_id" IS '创建人ID';
COMMENT ON COLUMN "incloud5"."incloud_base_app_application_authority"."create_user_name" IS '创建人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_app_application_authority"."create_user_org_id" IS '创建人父级机构ID';
COMMENT ON COLUMN "incloud5"."incloud_base_app_application_authority"."create_user_org_name" IS '创建人父级机构名称';
COMMENT ON COLUMN "incloud5"."incloud_base_app_application_authority"."create_user_org_full_id" IS '创建人父级组织全路径ID';

-- ----------------------------
-- Records of incloud_base_app_application_authority
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for incloud_base_center_done
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_center_done";
CREATE TABLE "incloud5"."incloud_base_center_done" (
  "id" int8 NOT NULL,
  "task_start_time" timestamp(6),
  "task_name" varchar(50) COLLATE "pg_catalog"."default",
  "task_start_userid" int8,
  "task_start_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "task_receive_person_type" int4,
  "task_receive_person_id" varchar(50) COLLATE "pg_catalog"."default",
  "task_receive_person_name" varchar(50) COLLATE "pg_catalog"."default",
  "task_todo_person_id" int8,
  "task_todo_person_name" varchar(50) COLLATE "pg_catalog"."default",
  "task_todo_org_name" varchar(50) COLLATE "pg_catalog"."default",
  "task_todo_org_id" int8,
  "task_todo_dept_name" varchar(50) COLLATE "pg_catalog"."default",
  "task_todo_dept_id" int8,
  "task_minute" int8,
  "task_state" int4,
  "sys_code" varchar(50) COLLATE "pg_catalog"."default",
  "sys_name" varchar(50) COLLATE "pg_catalog"."default",
  "is_main_task" int8,
  "task_level" int8,
  "task_source" varchar(255) COLLATE "pg_catalog"."default",
  "task_inst_id" int8,
  "apply_code" varchar(255) COLLATE "pg_catalog"."default",
  "apply_reason" varchar(1024) COLLATE "pg_catalog"."default",
  "create_time" timestamp(6),
  "update_time" timestamp(6),
  "create_user_id" int8,
  "create_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_full_id" varchar(2000) COLLATE "pg_catalog"."default",
  "task_type" int4,
  "task_end_time" timestamp(6),
  "schedule_type" int4,
  "task_classify_dict_code" varchar(50) COLLATE "pg_catalog"."default",
  "task_classify_dict_name" varchar(50) COLLATE "pg_catalog"."default",
  "priority" varchar(50) COLLATE "pg_catalog"."default",
  "participant_person_ids" varchar(255) COLLATE "pg_catalog"."default",
  "participant_person_names" varchar(255) COLLATE "pg_catalog"."default",
  "task_handle_start_time" timestamp(6),
  "task_handle_end_time" timestamp(6),
  "task_node_inst_id" int8,
  "create_user_org_id" int8,
  "create_user_org_name" varchar(255) COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "incloud5"."incloud_base_center_done" OWNER TO "root";
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."id" IS '主键';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."task_start_time" IS '任务发起时间';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."task_name" IS '任务名称';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."task_start_userid" IS '任务发起人';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."task_start_user_name" IS '任务发起人';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."task_receive_person_type" IS '任务接收人类型 1人2角色3职位4岗位';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."task_receive_person_id" IS '任务接收人,角色、职位、岗位存储的是Code码';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."task_receive_person_name" IS '任务接收人';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."task_todo_person_id" IS '任务办理人';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."task_todo_person_name" IS '任务办理人';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."task_todo_org_name" IS '任务办理机构';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."task_todo_org_id" IS '任务办理机构';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."task_todo_dept_name" IS '任务办理部门';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."task_todo_dept_id" IS '任务办理部门';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."task_minute" IS '办理时长';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."task_state" IS '任务状态 0.未开始1处理中2完成3.超期';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."sys_code" IS '子系统';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."sys_name" IS '子系统';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."is_main_task" IS '是否是主任务';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."task_level" IS '节点级别';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."task_source" IS '任务来源';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."task_inst_id" IS '任务实例Id';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."apply_code" IS '申请单号';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."apply_reason" IS '申请说明';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."create_time" IS '创建日期';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."update_time" IS '修改日期';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."create_user_id" IS '创建人ID';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."create_user_name" IS '创建人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."create_user_org_full_id" IS '创建人父级组织全路径ID';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."task_type" IS '任务类型1手动2系统';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."task_end_time" IS '任务结束日期';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."schedule_type" IS '日程类型1我的日程2他人日程';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."task_classify_dict_code" IS '任务分类';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."task_classify_dict_name" IS '任务分类';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."priority" IS '优先级';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."participant_person_ids" IS '参与人';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."participant_person_names" IS '参与人';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."task_handle_start_time" IS '任务实际办理开始时间';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."task_handle_end_time" IS '任务实际办理结束时间';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."task_node_inst_id" IS '任务节点Id';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."create_user_org_id" IS '创建人父级机构ID';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done"."create_user_org_name" IS '创建人父级机构名称';
COMMENT ON TABLE "incloud5"."incloud_base_center_done" IS '已办任务';

-- ----------------------------
-- Records of incloud_base_center_done
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for incloud_base_center_done_fun
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_center_done_fun";
CREATE TABLE "incloud5"."incloud_base_center_done_fun" (
  "id" int8 NOT NULL,
  "task_done_id" int8,
  "func_type" varchar(50) COLLATE "pg_catalog"."default",
  "fun_unique" varchar(50) COLLATE "pg_catalog"."default",
  "full_name" varchar(255) COLLATE "pg_catalog"."default",
  "func_param" text COLLATE "pg_catalog"."default",
  "camunda_procins_id" varchar(50) COLLATE "pg_catalog"."default",
  "camunda_procdef_key" varchar(50) COLLATE "pg_catalog"."default",
  "create_time" timestamp(6),
  "update_time" timestamp(6),
  "create_user_id" int8,
  "create_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_full_id" varchar(2000) COLLATE "pg_catalog"."default",
  "create_user_org_id" int8,
  "create_user_org_name" varchar(255) COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "incloud5"."incloud_base_center_done_fun" OWNER TO "root";
COMMENT ON COLUMN "incloud5"."incloud_base_center_done_fun"."id" IS '主键';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done_fun"."task_done_id" IS '已办任务id';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done_fun"."func_type" IS '功能类型';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done_fun"."fun_unique" IS '功能唯一标识';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done_fun"."full_name" IS '功能名称';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done_fun"."func_param" IS '功能参数';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done_fun"."camunda_procins_id" IS '流程实例Id';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done_fun"."camunda_procdef_key" IS '流程定义Id';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done_fun"."create_time" IS '创建日期';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done_fun"."update_time" IS '修改日期';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done_fun"."create_user_id" IS '创建人ID';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done_fun"."create_user_name" IS '创建人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done_fun"."create_user_org_full_id" IS '创建人父级组织全路径ID';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done_fun"."create_user_org_id" IS '创建人父级机构ID';
COMMENT ON COLUMN "incloud5"."incloud_base_center_done_fun"."create_user_org_name" IS '创建人父级机构名称';
COMMENT ON TABLE "incloud5"."incloud_base_center_done_fun" IS '已办任务功能';

-- ----------------------------
-- Records of incloud_base_center_done_fun
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for incloud_base_center_help
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_center_help";
CREATE TABLE "incloud5"."incloud_base_center_help" (
  "help_id" int4
)
;
ALTER TABLE "incloud5"."incloud_base_center_help" OWNER TO "root";

-- ----------------------------
-- Records of incloud_base_center_help
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for incloud_base_center_todo
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_center_todo";
CREATE TABLE "incloud5"."incloud_base_center_todo" (
  "id" int8 NOT NULL,
  "task_start_time" timestamp(6),
  "task_name" varchar(50) COLLATE "pg_catalog"."default",
  "task_start_userid" int8,
  "task_start_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "task_source" varchar(255) COLLATE "pg_catalog"."default",
  "task_receive_person_type" int4,
  "task_receive_person_id" varchar(50) COLLATE "pg_catalog"."default",
  "task_receive_person_name" varchar(50) COLLATE "pg_catalog"."default",
  "task_state" int4,
  "sys_code" varchar(50) COLLATE "pg_catalog"."default",
  "sys_name" varchar(50) COLLATE "pg_catalog"."default",
  "is_main_task" int8,
  "task_level" int8,
  "task_inst_id" int8,
  "task_node_inst_id" int8,
  "apply_code" varchar(255) COLLATE "pg_catalog"."default",
  "apply_reason" varchar(1024) COLLATE "pg_catalog"."default",
  "create_time" timestamp(6),
  "update_time" timestamp(6),
  "create_user_id" int8,
  "create_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_full_id" varchar(2000) COLLATE "pg_catalog"."default",
  "task_type" int4,
  "task_end_time" timestamp(6),
  "schedule_type" int4,
  "task_classify_dict_code" varchar(50) COLLATE "pg_catalog"."default",
  "task_classify_dict_name" varchar(50) COLLATE "pg_catalog"."default",
  "priority" varchar(50) COLLATE "pg_catalog"."default",
  "participant_person_ids" varchar(255) COLLATE "pg_catalog"."default",
  "participant_person_names" varchar(255) COLLATE "pg_catalog"."default",
  "finish_explain" varchar(900) COLLATE "pg_catalog"."default",
  "create_user_org_id" int8,
  "create_user_org_name" varchar(255) COLLATE "pg_catalog"."default",
  "participant_org_ids" varchar(255) COLLATE "pg_catalog"."default",
  "participant_org_names" varchar(255) COLLATE "pg_catalog"."default",
  "participant_contact_group_ids" varchar(255) COLLATE "pg_catalog"."default",
  "participant_contact_group_names" varchar(255) COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "incloud5"."incloud_base_center_todo" OWNER TO "root";
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."id" IS '主键';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."task_start_time" IS '任务发起时间';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."task_name" IS '任务名称';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."task_start_userid" IS '任务发起人';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."task_start_user_name" IS '任务发起人';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."task_source" IS '任务来源';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."task_receive_person_type" IS '任务接收人类型 1人2角色3职位4岗位';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."task_receive_person_id" IS '任务接收人,角色、职位、岗位存储的是Code码';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."task_receive_person_name" IS '任务接收人';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."task_state" IS '任务状态 0.未开始1处理中2完成3.超期';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."sys_code" IS '子系统';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."sys_name" IS '子系统';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."is_main_task" IS '是否是主任务';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."task_level" IS '节点级别';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."task_inst_id" IS '任务实例Id';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."task_node_inst_id" IS '任务节点Id';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."apply_code" IS '申请单号';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."apply_reason" IS '申请说明';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."create_time" IS '创建日期';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."update_time" IS '修改日期';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."create_user_id" IS '创建人ID';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."create_user_name" IS '创建人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."create_user_org_full_id" IS '创建人父级组织全路径ID';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."task_type" IS '任务类型1手动2系统';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."task_end_time" IS '任务结束日期';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."schedule_type" IS '日程类型1我的日程2他人日程';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."task_classify_dict_code" IS '任务分类';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."task_classify_dict_name" IS '任务分类';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."priority" IS '优先级';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."participant_person_ids" IS '参与人';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."participant_person_names" IS '参与人';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."finish_explain" IS '完成说明';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."create_user_org_id" IS '创建人父级机构ID';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."create_user_org_name" IS '创建人父级机构名称';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."participant_org_ids" IS '参与组织机构';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."participant_org_names" IS '参与组织机构';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."participant_contact_group_ids" IS '参与联系人组';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo"."participant_contact_group_names" IS '参与联系人组';
COMMENT ON TABLE "incloud5"."incloud_base_center_todo" IS '待办任务';

-- ----------------------------
-- Records of incloud_base_center_todo
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for incloud_base_center_todo_fun
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_center_todo_fun";
CREATE TABLE "incloud5"."incloud_base_center_todo_fun" (
  "id" int8 NOT NULL,
  "task_todo_id" int8,
  "fun_unique" varchar(50) COLLATE "pg_catalog"."default",
  "full_name" varchar(255) COLLATE "pg_catalog"."default",
  "func_param" text COLLATE "pg_catalog"."default",
  "func_type" varchar(50) COLLATE "pg_catalog"."default",
  "camunda_procins_id" varchar(50) COLLATE "pg_catalog"."default",
  "camunda_procdef_key" varchar(50) COLLATE "pg_catalog"."default",
  "create_time" timestamp(6),
  "update_time" timestamp(6),
  "create_user_id" int8,
  "create_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_full_id" varchar(2000) COLLATE "pg_catalog"."default",
  "create_user_org_id" int8,
  "create_user_org_name" varchar(255) COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "incloud5"."incloud_base_center_todo_fun" OWNER TO "root";
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_fun"."id" IS '主键';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_fun"."task_todo_id" IS '待办任务id';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_fun"."fun_unique" IS '功能唯一标识';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_fun"."full_name" IS '功能名称';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_fun"."func_param" IS '功能参数';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_fun"."func_type" IS '功能类型';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_fun"."camunda_procins_id" IS '流程实例Id';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_fun"."camunda_procdef_key" IS '流程定义Id';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_fun"."create_time" IS '创建日期';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_fun"."update_time" IS '修改日期';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_fun"."create_user_id" IS '创建人ID';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_fun"."create_user_name" IS '创建人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_fun"."create_user_org_full_id" IS '创建人父级组织全路径ID';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_fun"."create_user_org_id" IS '创建人父级机构ID';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_fun"."create_user_org_name" IS '创建人父级机构名称';
COMMENT ON TABLE "incloud5"."incloud_base_center_todo_fun" IS '待办任务功能';

-- ----------------------------
-- Records of incloud_base_center_todo_fun
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for incloud_base_center_todo_reminder
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_center_todo_reminder";
CREATE TABLE "incloud5"."incloud_base_center_todo_reminder" (
  "id" int8 NOT NULL,
  "task_todo_id" int8,
  "reminder_method" varchar(50) COLLATE "pg_catalog"."default",
  "reminder_time_type" varchar(10) COLLATE "pg_catalog"."default",
  "reminder_time" timestamp(6),
  "job_id" int8,
  "create_time" timestamp(6),
  "update_time" timestamp(6),
  "create_user_id" int8,
  "create_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_full_id" varchar(2000) COLLATE "pg_catalog"."default",
  "create_user_org_id" int8,
  "create_user_org_name" varchar(255) COLLATE "pg_catalog"."default",
  "reminder_user_ids" varchar(1024) COLLATE "pg_catalog"."default",
  "reminder_org_ids" varchar(1024) COLLATE "pg_catalog"."default",
  "reminder_contact_group_ids" varchar(1024) COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "incloud5"."incloud_base_center_todo_reminder" OWNER TO "root";
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_reminder"."id" IS '主键';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_reminder"."task_todo_id" IS '待办任务id';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_reminder"."reminder_method" IS '提醒方式1即时通2短信';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_reminder"."reminder_time_type" IS '提醒时间类型';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_reminder"."reminder_time" IS '提醒时间';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_reminder"."job_id" IS '定时调度任务Id';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_reminder"."create_time" IS '创建日期';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_reminder"."update_time" IS '修改日期';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_reminder"."create_user_id" IS '创建人ID';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_reminder"."create_user_name" IS '创建人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_reminder"."create_user_org_full_id" IS '创建人父级组织全路径ID';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_reminder"."create_user_org_id" IS '创建人父级机构ID';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_reminder"."create_user_org_name" IS '创建人父级机构名称';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_reminder"."reminder_user_ids" IS '提醒人';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_reminder"."reminder_org_ids" IS '提醒组织';
COMMENT ON COLUMN "incloud5"."incloud_base_center_todo_reminder"."reminder_contact_group_ids" IS '提醒常用联系人组';
COMMENT ON TABLE "incloud5"."incloud_base_center_todo_reminder" IS '待办任务提醒';

-- ----------------------------
-- Records of incloud_base_center_todo_reminder
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for incloud_base_cts_contact_group
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_cts_contact_group";
CREATE TABLE "incloud5"."incloud_base_cts_contact_group" (
  "id" int8 NOT NULL,
  "contact_group_name" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "create_time" timestamp(6),
  "update_time" timestamp(6),
  "create_user_id" int8,
  "create_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_id" int8,
  "create_user_org_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_full_id" varchar(2000) COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "incloud5"."incloud_base_cts_contact_group" OWNER TO "root";
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group"."id" IS '主键';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group"."contact_group_name" IS '常用联系人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group"."create_time" IS '创建日期';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group"."update_time" IS '修改日期';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group"."create_user_id" IS '创建人ID';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group"."create_user_name" IS '创建人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group"."create_user_org_id" IS '创建人父级机构ID';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group"."create_user_org_name" IS '创建人父级机构名称';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group"."create_user_org_full_id" IS '创建人父级组织全路径ID';
COMMENT ON TABLE "incloud5"."incloud_base_cts_contact_group" IS '常用联系组';

-- ----------------------------
-- Records of incloud_base_cts_contact_group
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for incloud_base_cts_contact_group_data
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_cts_contact_group_data";
CREATE TABLE "incloud5"."incloud_base_cts_contact_group_data" (
  "id" int8 NOT NULL,
  "contact_group_id" int8 NOT NULL,
  "contact_group_name" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "contact_group_data_type" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "contact_group_data_id" int8 NOT NULL,
  "contact_group_data_name" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "create_time" timestamp(6),
  "update_time" timestamp(6),
  "create_user_id" int8,
  "create_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_id" int8,
  "create_user_org_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_full_id" varchar(2000) COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "incloud5"."incloud_base_cts_contact_group_data" OWNER TO "root";
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group_data"."id" IS '主键';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group_data"."contact_group_id" IS '常用联系人组ID';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group_data"."contact_group_name" IS '常用联系人组名称';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group_data"."contact_group_data_type" IS '数据类型';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group_data"."contact_group_data_id" IS '数据ID';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group_data"."contact_group_data_name" IS '数据名称';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group_data"."create_time" IS '创建日期';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group_data"."update_time" IS '修改日期';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group_data"."create_user_id" IS '创建人ID';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group_data"."create_user_name" IS '创建人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group_data"."create_user_org_id" IS '创建人父级机构ID';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group_data"."create_user_org_name" IS '创建人父级机构名称';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group_data"."create_user_org_full_id" IS '创建人父级组织全路径ID';
COMMENT ON TABLE "incloud5"."incloud_base_cts_contact_group_data" IS '常用联系组数据';

-- ----------------------------
-- Records of incloud_base_cts_contact_group_data
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for incloud_base_cts_contact_group_user
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_cts_contact_group_user";
CREATE TABLE "incloud5"."incloud_base_cts_contact_group_user" (
  "id" int8 NOT NULL,
  "contact_group_id" int8 NOT NULL,
  "contact_group_name" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "contact_group_user_id" int8 NOT NULL,
  "contact_group_user_name" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "create_time" timestamp(6),
  "update_time" timestamp(6),
  "create_user_id" int8,
  "create_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_id" int8,
  "create_user_org_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_full_id" varchar(2000) COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "incloud5"."incloud_base_cts_contact_group_user" OWNER TO "root";
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group_user"."id" IS '主键';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group_user"."contact_group_id" IS '常用联系人组ID';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group_user"."contact_group_name" IS '常用联系人组名称';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group_user"."contact_group_user_id" IS '数据ID';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group_user"."contact_group_user_name" IS '数据名称';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group_user"."create_time" IS '创建日期';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group_user"."update_time" IS '修改日期';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group_user"."create_user_id" IS '创建人ID';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group_user"."create_user_name" IS '创建人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group_user"."create_user_org_id" IS '创建人父级机构ID';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group_user"."create_user_org_name" IS '创建人父级机构名称';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_contact_group_user"."create_user_org_full_id" IS '创建人父级组织全路径ID';
COMMENT ON TABLE "incloud5"."incloud_base_cts_contact_group_user" IS '常用联系组人员';

-- ----------------------------
-- Records of incloud_base_cts_contact_group_user
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for incloud_base_cts_multi_send_log
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_cts_multi_send_log";
CREATE TABLE "incloud5"."incloud_base_cts_multi_send_log" (
  "id" int8 NOT NULL,
  "msg_title" varchar(255) COLLATE "pg_catalog"."default",
  "msg_content" varchar(500) COLLATE "pg_catalog"."default" NOT NULL,
  "receiver_user_ids" varchar(3000) COLLATE "pg_catalog"."default",
  "receiver_user_names" varchar(3000) COLLATE "pg_catalog"."default",
  "receiver_dept_ids" varchar(3000) COLLATE "pg_catalog"."default",
  "receiver_dept_names" varchar(3000) COLLATE "pg_catalog"."default",
  "send_user_id" int8 NOT NULL,
  "send_user_name_ch" varchar(32) COLLATE "pg_catalog"."default" NOT NULL,
  "sms_msg_type" varchar(64) COLLATE "pg_catalog"."default",
  "create_time" timestamp(6),
  "update_time" timestamp(6),
  "create_user_id" int8,
  "create_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_id" int8,
  "create_user_org_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_full_id" varchar(2000) COLLATE "pg_catalog"."default",
  "receiver_group_ids" varchar(3000) COLLATE "pg_catalog"."default",
  "receiver_group_names" varchar(3000) COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "incloud5"."incloud_base_cts_multi_send_log" OWNER TO "root";
COMMENT ON COLUMN "incloud5"."incloud_base_cts_multi_send_log"."id" IS '主键';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_multi_send_log"."msg_title" IS '标题';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_multi_send_log"."msg_content" IS '内容';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_multi_send_log"."receiver_user_ids" IS '接收人ids';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_multi_send_log"."receiver_user_names" IS '接收人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_multi_send_log"."receiver_dept_ids" IS '接收部门ids';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_multi_send_log"."receiver_dept_names" IS '接收部门名称';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_multi_send_log"."send_user_id" IS '发送人id';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_multi_send_log"."send_user_name_ch" IS '发送人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_multi_send_log"."sms_msg_type" IS '消息类型';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_multi_send_log"."create_time" IS '创建日期';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_multi_send_log"."update_time" IS '修改日期';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_multi_send_log"."create_user_id" IS '创建人ID';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_multi_send_log"."create_user_name" IS '创建人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_multi_send_log"."create_user_org_id" IS '创建人父级机构ID';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_multi_send_log"."create_user_org_name" IS '创建人父级机构名称';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_multi_send_log"."create_user_org_full_id" IS '创建人父级组织全路径ID';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_multi_send_log"."receiver_group_ids" IS '接收部门ids';
COMMENT ON COLUMN "incloud5"."incloud_base_cts_multi_send_log"."receiver_group_names" IS '接收部门名称';
COMMENT ON TABLE "incloud5"."incloud_base_cts_multi_send_log" IS '通讯录消息群发记录';

-- ----------------------------
-- Records of incloud_base_cts_multi_send_log
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for incloud_base_demo_product
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_demo_product";
CREATE TABLE "incloud5"."incloud_base_demo_product" (
  "id" int8 NOT NULL,
  "code" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "batch_number" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "create_user_org_id" int8,
  "process_instance_id" varchar(64) COLLATE "pg_catalog"."default",
  "create_time" timestamp(6),
  "process_instance_status" int4,
  "update_time" timestamp(6),
  "create_user_id" int8,
  "create_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_full_id" varchar(2000) COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "incloud5"."incloud_base_demo_product" OWNER TO "root";
COMMENT ON COLUMN "incloud5"."incloud_base_demo_product"."id" IS '主键';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_product"."code" IS '商品编码';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_product"."name" IS '商品名称';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_product"."batch_number" IS '批次号';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_product"."create_user_org_id" IS '创建人机构ID';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_product"."process_instance_id" IS '流程实例id';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_product"."create_time" IS '创建日期';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_product"."process_instance_status" IS '流程实例状态';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_product"."update_time" IS '修改日期';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_product"."create_user_id" IS '创建人ID';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_product"."create_user_name" IS '创建人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_product"."create_user_org_name" IS '创建人机构名称';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_product"."create_user_org_full_id" IS '创建人父级组织全路径ID';
COMMENT ON TABLE "incloud5"."incloud_base_demo_product" IS '商品';

-- ----------------------------
-- Records of incloud_base_demo_product
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for incloud_base_demo_purchase
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_demo_purchase";
CREATE TABLE "incloud5"."incloud_base_demo_purchase" (
  "id" int8 NOT NULL,
  "ser_number" int4 NOT NULL,
  "reason" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "count" int4 NOT NULL,
  "apply_time" timestamp(6) NOT NULL,
  "type" int4 NOT NULL,
  "sum_price" numeric(10,2) NOT NULL,
  "remark" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_id" int8,
  "process_instance_id" varchar(64) COLLATE "pg_catalog"."default",
  "create_time" timestamp(6),
  "process_instance_status" int4,
  "update_time" timestamp(6),
  "create_user_id" int8,
  "create_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_full_id" varchar(2000) COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "incloud5"."incloud_base_demo_purchase" OWNER TO "root";
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase"."id" IS '主键';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase"."ser_number" IS '采购单号';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase"."reason" IS '申请原因';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase"."count" IS '采购数量';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase"."apply_time" IS '申请时间';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase"."type" IS '采购类型';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase"."sum_price" IS '采购总价';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase"."remark" IS '备注';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase"."create_user_org_id" IS '创建人机构ID';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase"."process_instance_id" IS '流程实例id';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase"."create_time" IS '创建日期';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase"."process_instance_status" IS '流程实例状态';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase"."update_time" IS '修改日期';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase"."create_user_id" IS '创建人ID';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase"."create_user_name" IS '创建人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase"."create_user_org_name" IS '创建人机构名称';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase"."create_user_org_full_id" IS '创建人父级组织全路径ID';
COMMENT ON TABLE "incloud5"."incloud_base_demo_purchase" IS '采购申请单';

-- ----------------------------
-- Records of incloud_base_demo_purchase
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for incloud_base_demo_purchase_detail
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_demo_purchase_detail";
CREATE TABLE "incloud5"."incloud_base_demo_purchase_detail" (
  "id" int8 NOT NULL,
  "purchase_id" int8 NOT NULL,
  "code" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "batch_number" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "price" numeric(10,2) NOT NULL,
  "count" int4,
  "sum_price" numeric(10,2),
  "create_user_org_id" int8,
  "process_instance_id" varchar(64) COLLATE "pg_catalog"."default",
  "create_time" timestamp(6),
  "process_instance_status" int4,
  "update_time" timestamp(6),
  "create_user_id" int8,
  "create_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_full_id" varchar(2000) COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "incloud5"."incloud_base_demo_purchase_detail" OWNER TO "root";
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase_detail"."id" IS '主键';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase_detail"."purchase_id" IS '采购单ID';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase_detail"."code" IS '商品编码';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase_detail"."name" IS '商品名称';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase_detail"."batch_number" IS '批次号';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase_detail"."price" IS '单品价格';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase_detail"."count" IS '数量';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase_detail"."sum_price" IS '合计总价';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase_detail"."create_user_org_id" IS '创建人机构ID';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase_detail"."process_instance_id" IS '流程实例id';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase_detail"."create_time" IS '创建日期';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase_detail"."process_instance_status" IS '流程实例状态';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase_detail"."update_time" IS '修改日期';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase_detail"."create_user_id" IS '创建人ID';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase_detail"."create_user_name" IS '创建人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase_detail"."create_user_org_name" IS '创建人机构名称';
COMMENT ON COLUMN "incloud5"."incloud_base_demo_purchase_detail"."create_user_org_full_id" IS '创建人父级组织全路径ID';
COMMENT ON TABLE "incloud5"."incloud_base_demo_purchase_detail" IS '采购申请单详情';

-- ----------------------------
-- Records of incloud_base_demo_purchase_detail
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for incloud_base_dict
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_dict";
CREATE TABLE "incloud5"."incloud_base_dict" (
  "id" int8 NOT NULL,
  "dict_name" varchar(100) COLLATE "pg_catalog"."default" NOT NULL,
  "dict_code" varchar(100) COLLATE "pg_catalog"."default" NOT NULL,
  "remark" varchar(100) COLLATE "pg_catalog"."default",
  "create_time" timestamp(6),
  "update_time" timestamp(6),
  "create_user_id" int8,
  "create_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_full_id" varchar(2000) COLLATE "pg_catalog"."default",
  "dict_type" int4,
  "dict_name_alias" varchar(100) COLLATE "pg_catalog"."default",
  "dict_code_alias" varchar(100) COLLATE "pg_catalog"."default",
  "create_user_org_id" int8,
  "create_user_org_name" varchar(255) COLLATE "pg_catalog"."default",
  "app_id" int8,
  "app_name" varchar(50) COLLATE "pg_catalog"."default",
  "dict_classify" int4
)
;
ALTER TABLE "incloud5"."incloud_base_dict" OWNER TO "root";
COMMENT ON COLUMN "incloud5"."incloud_base_dict"."id" IS '主键';
COMMENT ON COLUMN "incloud5"."incloud_base_dict"."dict_name" IS '字典名称';
COMMENT ON COLUMN "incloud5"."incloud_base_dict"."dict_code" IS '字典编码';
COMMENT ON COLUMN "incloud5"."incloud_base_dict"."remark" IS '备注';
COMMENT ON COLUMN "incloud5"."incloud_base_dict"."create_time" IS '创建日期';
COMMENT ON COLUMN "incloud5"."incloud_base_dict"."update_time" IS '修改日期';
COMMENT ON COLUMN "incloud5"."incloud_base_dict"."create_user_id" IS '创建人ID';
COMMENT ON COLUMN "incloud5"."incloud_base_dict"."create_user_name" IS '创建人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_dict"."create_user_org_full_id" IS '创建人父级组织全路径ID';
COMMENT ON COLUMN "incloud5"."incloud_base_dict"."dict_type" IS '字典类型';
COMMENT ON COLUMN "incloud5"."incloud_base_dict"."dict_name_alias" IS '字典名称别名';
COMMENT ON COLUMN "incloud5"."incloud_base_dict"."dict_code_alias" IS '字典编码别名';
COMMENT ON COLUMN "incloud5"."incloud_base_dict"."create_user_org_id" IS '创建人父级机构ID';
COMMENT ON COLUMN "incloud5"."incloud_base_dict"."create_user_org_name" IS '创建人父级机构名称';
COMMENT ON COLUMN "incloud5"."incloud_base_dict"."app_id" IS 'AppId';
COMMENT ON COLUMN "incloud5"."incloud_base_dict"."app_name" IS 'AppName';
COMMENT ON COLUMN "incloud5"."incloud_base_dict"."dict_classify" IS '字典分类';
COMMENT ON TABLE "incloud5"."incloud_base_dict" IS '字典';

-- ----------------------------
-- Records of incloud_base_dict
-- ----------------------------
BEGIN;
INSERT INTO "incloud5"."incloud_base_dict" ("id", "dict_name", "dict_code", "remark", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_type", "dict_name_alias", "dict_code_alias", "create_user_org_id", "create_user_org_name", "app_id", "app_name", "dict_classify") VALUES (1450345937061810178, '系统日志类型', 'SYSTEM_LOG_TYPE', NULL, '2021-10-19 14:19:52', '2021-10-19 14:19:52', NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1);
INSERT INTO "incloud5"."incloud_base_dict" ("id", "dict_name", "dict_code", "remark", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_type", "dict_name_alias", "dict_code_alias", "create_user_org_id", "create_user_org_name", "app_id", "app_name", "dict_classify") VALUES (1450346170210586625, '系统日志操作类型', 'SYSTEM_LOG_OPERATE_TYPE', NULL, '2021-10-19 14:20:48', '2021-10-19 14:20:48', NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1);
INSERT INTO "incloud5"."incloud_base_dict" ("id", "dict_name", "dict_code", "remark", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_type", "dict_name_alias", "dict_code_alias", "create_user_org_id", "create_user_org_name", "app_id", "app_name", "dict_classify") VALUES (1450395355265896450, '请求类型', 'REQUEST_TYPE', NULL, '2021-10-19 17:36:14', '2021-10-19 17:36:14', NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1);
INSERT INTO "incloud5"."incloud_base_dict" ("id", "dict_name", "dict_code", "remark", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_type", "dict_name_alias", "dict_code_alias", "create_user_org_id", "create_user_org_name", "app_id", "app_name", "dict_classify") VALUES (1450631776195055617, '系统名称', 'APP_NAME', '系统名称：工作流表单、日志使用', '2021-10-20 09:15:42', '2021-10-20 09:15:42', NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1);
INSERT INTO "incloud5"."incloud_base_dict" ("id", "dict_name", "dict_code", "remark", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_type", "dict_name_alias", "dict_code_alias", "create_user_org_id", "create_user_org_name", "app_id", "app_name", "dict_classify") VALUES (1452450906661457921, '日志级别', 'LOG_LEVEL', NULL, '2021-10-25 09:44:16', '2021-10-25 09:44:16', NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1);
INSERT INTO "incloud5"."incloud_base_dict" ("id", "dict_name", "dict_code", "remark", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_type", "dict_name_alias", "dict_code_alias", "create_user_org_id", "create_user_org_name", "app_id", "app_name", "dict_classify") VALUES (1458608540775092226, '数据建模子系统', 'MODEL_APP_NAME', NULL, '2021-11-11 09:32:30', '2021-11-11 09:32:30', 10000, 'admin', NULL, 1, '子系统名称', '子系统编码', NULL, NULL, NULL, NULL, 1);
INSERT INTO "incloud5"."incloud_base_dict" ("id", "dict_name", "dict_code", "remark", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_type", "dict_name_alias", "dict_code_alias", "create_user_org_id", "create_user_org_name", "app_id", "app_name", "dict_classify") VALUES (1458608751526285314, '数据建模按钮', 'MODEL_BUTTON', NULL, '2021-11-11 09:33:21', '2021-11-11 09:33:21', 10000, 'admin', NULL, 1, '按钮名称', '按钮编码', NULL, NULL, NULL, NULL, 1);
INSERT INTO "incloud5"."incloud_base_dict" ("id", "dict_name", "dict_code", "remark", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_type", "dict_name_alias", "dict_code_alias", "create_user_org_id", "create_user_org_name", "app_id", "app_name", "dict_classify") VALUES (1460859037615656961, '数据类型', 'MODEL_DB_TYPE', NULL, '2021-11-17 14:35:11', '2021-11-17 14:35:11', 0, 'admin', NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, 1);
INSERT INTO "incloud5"."incloud_base_dict" ("id", "dict_name", "dict_code", "remark", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_type", "dict_name_alias", "dict_code_alias", "create_user_org_id", "create_user_org_name", "app_id", "app_name", "dict_classify") VALUES (1508750085104603138, '工作流优先级', 'wfBizPriority', NULL, '2022-03-29 18:17:06', '2022-03-29 18:17:06', 0, 'admin', '0', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1);
INSERT INTO "incloud5"."incloud_base_dict" ("id", "dict_name", "dict_code", "remark", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_type", "dict_name_alias", "dict_code_alias", "create_user_org_id", "create_user_org_name", "app_id", "app_name", "dict_classify") VALUES (1572025848807460866, '日程分类', 'TASK-CLASSIFY', NULL, '2022-09-20 08:52:24', '2022-09-20 08:52:24', 0, 'admin', '0', 1, NULL, NULL, NULL, NULL, NULL, NULL, 1);
INSERT INTO "incloud5"."incloud_base_dict" ("id", "dict_name", "dict_code", "remark", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_type", "dict_name_alias", "dict_code_alias", "create_user_org_id", "create_user_org_name", "app_id", "app_name", "dict_classify") VALUES (1657599083668770817, '日程优先级', 'TASK-PRIORITY', '日程优先级', '2023-05-14 12:09:53', '2023-05-14 12:09:53', 1, 'admin', '0', 1, NULL, NULL, 0, NULL, NULL, NULL, 1);
INSERT INTO "incloud5"."incloud_base_dict" ("id", "dict_name", "dict_code", "remark", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_type", "dict_name_alias", "dict_code_alias", "create_user_org_id", "create_user_org_name", "app_id", "app_name", "dict_classify") VALUES (1657616436532023298, '日程提醒时间选项', 'TASK-REMINDER-TIME-TYPE', '日程提醒时间选项', '2023-05-14 13:18:50', '2023-05-14 13:18:50', 1, 'admin', '0', 1, NULL, NULL, 0, NULL, NULL, NULL, 1);
INSERT INTO "incloud5"."incloud_base_dict" ("id", "dict_name", "dict_code", "remark", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_type", "dict_name_alias", "dict_code_alias", "create_user_org_id", "create_user_org_name", "app_id", "app_name", "dict_classify") VALUES (1658025329381945345, '通讯录消息类型', 'CTS-REMINDER-TYPE', '通讯录消息类型', '2023-05-15 16:23:38', '2023-05-15 16:23:38', 1, 'admin', '0', 1, NULL, NULL, 0, NULL, NULL, NULL, 1);
INSERT INTO "incloud5"."incloud_base_dict" ("id", "dict_name", "dict_code", "remark", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_type", "dict_name_alias", "dict_code_alias", "create_user_org_id", "create_user_org_name", "app_id", "app_name", "dict_classify") VALUES (1660313137788342273, '日程提醒方式', 'TASK-REMINDER-TYPE', '日程提醒方式', '2023-05-21 23:54:34', '2023-05-21 23:54:34', 1, 'admin', '0', 1, NULL, NULL, 0, NULL, NULL, NULL, 1);
INSERT INTO "incloud5"."incloud_base_dict" ("id", "dict_name", "dict_code", "remark", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_type", "dict_name_alias", "dict_code_alias", "create_user_org_id", "create_user_org_name", "app_id", "app_name", "dict_classify") VALUES (1665598558092214273, '用户职级', 'MDM-USER-RANK', NULL, '2023-06-05 13:56:56', '2023-06-05 13:56:56', 1, 'admin', '0', 1, 'MDM-USER-RANK', NULL, 0, NULL, NULL, NULL, 1);
COMMIT;

-- ----------------------------
-- Table structure for incloud_base_dict_item
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_dict_item";
CREATE TABLE "incloud5"."incloud_base_dict_item" (
  "id" int8 NOT NULL,
  "dict_id" int8 NOT NULL,
  "dict_code" varchar(100) COLLATE "pg_catalog"."default" NOT NULL,
  "remark" varchar(100) COLLATE "pg_catalog"."default",
  "sort" int4,
  "create_time" timestamp(6),
  "update_time" timestamp(6),
  "create_user_id" int8,
  "create_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_full_id" varchar(2000) COLLATE "pg_catalog"."default",
  "dict_item_name" varchar(100) COLLATE "pg_catalog"."default" NOT NULL,
  "dict_item_code" varchar(100) COLLATE "pg_catalog"."default" NOT NULL,
  "is_enable" int4,
  "version" int4,
  "create_user_org_id" int8,
  "create_user_org_name" varchar(255) COLLATE "pg_catalog"."default",
  "parent_id" int8,
  "grade" int4
)
;
ALTER TABLE "incloud5"."incloud_base_dict_item" OWNER TO "root";
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item"."id" IS '主键';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item"."dict_id" IS '所属字典类id';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item"."dict_code" IS '字典编码';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item"."remark" IS '备注';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item"."sort" IS '排序值，默认升序';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item"."create_time" IS '创建日期';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item"."update_time" IS '修改日期';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item"."create_user_id" IS '创建人ID';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item"."create_user_name" IS '创建人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item"."create_user_org_full_id" IS '创建人父级组织全路径ID';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item"."dict_item_name" IS '字典项名称';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item"."dict_item_code" IS '字典项编码';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item"."is_enable" IS '是否启用';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item"."version" IS '版本号';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item"."create_user_org_id" IS '创建人父级机构ID';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item"."create_user_org_name" IS '创建人父级机构名称';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item"."parent_id" IS '父级ID';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item"."grade" IS '级别';
COMMENT ON TABLE "incloud5"."incloud_base_dict_item" IS '字典项';

-- ----------------------------
-- Records of incloud_base_dict_item
-- ----------------------------
BEGIN;
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1450346003923210241, 1450345937061810178, 'SYSTEM_LOG_TYPE', NULL, 1, '2021-10-19 14:20:08', '2021-10-19 14:20:08', NULL, NULL, NULL, '登录', 'LOG_TYPE_LOGIN', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1450346003923210245, 1450345937061810178, 'subordinate_platform', NULL, 1, '2021-10-19 14:20:08', '2021-10-19 14:20:08', NULL, NULL, NULL, '所属平台', 'subordinate_platform', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1450346037184040962, 1450345937061810178, 'SYSTEM_LOG_TYPE', NULL, 2, '2021-10-19 14:20:16', '2021-10-19 14:20:16', NULL, NULL, NULL, '退出', 'LOG_TYPE_LOGOUT', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1450346067802460161, 1450345937061810178, 'SYSTEM_LOG_TYPE', NULL, 3, '2021-10-19 14:20:23', '2021-10-19 14:20:23', NULL, NULL, NULL, '操作', 'LOG_TYPE_OPERATE', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1450346212854075393, 1450346170210586625, 'SYSTEM_LOG_OPERATE_TYPE', NULL, 1, '2021-10-19 14:20:58', '2021-10-19 14:20:58', NULL, NULL, NULL, '查询', 'OPERATE_TYPE_QUERY', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1450346251408117762, 1450346170210586625, 'SYSTEM_LOG_OPERATE_TYPE', NULL, 2, '2021-10-19 14:21:07', '2021-10-19 14:21:07', NULL, NULL, NULL, '添加', 'OPERATE_TYPE_ADD', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1450346280512393218, 1450346170210586625, 'SYSTEM_LOG_OPERATE_TYPE', NULL, 3, '2021-10-19 14:21:14', '2021-10-19 14:21:14', NULL, NULL, NULL, '更新', 'OPERATE_TYPE_EDIT', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1450346315375448066, 1450346170210586625, 'SYSTEM_LOG_OPERATE_TYPE', NULL, 4, '2021-10-19 14:21:22', '2021-10-19 14:21:22', NULL, NULL, NULL, '删除', 'OPERATE_TYPE_DEL', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1450346360703291393, 1450346170210586625, 'SYSTEM_LOG_OPERATE_TYPE', NULL, 5, '2021-10-19 14:21:33', '2021-10-19 14:21:33', NULL, NULL, NULL, '导入', 'OPERATE_TYPE_IMPORT', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1450346404990947330, 1450346170210586625, 'SYSTEM_LOG_OPERATE_TYPE', NULL, 6, '2021-10-19 14:21:44', '2021-10-19 14:21:44', NULL, NULL, NULL, '导出', 'OPERATE_TYPE_EXPORT', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1450395385561354241, 1450395355265896450, 'REQUEST_TYPE', NULL, NULL, '2021-10-19 17:36:22', '2021-11-10 17:17:38', NULL, NULL, NULL, 'GET', 'GET', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1450395405635293185, 1450395355265896450, 'REQUEST_TYPE', NULL, NULL, '2021-10-19 17:36:26', '2021-11-10 17:17:38', NULL, NULL, NULL, 'POST', 'POST', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1450395465253130241, 1450395355265896450, 'REQUEST_TYPE', NULL, NULL, '2021-10-19 17:36:41', '2021-11-10 17:17:38', NULL, NULL, NULL, 'DELETE', 'DELETE', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1450631878527684610, 1450631776195055617, 'APP_NAME', NULL, 5, '2021-10-20 09:16:06', '2022-03-09 16:02:25', NULL, NULL, NULL, 'Main', 'incloud-base-main', 0, 2, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1450631878527684611, 1450631776195055617, 'widgets-type', NULL, 5, '2021-10-20 09:16:06', '2022-03-09 16:02:25', NULL, NULL, NULL, '日常组件', 'widgets-type-day', 0, 2, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1450631958332706818, 1450631776195055617, 'APP_NAME', NULL, 2, '2021-10-20 09:16:25', '2022-03-09 16:02:25', NULL, NULL, NULL, '认证中心', 'incloud-base-oauth', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1450632022950154241, 1450631776195055617, 'APP_NAME', NULL, 1, '2021-10-20 09:16:40', '2022-03-09 16:02:25', NULL, NULL, NULL, '网关', 'incloud-base-gateway', 0, 2, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1452450940845035521, 1452450906661457921, 'LOG_LEVEL', NULL, NULL, '2021-10-25 09:44:24', '2021-10-25 09:44:24', NULL, NULL, NULL, 'INFO', 'INFO', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1452450957022466050, 1452450906661457921, 'LOG_LEVEL', NULL, NULL, '2021-10-25 09:44:28', '2021-10-25 09:44:28', NULL, NULL, NULL, 'ERROR', 'ERROR', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1458377286171496450, 1452450906661457921, 'LOG_LEVEL', NULL, NULL, '2021-11-10 18:13:35', '2021-11-10 18:13:35', 10000, 'admin', NULL, 'DEBUG', 'DEBUG', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1458377350004609026, 1452450906661457921, 'LOG_LEVEL', NULL, NULL, '2021-11-10 18:13:50', '2021-11-10 18:13:50', 10000, 'admin', NULL, 'WARN', 'WARN', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1460529719416983553, 1458608540775092226, 'MODEL_APP_NAME', NULL, NULL, '2021-11-16 16:46:35', '2021-11-25 09:44:43', 0, 'admin', NULL, '测试建模', 'csjm', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1460859285192839170, 1460859037615656961, 'MODEL_DB_TYPE', NULL, NULL, '2021-11-17 14:36:10', '2021-11-17 14:36:10', 0, 'admin', NULL, 'bigint', 'bigint', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1460859475123507201, 1460859037615656961, 'MODEL_DB_TYPE', NULL, NULL, '2021-11-17 14:36:55', '2021-11-17 14:36:55', 0, 'admin', NULL, 'int', 'int', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1460859573328941058, 1460859037615656961, 'MODEL_DB_TYPE', NULL, NULL, '2021-11-17 14:37:18', '2021-11-17 14:37:18', 0, 'admin', NULL, 'double', 'double', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1460859591347671041, 1460859037615656961, 'MODEL_DB_TYPE', NULL, NULL, '2021-11-17 14:37:23', '2021-11-17 14:37:23', 0, 'admin', NULL, 'decimal', 'decimal', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1460859780829548546, 1460859037615656961, 'MODEL_DB_TYPE', NULL, NULL, '2021-11-17 14:38:08', '2021-11-17 14:38:08', 0, 'admin', NULL, 'varchar', 'varchar', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1460859799477424130, 1460859037615656961, 'MODEL_DB_TYPE', NULL, NULL, '2021-11-17 14:38:12', '2021-11-17 14:38:12', 0, 'admin', NULL, 'char', 'char', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1460859841726648321, 1460859037615656961, 'MODEL_DB_TYPE', NULL, NULL, '2021-11-17 14:38:22', '2021-11-17 14:38:22', 0, 'admin', NULL, 'text', 'text', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1460859869614575618, 1460859037615656961, 'MODEL_DB_TYPE', NULL, NULL, '2021-11-17 14:38:29', '2021-11-17 14:38:29', 0, 'admin', NULL, 'longtext', 'longtext', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1460859887159349250, 1460859037615656961, 'MODEL_DB_TYPE', NULL, NULL, '2021-11-17 14:38:33', '2021-11-17 14:38:33', 0, 'admin', NULL, 'mediumtext', 'mediumtext', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1460859906201489409, 1460859037615656961, 'MODEL_DB_TYPE', NULL, NULL, '2021-11-17 14:38:38', '2021-11-17 14:38:38', 0, 'admin', NULL, 'date', 'date', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1460859924576735233, 1460859037615656961, 'MODEL_DB_TYPE', NULL, NULL, '2021-11-17 14:38:42', '2021-11-17 14:38:42', 0, 'admin', NULL, 'datetime', 'datetime', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1460859960383508481, 1460859037615656961, 'MODEL_DB_TYPE', NULL, NULL, '2021-11-17 14:38:51', '2021-11-17 14:38:51', 0, 'admin', NULL, 'timestamp', 'timestamp', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1463689311021961217, 1458608540775092226, 'MODEL_APP_NAME', NULL, NULL, '2021-11-25 10:01:40', '2021-11-25 10:01:40', 0, 'admin', NULL, '中原建', 'zyj', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1463761535779213313, 1450631776195055617, 'APP_NAME', NULL, 9, '2021-11-25 14:48:40', '2022-03-09 16:02:25', 0, 'admin', NULL, '在线学习', 'incloud-biz-study', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1465139977951121410, 1458608751526285314, 'MODEL_BUTTON', NULL, NULL, '2021-11-29 10:06:06', '2021-11-29 10:06:06', 0, 'admin', NULL, '保存', 'save', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1465140001359532034, 1458608751526285314, 'MODEL_BUTTON', NULL, NULL, '2021-11-29 10:06:12', '2021-11-29 10:06:12', 0, 'admin', NULL, '修改', 'update', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1465140024759554050, 1458608751526285314, 'MODEL_BUTTON', NULL, NULL, '2021-11-29 10:06:18', '2021-11-29 10:06:18', 0, 'admin', NULL, '删除', 'del', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1465140068032188418, 1458608751526285314, 'MODEL_BUTTON', NULL, NULL, '2021-11-29 10:06:28', '2021-11-29 10:06:28', 0, 'admin', NULL, '查询', 'query', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1465140107471228930, 1458608751526285314, 'MODEL_BUTTON', NULL, NULL, '2021-11-29 10:06:37', '2021-11-29 10:06:37', 0, 'admin', NULL, '提交', 'submit', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1465614921600339969, 1465614808781950978, 'Study_Exam_Database_Def', NULL, 1, '2021-11-30 17:33:22', '2021-11-30 17:33:22', 0, 'admin', NULL, '测试_1', 'ceshi', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1475779591313297409, 1475779482399805441, 'Study_certificate', NULL, 1, '2021-12-28 18:44:08', '2021-12-28 18:44:08', 0, 'admin', '0', '证书分类1', 'zsfl1', 0, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1498251135754964994, 1458608540775092226, 'MODEL_APP_NAME', '3', 3, '2022-02-28 18:58:02', '2022-02-28 18:58:02', 0, 'admin', '0', 'test33', 'test33', -1, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1508750220769366017, 1508750085104603138, 'wfBizPriority', NULL, 0, '2022-03-29 18:17:39', '2023-03-09 09:16:20', 0, 'admin', '0', '一般', 'general', 1, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1508750337513623553, 1508750085104603138, 'wfBizPriority', NULL, 1, '2022-03-29 18:18:06', '2023-03-09 09:16:20', 0, 'admin', '0', '重要', 'important', 1, 2, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1508750463208525826, 1508750085104603138, 'wfBizPriority', NULL, 2, '2022-03-29 18:18:36', '2023-03-09 09:16:20', 0, 'admin', '0', '非常重要', 'veryimportant', 1, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1546406196652982273, 1450631776195055617, 'APP_NAME', NULL, 10, '2022-07-11 16:09:03', '2022-07-11 16:09:03', 0, 'admin', '0', '任务中心', 'incloud-base-center', -1, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1563107224437452802, 1450631776195055617, 'APP_NAME', NULL, 13, '2022-08-26 18:12:58', '2022-08-26 18:12:58', 0, 'admin', '0', '报表填报系统', 'incloud-biz-smm', -1, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1563107224437452805, 1450631776195055617, 'APP_NAME', NULL, 15, '2022-08-26 18:12:58', '2022-08-26 18:12:58', 0, 'admin', '0', '门户管理', 'incloud-base-portal', -1, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1563107224437452866, 1450631776195055617, 'APP_NAME', NULL, 15, '2022-08-26 18:12:58', '2022-08-26 18:12:58', 0, 'admin', '0', '物资采购填报', 'incloud-biz-supp', -1, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1572026079125082113, 1572025848807460866, 'TASK-CLASSIFY', NULL, 0, '2022-09-20 08:53:19', '2022-09-20 08:53:19', 0, 'admin', '0', '日常', 'rc', 1, 2, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1572026136209559553, 1572025848807460866, 'TASK-CLASSIFY', NULL, 1, '2022-09-20 08:53:32', '2022-09-20 08:53:32', 0, 'admin', '0', '会议', 'hy', 1, 2, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1572026335124426753, 1572025848807460866, 'TASK-CLASSIFY', NULL, 2, '2022-09-20 08:54:20', '2022-09-20 08:54:20', 0, 'admin', '0', '特殊', 'ts', 1, 1, NULL, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1657599252032327681, 1657599083668770817, 'TASK-PRIORITY', NULL, 1, '2023-05-14 12:10:33', '2023-05-14 12:34:01', 1, 'admin', '0', '紧急', '1', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1657599310639337473, 1657599083668770817, 'TASK-PRIORITY', NULL, 2, '2023-05-14 12:10:47', '2023-05-14 12:34:01', 1, 'admin', '0', '中级', '2', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1657599403350233089, 1657599083668770817, 'TASK-PRIORITY', NULL, 3, '2023-05-14 12:11:09', '2023-05-14 12:34:01', 1, 'admin', '0', '一般', '3', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1657620038763876353, 1657616436532023298, 'TASK-REMINDER-TIME-TYPE', NULL, 1, '2023-05-14 13:33:09', '2023-05-21 23:51:34', 1, 'admin', '0', '十分钟前', 'shifenzhongqian', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1657620441756798978, 1657616436532023298, 'TASK-REMINDER-TIME-TYPE', NULL, 3, '2023-05-14 13:34:45', '2023-05-21 23:51:34', 1, 'admin', '0', '半小时之前', '30m', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1657620520894926850, 1657616436532023298, 'TASK-REMINDER-TIME-TYPE', NULL, 4, '2023-05-14 13:35:04', '2023-05-21 23:51:34', 1, 'admin', '0', '一小时之前', '1h', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1657620688084078594, 1657616436532023298, 'TASK-REMINDER-TIME-TYPE', NULL, 5, '2023-05-14 13:35:44', '2023-05-21 23:51:34', 1, 'admin', '0', '一天之前', '24h', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1657620864454561793, 1657616436532023298, 'TASK-REMINDER-TIME-TYPE', NULL, 100, '2023-05-14 13:36:26', '2023-05-21 23:51:34', 1, 'admin', '0', '自定义', 'SELF-SAVE', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1658046988578631682, 1658025329381945345, 'CTS-REMINDER-TYPE', '华北油田，短信', 1, '2023-05-15 17:49:42', '2023-05-15 17:49:42', 1, 'admin', '0', '短信', 'hb-sms', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1658047154626932738, 1658025329381945345, 'CTS-REMINDER-TYPE', NULL, 2, '2023-05-15 17:50:21', '2023-05-15 17:50:21', 1, 'admin', '0', '企业微信', 'hb-WeChat', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1658047258540814338, 1658025329381945345, 'CTS-REMINDER-TYPE', '平台邮箱', 3, '2023-05-15 17:50:46', '2023-05-15 17:50:46', 1, 'admin', '0', '邮箱', 'email', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1660313299524898818, 1660313137788342273, 'TASK-REMINDER-TYPE', '短信', 1, '2023-05-21 23:55:12', '2023-05-21 23:55:12', 1, 'admin', '0', '短信', 'sms', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1660313485873631233, 1660313137788342273, 'TASK-REMINDER-TYPE', NULL, 2, '2023-05-21 23:55:57', '2023-05-21 23:55:57', 1, 'admin', '0', '及时通', 'wechat', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1665557121457852417, 1665598558092214273, 'MDM-USER-RANK', NULL, 1, '2023-06-05 11:12:17', '2023-06-05 11:12:17', 0, 'admin', '0', '一般员工', '10', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1665557221517168641, 1665598558092214273, 'MDM-USER-RANK', NULL, 2, '2023-06-05 11:12:41', '2023-06-05 11:12:41', 0, 'admin', '0', '三级正', '31', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1665557290073067521, 1665598558092214273, 'MDM-USER-RANK', NULL, 30, '2023-06-05 11:12:57', '2023-06-05 11:12:57', 0, 'admin', '0', '三级副', '30', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1665557347446951938, 1665598558092214273, 'MDM-USER-RANK', NULL, 50, '2023-06-05 11:13:11', '2023-06-05 11:13:11', 0, 'admin', '0', '厂级机关员工', '50', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1665557407228366850, 1665598558092214273, 'MDM-USER-RANK', NULL, 20, '2023-06-05 11:13:25', '2023-06-05 11:13:25', 0, 'admin', '0', '二级副', '20', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1665557464824549377, 1665598558092214273, 'MDM-USER-RANK', NULL, 21, '2023-06-05 11:13:39', '2023-06-05 11:13:39', 0, 'admin', '0', '二级正', '21', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1665557519455358977, 1665598558092214273, 'MDM-USER-RANK', NULL, 99, '2023-06-05 11:13:52', '2023-06-05 11:13:52', 0, 'admin', '0', '公司执行董事', '99', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1665557570575536130, 1665598558092214273, 'MDM-USER-RANK', NULL, 42, '2023-06-05 11:14:04', '2023-06-05 11:14:04', 0, 'admin', '0', '首席专家', '42', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1665557627429326849, 1665598558092214273, 'MDM-USER-RANK', NULL, 40, '2023-06-05 11:14:18', '2023-06-05 11:14:18', 0, 'admin', '0', '二级技术专家', '40', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1665557687965716481, 1665598558092214273, 'MDM-USER-RANK', NULL, 41, '2023-06-05 11:14:32', '2023-06-05 11:14:32', 0, 'admin', '0', '一级技术专家', '41', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1665557745314435073, 1665598558092214273, 'MDM-USER-RANK', NULL, 61, '2023-06-05 11:14:46', '2023-06-05 11:14:46', 0, 'admin', '0', '一级工程师', '61', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1665557800507281410, 1665598558092214273, 'MDM-USER-RANK', NULL, 62, '2023-06-05 11:14:59', '2023-06-05 11:14:59', 0, 'admin', '0', '二级工程师', '62', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1665557855960174594, 1665598558092214273, 'MDM-USER-RANK', NULL, 43, '2023-06-05 11:15:12', '2023-06-05 11:15:12', 0, 'admin', '0', '咨询专家', '43', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1665557977297195010, 1665598558092214273, 'MDM-USER-RANK', NULL, 51, '2023-06-05 11:15:41', '2023-06-05 11:15:41', 0, 'admin', '0', '公司机关员工', '51', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1665558036512378881, 1665598558092214273, 'MDM-USER-RANK', NULL, 90, '2023-06-05 11:15:55', '2023-06-05 11:15:55', 0, 'admin', '0', '一级副', '90', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1665558087284428801, 1665598558092214273, 'MDM-USER-RANK', NULL, 91, '2023-06-05 11:16:07', '2023-06-05 11:16:07', 0, 'admin', '0', '一级正', '91', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1667751397286121473, 1660313137788342273, 'TASK-REMINDER-TYPE', NULL, 3, '2023-06-11 12:31:33', '2023-06-11 12:31:33', 1, 'admin', '0', '邮件', 'email', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1669004047282012162, 1450631776195055617, 'APP_NAME', NULL, 2, '2023-06-14 23:29:08', '2023-06-14 23:29:08', 1, 'admin', '0', '门户2', 'incloud-biz-portal', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1673528464641966081, 1572025848807460866, 'TASK-CLASSIFY', NULL, 3, '2023-06-27 11:07:33', '2023-06-27 11:07:33', 1, 'admin', '0', '短期任务', 'duanqirenwu', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1673528791210475522, 1657616436532023298, 'TASK-REMINDER-TIME-TYPE', NULL, 2, '2023-06-27 11:08:51', '2023-06-27 11:08:51', 1, 'admin', '0', '十五分钟前', '15m', 1, 1, 0, NULL, 0, 1);
INSERT INTO "incloud5"."incloud_base_dict_item" ("id", "dict_id", "dict_code", "remark", "sort", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_item_name", "dict_item_code", "is_enable", "version", "create_user_org_id", "create_user_org_name", "parent_id", "grade") VALUES (1684089916509827074, 1450395355265896450, 'REQUEST_TYPE', NULL, NULL, '2023-07-26 14:35:00', '2023-07-26 14:35:00', 1, 'admin', '0,1665239138713931778', 'PUT', 'PUT', 0, 1, 1665239138713931778, NULL, 0, 1);
COMMIT;

-- ----------------------------
-- Table structure for incloud_base_dict_item_version
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_dict_item_version";
CREATE TABLE "incloud5"."incloud_base_dict_item_version" (
  "id" int8 NOT NULL,
  "old_dict_item_id" int8,
  "version" int4,
  "is_main_version" int4,
  "dict_id" int8 NOT NULL,
  "dict_code" varchar(100) COLLATE "pg_catalog"."default" NOT NULL,
  "dict_item_name" varchar(100) COLLATE "pg_catalog"."default" NOT NULL,
  "dict_item_code" varchar(100) COLLATE "pg_catalog"."default" NOT NULL,
  "remark" varchar(100) COLLATE "pg_catalog"."default",
  "sort" int4,
  "is_enable" int4,
  "create_time" timestamp(6),
  "update_time" timestamp(6),
  "create_user_id" int8,
  "create_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_id" int8,
  "create_user_org_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_full_id" varchar(2000) COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "incloud5"."incloud_base_dict_item_version" OWNER TO "root";
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item_version"."id" IS '主键';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item_version"."old_dict_item_id" IS '原字典项Id';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item_version"."version" IS 'version';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item_version"."is_main_version" IS '是否主版本';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item_version"."dict_id" IS '所属字典类id';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item_version"."dict_code" IS '字典编码';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item_version"."dict_item_name" IS '字典项名称';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item_version"."dict_item_code" IS '字典项编码';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item_version"."remark" IS '备注';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item_version"."sort" IS '排序值，默认升序';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item_version"."is_enable" IS '是否启用';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item_version"."create_time" IS '创建日期';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item_version"."update_time" IS '修改日期';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item_version"."create_user_id" IS '创建人ID';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item_version"."create_user_name" IS '创建人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item_version"."create_user_org_id" IS '创建人父级机构ID';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item_version"."create_user_org_name" IS '创建人父级机构名称';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_item_version"."create_user_org_full_id" IS '创建人父级组织全路径ID';
COMMENT ON TABLE "incloud5"."incloud_base_dict_item_version" IS '字典项版本';

-- ----------------------------
-- Records of incloud_base_dict_item_version
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for incloud_base_dict_tree
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_dict_tree";
CREATE TABLE "incloud5"."incloud_base_dict_tree" (
  "id" int8 NOT NULL,
  "dict_name" varchar(100) COLLATE "pg_catalog"."default" NOT NULL,
  "dict_code" varchar(100) COLLATE "pg_catalog"."default" NOT NULL,
  "remark" varchar(100) COLLATE "pg_catalog"."default",
  "parent_id" int8,
  "grade" int4,
  "create_time" timestamp(6),
  "update_time" timestamp(6),
  "create_user_id" int8,
  "create_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_full_id" varchar(2000) COLLATE "pg_catalog"."default",
  "dict_name_alias" varchar(100) COLLATE "pg_catalog"."default",
  "dict_code_alias" varchar(100) COLLATE "pg_catalog"."default",
  "version" int4,
  "ext_id" varchar(100) COLLATE "pg_catalog"."default",
  "ext_pid" varchar(100) COLLATE "pg_catalog"."default",
  "ext_full_code" varchar(1024) COLLATE "pg_catalog"."default",
  "create_user_org_id" int8,
  "create_user_org_name" varchar(255) COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "incloud5"."incloud_base_dict_tree" OWNER TO "root";
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree"."id" IS '主键';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree"."dict_name" IS '字典名称';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree"."dict_code" IS '字典编码';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree"."remark" IS '备注';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree"."parent_id" IS '父级ID';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree"."grade" IS '级别';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree"."create_time" IS '创建日期';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree"."update_time" IS '修改日期';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree"."create_user_id" IS '创建人ID';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree"."create_user_name" IS '创建人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree"."create_user_org_full_id" IS '创建人父级组织全路径ID';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree"."dict_name_alias" IS '字典名称别名';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree"."dict_code_alias" IS '字典编码别名';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree"."version" IS '版本号';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree"."ext_id" IS '扩展Id';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree"."ext_pid" IS '扩展父级Id';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree"."ext_full_code" IS '扩展父级Id';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree"."create_user_org_id" IS '创建人父级机构ID';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree"."create_user_org_name" IS '创建人父级机构名称';
COMMENT ON TABLE "incloud5"."incloud_base_dict_tree" IS '字典树形';

-- ----------------------------
-- Records of incloud_base_dict_tree
-- ----------------------------
BEGIN;
INSERT INTO "incloud5"."incloud_base_dict_tree" ("id", "dict_name", "dict_code", "remark", "parent_id", "grade", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_name_alias", "dict_code_alias", "version", "ext_id", "ext_pid", "ext_full_code", "create_user_org_id", "create_user_org_name") VALUES (1643581671751995393, '地区', 'diqu', NULL, 0, 1, '2023-04-05 19:49:41', '2023-04-05 19:49:41', 0, 'admin', '0', NULL, NULL, 1, NULL, NULL, NULL, 1637657267702616065, NULL);
INSERT INTO "incloud5"."incloud_base_dict_tree" ("id", "dict_name", "dict_code", "remark", "parent_id", "grade", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_name_alias", "dict_code_alias", "version", "ext_id", "ext_pid", "ext_full_code", "create_user_org_id", "create_user_org_name") VALUES (1643581748910411778, '北京', 'beijing', NULL, 1643581671751995393, 2, '2023-04-05 19:50:00', '2023-04-05 19:50:00', 0, 'admin', '0', NULL, NULL, 1, NULL, NULL, NULL, 1637657267702616065, NULL);
INSERT INTO "incloud5"."incloud_base_dict_tree" ("id", "dict_name", "dict_code", "remark", "parent_id", "grade", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "dict_name_alias", "dict_code_alias", "version", "ext_id", "ext_pid", "ext_full_code", "create_user_org_id", "create_user_org_name") VALUES (1643581799560826882, '河北', 'hebei', NULL, 1643581671751995393, 2, '2023-04-05 19:50:12', '2023-04-05 19:50:12', 0, 'admin', '0', NULL, NULL, 1, NULL, NULL, NULL, 1637657267702616065, NULL);
COMMIT;

-- ----------------------------
-- Table structure for incloud_base_dict_tree_version
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_dict_tree_version";
CREATE TABLE "incloud5"."incloud_base_dict_tree_version" (
  "id" int8 NOT NULL,
  "version" int4,
  "is_main_version" int4,
  "dict_name" varchar(100) COLLATE "pg_catalog"."default" NOT NULL,
  "dict_code" varchar(100) COLLATE "pg_catalog"."default" NOT NULL,
  "dict_name_alias" varchar(100) COLLATE "pg_catalog"."default",
  "dict_code_alias" varchar(100) COLLATE "pg_catalog"."default",
  "remark" varchar(100) COLLATE "pg_catalog"."default",
  "parent_id" int8,
  "grade" int4,
  "create_time" timestamp(6),
  "update_time" timestamp(6),
  "create_user_id" int8,
  "create_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_full_id" varchar(2000) COLLATE "pg_catalog"."default",
  "old_dict_tree_id" int8,
  "create_user_org_id" int8,
  "create_user_org_name" varchar(255) COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "incloud5"."incloud_base_dict_tree_version" OWNER TO "root";
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree_version"."id" IS '主键';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree_version"."version" IS 'version';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree_version"."is_main_version" IS '是否主版本';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree_version"."dict_name" IS '字典名称';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree_version"."dict_code" IS '字典编码';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree_version"."dict_name_alias" IS '字典名称别名';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree_version"."dict_code_alias" IS '字典编码别名';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree_version"."remark" IS '备注';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree_version"."parent_id" IS '父级ID';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree_version"."grade" IS '级别';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree_version"."create_time" IS '创建日期';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree_version"."update_time" IS '修改日期';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree_version"."create_user_id" IS '创建人ID';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree_version"."create_user_name" IS '创建人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree_version"."create_user_org_full_id" IS '创建人父级组织全路径ID';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree_version"."old_dict_tree_id" IS '原字典Id';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree_version"."create_user_org_id" IS '创建人父级机构ID';
COMMENT ON COLUMN "incloud5"."incloud_base_dict_tree_version"."create_user_org_name" IS '创建人父级机构名称';
COMMENT ON TABLE "incloud5"."incloud_base_dict_tree_version" IS '字典树形版本';

-- ----------------------------
-- Records of incloud_base_dict_tree_version
-- ----------------------------
BEGIN;
INSERT INTO "incloud5"."incloud_base_dict_tree_version" ("id", "version", "is_main_version", "dict_name", "dict_code", "dict_name_alias", "dict_code_alias", "remark", "parent_id", "grade", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "old_dict_tree_id", "create_user_org_id", "create_user_org_name") VALUES (1643581671798132737, 1, 1, '地区', 'diqu', NULL, NULL, NULL, 0, 1, '2023-04-05 19:49:41', '2023-04-05 19:49:41', 0, 'admin', '0', 1643581671751995393, 1637657267702616065, NULL);
INSERT INTO "incloud5"."incloud_base_dict_tree_version" ("id", "version", "is_main_version", "dict_name", "dict_code", "dict_name_alias", "dict_code_alias", "remark", "parent_id", "grade", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "old_dict_tree_id", "create_user_org_id", "create_user_org_name") VALUES (1643581748956549121, 1, 1, '北京', 'beijing', NULL, NULL, NULL, 1643581671751995393, 2, '2023-04-05 19:50:00', '2023-04-05 19:50:00', 0, 'admin', '0', 1643581748910411778, 1637657267702616065, NULL);
INSERT INTO "incloud5"."incloud_base_dict_tree_version" ("id", "version", "is_main_version", "dict_name", "dict_code", "dict_name_alias", "dict_code_alias", "remark", "parent_id", "grade", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "old_dict_tree_id", "create_user_org_id", "create_user_org_name") VALUES (1643581799602769921, 1, 1, '河北', 'hebei', NULL, NULL, NULL, 1643581671751995393, 2, '2023-04-05 19:50:12', '2023-04-05 19:50:12', 0, 'admin', '0', 1643581799560826882, 1637657267702616065, NULL);
COMMIT;

-- ----------------------------
-- Table structure for incloud_base_dynamic_metadata
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_dynamic_metadata";
CREATE TABLE "incloud5"."incloud_base_dynamic_metadata" (
  "id" int8 NOT NULL,
  "content" text COLLATE "pg_catalog"."default" NOT NULL,
  "create_time" timestamp(6),
  "update_time" timestamp(6),
  "create_user_id" int8,
  "create_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_full_id" varchar(2000) COLLATE "pg_catalog"."default",
  "route_id" varchar(100) COLLATE "pg_catalog"."default" NOT NULL,
  "create_user_org_id" int8,
  "create_user_org_name" varchar(255) COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "incloud5"."incloud_base_dynamic_metadata" OWNER TO "root";
COMMENT ON COLUMN "incloud5"."incloud_base_dynamic_metadata"."id" IS '主键';
COMMENT ON COLUMN "incloud5"."incloud_base_dynamic_metadata"."content" IS '存储数据';
COMMENT ON COLUMN "incloud5"."incloud_base_dynamic_metadata"."create_time" IS '创建日期';
COMMENT ON COLUMN "incloud5"."incloud_base_dynamic_metadata"."update_time" IS '修改日期';
COMMENT ON COLUMN "incloud5"."incloud_base_dynamic_metadata"."create_user_id" IS '创建人ID';
COMMENT ON COLUMN "incloud5"."incloud_base_dynamic_metadata"."create_user_name" IS '创建人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_dynamic_metadata"."create_user_org_full_id" IS '创建人父级组织全路径ID';
COMMENT ON COLUMN "incloud5"."incloud_base_dynamic_metadata"."route_id" IS '路由ID';
COMMENT ON COLUMN "incloud5"."incloud_base_dynamic_metadata"."create_user_org_id" IS '创建人父级机构ID';
COMMENT ON COLUMN "incloud5"."incloud_base_dynamic_metadata"."create_user_org_name" IS '创建人父级机构名称';
COMMENT ON TABLE "incloud5"."incloud_base_dynamic_metadata" IS '动态接口元数据存储';

-- ----------------------------
-- Records of incloud_base_dynamic_metadata
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for incloud_base_enterprise_information
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_enterprise_information";
CREATE TABLE "incloud5"."incloud_base_enterprise_information" (
  "id" int8 NOT NULL,
  "home_top_file_id" int8,
  "home_top_file_url" varchar(100) COLLATE "pg_catalog"."default",
  "home_bottom_file_id" int8,
  "home_bottom_file_url" varchar(100) COLLATE "pg_catalog"."default",
  "home_background_file_id" int8,
  "home_background_file_url" varchar(100) COLLATE "pg_catalog"."default",
  "main_top_file_id" int8,
  "main_top_file_url" varchar(100) COLLATE "pg_catalog"."default",
  "copyright" varchar(50) COLLATE "pg_catalog"."default",
  "company_name" varchar(50) COLLATE "pg_catalog"."default" NOT NULL,
  "english_name_abbreviation" varchar(50) COLLATE "pg_catalog"."default" NOT NULL,
  "create_time" timestamp(6),
  "update_time" timestamp(6),
  "create_user_id" int8,
  "create_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_id" int8,
  "create_user_org_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_full_id" varchar(2000) COLLATE "pg_catalog"."default",
  "is_expand" int4 NOT NULL
)
;
ALTER TABLE "incloud5"."incloud_base_enterprise_information" OWNER TO "root";
COMMENT ON COLUMN "incloud5"."incloud_base_enterprise_information"."id" IS '主键';
COMMENT ON COLUMN "incloud5"."incloud_base_enterprise_information"."home_top_file_id" IS '首页上方logo';
COMMENT ON COLUMN "incloud5"."incloud_base_enterprise_information"."home_top_file_url" IS '首页上方logoUrl';
COMMENT ON COLUMN "incloud5"."incloud_base_enterprise_information"."home_bottom_file_id" IS '首页下方logo';
COMMENT ON COLUMN "incloud5"."incloud_base_enterprise_information"."home_bottom_file_url" IS '首页下方logoUrl';
COMMENT ON COLUMN "incloud5"."incloud_base_enterprise_information"."home_background_file_id" IS '首页背景图';
COMMENT ON COLUMN "incloud5"."incloud_base_enterprise_information"."home_background_file_url" IS '首页背景图url';
COMMENT ON COLUMN "incloud5"."incloud_base_enterprise_information"."main_top_file_id" IS '主页上方logo';
COMMENT ON COLUMN "incloud5"."incloud_base_enterprise_information"."main_top_file_url" IS '主页上方logoUrl';
COMMENT ON COLUMN "incloud5"."incloud_base_enterprise_information"."copyright" IS '版权';
COMMENT ON COLUMN "incloud5"."incloud_base_enterprise_information"."company_name" IS '企业名称';
COMMENT ON COLUMN "incloud5"."incloud_base_enterprise_information"."english_name_abbreviation" IS '企业英文简称';
COMMENT ON COLUMN "incloud5"."incloud_base_enterprise_information"."create_time" IS '创建日期';
COMMENT ON COLUMN "incloud5"."incloud_base_enterprise_information"."update_time" IS '修改日期';
COMMENT ON COLUMN "incloud5"."incloud_base_enterprise_information"."create_user_id" IS '创建人ID';
COMMENT ON COLUMN "incloud5"."incloud_base_enterprise_information"."create_user_name" IS '创建人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_enterprise_information"."create_user_org_id" IS '创建人父级机构ID';
COMMENT ON COLUMN "incloud5"."incloud_base_enterprise_information"."create_user_org_name" IS '创建人父级机构名称';
COMMENT ON COLUMN "incloud5"."incloud_base_enterprise_information"."create_user_org_full_id" IS '创建人父级组织全路径ID';
COMMENT ON COLUMN "incloud5"."incloud_base_enterprise_information"."is_expand" IS '是否展开左侧菜单0不展开1展开';
COMMENT ON TABLE "incloud5"."incloud_base_enterprise_information" IS '企业信息';

-- ----------------------------
-- Records of incloud_base_enterprise_information
-- ----------------------------
BEGIN;
INSERT INTO "incloud5"."incloud_base_enterprise_information" ("id", "home_top_file_id", "home_top_file_url", "home_bottom_file_id", "home_bottom_file_url", "home_background_file_id", "home_background_file_url", "main_top_file_id", "main_top_file_url", "copyright", "company_name", "english_name_abbreviation", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_id", "create_user_org_name", "create_user_org_full_id", "is_expand") VALUES (1727632374717313026, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '云数网讯', 'netwisd', '2023-11-23 18:18:11', '2023-11-23 18:18:11', 1, 'admin', 0, 'root', '0', 1);
COMMIT;

-- ----------------------------
-- Table structure for incloud_base_file_ds
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_file_ds";
CREATE TABLE "incloud5"."incloud_base_file_ds" (
  "id" int8 NOT NULL,
  "pool_name" varchar(50) COLLATE "pg_catalog"."default" NOT NULL,
  "type" varchar(10) COLLATE "pg_catalog"."default" NOT NULL,
  "is_default" int4 NOT NULL,
  "minio_url" varchar(255) COLLATE "pg_catalog"."default",
  "minio_access_key" varchar(255) COLLATE "pg_catalog"."default",
  "minio_secret_key" varchar(255) COLLATE "pg_catalog"."default",
  "minio_bucket_name" varchar(255) COLLATE "pg_catalog"."default",
  "local_file_path" varchar(255) COLLATE "pg_catalog"."default",
  "local_file_prefix" varchar(255) COLLATE "pg_catalog"."default",
  "create_time" timestamp(6),
  "update_time" timestamp(6),
  "create_user_id" int8,
  "create_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_full_id" varchar(2000) COLLATE "pg_catalog"."default",
  "create_user_org_id" int8,
  "create_user_org_name" varchar(255) COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "incloud5"."incloud_base_file_ds" OWNER TO "root";
COMMENT ON COLUMN "incloud5"."incloud_base_file_ds"."id" IS '主键';
COMMENT ON COLUMN "incloud5"."incloud_base_file_ds"."pool_name" IS '数据源名称';
COMMENT ON COLUMN "incloud5"."incloud_base_file_ds"."type" IS '文档存储类型';
COMMENT ON COLUMN "incloud5"."incloud_base_file_ds"."is_default" IS '是否默认实现';
COMMENT ON COLUMN "incloud5"."incloud_base_file_ds"."minio_url" IS 'minio地址';
COMMENT ON COLUMN "incloud5"."incloud_base_file_ds"."minio_access_key" IS 'minio账号';
COMMENT ON COLUMN "incloud5"."incloud_base_file_ds"."minio_secret_key" IS 'minio密码';
COMMENT ON COLUMN "incloud5"."incloud_base_file_ds"."minio_bucket_name" IS 'minio库名称';
COMMENT ON COLUMN "incloud5"."incloud_base_file_ds"."local_file_path" IS '本地存储路径';
COMMENT ON COLUMN "incloud5"."incloud_base_file_ds"."local_file_prefix" IS '本地存储前缀';
COMMENT ON COLUMN "incloud5"."incloud_base_file_ds"."create_time" IS '创建日期';
COMMENT ON COLUMN "incloud5"."incloud_base_file_ds"."update_time" IS '修改日期';
COMMENT ON COLUMN "incloud5"."incloud_base_file_ds"."create_user_id" IS '创建人ID';
COMMENT ON COLUMN "incloud5"."incloud_base_file_ds"."create_user_name" IS '创建人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_file_ds"."create_user_org_full_id" IS '创建人父级组织全路径ID';
COMMENT ON COLUMN "incloud5"."incloud_base_file_ds"."create_user_org_id" IS '创建人父级机构ID';
COMMENT ON COLUMN "incloud5"."incloud_base_file_ds"."create_user_org_name" IS '创建人父级机构名称';
COMMENT ON TABLE "incloud5"."incloud_base_file_ds" IS '文件数据源';

-- ----------------------------
-- Records of incloud_base_file_ds
-- ----------------------------
BEGIN;
INSERT INTO "incloud5"."incloud_base_file_ds" ("id", "pool_name", "type", "is_default", "minio_url", "minio_access_key", "minio_secret_key", "minio_bucket_name", "local_file_path", "local_file_prefix", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "create_user_org_id", "create_user_org_name") VALUES (1509841063911624705, 'default', 'LOCAL', 1, NULL, NULL, NULL, NULL, '/opt/localFile', '/localFile', '2022-04-06 16:20:48', '2023-05-02 10:57:10', 0, 'admin', '0', NULL, NULL);
COMMIT;

-- ----------------------------
-- Table structure for incloud_base_file_info
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_file_info";
CREATE TABLE "incloud5"."incloud_base_file_info" (
  "id" int8 NOT NULL,
  "file_name" varchar(100) COLLATE "pg_catalog"."default" NOT NULL,
  "file_is_img" int4,
  "file_content_type" varchar(255) COLLATE "pg_catalog"."default",
  "file_source" varchar(50) COLLATE "pg_catalog"."default" NOT NULL,
  "file_store_type" varchar(10) COLLATE "pg_catalog"."default" NOT NULL,
  "file_md5_code" varchar(32) COLLATE "pg_catalog"."default" NOT NULL,
  "file_bucket_name" varchar(50) COLLATE "pg_catalog"."default",
  "file_size" int8 NOT NULL,
  "file_size_view" varchar(20) COLLATE "pg_catalog"."default" NOT NULL,
  "file_path" varchar(255) COLLATE "pg_catalog"."default",
  "file_url" varchar(255) COLLATE "pg_catalog"."default",
  "create_time" timestamp(6),
  "update_time" timestamp(6),
  "create_user_id" int8,
  "create_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_full_id" varchar(2000) COLLATE "pg_catalog"."default",
  "file_pool_name" varchar(50) COLLATE "pg_catalog"."default" NOT NULL,
  "file_duration" int8,
  "create_user_org_id" int8,
  "create_user_org_name" varchar(255) COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "incloud5"."incloud_base_file_info" OWNER TO "root";
COMMENT ON COLUMN "incloud5"."incloud_base_file_info"."id" IS '主键';
COMMENT ON COLUMN "incloud5"."incloud_base_file_info"."file_name" IS '原始文件名';
COMMENT ON COLUMN "incloud5"."incloud_base_file_info"."file_is_img" IS '是否是图片,0:是，1:不是';
COMMENT ON COLUMN "incloud5"."incloud_base_file_info"."file_content_type" IS '文件的真实类型';
COMMENT ON COLUMN "incloud5"."incloud_base_file_info"."file_source" IS '文件来源，业务来源';
COMMENT ON COLUMN "incloud5"."incloud_base_file_info"."file_store_type" IS '文件存储方式；1.本地；2aliyun；3.minio';
COMMENT ON COLUMN "incloud5"."incloud_base_file_info"."file_md5_code" IS 'md5文件唯一标识';
COMMENT ON COLUMN "incloud5"."incloud_base_file_info"."file_bucket_name" IS 'minio和aliyun时会用到';
COMMENT ON COLUMN "incloud5"."incloud_base_file_info"."file_size" IS '文件大小';
COMMENT ON COLUMN "incloud5"."incloud_base_file_info"."file_size_view" IS '文件展示大小';
COMMENT ON COLUMN "incloud5"."incloud_base_file_info"."file_path" IS '本地存储时使用，真实路径';
COMMENT ON COLUMN "incloud5"."incloud_base_file_info"."file_url" IS '本地存储时使用，访问路径';
COMMENT ON COLUMN "incloud5"."incloud_base_file_info"."create_time" IS '创建日期';
COMMENT ON COLUMN "incloud5"."incloud_base_file_info"."update_time" IS '修改日期';
COMMENT ON COLUMN "incloud5"."incloud_base_file_info"."create_user_id" IS '创建人ID';
COMMENT ON COLUMN "incloud5"."incloud_base_file_info"."create_user_name" IS '创建人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_file_info"."create_user_org_full_id" IS '创建人父级组织全路径ID';
COMMENT ON COLUMN "incloud5"."incloud_base_file_info"."file_pool_name" IS '文件存储的库';
COMMENT ON COLUMN "incloud5"."incloud_base_file_info"."file_duration" IS '媒体文件时长毫秒';
COMMENT ON COLUMN "incloud5"."incloud_base_file_info"."create_user_org_id" IS '创建人父级机构ID';
COMMENT ON COLUMN "incloud5"."incloud_base_file_info"."create_user_org_name" IS '创建人父级机构名称';
COMMENT ON TABLE "incloud5"."incloud_base_file_info" IS '文件存储';

-- ----------------------------
-- Records of incloud_base_file_info
-- ----------------------------
BEGIN;
INSERT INTO "incloud5"."incloud_base_file_info" ("id", "file_name", "file_is_img", "file_content_type", "file_source", "file_store_type", "file_md5_code", "file_bucket_name", "file_size", "file_size_view", "file_path", "file_url", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "file_pool_name", "file_duration", "create_user_org_id", "create_user_org_name") VALUES (1688753583402692610, 'WechatIMG24.jpg', 0, 'image/jpeg', 'portal', 'LOCAL', '1ed5ad5e7b981e052fe06c942a382945', NULL, 15465, '15.1KB', '/opt/localFile/2023/08/08/1ed5ad5e7b981e052fe06c942a382945.jpg', '/localFile/2023/08/08/1ed5ad5e7b981e052fe06c942a382945.jpg', '2023-08-08 11:26:44', '2023-08-08 11:26:44', 1, 'admin', '0,1665239138713931778', 'default', NULL, 1665239138713931778, NULL);
INSERT INTO "incloud5"."incloud_base_file_info" ("id", "file_name", "file_is_img", "file_content_type", "file_source", "file_store_type", "file_md5_code", "file_bucket_name", "file_size", "file_size_view", "file_path", "file_url", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_full_id", "file_pool_name", "file_duration", "create_user_org_id", "create_user_org_name") VALUES (1688788974042263554, 'WechatIMG14436.jpg', 0, 'image/jpeg', 'main', 'LOCAL', '2bc2ff16decdb9a8e7cd49df21bcbc2a', NULL, 546845, '534KB', '/opt/localFile/2023/08/08/2bc2ff16decdb9a8e7cd49df21bcbc2a.jpg', '/localFile/2023/08/08/2bc2ff16decdb9a8e7cd49df21bcbc2a.jpg', '2023-08-08 13:47:19', '2023-08-08 13:47:19', 1, 'admin', '0', 'default', NULL, 0, NULL);
COMMIT;

-- ----------------------------
-- Table structure for incloud_base_file_watermark
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_file_watermark";
CREATE TABLE "incloud5"."incloud_base_file_watermark" (
  "id" int8 NOT NULL,
  "width" int4,
  "height" int4,
  "rotate" int4,
  "watermark" varchar(100) COLLATE "pg_catalog"."default",
  "font_size" int4,
  "color" varchar(100) COLLATE "pg_catalog"."default",
  "alpha" numeric(10,2),
  "offset_x" int4,
  "offset_y" int4,
  "create_time" timestamp(6),
  "update_time" timestamp(6),
  "create_user_id" int8,
  "create_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_id" int8,
  "create_user_org_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_full_id" varchar(2000) COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "incloud5"."incloud_base_file_watermark" OWNER TO "root";
COMMENT ON COLUMN "incloud5"."incloud_base_file_watermark"."id" IS '主键';
COMMENT ON COLUMN "incloud5"."incloud_base_file_watermark"."width" IS '宽';
COMMENT ON COLUMN "incloud5"."incloud_base_file_watermark"."height" IS '高';
COMMENT ON COLUMN "incloud5"."incloud_base_file_watermark"."rotate" IS '旋转度';
COMMENT ON COLUMN "incloud5"."incloud_base_file_watermark"."watermark" IS '水印内容';
COMMENT ON COLUMN "incloud5"."incloud_base_file_watermark"."font_size" IS '字体大小';
COMMENT ON COLUMN "incloud5"."incloud_base_file_watermark"."color" IS '颜色';
COMMENT ON COLUMN "incloud5"."incloud_base_file_watermark"."alpha" IS '透明度';
COMMENT ON COLUMN "incloud5"."incloud_base_file_watermark"."offset_x" IS '偏移';
COMMENT ON COLUMN "incloud5"."incloud_base_file_watermark"."offset_y" IS '偏移';
COMMENT ON COLUMN "incloud5"."incloud_base_file_watermark"."create_time" IS '创建日期';
COMMENT ON COLUMN "incloud5"."incloud_base_file_watermark"."update_time" IS '修改日期';
COMMENT ON COLUMN "incloud5"."incloud_base_file_watermark"."create_user_id" IS '创建人ID';
COMMENT ON COLUMN "incloud5"."incloud_base_file_watermark"."create_user_name" IS '创建人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_file_watermark"."create_user_org_id" IS '创建人父级机构ID';
COMMENT ON COLUMN "incloud5"."incloud_base_file_watermark"."create_user_org_name" IS '创建人父级机构名称';
COMMENT ON COLUMN "incloud5"."incloud_base_file_watermark"."create_user_org_full_id" IS '创建人父级组织全路径ID';
COMMENT ON TABLE "incloud5"."incloud_base_file_watermark" IS '文件水印';

-- ----------------------------
-- Records of incloud_base_file_watermark
-- ----------------------------
BEGIN;
INSERT INTO "incloud5"."incloud_base_file_watermark" ("id", "width", "height", "rotate", "watermark", "font_size", "color", "alpha", "offset_x", "offset_y", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_org_id", "create_user_org_name", "create_user_org_full_id") VALUES (1683754814056747010, 300, 200, -45, '云数网讯', 30, '#fa0000', 0.60, 50, -50, '2023-07-25 16:23:25', '2023-07-25 16:23:25', 1, 'admin', 1665239138713931778, '华北油田分公司', '0,1665239138713931778');
COMMIT;

-- ----------------------------
-- Table structure for incloud_base_gateway_dynamic_route
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_gateway_dynamic_route";
CREATE TABLE "incloud5"."incloud_base_gateway_dynamic_route" (
  "id" int8 NOT NULL,
  "route_id" varchar(100) COLLATE "pg_catalog"."default" NOT NULL,
  "content" text COLLATE "pg_catalog"."default" NOT NULL,
  "create_time" timestamp(6),
  "update_time" timestamp(6),
  "create_user_id" int8,
  "create_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_id" int8,
  "create_user_org_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_full_id" varchar(2000) COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "incloud5"."incloud_base_gateway_dynamic_route" OWNER TO "root";
COMMENT ON COLUMN "incloud5"."incloud_base_gateway_dynamic_route"."id" IS '主键';
COMMENT ON COLUMN "incloud5"."incloud_base_gateway_dynamic_route"."route_id" IS '路由ID';
COMMENT ON COLUMN "incloud5"."incloud_base_gateway_dynamic_route"."content" IS '内容';
COMMENT ON COLUMN "incloud5"."incloud_base_gateway_dynamic_route"."create_time" IS '创建日期';
COMMENT ON COLUMN "incloud5"."incloud_base_gateway_dynamic_route"."update_time" IS '修改日期';
COMMENT ON COLUMN "incloud5"."incloud_base_gateway_dynamic_route"."create_user_id" IS '创建人ID';
COMMENT ON COLUMN "incloud5"."incloud_base_gateway_dynamic_route"."create_user_name" IS '创建人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_gateway_dynamic_route"."create_user_org_id" IS '创建人父级机构ID';
COMMENT ON COLUMN "incloud5"."incloud_base_gateway_dynamic_route"."create_user_org_name" IS '创建人父级机构名称';
COMMENT ON COLUMN "incloud5"."incloud_base_gateway_dynamic_route"."create_user_org_full_id" IS '创建人父级组织全路径ID';
COMMENT ON TABLE "incloud5"."incloud_base_gateway_dynamic_route" IS '动态网关';

-- ----------------------------
-- Records of incloud_base_gateway_dynamic_route
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for incloud_base_help_md
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_help_md";
CREATE TABLE "incloud5"."incloud_base_help_md" (
  "id" int8 NOT NULL,
  "md_name" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "create_time" timestamp(6),
  "update_time" timestamp(6),
  "create_user_id" int8,
  "create_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_id" int8,
  "create_user_org_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_full_id" varchar(2000) COLLATE "pg_catalog"."default",
  "md_code" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "md_type" int4 NOT NULL,
  "md_content" text COLLATE "pg_catalog"."default" NOT NULL
)
;
ALTER TABLE "incloud5"."incloud_base_help_md" OWNER TO "root";
COMMENT ON COLUMN "incloud5"."incloud_base_help_md"."id" IS '主键';
COMMENT ON COLUMN "incloud5"."incloud_base_help_md"."md_name" IS 'md名称';
COMMENT ON COLUMN "incloud5"."incloud_base_help_md"."create_time" IS '创建日期';
COMMENT ON COLUMN "incloud5"."incloud_base_help_md"."update_time" IS '修改日期';
COMMENT ON COLUMN "incloud5"."incloud_base_help_md"."create_user_id" IS '创建人ID';
COMMENT ON COLUMN "incloud5"."incloud_base_help_md"."create_user_name" IS '创建人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_help_md"."create_user_org_id" IS '创建人父级机构ID';
COMMENT ON COLUMN "incloud5"."incloud_base_help_md"."create_user_org_name" IS '创建人父级机构名称';
COMMENT ON COLUMN "incloud5"."incloud_base_help_md"."create_user_org_full_id" IS '创建人父级组织全路径ID';
COMMENT ON COLUMN "incloud5"."incloud_base_help_md"."md_code" IS 'md编码';
COMMENT ON COLUMN "incloud5"."incloud_base_help_md"."md_type" IS '文档类型';
COMMENT ON COLUMN "incloud5"."incloud_base_help_md"."md_content" IS 'md内容';

-- ----------------------------
-- Records of incloud_base_help_md
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for incloud_base_mdm_area
-- ----------------------------
DROP TABLE IF EXISTS "incloud5"."incloud_base_mdm_area";
CREATE TABLE "incloud5"."incloud_base_mdm_area" (
  "id" int8 NOT NULL,
  "code" varchar(255) COLLATE "pg_catalog"."default",
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "level" int4,
  "parent_id" int8,
  "create_time" timestamp(6),
  "update_time" timestamp(6),
  "create_user_id" int8,
  "create_user_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_parent_org_id" int8,
  "create_user_parent_org_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_parent_dept_id" int8,
  "create_user_parent_dept_name" varchar(255) COLLATE "pg_catalog"."default",
  "create_user_org_full_id" varchar(2000) COLLATE "pg_catalog"."default"
)
;
ALTER TABLE "incloud5"."incloud_base_mdm_area" OWNER TO "root";
COMMENT ON COLUMN "incloud5"."incloud_base_mdm_area"."id" IS '主键';
COMMENT ON COLUMN "incloud5"."incloud_base_mdm_area"."code" IS '编码';
COMMENT ON COLUMN "incloud5"."incloud_base_mdm_area"."name" IS '名称';
COMMENT ON COLUMN "incloud5"."incloud_base_mdm_area"."level" IS '等级 1：省 2：市 3：区';
COMMENT ON COLUMN "incloud5"."incloud_base_mdm_area"."parent_id" IS '父级id';
COMMENT ON COLUMN "incloud5"."incloud_base_mdm_area"."create_time" IS '创建日期';
COMMENT ON COLUMN "incloud5"."incloud_base_mdm_area"."update_time" IS '修改日期';
COMMENT ON COLUMN "incloud5"."incloud_base_mdm_area"."create_user_id" IS '创建人ID';
COMMENT ON COLUMN "incloud5"."incloud_base_mdm_area"."create_user_name" IS '创建人名称';
COMMENT ON COLUMN "incloud5"."incloud_base_mdm_area"."create_user_parent_org_id" IS '创建人父级机构ID';
COMMENT ON COLUMN "incloud5"."incloud_base_mdm_area"."create_user_parent_org_name" IS '创建人父级机构名称';
COMMENT ON COLUMN "incloud5"."incloud_base_mdm_area"."create_user_parent_dept_id" IS '创建人父级部门ID';
COMMENT ON COLUMN "incloud5"."incloud_base_mdm_area"."create_user_parent_dept_name" IS '创建人父级部门名称';
COMMENT ON COLUMN "incloud5"."incloud_base_mdm_area"."create_user_org_full_id" IS '创建人父级组织全路径ID';
COMMENT ON TABLE "incloud5"."incloud_base_mdm_area" IS '地区表';

-- ----------------------------
-- Records of incloud_base_mdm_area
-- ----------------------------
BEGIN;
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871873, '11', '北京', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871874, '1101', '市辖区', 2, 1611571208257871873, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871875, '110101', '东城区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871876, '110102', '西城区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871877, '110105', '朝阳区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871878, '110106', '丰台区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871879, '110107', '石景山区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871880, '110108', '海淀区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871881, '110109', '门头沟区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871882, '110111', '房山区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871883, '110112', '通州区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871884, '110113', '顺义区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871885, '110114', '昌平区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871886, '110115', '大兴区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871887, '110116', '怀柔区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871888, '110117', '平谷区', 3, 1611571208257871874, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871889, '1102', '县', 2, 1611571208257871873, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871890, '110228', '密云县', 3, 1611571208257871889, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871891, '110229', '延庆县', 3, 1611571208257871889, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871892, '12', '天津', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871893, '1201', '市辖区', 2, 1611571208257871892, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871894, '120101', '和平区', 3, 1611571208257871893, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871895, '120102', '河东区', 3, 1611571208257871893, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871896, '120103', '河西区', 3, 1611571208257871893, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871897, '120104', '南开区', 3, 1611571208257871893, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871898, '120105', '河北区', 3, 1611571208257871893, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871899, '120106', '红桥区', 3, 1611571208257871893, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871900, '120110', '东丽区', 3, 1611571208257871893, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871901, '120111', '西青区', 3, 1611571208257871893, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871902, '120112', '津南区', 3, 1611571208257871893, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871903, '120113', '北辰区', 3, 1611571208257871893, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871904, '120114', '武清区', 3, 1611571208257871893, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871905, '120115', '宝坻区', 3, 1611571208257871893, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871906, '120116', '滨海新区', 3, 1611571208257871893, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871907, '1202', '县', 2, 1611571208257871892, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871908, '120221', '宁河县', 3, 1611571208257871907, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871909, '120223', '静海县', 3, 1611571208257871907, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871910, '120225', '蓟县', 3, 1611571208257871907, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871911, '13', '河北', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871912, '1301', '石家庄市', 2, 1611571208257871911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871913, '130101', '市辖区', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871914, '130102', '长安区', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871915, '130103', '桥东区', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871916, '130104', '桥西区', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871917, '130105', '新华区', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871918, '130107', '井陉矿区', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871919, '130108', '裕华区', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871920, '130121', '井陉县', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871921, '130123', '正定县', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871922, '130124', '栾城县', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871923, '130125', '行唐县', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871924, '130126', '灵寿县', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871925, '130127', '高邑县', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871926, '130128', '深泽县', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871927, '130129', '赞皇县', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871928, '130130', '无极县', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871929, '130131', '平山县', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871930, '130132', '元氏县', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871931, '130133', '赵县', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871932, '130181', '辛集市', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871933, '130182', '藁城市', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871934, '130183', '晋州市', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871935, '130184', '新乐市', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871936, '130185', '鹿泉市', 3, 1611571208257871912, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871937, '1302', '唐山市', 2, 1611571208257871911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871938, '130201', '市辖区', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871939, '130202', '路南区', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871940, '130203', '路北区', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871941, '130204', '古冶区', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871942, '130205', '开平区', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871943, '130207', '丰南区', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871944, '130208', '丰润区', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871945, '130209', '曹妃甸区', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871946, '130223', '滦县', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871947, '130224', '滦南县', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871948, '130225', '乐亭县', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871949, '130227', '迁西县', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871950, '130229', '玉田县', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871951, '130281', '遵化市', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871952, '130283', '迁安市', 3, 1611571208257871937, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871953, '1303', '秦皇岛市', 2, 1611571208257871911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871954, '130301', '市辖区', 3, 1611571208257871953, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871955, '130302', '海港区', 3, 1611571208257871953, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871956, '130303', '山海关区', 3, 1611571208257871953, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871957, '130304', '北戴河区', 3, 1611571208257871953, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871958, '130321', '青龙满族自治县', 3, 1611571208257871953, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871959, '130322', '昌黎县', 3, 1611571208257871953, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871960, '130323', '抚宁县', 3, 1611571208257871953, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871961, '130324', '卢龙县', 3, 1611571208257871953, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871962, '1304', '邯郸市', 2, 1611571208257871911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871963, '130401', '市辖区', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871964, '130402', '邯山区', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871965, '130403', '丛台区', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871966, '130404', '复兴区', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871967, '130406', '峰峰矿区', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871968, '130421', '邯郸县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871969, '130423', '临漳县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871970, '130424', '成安县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871971, '130425', '大名县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871972, '130426', '涉县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871973, '130427', '磁县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871974, '130428', '肥乡县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871975, '130429', '永年县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871976, '130430', '邱县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871977, '130431', '鸡泽县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871978, '130432', '广平县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871979, '130433', '馆陶县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871980, '130434', '魏县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871981, '130435', '曲周县', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871982, '130481', '武安市', 3, 1611571208257871962, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871983, '1305', '邢台市', 2, 1611571208257871911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871984, '130501', '市辖区', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871985, '130502', '桥东区', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871986, '130503', '桥西区', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871987, '130521', '邢台县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871988, '130522', '临城县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871989, '130523', '内丘县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871990, '130524', '柏乡县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871991, '130525', '隆尧县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871992, '130526', '任县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871993, '130527', '南和县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871994, '130528', '宁晋县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871995, '130529', '巨鹿县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871996, '130530', '新河县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871997, '130531', '广宗县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871998, '130532', '平乡县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257871999, '130533', '威县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872000, '130534', '清河县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872001, '130535', '临西县', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872002, '130581', '南宫市', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872003, '130582', '沙河市', 3, 1611571208257871983, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872004, '1306', '保定市', 2, 1611571208257871911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872005, '130601', '市辖区', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872006, '130602', '新市区', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872007, '130603', '北市区', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872008, '130604', '南市区', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872009, '130621', '满城县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872010, '130622', '清苑县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872011, '130623', '涞水县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872012, '130624', '阜平县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872013, '130625', '徐水县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872014, '130626', '定兴县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872015, '130627', '唐县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872016, '130628', '高阳县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872017, '130629', '容城县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872018, '130630', '涞源县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872019, '130631', '望都县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872020, '130632', '安新县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872021, '130633', '易县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872022, '130634', '曲阳县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872023, '130635', '蠡县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872024, '130636', '顺平县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872025, '130637', '博野县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872026, '130638', '雄县', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872027, '130681', '涿州市', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872028, '130682', '定州市', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872029, '130683', '安国市', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872030, '130684', '高碑店市', 3, 1611571208257872004, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872031, '1307', '张家口市', 2, 1611571208257871911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872032, '130701', '市辖区', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872033, '130702', '桥东区', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872034, '130703', '桥西区', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872035, '130705', '宣化区', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872036, '130706', '下花园区', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872037, '130721', '宣化县', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872038, '130722', '张北县', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872039, '130723', '康保县', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872040, '130724', '沽源县', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872041, '130725', '尚义县', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872042, '130726', '蔚县', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872043, '130727', '阳原县', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872044, '130728', '怀安县', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872045, '130729', '万全县', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872046, '130730', '怀来县', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872047, '130731', '涿鹿县', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872048, '130732', '赤城县', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872049, '130733', '崇礼县', 3, 1611571208257872031, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872050, '1308', '承德市', 2, 1611571208257871911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872051, '130801', '市辖区', 3, 1611571208257872050, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872052, '130802', '双桥区', 3, 1611571208257872050, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872053, '130803', '双滦区', 3, 1611571208257872050, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872054, '130804', '鹰手营子矿区', 3, 1611571208257872050, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872055, '130821', '承德县', 3, 1611571208257872050, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872056, '130822', '兴隆县', 3, 1611571208257872050, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872057, '130823', '平泉县', 3, 1611571208257872050, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872058, '130824', '滦平县', 3, 1611571208257872050, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872059, '130825', '隆化县', 3, 1611571208257872050, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872060, '130826', '丰宁满族自治县', 3, 1611571208257872050, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872061, '130827', '宽城满族自治县', 3, 1611571208257872050, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872062, '130828', '围场满族蒙古族自治县', 3, 1611571208257872050, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872063, '1309', '沧州市', 2, 1611571208257871911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872064, '130901', '市辖区', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872065, '130902', '新华区', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872066, '130903', '运河区', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872067, '130921', '沧县', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872068, '130922', '青县', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872069, '130923', '东光县', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872070, '130924', '海兴县', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872071, '130925', '盐山县', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872072, '130926', '肃宁县', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872073, '130927', '南皮县', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872074, '130928', '吴桥县', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872075, '130929', '献县', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872076, '130930', '孟村回族自治县', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872077, '130981', '泊头市', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872078, '130982', '任丘市', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872079, '130983', '黄骅市', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872080, '130984', '河间市', 3, 1611571208257872063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872081, '1310', '廊坊市', 2, 1611571208257871911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872082, '131001', '市辖区', 3, 1611571208257872081, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872083, '131002', '安次区', 3, 1611571208257872081, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872084, '131003', '广阳区', 3, 1611571208257872081, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872085, '131022', '固安县', 3, 1611571208257872081, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872086, '131023', '永清县', 3, 1611571208257872081, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872087, '131024', '香河县', 3, 1611571208257872081, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872088, '131025', '大城县', 3, 1611571208257872081, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872089, '131026', '文安县', 3, 1611571208257872081, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872090, '131028', '大厂回族自治县', 3, 1611571208257872081, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872091, '131081', '霸州市', 3, 1611571208257872081, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872092, '131082', '三河市', 3, 1611571208257872081, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872093, '1311', '衡水市', 2, 1611571208257871911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872094, '131101', '市辖区', 3, 1611571208257872093, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872095, '131102', '桃城区', 3, 1611571208257872093, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872096, '131121', '枣强县', 3, 1611571208257872093, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872097, '131122', '武邑县', 3, 1611571208257872093, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872098, '131123', '武强县', 3, 1611571208257872093, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872099, '131124', '饶阳县', 3, 1611571208257872093, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872100, '131125', '安平县', 3, 1611571208257872093, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872101, '131126', '故城县', 3, 1611571208257872093, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872102, '131127', '景县', 3, 1611571208257872093, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872103, '131128', '阜城县', 3, 1611571208257872093, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872104, '131181', '冀州市', 3, 1611571208257872093, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872105, '131182', '深州市', 3, 1611571208257872093, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872106, '14', '山西', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872107, '1401', '太原市', 2, 1611571208257872106, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872108, '140101', '市辖区', 3, 1611571208257872107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872109, '140105', '小店区', 3, 1611571208257872107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872110, '140106', '迎泽区', 3, 1611571208257872107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872111, '140107', '杏花岭区', 3, 1611571208257872107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872112, '140108', '尖草坪区', 3, 1611571208257872107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872113, '140109', '万柏林区', 3, 1611571208257872107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872114, '140110', '晋源区', 3, 1611571208257872107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872115, '140121', '清徐县', 3, 1611571208257872107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872116, '140122', '阳曲县', 3, 1611571208257872107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872117, '140123', '娄烦县', 3, 1611571208257872107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872118, '140181', '古交市', 3, 1611571208257872107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872119, '1402', '大同市', 2, 1611571208257872106, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872120, '140201', '市辖区', 3, 1611571208257872119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872121, '140202', '城区', 3, 1611571208257872119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872122, '140203', '矿区', 3, 1611571208257872119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872123, '140211', '南郊区', 3, 1611571208257872119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872124, '140212', '新荣区', 3, 1611571208257872119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872125, '140221', '阳高县', 3, 1611571208257872119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872126, '140222', '天镇县', 3, 1611571208257872119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872127, '140223', '广灵县', 3, 1611571208257872119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872128, '140224', '灵丘县', 3, 1611571208257872119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872129, '140225', '浑源县', 3, 1611571208257872119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872130, '140226', '左云县', 3, 1611571208257872119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872131, '140227', '大同县', 3, 1611571208257872119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872132, '1403', '阳泉市', 2, 1611571208257872106, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872133, '140301', '市辖区', 3, 1611571208257872132, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872134, '140302', '城区', 3, 1611571208257872132, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872135, '140303', '矿区', 3, 1611571208257872132, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872136, '140311', '郊区', 3, 1611571208257872132, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872137, '140321', '平定县', 3, 1611571208257872132, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872138, '140322', '盂县', 3, 1611571208257872132, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872139, '1404', '长治市', 2, 1611571208257872106, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872140, '140401', '市辖区', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872141, '140402', '城区', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872142, '140411', '郊区', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872143, '140421', '长治县', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872144, '140423', '襄垣县', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872145, '140424', '屯留县', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872146, '140425', '平顺县', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872147, '140426', '黎城县', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872148, '140427', '壶关县', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872149, '140428', '长子县', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872150, '140429', '武乡县', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872151, '140430', '沁县', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872152, '140431', '沁源县', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872153, '140481', '潞城市', 3, 1611571208257872139, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872154, '1405', '晋城市', 2, 1611571208257872106, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872155, '140501', '市辖区', 3, 1611571208257872154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872156, '140502', '城区', 3, 1611571208257872154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872157, '140521', '沁水县', 3, 1611571208257872154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872158, '140522', '阳城县', 3, 1611571208257872154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872159, '140524', '陵川县', 3, 1611571208257872154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872160, '140525', '泽州县', 3, 1611571208257872154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872161, '140581', '高平市', 3, 1611571208257872154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872162, '1406', '朔州市', 2, 1611571208257872106, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872163, '140601', '市辖区', 3, 1611571208257872162, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872164, '140602', '朔城区', 3, 1611571208257872162, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872165, '140603', '平鲁区', 3, 1611571208257872162, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872166, '140621', '山阴县', 3, 1611571208257872162, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872167, '140622', '应县', 3, 1611571208257872162, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872168, '140623', '右玉县', 3, 1611571208257872162, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872169, '140624', '怀仁县', 3, 1611571208257872162, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872170, '1407', '晋中市', 2, 1611571208257872106, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872171, '140701', '市辖区', 3, 1611571208257872170, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872172, '140702', '榆次区', 3, 1611571208257872170, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872173, '140721', '榆社县', 3, 1611571208257872170, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872174, '140722', '左权县', 3, 1611571208257872170, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872175, '140723', '和顺县', 3, 1611571208257872170, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872176, '140724', '昔阳县', 3, 1611571208257872170, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872177, '140725', '寿阳县', 3, 1611571208257872170, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872178, '140726', '太谷县', 3, 1611571208257872170, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872179, '140727', '祁县', 3, 1611571208257872170, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872180, '140728', '平遥县', 3, 1611571208257872170, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872181, '140729', '灵石县', 3, 1611571208257872170, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872182, '140781', '介休市', 3, 1611571208257872170, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872183, '1408', '运城市', 2, 1611571208257872106, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872184, '140801', '市辖区', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872185, '140802', '盐湖区', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872186, '140821', '临猗县', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872187, '140822', '万荣县', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872188, '140823', '闻喜县', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872189, '140824', '稷山县', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872190, '140825', '新绛县', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872191, '140826', '绛县', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872192, '140827', '垣曲县', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872193, '140828', '夏县', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872194, '140829', '平陆县', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872195, '140830', '芮城县', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872196, '140881', '永济市', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872197, '140882', '河津市', 3, 1611571208257872183, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872198, '1409', '忻州市', 2, 1611571208257872106, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872199, '140901', '市辖区', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872200, '140902', '忻府区', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872201, '140921', '定襄县', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872202, '140922', '五台县', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872203, '140923', '代县', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872204, '140924', '繁峙县', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872205, '140925', '宁武县', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872206, '140926', '静乐县', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872207, '140927', '神池县', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872208, '140928', '五寨县', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872209, '140929', '岢岚县', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872210, '140930', '河曲县', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872211, '140931', '保德县', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872212, '140932', '偏关县', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872213, '140981', '原平市', 3, 1611571208257872198, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872214, '1410', '临汾市', 2, 1611571208257872106, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872215, '141001', '市辖区', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872216, '141002', '尧都区', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872217, '141021', '曲沃县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872218, '141022', '翼城县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872219, '141023', '襄汾县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872220, '141024', '洪洞县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872221, '141025', '古县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872222, '141026', '安泽县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872223, '141027', '浮山县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872224, '141028', '吉县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872225, '141029', '乡宁县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872226, '141030', '大宁县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872227, '141031', '隰县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872228, '141032', '永和县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872229, '141033', '蒲县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872230, '141034', '汾西县', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872231, '141081', '侯马市', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872232, '141082', '霍州市', 3, 1611571208257872214, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872233, '1411', '吕梁市', 2, 1611571208257872106, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872234, '141101', '市辖区', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872235, '141102', '离石区', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872236, '141121', '文水县', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872237, '141122', '交城县', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872238, '141123', '兴县', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872239, '141124', '临县', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872240, '141125', '柳林县', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872241, '141126', '石楼县', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872242, '141127', '岚县', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872243, '141128', '方山县', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872244, '141129', '中阳县', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872245, '141130', '交口县', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872246, '141181', '孝义市', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872247, '141182', '汾阳市', 3, 1611571208257872233, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872248, '15', '内蒙古', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872249, '1501', '呼和浩特市', 2, 1611571208257872248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872250, '150101', '市辖区', 3, 1611571208257872249, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872251, '150102', '新城区', 3, 1611571208257872249, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872252, '150103', '回民区', 3, 1611571208257872249, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872253, '150104', '玉泉区', 3, 1611571208257872249, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872254, '150105', '赛罕区', 3, 1611571208257872249, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208257872255, '150121', '土默特左旗', 3, 1611571208257872249, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208530501633, '150122', '托克托县', 3, 1611571208257872249, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056066, '150123', '和林格尔县', 3, 1611571208257872249, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056067, '150124', '清水河县', 3, 1611571208257872249, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056068, '150125', '武川县', 3, 1611571208257872249, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056069, '1502', '包头市', 2, 1611571208257872248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056070, '150201', '市辖区', 3, 1611571208564056069, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056071, '150202', '东河区', 3, 1611571208564056069, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056072, '150203', '昆都仑区', 3, 1611571208564056069, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056073, '150204', '青山区', 3, 1611571208564056069, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056074, '150205', '石拐区', 3, 1611571208564056069, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056075, '150206', '白云鄂博矿区', 3, 1611571208564056069, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056076, '150207', '九原区', 3, 1611571208564056069, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056077, '150221', '土默特右旗', 3, 1611571208564056069, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056078, '150222', '固阳县', 3, 1611571208564056069, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056079, '150223', '达尔罕茂明安联合旗', 3, 1611571208564056069, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056080, '1503', '乌海市', 2, 1611571208257872248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056081, '150301', '市辖区', 3, 1611571208564056080, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056082, '150302', '海勃湾区', 3, 1611571208564056080, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056083, '150303', '海南区', 3, 1611571208564056080, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056084, '150304', '乌达区', 3, 1611571208564056080, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056085, '1504', '赤峰市', 2, 1611571208257872248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056086, '150401', '市辖区', 3, 1611571208564056085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056087, '150402', '红山区', 3, 1611571208564056085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056088, '150403', '元宝山区', 3, 1611571208564056085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056089, '150404', '松山区', 3, 1611571208564056085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056090, '150421', '阿鲁科尔沁旗', 3, 1611571208564056085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056091, '150422', '巴林左旗', 3, 1611571208564056085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056092, '150423', '巴林右旗', 3, 1611571208564056085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056093, '150424', '林西县', 3, 1611571208564056085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056094, '150425', '克什克腾旗', 3, 1611571208564056085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056095, '150426', '翁牛特旗', 3, 1611571208564056085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056096, '150428', '喀喇沁旗', 3, 1611571208564056085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056097, '150429', '宁城县', 3, 1611571208564056085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056098, '150430', '敖汉旗', 3, 1611571208564056085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056099, '1505', '通辽市', 2, 1611571208257872248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056100, '150501', '市辖区', 3, 1611571208564056099, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056101, '150502', '科尔沁区', 3, 1611571208564056099, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056102, '150521', '科尔沁左翼中旗', 3, 1611571208564056099, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056103, '150522', '科尔沁左翼后旗', 3, 1611571208564056099, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056104, '150523', '开鲁县', 3, 1611571208564056099, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056105, '150524', '库伦旗', 3, 1611571208564056099, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056106, '150525', '奈曼旗', 3, 1611571208564056099, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056107, '150526', '扎鲁特旗', 3, 1611571208564056099, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056108, '150581', '霍林郭勒市', 3, 1611571208564056099, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056109, '1506', '鄂尔多斯市', 2, 1611571208257872248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056110, '150601', '市辖区', 3, 1611571208564056109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056111, '150602', '东胜区', 3, 1611571208564056109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056112, '150621', '达拉特旗', 3, 1611571208564056109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056113, '150622', '准格尔旗', 3, 1611571208564056109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056114, '150623', '鄂托克前旗', 3, 1611571208564056109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056115, '150624', '鄂托克旗', 3, 1611571208564056109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056116, '150625', '杭锦旗', 3, 1611571208564056109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056117, '150626', '乌审旗', 3, 1611571208564056109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056118, '150627', '伊金霍洛旗', 3, 1611571208564056109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056119, '1507', '呼伦贝尔市', 2, 1611571208257872248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056120, '150701', '市辖区', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056121, '150702', '海拉尔区', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056122, '150721', '阿荣旗', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056123, '150722', '莫力达瓦达斡尔族自治旗', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056124, '150723', '鄂伦春自治旗', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056125, '150724', '鄂温克族自治旗', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056126, '150725', '陈巴尔虎旗', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056127, '150726', '新巴尔虎左旗', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056128, '150727', '新巴尔虎右旗', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056129, '150781', '满洲里市', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056130, '150782', '牙克石市', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056131, '150783', '扎兰屯市', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056132, '150784', '额尔古纳市', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056133, '150785', '根河市', 3, 1611571208564056119, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056134, '1508', '巴彦淖尔市', 2, 1611571208257872248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056135, '150801', '市辖区', 3, 1611571208564056134, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056136, '150802', '临河区', 3, 1611571208564056134, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056137, '150821', '五原县', 3, 1611571208564056134, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056138, '150822', '磴口县', 3, 1611571208564056134, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056139, '150823', '乌拉特前旗', 3, 1611571208564056134, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056140, '150824', '乌拉特中旗', 3, 1611571208564056134, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056141, '150825', '乌拉特后旗', 3, 1611571208564056134, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056142, '150826', '杭锦后旗', 3, 1611571208564056134, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056143, '1509', '乌兰察布市', 2, 1611571208257872248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056144, '150901', '市辖区', 3, 1611571208564056143, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056145, '150902', '集宁区', 3, 1611571208564056143, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056146, '150921', '卓资县', 3, 1611571208564056143, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056147, '150922', '化德县', 3, 1611571208564056143, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056148, '150923', '商都县', 3, 1611571208564056143, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056149, '150924', '兴和县', 3, 1611571208564056143, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056150, '150925', '凉城县', 3, 1611571208564056143, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056151, '150926', '察哈尔右翼前旗', 3, 1611571208564056143, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056152, '150927', '察哈尔右翼中旗', 3, 1611571208564056143, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056153, '150928', '察哈尔右翼后旗', 3, 1611571208564056143, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056154, '150929', '四子王旗', 3, 1611571208564056143, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056155, '150981', '丰镇市', 3, 1611571208564056143, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056156, '1522', '兴安盟', 2, 1611571208257872248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056157, '152201', '乌兰浩特市', 3, 1611571208564056156, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056158, '152202', '阿尔山市', 3, 1611571208564056156, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056159, '152221', '科尔沁右翼前旗', 3, 1611571208564056156, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056160, '152222', '科尔沁右翼中旗', 3, 1611571208564056156, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056161, '152223', '扎赉特旗', 3, 1611571208564056156, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056162, '152224', '突泉县', 3, 1611571208564056156, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056163, '1525', '锡林郭勒盟', 2, 1611571208257872248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056164, '152501', '二连浩特市', 3, 1611571208564056163, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056165, '152502', '锡林浩特市', 3, 1611571208564056163, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056166, '152522', '阿巴嘎旗', 3, 1611571208564056163, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056167, '152523', '苏尼特左旗', 3, 1611571208564056163, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056168, '152524', '苏尼特右旗', 3, 1611571208564056163, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056169, '152525', '东乌珠穆沁旗', 3, 1611571208564056163, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056170, '152526', '西乌珠穆沁旗', 3, 1611571208564056163, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056171, '152527', '太仆寺旗', 3, 1611571208564056163, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056172, '152528', '镶黄旗', 3, 1611571208564056163, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056173, '152529', '正镶白旗', 3, 1611571208564056163, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056174, '152530', '正蓝旗', 3, 1611571208564056163, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056175, '152531', '多伦县', 3, 1611571208564056163, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056176, '1529', '阿拉善盟', 2, 1611571208257872248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056177, '152921', '阿拉善左旗', 3, 1611571208564056176, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056178, '152922', '阿拉善右旗', 3, 1611571208564056176, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056179, '152923', '额济纳旗', 3, 1611571208564056176, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056180, '21', '辽宁', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056181, '2101', '沈阳市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056182, '210101', '市辖区', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056183, '210102', '和平区', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056184, '210103', '沈河区', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056185, '210104', '大东区', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056186, '210105', '皇姑区', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056187, '210106', '铁西区', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056188, '210111', '苏家屯区', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056189, '210112', '东陵区', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056190, '210113', '沈北新区', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056191, '210114', '于洪区', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056192, '210122', '辽中县', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056193, '210123', '康平县', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056194, '210124', '法库县', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056195, '210181', '新民市', 3, 1611571208564056181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056196, '2102', '大连市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056197, '210201', '市辖区', 3, 1611571208564056196, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056198, '210202', '中山区', 3, 1611571208564056196, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056199, '210203', '西岗区', 3, 1611571208564056196, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056200, '210204', '沙河口区', 3, 1611571208564056196, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056201, '210211', '甘井子区', 3, 1611571208564056196, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056202, '210212', '旅顺口区', 3, 1611571208564056196, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056203, '210213', '金州区', 3, 1611571208564056196, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056204, '210224', '长海县', 3, 1611571208564056196, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056205, '210281', '瓦房店市', 3, 1611571208564056196, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056206, '210282', '普兰店市', 3, 1611571208564056196, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056207, '210283', '庄河市', 3, 1611571208564056196, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056208, '2103', '鞍山市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056209, '210301', '市辖区', 3, 1611571208564056208, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056210, '210302', '铁东区', 3, 1611571208564056208, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056211, '210303', '铁西区', 3, 1611571208564056208, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056212, '210304', '立山区', 3, 1611571208564056208, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056213, '210311', '千山区', 3, 1611571208564056208, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056214, '210321', '台安县', 3, 1611571208564056208, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056215, '210323', '岫岩满族自治县', 3, 1611571208564056208, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056216, '210381', '海城市', 3, 1611571208564056208, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056217, '2104', '抚顺市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056218, '210401', '市辖区', 3, 1611571208564056217, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056219, '210402', '新抚区', 3, 1611571208564056217, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056220, '210403', '东洲区', 3, 1611571208564056217, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056221, '210404', '望花区', 3, 1611571208564056217, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056222, '210411', '顺城区', 3, 1611571208564056217, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056223, '210421', '抚顺县', 3, 1611571208564056217, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056224, '210422', '新宾满族自治县', 3, 1611571208564056217, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056225, '210423', '清原满族自治县', 3, 1611571208564056217, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056226, '2105', '本溪市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056227, '210501', '市辖区', 3, 1611571208564056226, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056228, '210502', '平山区', 3, 1611571208564056226, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056229, '210503', '溪湖区', 3, 1611571208564056226, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056230, '210504', '明山区', 3, 1611571208564056226, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056231, '210505', '南芬区', 3, 1611571208564056226, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056232, '210521', '本溪满族自治县', 3, 1611571208564056226, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056233, '210522', '桓仁满族自治县', 3, 1611571208564056226, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056234, '2106', '丹东市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056235, '210601', '市辖区', 3, 1611571208564056234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056236, '210602', '元宝区', 3, 1611571208564056234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056237, '210603', '振兴区', 3, 1611571208564056234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056238, '210604', '振安区', 3, 1611571208564056234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056239, '210624', '宽甸满族自治县', 3, 1611571208564056234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056240, '210681', '东港市', 3, 1611571208564056234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056241, '210682', '凤城市', 3, 1611571208564056234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056242, '2107', '锦州市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056243, '210701', '市辖区', 3, 1611571208564056242, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056244, '210702', '古塔区', 3, 1611571208564056242, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056245, '210703', '凌河区', 3, 1611571208564056242, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056246, '210711', '太和区', 3, 1611571208564056242, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056247, '210726', '黑山县', 3, 1611571208564056242, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056248, '210727', '义县', 3, 1611571208564056242, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056249, '210781', '凌海市', 3, 1611571208564056242, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056250, '210782', '北镇市', 3, 1611571208564056242, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056251, '2108', '营口市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056252, '210801', '市辖区', 3, 1611571208564056251, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056253, '210802', '站前区', 3, 1611571208564056251, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056254, '210803', '西市区', 3, 1611571208564056251, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056255, '210804', '鲅鱼圈区', 3, 1611571208564056251, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056256, '210811', '老边区', 3, 1611571208564056251, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056257, '210881', '盖州市', 3, 1611571208564056251, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056258, '210882', '大石桥市', 3, 1611571208564056251, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056259, '2109', '阜新市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056260, '210901', '市辖区', 3, 1611571208564056259, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056261, '210902', '海州区', 3, 1611571208564056259, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056262, '210903', '新邱区', 3, 1611571208564056259, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056263, '210904', '太平区', 3, 1611571208564056259, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056264, '210905', '清河门区', 3, 1611571208564056259, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056265, '210911', '细河区', 3, 1611571208564056259, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056266, '210921', '阜新蒙古族自治县', 3, 1611571208564056259, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056267, '210922', '彰武县', 3, 1611571208564056259, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056268, '2110', '辽阳市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056269, '211001', '市辖区', 3, 1611571208564056268, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056270, '211002', '白塔区', 3, 1611571208564056268, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056271, '211003', '文圣区', 3, 1611571208564056268, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056272, '211004', '宏伟区', 3, 1611571208564056268, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056273, '211005', '弓长岭区', 3, 1611571208564056268, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056274, '211011', '太子河区', 3, 1611571208564056268, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056275, '211021', '辽阳县', 3, 1611571208564056268, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056276, '211081', '灯塔市', 3, 1611571208564056268, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056277, '2111', '盘锦市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056278, '211101', '市辖区', 3, 1611571208564056277, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056279, '211102', '双台子区', 3, 1611571208564056277, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056280, '211103', '兴隆台区', 3, 1611571208564056277, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056281, '211121', '大洼县', 3, 1611571208564056277, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056282, '211122', '盘山县', 3, 1611571208564056277, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056283, '2112', '铁岭市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056284, '211201', '市辖区', 3, 1611571208564056283, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056285, '211202', '银州区', 3, 1611571208564056283, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056286, '211204', '清河区', 3, 1611571208564056283, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056287, '211221', '铁岭县', 3, 1611571208564056283, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056288, '211223', '西丰县', 3, 1611571208564056283, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056289, '211224', '昌图县', 3, 1611571208564056283, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056290, '211281', '调兵山市', 3, 1611571208564056283, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056291, '211282', '开原市', 3, 1611571208564056283, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056292, '2113', '朝阳市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056293, '211301', '市辖区', 3, 1611571208564056292, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056294, '211302', '双塔区', 3, 1611571208564056292, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056295, '211303', '龙城区', 3, 1611571208564056292, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056296, '211321', '朝阳县', 3, 1611571208564056292, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056297, '211322', '建平县', 3, 1611571208564056292, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056298, '211324', '喀喇沁左翼蒙古族自治县', 3, 1611571208564056292, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056299, '211381', '北票市', 3, 1611571208564056292, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056300, '211382', '凌源市', 3, 1611571208564056292, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056301, '2114', '葫芦岛市', 2, 1611571208564056180, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056302, '211401', '市辖区', 3, 1611571208564056301, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056303, '211402', '连山区', 3, 1611571208564056301, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056304, '211403', '龙港区', 3, 1611571208564056301, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056305, '211404', '南票区', 3, 1611571208564056301, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056306, '211421', '绥中县', 3, 1611571208564056301, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056307, '211422', '建昌县', 3, 1611571208564056301, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056308, '211481', '兴城市', 3, 1611571208564056301, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056309, '22', '吉林', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056310, '2201', '长春市', 2, 1611571208564056309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056311, '220101', '市辖区', 3, 1611571208564056310, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056312, '220102', '南关区', 3, 1611571208564056310, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056313, '220103', '宽城区', 3, 1611571208564056310, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056314, '220104', '朝阳区', 3, 1611571208564056310, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056315, '220105', '二道区', 3, 1611571208564056310, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056316, '220106', '绿园区', 3, 1611571208564056310, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056317, '220112', '双阳区', 3, 1611571208564056310, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056318, '220122', '农安县', 3, 1611571208564056310, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056319, '220181', '九台市', 3, 1611571208564056310, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056320, '220182', '榆树市', 3, 1611571208564056310, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056321, '220183', '德惠市', 3, 1611571208564056310, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056322, '2202', '吉林市', 2, 1611571208564056309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056323, '220201', '市辖区', 3, 1611571208564056322, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056324, '220202', '昌邑区', 3, 1611571208564056322, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056325, '220203', '龙潭区', 3, 1611571208564056322, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056326, '220204', '船营区', 3, 1611571208564056322, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056327, '220211', '丰满区', 3, 1611571208564056322, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056328, '220221', '永吉县', 3, 1611571208564056322, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056329, '220281', '蛟河市', 3, 1611571208564056322, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056330, '220282', '桦甸市', 3, 1611571208564056322, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056331, '220283', '舒兰市', 3, 1611571208564056322, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056332, '220284', '磐石市', 3, 1611571208564056322, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056333, '2203', '四平市', 2, 1611571208564056309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056334, '220301', '市辖区', 3, 1611571208564056333, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056335, '220302', '铁西区', 3, 1611571208564056333, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056336, '220303', '铁东区', 3, 1611571208564056333, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056337, '220322', '梨树县', 3, 1611571208564056333, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056338, '220323', '伊通满族自治县', 3, 1611571208564056333, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056339, '220381', '公主岭市', 3, 1611571208564056333, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056340, '220382', '双辽市', 3, 1611571208564056333, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056341, '2204', '辽源市', 2, 1611571208564056309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056342, '220401', '市辖区', 3, 1611571208564056341, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056343, '220402', '龙山区', 3, 1611571208564056341, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056344, '220403', '西安区', 3, 1611571208564056341, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056345, '220421', '东丰县', 3, 1611571208564056341, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056346, '220422', '东辽县', 3, 1611571208564056341, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056347, '2205', '通化市', 2, 1611571208564056309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056348, '220501', '市辖区', 3, 1611571208564056347, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056349, '220502', '东昌区', 3, 1611571208564056347, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056350, '220503', '二道江区', 3, 1611571208564056347, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056351, '220521', '通化县', 3, 1611571208564056347, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056352, '220523', '辉南县', 3, 1611571208564056347, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056353, '220524', '柳河县', 3, 1611571208564056347, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056354, '220581', '梅河口市', 3, 1611571208564056347, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056355, '220582', '集安市', 3, 1611571208564056347, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056356, '2206', '白山市', 2, 1611571208564056309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056357, '220601', '市辖区', 3, 1611571208564056356, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056358, '220602', '浑江区', 3, 1611571208564056356, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056359, '220605', '江源区', 3, 1611571208564056356, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056360, '220621', '抚松县', 3, 1611571208564056356, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056361, '220622', '靖宇县', 3, 1611571208564056356, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056362, '220623', '长白朝鲜族自治县', 3, 1611571208564056356, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056363, '220681', '临江市', 3, 1611571208564056356, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056364, '2207', '松原市', 2, 1611571208564056309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056365, '220701', '市辖区', 3, 1611571208564056364, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056366, '220702', '宁江区', 3, 1611571208564056364, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056367, '220721', '前郭尔罗斯蒙古族自治县', 3, 1611571208564056364, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056368, '220722', '长岭县', 3, 1611571208564056364, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056369, '220723', '乾安县', 3, 1611571208564056364, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056370, '220724', '扶余县', 3, 1611571208564056364, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056371, '2208', '白城市', 2, 1611571208564056309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056372, '220801', '市辖区', 3, 1611571208564056371, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056373, '220802', '洮北区', 3, 1611571208564056371, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056374, '220821', '镇赉县', 3, 1611571208564056371, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056375, '220822', '通榆县', 3, 1611571208564056371, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056376, '220881', '洮南市', 3, 1611571208564056371, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056377, '220882', '大安市', 3, 1611571208564056371, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056378, '2224', '延边朝鲜族自治州', 2, 1611571208564056309, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056379, '222401', '延吉市', 3, 1611571208564056378, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056380, '222402', '图们市', 3, 1611571208564056378, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056381, '222403', '敦化市', 3, 1611571208564056378, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056382, '222404', '珲春市', 3, 1611571208564056378, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056383, '222405', '龙井市', 3, 1611571208564056378, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056384, '222406', '和龙市', 3, 1611571208564056378, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056385, '222424', '汪清县', 3, 1611571208564056378, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056386, '222426', '安图县', 3, 1611571208564056378, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056387, '23', '黑龙江', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056388, '2301', '哈尔滨市', 2, 1611571208564056387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056389, '230101', '市辖区', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056390, '230102', '道里区', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056391, '230103', '南岗区', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056392, '230104', '道外区', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056393, '230108', '平房区', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056394, '230109', '松北区', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056395, '230110', '香坊区', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056396, '230111', '呼兰区', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056397, '230112', '阿城区', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056398, '230123', '依兰县', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056399, '230124', '方正县', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056400, '230125', '宾县', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056401, '230126', '巴彦县', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056402, '230127', '木兰县', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056403, '230128', '通河县', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056404, '230129', '延寿县', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056405, '230182', '双城市', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056406, '230183', '尚志市', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056407, '230184', '五常市', 3, 1611571208564056388, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056408, '2302', '齐齐哈尔市', 2, 1611571208564056387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056409, '230201', '市辖区', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056410, '230202', '龙沙区', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056411, '230203', '建华区', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056412, '230204', '铁锋区', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056413, '230205', '昂昂溪区', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056414, '230206', '富拉尔基区', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056415, '230207', '碾子山区', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056416, '230208', '梅里斯达斡尔族区', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056417, '230221', '龙江县', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056418, '230223', '依安县', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056419, '230224', '泰来县', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056420, '230225', '甘南县', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056421, '230227', '富裕县', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056422, '230229', '克山县', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056423, '230230', '克东县', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056424, '230231', '拜泉县', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056425, '230281', '讷河市', 3, 1611571208564056408, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056426, '2303', '鸡西市', 2, 1611571208564056387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056427, '230301', '市辖区', 3, 1611571208564056426, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056428, '230302', '鸡冠区', 3, 1611571208564056426, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056429, '230303', '恒山区', 3, 1611571208564056426, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056430, '230304', '滴道区', 3, 1611571208564056426, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056431, '230305', '梨树区', 3, 1611571208564056426, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056432, '230306', '城子河区', 3, 1611571208564056426, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056433, '230307', '麻山区', 3, 1611571208564056426, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056434, '230321', '鸡东县', 3, 1611571208564056426, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056435, '230381', '虎林市', 3, 1611571208564056426, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056436, '230382', '密山市', 3, 1611571208564056426, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056437, '2304', '鹤岗市', 2, 1611571208564056387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056438, '230401', '市辖区', 3, 1611571208564056437, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056439, '230402', '向阳区', 3, 1611571208564056437, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056440, '230403', '工农区', 3, 1611571208564056437, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056441, '230404', '南山区', 3, 1611571208564056437, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056442, '230405', '兴安区', 3, 1611571208564056437, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056443, '230406', '东山区', 3, 1611571208564056437, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056444, '230407', '兴山区', 3, 1611571208564056437, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056445, '230421', '萝北县', 3, 1611571208564056437, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056446, '230422', '绥滨县', 3, 1611571208564056437, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056447, '2305', '双鸭山市', 2, 1611571208564056387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056448, '230501', '市辖区', 3, 1611571208564056447, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056449, '230502', '尖山区', 3, 1611571208564056447, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056450, '230503', '岭东区', 3, 1611571208564056447, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056451, '230505', '四方台区', 3, 1611571208564056447, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056452, '230506', '宝山区', 3, 1611571208564056447, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056453, '230521', '集贤县', 3, 1611571208564056447, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056454, '230522', '友谊县', 3, 1611571208564056447, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056455, '230523', '宝清县', 3, 1611571208564056447, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056456, '230524', '饶河县', 3, 1611571208564056447, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056457, '2306', '大庆市', 2, 1611571208564056387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056458, '230601', '市辖区', 3, 1611571208564056457, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056459, '230602', '萨尔图区', 3, 1611571208564056457, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056460, '230603', '龙凤区', 3, 1611571208564056457, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056461, '230604', '让胡路区', 3, 1611571208564056457, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056462, '230605', '红岗区', 3, 1611571208564056457, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056463, '230606', '大同区', 3, 1611571208564056457, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056464, '230621', '肇州县', 3, 1611571208564056457, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056465, '230622', '肇源县', 3, 1611571208564056457, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056466, '230623', '林甸县', 3, 1611571208564056457, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056467, '230624', '杜尔伯特蒙古族自治县', 3, 1611571208564056457, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056468, '2307', '伊春市', 2, 1611571208564056387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056469, '230701', '市辖区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056470, '230702', '伊春区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056471, '230703', '南岔区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056472, '230704', '友好区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056473, '230705', '西林区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056474, '230706', '翠峦区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056475, '230707', '新青区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056476, '230708', '美溪区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056477, '230709', '金山屯区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056478, '230710', '五营区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056479, '230711', '乌马河区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056480, '230712', '汤旺河区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056481, '230713', '带岭区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056482, '230714', '乌伊岭区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056483, '230715', '红星区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056484, '230716', '上甘岭区', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056485, '230722', '嘉荫县', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056486, '230781', '铁力市', 3, 1611571208564056468, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056487, '2308', '佳木斯市', 2, 1611571208564056387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056488, '230801', '市辖区', 3, 1611571208564056487, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056489, '230803', '向阳区', 3, 1611571208564056487, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056490, '230804', '前进区', 3, 1611571208564056487, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056491, '230805', '东风区', 3, 1611571208564056487, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056492, '230811', '郊区', 3, 1611571208564056487, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056493, '230822', '桦南县', 3, 1611571208564056487, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056494, '230826', '桦川县', 3, 1611571208564056487, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056495, '230828', '汤原县', 3, 1611571208564056487, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056496, '230833', '抚远县', 3, 1611571208564056487, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056497, '230881', '同江市', 3, 1611571208564056487, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056498, '230882', '富锦市', 3, 1611571208564056487, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056499, '2309', '七台河市', 2, 1611571208564056387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056500, '230901', '市辖区', 3, 1611571208564056499, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056501, '230902', '新兴区', 3, 1611571208564056499, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056502, '230903', '桃山区', 3, 1611571208564056499, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056503, '230904', '茄子河区', 3, 1611571208564056499, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056504, '230921', '勃利县', 3, 1611571208564056499, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056505, '2310', '牡丹江市', 2, 1611571208564056387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056506, '231001', '市辖区', 3, 1611571208564056505, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056507, '231002', '东安区', 3, 1611571208564056505, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056508, '231003', '阳明区', 3, 1611571208564056505, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056509, '231004', '爱民区', 3, 1611571208564056505, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056510, '231005', '西安区', 3, 1611571208564056505, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056511, '231024', '东宁县', 3, 1611571208564056505, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056512, '231025', '林口县', 3, 1611571208564056505, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056513, '231081', '绥芬河市', 3, 1611571208564056505, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056514, '231083', '海林市', 3, 1611571208564056505, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056515, '231084', '宁安市', 3, 1611571208564056505, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056516, '231085', '穆棱市', 3, 1611571208564056505, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056517, '2311', '黑河市', 2, 1611571208564056387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056518, '231101', '市辖区', 3, 1611571208564056517, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056519, '231102', '爱辉区', 3, 1611571208564056517, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056520, '231121', '嫩江县', 3, 1611571208564056517, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056521, '231123', '逊克县', 3, 1611571208564056517, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056522, '231124', '孙吴县', 3, 1611571208564056517, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056523, '231181', '北安市', 3, 1611571208564056517, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056524, '231182', '五大连池市', 3, 1611571208564056517, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056525, '2312', '绥化市', 2, 1611571208564056387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056526, '231201', '市辖区', 3, 1611571208564056525, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056527, '231202', '北林区', 3, 1611571208564056525, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056528, '231221', '望奎县', 3, 1611571208564056525, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056529, '231222', '兰西县', 3, 1611571208564056525, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056530, '231223', '青冈县', 3, 1611571208564056525, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056531, '231224', '庆安县', 3, 1611571208564056525, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056532, '231225', '明水县', 3, 1611571208564056525, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056533, '231226', '绥棱县', 3, 1611571208564056525, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056534, '231281', '安达市', 3, 1611571208564056525, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056535, '231282', '肇东市', 3, 1611571208564056525, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056536, '231283', '海伦市', 3, 1611571208564056525, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056537, '2327', '大兴安岭地区', 2, 1611571208564056387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056538, '232721', '呼玛县', 3, 1611571208564056537, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056539, '232722', '塔河县', 3, 1611571208564056537, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056540, '232723', '漠河县', 3, 1611571208564056537, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056541, '31', '上海', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056542, '3101', '市辖区', 2, 1611571208564056541, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056543, '310101', '黄浦区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056544, '310104', '徐汇区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056545, '310105', '长宁区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056546, '310106', '静安区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056547, '310107', '普陀区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056548, '310108', '闸北区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056549, '310109', '虹口区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056550, '310110', '杨浦区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056551, '310112', '闵行区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056552, '310113', '宝山区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056553, '310114', '嘉定区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056554, '310115', '浦东新区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056555, '310116', '金山区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056556, '310117', '松江区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056557, '310118', '青浦区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056558, '310120', '奉贤区', 3, 1611571208564056542, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056559, '3102', '县', 2, 1611571208564056541, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056560, '310230', '崇明县', 3, 1611571208564056559, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056561, '32', '江苏', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056562, '3201', '南京市', 2, 1611571208564056561, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056563, '320101', '市辖区', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056564, '320102', '玄武区', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056565, '320103', '白下区', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056566, '320104', '秦淮区', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056567, '320105', '建邺区', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056568, '320106', '鼓楼区', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056569, '320107', '下关区', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056570, '320111', '浦口区', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056571, '320113', '栖霞区', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056572, '320114', '雨花台区', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056573, '320115', '江宁区', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056574, '320116', '六合区', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056575, '320124', '溧水县', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056576, '320125', '高淳县', 3, 1611571208564056562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056577, '3202', '无锡市', 2, 1611571208564056561, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056578, '320201', '市辖区', 3, 1611571208564056577, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056579, '320202', '崇安区', 3, 1611571208564056577, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056580, '320203', '南长区', 3, 1611571208564056577, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056581, '320204', '北塘区', 3, 1611571208564056577, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056582, '320205', '锡山区', 3, 1611571208564056577, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056583, '320206', '惠山区', 3, 1611571208564056577, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056584, '320211', '滨湖区', 3, 1611571208564056577, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056585, '320281', '江阴市', 3, 1611571208564056577, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056586, '320282', '宜兴市', 3, 1611571208564056577, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056587, '3203', '徐州市', 2, 1611571208564056561, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056588, '320301', '市辖区', 3, 1611571208564056587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056589, '320302', '鼓楼区', 3, 1611571208564056587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056590, '320303', '云龙区', 3, 1611571208564056587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056591, '320305', '贾汪区', 3, 1611571208564056587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056592, '320311', '泉山区', 3, 1611571208564056587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056593, '320312', '铜山区', 3, 1611571208564056587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056594, '320321', '丰县', 3, 1611571208564056587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056595, '320322', '沛县', 3, 1611571208564056587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056596, '320324', '睢宁县', 3, 1611571208564056587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056597, '320381', '新沂市', 3, 1611571208564056587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056598, '320382', '邳州市', 3, 1611571208564056587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056599, '3204', '常州市', 2, 1611571208564056561, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056600, '320401', '市辖区', 3, 1611571208564056599, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056601, '320402', '天宁区', 3, 1611571208564056599, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056602, '320404', '钟楼区', 3, 1611571208564056599, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056603, '320405', '戚墅堰区', 3, 1611571208564056599, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056604, '320411', '新北区', 3, 1611571208564056599, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056605, '320412', '武进区', 3, 1611571208564056599, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056606, '320481', '溧阳市', 3, 1611571208564056599, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056607, '320482', '金坛市', 3, 1611571208564056599, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056608, '3205', '苏州市', 2, 1611571208564056561, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056609, '320501', '市辖区', 3, 1611571208564056608, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056610, '320505', '虎丘区', 3, 1611571208564056608, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056611, '320506', '吴中区', 3, 1611571208564056608, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056612, '320507', '相城区', 3, 1611571208564056608, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056613, '320508', '姑苏区', 3, 1611571208564056608, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056614, '320509', '吴江区', 3, 1611571208564056608, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056615, '320581', '常熟市', 3, 1611571208564056608, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056616, '320582', '张家港市', 3, 1611571208564056608, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056617, '320583', '昆山市', 3, 1611571208564056608, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056618, '320585', '太仓市', 3, 1611571208564056608, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056619, '3206', '南通市', 2, 1611571208564056561, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056620, '320601', '市辖区', 3, 1611571208564056619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056621, '320602', '崇川区', 3, 1611571208564056619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056622, '320611', '港闸区', 3, 1611571208564056619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056623, '320612', '通州区', 3, 1611571208564056619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056624, '320621', '海安县', 3, 1611571208564056619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056625, '320623', '如东县', 3, 1611571208564056619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056626, '320681', '启东市', 3, 1611571208564056619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056627, '320682', '如皋市', 3, 1611571208564056619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056628, '320684', '海门市', 3, 1611571208564056619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056629, '3207', '连云港市', 2, 1611571208564056561, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056630, '320701', '市辖区', 3, 1611571208564056629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056631, '320703', '连云区', 3, 1611571208564056629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056632, '320705', '新浦区', 3, 1611571208564056629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056633, '320706', '海州区', 3, 1611571208564056629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056634, '320721', '赣榆县', 3, 1611571208564056629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056635, '320722', '东海县', 3, 1611571208564056629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056636, '320723', '灌云县', 3, 1611571208564056629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056637, '320724', '灌南县', 3, 1611571208564056629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056638, '3208', '淮安市', 2, 1611571208564056561, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056639, '320801', '市辖区', 3, 1611571208564056638, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056640, '320802', '清河区', 3, 1611571208564056638, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056641, '320803', '淮安区', 3, 1611571208564056638, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056642, '320804', '淮阴区', 3, 1611571208564056638, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056643, '320811', '清浦区', 3, 1611571208564056638, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056644, '320826', '涟水县', 3, 1611571208564056638, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056645, '320829', '洪泽县', 3, 1611571208564056638, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056646, '320830', '盱眙县', 3, 1611571208564056638, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056647, '320831', '金湖县', 3, 1611571208564056638, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056648, '3209', '盐城市', 2, 1611571208564056561, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056649, '320901', '市辖区', 3, 1611571208564056648, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056650, '320902', '亭湖区', 3, 1611571208564056648, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056651, '320903', '盐都区', 3, 1611571208564056648, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056652, '320921', '响水县', 3, 1611571208564056648, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056653, '320922', '滨海县', 3, 1611571208564056648, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056654, '320923', '阜宁县', 3, 1611571208564056648, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056655, '320924', '射阳县', 3, 1611571208564056648, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056656, '320925', '建湖县', 3, 1611571208564056648, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056657, '320981', '东台市', 3, 1611571208564056648, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056658, '320982', '大丰市', 3, 1611571208564056648, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056659, '3210', '扬州市', 2, 1611571208564056561, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056660, '321001', '市辖区', 3, 1611571208564056659, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056661, '321002', '广陵区', 3, 1611571208564056659, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056662, '321003', '邗江区', 3, 1611571208564056659, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056663, '321012', '江都区', 3, 1611571208564056659, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056664, '321023', '宝应县', 3, 1611571208564056659, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056665, '321081', '仪征市', 3, 1611571208564056659, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056666, '321084', '高邮市', 3, 1611571208564056659, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056667, '3211', '镇江市', 2, 1611571208564056561, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056668, '321101', '市辖区', 3, 1611571208564056667, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056669, '321102', '京口区', 3, 1611571208564056667, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056670, '321111', '润州区', 3, 1611571208564056667, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056671, '321112', '丹徒区', 3, 1611571208564056667, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056672, '321181', '丹阳市', 3, 1611571208564056667, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056673, '321182', '扬中市', 3, 1611571208564056667, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056674, '321183', '句容市', 3, 1611571208564056667, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056675, '3212', '泰州市', 2, 1611571208564056561, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056676, '321201', '市辖区', 3, 1611571208564056675, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056677, '321202', '海陵区', 3, 1611571208564056675, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056678, '321203', '高港区', 3, 1611571208564056675, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056679, '321281', '兴化市', 3, 1611571208564056675, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056680, '321282', '靖江市', 3, 1611571208564056675, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056681, '321283', '泰兴市', 3, 1611571208564056675, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056682, '321284', '姜堰市', 3, 1611571208564056675, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056683, '3213', '宿迁市', 2, 1611571208564056561, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056684, '321301', '市辖区', 3, 1611571208564056683, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056685, '321302', '宿城区', 3, 1611571208564056683, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056686, '321311', '宿豫区', 3, 1611571208564056683, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056687, '321322', '沭阳县', 3, 1611571208564056683, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056688, '321323', '泗阳县', 3, 1611571208564056683, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056689, '321324', '泗洪县', 3, 1611571208564056683, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056690, '33', '浙江', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056691, '3301', '杭州市', 2, 1611571208564056690, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056692, '330101', '市辖区', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056693, '330102', '上城区', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056694, '330103', '下城区', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056695, '330104', '江干区', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056696, '330105', '拱墅区', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056697, '330106', '西湖区', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056698, '330108', '滨江区', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056699, '330109', '萧山区', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056700, '330110', '余杭区', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056701, '330122', '桐庐县', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056702, '330127', '淳安县', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056703, '330182', '建德市', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056704, '330183', '富阳市', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056705, '330185', '临安市', 3, 1611571208564056691, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056706, '3302', '宁波市', 2, 1611571208564056690, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056707, '330201', '市辖区', 3, 1611571208564056706, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056708, '330203', '海曙区', 3, 1611571208564056706, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056709, '330204', '江东区', 3, 1611571208564056706, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056710, '330205', '江北区', 3, 1611571208564056706, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056711, '330206', '北仑区', 3, 1611571208564056706, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056712, '330211', '镇海区', 3, 1611571208564056706, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056713, '330212', '鄞州区', 3, 1611571208564056706, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056714, '330225', '象山县', 3, 1611571208564056706, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056715, '330226', '宁海县', 3, 1611571208564056706, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056716, '330281', '余姚市', 3, 1611571208564056706, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056717, '330282', '慈溪市', 3, 1611571208564056706, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056718, '330283', '奉化市', 3, 1611571208564056706, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056719, '3303', '温州市', 2, 1611571208564056690, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056720, '330301', '市辖区', 3, 1611571208564056719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056721, '330302', '鹿城区', 3, 1611571208564056719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056722, '330303', '龙湾区', 3, 1611571208564056719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056723, '330304', '瓯海区', 3, 1611571208564056719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056724, '330322', '洞头县', 3, 1611571208564056719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056725, '330324', '永嘉县', 3, 1611571208564056719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056726, '330326', '平阳县', 3, 1611571208564056719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056727, '330327', '苍南县', 3, 1611571208564056719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056728, '330328', '文成县', 3, 1611571208564056719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056729, '330329', '泰顺县', 3, 1611571208564056719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056730, '330381', '瑞安市', 3, 1611571208564056719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056731, '330382', '乐清市', 3, 1611571208564056719, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056732, '3304', '嘉兴市', 2, 1611571208564056690, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056733, '330401', '市辖区', 3, 1611571208564056732, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056734, '330402', '南湖区', 3, 1611571208564056732, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056735, '330411', '秀洲区', 3, 1611571208564056732, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056736, '330421', '嘉善县', 3, 1611571208564056732, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056737, '330424', '海盐县', 3, 1611571208564056732, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056738, '330481', '海宁市', 3, 1611571208564056732, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056739, '330482', '平湖市', 3, 1611571208564056732, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056740, '330483', '桐乡市', 3, 1611571208564056732, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056741, '3305', '湖州市', 2, 1611571208564056690, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056742, '330501', '市辖区', 3, 1611571208564056741, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056743, '330502', '吴兴区', 3, 1611571208564056741, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056744, '330503', '南浔区', 3, 1611571208564056741, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056745, '330521', '德清县', 3, 1611571208564056741, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056746, '330522', '长兴县', 3, 1611571208564056741, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056747, '330523', '安吉县', 3, 1611571208564056741, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056748, '3306', '绍兴市', 2, 1611571208564056690, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056749, '330601', '市辖区', 3, 1611571208564056748, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056750, '330602', '越城区', 3, 1611571208564056748, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056751, '330621', '绍兴县', 3, 1611571208564056748, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056752, '330624', '新昌县', 3, 1611571208564056748, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056753, '330681', '诸暨市', 3, 1611571208564056748, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056754, '330682', '上虞市', 3, 1611571208564056748, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056755, '330683', '嵊州市', 3, 1611571208564056748, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056756, '3307', '金华市', 2, 1611571208564056690, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056757, '330701', '市辖区', 3, 1611571208564056756, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056758, '330702', '婺城区', 3, 1611571208564056756, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056759, '330703', '金东区', 3, 1611571208564056756, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056760, '330723', '武义县', 3, 1611571208564056756, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056761, '330726', '浦江县', 3, 1611571208564056756, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056762, '330727', '磐安县', 3, 1611571208564056756, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056763, '330781', '兰溪市', 3, 1611571208564056756, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056764, '330782', '义乌市', 3, 1611571208564056756, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056765, '330783', '东阳市', 3, 1611571208564056756, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056766, '330784', '永康市', 3, 1611571208564056756, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056767, '3308', '衢州市', 2, 1611571208564056690, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056768, '330801', '市辖区', 3, 1611571208564056767, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056769, '330802', '柯城区', 3, 1611571208564056767, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056770, '330803', '衢江区', 3, 1611571208564056767, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056771, '330822', '常山县', 3, 1611571208564056767, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056772, '330824', '开化县', 3, 1611571208564056767, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056773, '330825', '龙游县', 3, 1611571208564056767, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056774, '330881', '江山市', 3, 1611571208564056767, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056775, '3309', '舟山市', 2, 1611571208564056690, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056776, '330901', '市辖区', 3, 1611571208564056775, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056777, '330902', '定海区', 3, 1611571208564056775, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056778, '330903', '普陀区', 3, 1611571208564056775, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056779, '330921', '岱山县', 3, 1611571208564056775, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056780, '330922', '嵊泗县', 3, 1611571208564056775, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056781, '3310', '台州市', 2, 1611571208564056690, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056782, '331001', '市辖区', 3, 1611571208564056781, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056783, '331002', '椒江区', 3, 1611571208564056781, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056784, '331003', '黄岩区', 3, 1611571208564056781, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056785, '331004', '路桥区', 3, 1611571208564056781, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056786, '331021', '玉环县', 3, 1611571208564056781, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056787, '331022', '三门县', 3, 1611571208564056781, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056788, '331023', '天台县', 3, 1611571208564056781, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056789, '331024', '仙居县', 3, 1611571208564056781, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056790, '331081', '温岭市', 3, 1611571208564056781, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056791, '331082', '临海市', 3, 1611571208564056781, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056792, '3311', '丽水市', 2, 1611571208564056690, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056793, '331101', '市辖区', 3, 1611571208564056792, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056794, '331102', '莲都区', 3, 1611571208564056792, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056795, '331121', '青田县', 3, 1611571208564056792, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056796, '331122', '缙云县', 3, 1611571208564056792, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056797, '331123', '遂昌县', 3, 1611571208564056792, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056798, '331124', '松阳县', 3, 1611571208564056792, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056799, '331125', '云和县', 3, 1611571208564056792, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056800, '331126', '庆元县', 3, 1611571208564056792, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056801, '331127', '景宁畲族自治县', 3, 1611571208564056792, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056802, '331181', '龙泉市', 3, 1611571208564056792, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056803, '34', '安徽', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056804, '3401', '合肥市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056805, '340101', '市辖区', 3, 1611571208564056804, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056806, '340102', '瑶海区', 3, 1611571208564056804, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056807, '340103', '庐阳区', 3, 1611571208564056804, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056808, '340104', '蜀山区', 3, 1611571208564056804, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056809, '340111', '包河区', 3, 1611571208564056804, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056810, '340121', '长丰县', 3, 1611571208564056804, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056811, '340122', '肥东县', 3, 1611571208564056804, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056812, '340123', '肥西县', 3, 1611571208564056804, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056813, '340124', '庐江县', 3, 1611571208564056804, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056814, '340181', '巢湖市', 3, 1611571208564056804, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056815, '3402', '芜湖市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056816, '340201', '市辖区', 3, 1611571208564056815, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056817, '340202', '镜湖区', 3, 1611571208564056815, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056818, '340203', '弋江区', 3, 1611571208564056815, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056819, '340207', '鸠江区', 3, 1611571208564056815, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056820, '340208', '三山区', 3, 1611571208564056815, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056821, '340221', '芜湖县', 3, 1611571208564056815, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056822, '340222', '繁昌县', 3, 1611571208564056815, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056823, '340223', '南陵县', 3, 1611571208564056815, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056824, '340225', '无为县', 3, 1611571208564056815, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056825, '3403', '蚌埠市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056826, '340301', '市辖区', 3, 1611571208564056825, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056827, '340302', '龙子湖区', 3, 1611571208564056825, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056828, '340303', '蚌山区', 3, 1611571208564056825, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056829, '340304', '禹会区', 3, 1611571208564056825, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056830, '340311', '淮上区', 3, 1611571208564056825, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056831, '340321', '怀远县', 3, 1611571208564056825, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056832, '340322', '五河县', 3, 1611571208564056825, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056833, '340323', '固镇县', 3, 1611571208564056825, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056834, '3404', '淮南市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056835, '340401', '市辖区', 3, 1611571208564056834, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056836, '340402', '大通区', 3, 1611571208564056834, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056837, '340403', '田家庵区', 3, 1611571208564056834, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056838, '340404', '谢家集区', 3, 1611571208564056834, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056839, '340405', '八公山区', 3, 1611571208564056834, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056840, '340406', '潘集区', 3, 1611571208564056834, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056841, '340421', '凤台县', 3, 1611571208564056834, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056842, '3405', '马鞍山市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056843, '340501', '市辖区', 3, 1611571208564056842, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056844, '340503', '花山区', 3, 1611571208564056842, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056845, '340504', '雨山区', 3, 1611571208564056842, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056846, '340506', '博望区', 3, 1611571208564056842, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056847, '340521', '当涂县', 3, 1611571208564056842, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056848, '340522', '含山县', 3, 1611571208564056842, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056849, '340523', '和县', 3, 1611571208564056842, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056850, '3406', '淮北市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056851, '340601', '市辖区', 3, 1611571208564056850, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056852, '340602', '杜集区', 3, 1611571208564056850, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056853, '340603', '相山区', 3, 1611571208564056850, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056854, '340604', '烈山区', 3, 1611571208564056850, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056855, '340621', '濉溪县', 3, 1611571208564056850, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056856, '3407', '铜陵市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056857, '340701', '市辖区', 3, 1611571208564056856, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056858, '340702', '铜官山区', 3, 1611571208564056856, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056859, '340703', '狮子山区', 3, 1611571208564056856, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056860, '340711', '郊区', 3, 1611571208564056856, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056861, '340721', '铜陵县', 3, 1611571208564056856, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056862, '3408', '安庆市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056863, '340801', '市辖区', 3, 1611571208564056862, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056864, '340802', '迎江区', 3, 1611571208564056862, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056865, '340803', '大观区', 3, 1611571208564056862, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056866, '340811', '宜秀区', 3, 1611571208564056862, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056867, '340822', '怀宁县', 3, 1611571208564056862, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056868, '340823', '枞阳县', 3, 1611571208564056862, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056869, '340824', '潜山县', 3, 1611571208564056862, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056870, '340825', '太湖县', 3, 1611571208564056862, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056871, '340826', '宿松县', 3, 1611571208564056862, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056872, '340827', '望江县', 3, 1611571208564056862, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056873, '340828', '岳西县', 3, 1611571208564056862, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056874, '340881', '桐城市', 3, 1611571208564056862, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056875, '3410', '黄山市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056876, '341001', '市辖区', 3, 1611571208564056875, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056877, '341002', '屯溪区', 3, 1611571208564056875, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056878, '341003', '黄山区', 3, 1611571208564056875, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056879, '341004', '徽州区', 3, 1611571208564056875, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056880, '341021', '歙县', 3, 1611571208564056875, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056881, '341022', '休宁县', 3, 1611571208564056875, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056882, '341023', '黟县', 3, 1611571208564056875, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056883, '341024', '祁门县', 3, 1611571208564056875, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056884, '3411', '滁州市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056885, '341101', '市辖区', 3, 1611571208564056884, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056886, '341102', '琅琊区', 3, 1611571208564056884, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056887, '341103', '南谯区', 3, 1611571208564056884, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056888, '341122', '来安县', 3, 1611571208564056884, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056889, '341124', '全椒县', 3, 1611571208564056884, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056890, '341125', '定远县', 3, 1611571208564056884, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056891, '341126', '凤阳县', 3, 1611571208564056884, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056892, '341181', '天长市', 3, 1611571208564056884, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056893, '341182', '明光市', 3, 1611571208564056884, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056894, '3412', '阜阳市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056895, '341201', '市辖区', 3, 1611571208564056894, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056896, '341202', '颍州区', 3, 1611571208564056894, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056897, '341203', '颍东区', 3, 1611571208564056894, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056898, '341204', '颍泉区', 3, 1611571208564056894, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056899, '341221', '临泉县', 3, 1611571208564056894, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056900, '341222', '太和县', 3, 1611571208564056894, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056901, '341225', '阜南县', 3, 1611571208564056894, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056902, '341226', '颍上县', 3, 1611571208564056894, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056903, '341282', '界首市', 3, 1611571208564056894, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056904, '3413', '宿州市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056905, '341301', '市辖区', 3, 1611571208564056904, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056906, '341302', '埇桥区', 3, 1611571208564056904, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056907, '341321', '砀山县', 3, 1611571208564056904, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056908, '341322', '萧县', 3, 1611571208564056904, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056909, '341323', '灵璧县', 3, 1611571208564056904, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056910, '341324', '泗县', 3, 1611571208564056904, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056911, '3415', '六安市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056912, '341501', '市辖区', 3, 1611571208564056911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056913, '341502', '金安区', 3, 1611571208564056911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056914, '341503', '裕安区', 3, 1611571208564056911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056915, '341521', '寿县', 3, 1611571208564056911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056916, '341522', '霍邱县', 3, 1611571208564056911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056917, '341523', '舒城县', 3, 1611571208564056911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056918, '341524', '金寨县', 3, 1611571208564056911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056919, '341525', '霍山县', 3, 1611571208564056911, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056920, '3416', '亳州市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056921, '341601', '市辖区', 3, 1611571208564056920, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056922, '341602', '谯城区', 3, 1611571208564056920, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056923, '341621', '涡阳县', 3, 1611571208564056920, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056924, '341622', '蒙城县', 3, 1611571208564056920, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056925, '341623', '利辛县', 3, 1611571208564056920, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056926, '3417', '池州市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056927, '341701', '市辖区', 3, 1611571208564056926, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056928, '341702', '贵池区', 3, 1611571208564056926, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056929, '341721', '东至县', 3, 1611571208564056926, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056930, '341722', '石台县', 3, 1611571208564056926, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056931, '341723', '青阳县', 3, 1611571208564056926, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056932, '3418', '宣城市', 2, 1611571208564056803, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056933, '341801', '市辖区', 3, 1611571208564056932, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056934, '341802', '宣州区', 3, 1611571208564056932, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056935, '341821', '郎溪县', 3, 1611571208564056932, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056936, '341822', '广德县', 3, 1611571208564056932, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056937, '341823', '泾县', 3, 1611571208564056932, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056938, '341824', '绩溪县', 3, 1611571208564056932, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056939, '341825', '旌德县', 3, 1611571208564056932, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056940, '341881', '宁国市', 3, 1611571208564056932, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056941, '35', '福建', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056942, '3501', '福州市', 2, 1611571208564056941, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056943, '350101', '市辖区', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056944, '350102', '鼓楼区', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056945, '350103', '台江区', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056946, '350104', '仓山区', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056947, '350105', '马尾区', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056948, '350111', '晋安区', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056949, '350121', '闽侯县', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056950, '350122', '连江县', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056951, '350123', '罗源县', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056952, '350124', '闽清县', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056953, '350125', '永泰县', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056954, '350128', '平潭县', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056955, '350181', '福清市', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056956, '350182', '长乐市', 3, 1611571208564056942, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056957, '3502', '厦门市', 2, 1611571208564056941, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056958, '350201', '市辖区', 3, 1611571208564056957, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056959, '350203', '思明区', 3, 1611571208564056957, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056960, '350205', '海沧区', 3, 1611571208564056957, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056961, '350206', '湖里区', 3, 1611571208564056957, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056962, '350211', '集美区', 3, 1611571208564056957, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056963, '350212', '同安区', 3, 1611571208564056957, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056964, '350213', '翔安区', 3, 1611571208564056957, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056965, '3503', '莆田市', 2, 1611571208564056941, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056966, '350301', '市辖区', 3, 1611571208564056965, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056967, '350302', '城厢区', 3, 1611571208564056965, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056968, '350303', '涵江区', 3, 1611571208564056965, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056969, '350304', '荔城区', 3, 1611571208564056965, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056970, '350305', '秀屿区', 3, 1611571208564056965, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056971, '350322', '仙游县', 3, 1611571208564056965, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056972, '3504', '三明市', 2, 1611571208564056941, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056973, '350401', '市辖区', 3, 1611571208564056972, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056974, '350402', '梅列区', 3, 1611571208564056972, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056975, '350403', '三元区', 3, 1611571208564056972, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056976, '350421', '明溪县', 3, 1611571208564056972, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056977, '350423', '清流县', 3, 1611571208564056972, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056978, '350424', '宁化县', 3, 1611571208564056972, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056979, '350425', '大田县', 3, 1611571208564056972, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056980, '350426', '尤溪县', 3, 1611571208564056972, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056981, '350427', '沙县', 3, 1611571208564056972, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056982, '350428', '将乐县', 3, 1611571208564056972, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056983, '350429', '泰宁县', 3, 1611571208564056972, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056984, '350430', '建宁县', 3, 1611571208564056972, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056985, '350481', '永安市', 3, 1611571208564056972, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056986, '3505', '泉州市', 2, 1611571208564056941, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056987, '350501', '市辖区', 3, 1611571208564056986, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056988, '350502', '鲤城区', 3, 1611571208564056986, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056989, '350503', '丰泽区', 3, 1611571208564056986, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056990, '350504', '洛江区', 3, 1611571208564056986, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056991, '350505', '泉港区', 3, 1611571208564056986, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056992, '350521', '惠安县', 3, 1611571208564056986, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056993, '350524', '安溪县', 3, 1611571208564056986, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056994, '350525', '永春县', 3, 1611571208564056986, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056995, '350526', '德化县', 3, 1611571208564056986, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056996, '350527', '金门县', 3, 1611571208564056986, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056997, '350581', '石狮市', 3, 1611571208564056986, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056998, '350582', '晋江市', 3, 1611571208564056986, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564056999, '350583', '南安市', 3, 1611571208564056986, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057000, '3506', '漳州市', 2, 1611571208564056941, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057001, '350601', '市辖区', 3, 1611571208564057000, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057002, '350602', '芗城区', 3, 1611571208564057000, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057003, '350603', '龙文区', 3, 1611571208564057000, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057004, '350622', '云霄县', 3, 1611571208564057000, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057005, '350623', '漳浦县', 3, 1611571208564057000, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057006, '350624', '诏安县', 3, 1611571208564057000, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057007, '350625', '长泰县', 3, 1611571208564057000, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057008, '350626', '东山县', 3, 1611571208564057000, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057009, '350627', '南靖县', 3, 1611571208564057000, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057010, '350628', '平和县', 3, 1611571208564057000, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057011, '350629', '华安县', 3, 1611571208564057000, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057012, '350681', '龙海市', 3, 1611571208564057000, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057013, '3507', '南平市', 2, 1611571208564056941, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057014, '350701', '市辖区', 3, 1611571208564057013, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057015, '350702', '延平区', 3, 1611571208564057013, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057016, '350721', '顺昌县', 3, 1611571208564057013, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057017, '350722', '浦城县', 3, 1611571208564057013, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057018, '350723', '光泽县', 3, 1611571208564057013, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057019, '350724', '松溪县', 3, 1611571208564057013, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057020, '350725', '政和县', 3, 1611571208564057013, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057021, '350781', '邵武市', 3, 1611571208564057013, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057022, '350782', '武夷山市', 3, 1611571208564057013, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057023, '350783', '建瓯市', 3, 1611571208564057013, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057024, '350784', '建阳市', 3, 1611571208564057013, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057025, '3508', '龙岩市', 2, 1611571208564056941, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057026, '350801', '市辖区', 3, 1611571208564057025, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057027, '350802', '新罗区', 3, 1611571208564057025, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057028, '350821', '长汀县', 3, 1611571208564057025, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057029, '350822', '永定县', 3, 1611571208564057025, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057030, '350823', '上杭县', 3, 1611571208564057025, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057031, '350824', '武平县', 3, 1611571208564057025, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057032, '350825', '连城县', 3, 1611571208564057025, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057033, '350881', '漳平市', 3, 1611571208564057025, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057034, '3509', '宁德市', 2, 1611571208564056941, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057035, '350901', '市辖区', 3, 1611571208564057034, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057036, '350902', '蕉城区', 3, 1611571208564057034, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057037, '350921', '霞浦县', 3, 1611571208564057034, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057038, '350922', '古田县', 3, 1611571208564057034, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057039, '350923', '屏南县', 3, 1611571208564057034, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057040, '350924', '寿宁县', 3, 1611571208564057034, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057041, '350925', '周宁县', 3, 1611571208564057034, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057042, '350926', '柘荣县', 3, 1611571208564057034, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057043, '350981', '福安市', 3, 1611571208564057034, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057044, '350982', '福鼎市', 3, 1611571208564057034, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057045, '36', '江西', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057046, '3601', '南昌市', 2, 1611571208564057045, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057047, '360101', '市辖区', 3, 1611571208564057046, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057048, '360102', '东湖区', 3, 1611571208564057046, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057049, '360103', '西湖区', 3, 1611571208564057046, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057050, '360104', '青云谱区', 3, 1611571208564057046, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057051, '360105', '湾里区', 3, 1611571208564057046, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057052, '360111', '青山湖区', 3, 1611571208564057046, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057053, '360121', '南昌县', 3, 1611571208564057046, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057054, '360122', '新建县', 3, 1611571208564057046, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057055, '360123', '安义县', 3, 1611571208564057046, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057056, '360124', '进贤县', 3, 1611571208564057046, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057057, '3602', '景德镇市', 2, 1611571208564057045, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057058, '360201', '市辖区', 3, 1611571208564057057, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057059, '360202', '昌江区', 3, 1611571208564057057, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057060, '360203', '珠山区', 3, 1611571208564057057, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057061, '360222', '浮梁县', 3, 1611571208564057057, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057062, '360281', '乐平市', 3, 1611571208564057057, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057063, '3603', '萍乡市', 2, 1611571208564057045, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057064, '360301', '市辖区', 3, 1611571208564057063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057065, '360302', '安源区', 3, 1611571208564057063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057066, '360313', '湘东区', 3, 1611571208564057063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057067, '360321', '莲花县', 3, 1611571208564057063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057068, '360322', '上栗县', 3, 1611571208564057063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057069, '360323', '芦溪县', 3, 1611571208564057063, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057070, '3604', '九江市', 2, 1611571208564057045, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057071, '360401', '市辖区', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057072, '360402', '庐山区', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057073, '360403', '浔阳区', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057074, '360421', '九江县', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057075, '360423', '武宁县', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057076, '360424', '修水县', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057077, '360425', '永修县', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057078, '360426', '德安县', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057079, '360427', '星子县', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057080, '360428', '都昌县', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057081, '360429', '湖口县', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057082, '360430', '彭泽县', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057083, '360481', '瑞昌市', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057084, '360482', '共青城市', 3, 1611571208564057070, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057085, '3605', '新余市', 2, 1611571208564057045, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057086, '360501', '市辖区', 3, 1611571208564057085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057087, '360502', '渝水区', 3, 1611571208564057085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057088, '360521', '分宜县', 3, 1611571208564057085, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057089, '3606', '鹰潭市', 2, 1611571208564057045, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057090, '360601', '市辖区', 3, 1611571208564057089, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057091, '360602', '月湖区', 3, 1611571208564057089, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057092, '360622', '余江县', 3, 1611571208564057089, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057093, '360681', '贵溪市', 3, 1611571208564057089, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057094, '3607', '赣州市', 2, 1611571208564057045, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057095, '360701', '市辖区', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057096, '360702', '章贡区', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057097, '360721', '赣县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057098, '360722', '信丰县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057099, '360723', '大余县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057100, '360724', '上犹县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057101, '360725', '崇义县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057102, '360726', '安远县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057103, '360727', '龙南县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057104, '360728', '定南县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057105, '360729', '全南县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057106, '360730', '宁都县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057107, '360731', '于都县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057108, '360732', '兴国县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057109, '360733', '会昌县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057110, '360734', '寻乌县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057111, '360735', '石城县', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057112, '360781', '瑞金市', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057113, '360782', '南康市', 3, 1611571208564057094, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057114, '3608', '吉安市', 2, 1611571208564057045, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057115, '360801', '市辖区', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057116, '360802', '吉州区', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057117, '360803', '青原区', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057118, '360821', '吉安县', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057119, '360822', '吉水县', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057120, '360823', '峡江县', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057121, '360824', '新干县', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057122, '360825', '永丰县', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057123, '360826', '泰和县', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057124, '360827', '遂川县', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057125, '360828', '万安县', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057126, '360829', '安福县', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057127, '360830', '永新县', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057128, '360881', '井冈山市', 3, 1611571208564057114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057129, '3609', '宜春市', 2, 1611571208564057045, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057130, '360901', '市辖区', 3, 1611571208564057129, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057131, '360902', '袁州区', 3, 1611571208564057129, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057132, '360921', '奉新县', 3, 1611571208564057129, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057133, '360922', '万载县', 3, 1611571208564057129, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057134, '360923', '上高县', 3, 1611571208564057129, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057135, '360924', '宜丰县', 3, 1611571208564057129, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057136, '360925', '靖安县', 3, 1611571208564057129, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057137, '360926', '铜鼓县', 3, 1611571208564057129, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057138, '360981', '丰城市', 3, 1611571208564057129, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057139, '360982', '樟树市', 3, 1611571208564057129, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057140, '360983', '高安市', 3, 1611571208564057129, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057141, '3610', '抚州市', 2, 1611571208564057045, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057142, '361001', '市辖区', 3, 1611571208564057141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057143, '361002', '临川区', 3, 1611571208564057141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057144, '361021', '南城县', 3, 1611571208564057141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057145, '361022', '黎川县', 3, 1611571208564057141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057146, '361023', '南丰县', 3, 1611571208564057141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057147, '361024', '崇仁县', 3, 1611571208564057141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057148, '361025', '乐安县', 3, 1611571208564057141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057149, '361026', '宜黄县', 3, 1611571208564057141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057150, '361027', '金溪县', 3, 1611571208564057141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057151, '361028', '资溪县', 3, 1611571208564057141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057152, '361029', '东乡县', 3, 1611571208564057141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057153, '361030', '广昌县', 3, 1611571208564057141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057154, '3611', '上饶市', 2, 1611571208564057045, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057155, '361101', '市辖区', 3, 1611571208564057154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057156, '361102', '信州区', 3, 1611571208564057154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057157, '361121', '上饶县', 3, 1611571208564057154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057158, '361122', '广丰县', 3, 1611571208564057154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057159, '361123', '玉山县', 3, 1611571208564057154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057160, '361124', '铅山县', 3, 1611571208564057154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057161, '361125', '横峰县', 3, 1611571208564057154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057162, '361126', '弋阳县', 3, 1611571208564057154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057163, '361127', '余干县', 3, 1611571208564057154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057164, '361128', '鄱阳县', 3, 1611571208564057154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057165, '361129', '万年县', 3, 1611571208564057154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057166, '361130', '婺源县', 3, 1611571208564057154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057167, '361181', '德兴市', 3, 1611571208564057154, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057168, '37', '山东', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057169, '3701', '济南市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057170, '370101', '市辖区', 3, 1611571208564057169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057171, '370102', '历下区', 3, 1611571208564057169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057172, '370103', '市中区', 3, 1611571208564057169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057173, '370104', '槐荫区', 3, 1611571208564057169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057174, '370105', '天桥区', 3, 1611571208564057169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057175, '370112', '历城区', 3, 1611571208564057169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057176, '370113', '长清区', 3, 1611571208564057169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057177, '370124', '平阴县', 3, 1611571208564057169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057178, '370125', '济阳县', 3, 1611571208564057169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057179, '370126', '商河县', 3, 1611571208564057169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057180, '370181', '章丘市', 3, 1611571208564057169, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057181, '3702', '青岛市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057182, '370201', '市辖区', 3, 1611571208564057181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057183, '370202', '市南区', 3, 1611571208564057181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057184, '370203', '市北区', 3, 1611571208564057181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057185, '370205', '四方区', 3, 1611571208564057181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057186, '370211', '黄岛区', 3, 1611571208564057181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057187, '370212', '崂山区', 3, 1611571208564057181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057188, '370213', '李沧区', 3, 1611571208564057181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057189, '370214', '城阳区', 3, 1611571208564057181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057190, '370281', '胶州市', 3, 1611571208564057181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057191, '370282', '即墨市', 3, 1611571208564057181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057192, '370283', '平度市', 3, 1611571208564057181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057193, '370284', '胶南市', 3, 1611571208564057181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057194, '370285', '莱西市', 3, 1611571208564057181, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057195, '3703', '淄博市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057196, '370301', '市辖区', 3, 1611571208564057195, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057197, '370302', '淄川区', 3, 1611571208564057195, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057198, '370303', '张店区', 3, 1611571208564057195, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057199, '370304', '博山区', 3, 1611571208564057195, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057200, '370305', '临淄区', 3, 1611571208564057195, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057201, '370306', '周村区', 3, 1611571208564057195, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057202, '370321', '桓台县', 3, 1611571208564057195, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057203, '370322', '高青县', 3, 1611571208564057195, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057204, '370323', '沂源县', 3, 1611571208564057195, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057205, '3704', '枣庄市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057206, '370401', '市辖区', 3, 1611571208564057205, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057207, '370402', '市中区', 3, 1611571208564057205, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057208, '370403', '薛城区', 3, 1611571208564057205, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057209, '370404', '峄城区', 3, 1611571208564057205, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057210, '370405', '台儿庄区', 3, 1611571208564057205, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057211, '370406', '山亭区', 3, 1611571208564057205, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057212, '370481', '滕州市', 3, 1611571208564057205, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057213, '3705', '东营市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057214, '370501', '市辖区', 3, 1611571208564057213, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057215, '370502', '东营区', 3, 1611571208564057213, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057216, '370503', '河口区', 3, 1611571208564057213, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057217, '370521', '垦利县', 3, 1611571208564057213, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057218, '370522', '利津县', 3, 1611571208564057213, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057219, '370523', '广饶县', 3, 1611571208564057213, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057220, '3706', '烟台市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057221, '370601', '市辖区', 3, 1611571208564057220, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057222, '370602', '芝罘区', 3, 1611571208564057220, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057223, '370611', '福山区', 3, 1611571208564057220, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057224, '370612', '牟平区', 3, 1611571208564057220, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057225, '370613', '莱山区', 3, 1611571208564057220, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057226, '370634', '长岛县', 3, 1611571208564057220, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057227, '370681', '龙口市', 3, 1611571208564057220, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057228, '370682', '莱阳市', 3, 1611571208564057220, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057229, '370683', '莱州市', 3, 1611571208564057220, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057230, '370684', '蓬莱市', 3, 1611571208564057220, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057231, '370685', '招远市', 3, 1611571208564057220, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057232, '370686', '栖霞市', 3, 1611571208564057220, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057233, '370687', '海阳市', 3, 1611571208564057220, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057234, '3707', '潍坊市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057235, '370701', '市辖区', 3, 1611571208564057234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057236, '370702', '潍城区', 3, 1611571208564057234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057237, '370703', '寒亭区', 3, 1611571208564057234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057238, '370704', '坊子区', 3, 1611571208564057234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057239, '370705', '奎文区', 3, 1611571208564057234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057240, '370724', '临朐县', 3, 1611571208564057234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057241, '370725', '昌乐县', 3, 1611571208564057234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057242, '370781', '青州市', 3, 1611571208564057234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057243, '370782', '诸城市', 3, 1611571208564057234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057244, '370783', '寿光市', 3, 1611571208564057234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057245, '370784', '安丘市', 3, 1611571208564057234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057246, '370785', '高密市', 3, 1611571208564057234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057247, '370786', '昌邑市', 3, 1611571208564057234, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057248, '3708', '济宁市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057249, '370801', '市辖区', 3, 1611571208564057248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057250, '370802', '市中区', 3, 1611571208564057248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057251, '370811', '任城区', 3, 1611571208564057248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057252, '370826', '微山县', 3, 1611571208564057248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057253, '370827', '鱼台县', 3, 1611571208564057248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057254, '370828', '金乡县', 3, 1611571208564057248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057255, '370829', '嘉祥县', 3, 1611571208564057248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057256, '370830', '汶上县', 3, 1611571208564057248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057257, '370831', '泗水县', 3, 1611571208564057248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057258, '370832', '梁山县', 3, 1611571208564057248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057259, '370881', '曲阜市', 3, 1611571208564057248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057260, '370882', '兖州市', 3, 1611571208564057248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057261, '370883', '邹城市', 3, 1611571208564057248, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057262, '3709', '泰安市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057263, '370901', '市辖区', 3, 1611571208564057262, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057264, '370902', '泰山区', 3, 1611571208564057262, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057265, '370911', '岱岳区', 3, 1611571208564057262, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057266, '370921', '宁阳县', 3, 1611571208564057262, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057267, '370923', '东平县', 3, 1611571208564057262, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057268, '370982', '新泰市', 3, 1611571208564057262, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057269, '370983', '肥城市', 3, 1611571208564057262, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057270, '3710', '威海市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057271, '371001', '市辖区', 3, 1611571208564057270, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057272, '371002', '环翠区', 3, 1611571208564057270, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057273, '371081', '文登市', 3, 1611571208564057270, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057274, '371082', '荣成市', 3, 1611571208564057270, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057275, '371083', '乳山市', 3, 1611571208564057270, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057276, '3711', '日照市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057277, '371101', '市辖区', 3, 1611571208564057276, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057278, '371102', '东港区', 3, 1611571208564057276, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057279, '371103', '岚山区', 3, 1611571208564057276, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057280, '371121', '五莲县', 3, 1611571208564057276, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057281, '371122', '莒县', 3, 1611571208564057276, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057282, '3712', '莱芜市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057283, '371201', '市辖区', 3, 1611571208564057282, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057284, '371202', '莱城区', 3, 1611571208564057282, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057285, '371203', '钢城区', 3, 1611571208564057282, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057286, '3713', '临沂市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057287, '371301', '市辖区', 3, 1611571208564057286, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057288, '371302', '兰山区', 3, 1611571208564057286, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057289, '371311', '罗庄区', 3, 1611571208564057286, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057290, '371312', '河东区', 3, 1611571208564057286, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057291, '371321', '沂南县', 3, 1611571208564057286, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057292, '371322', '郯城县', 3, 1611571208564057286, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057293, '371323', '沂水县', 3, 1611571208564057286, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057294, '371324', '苍山县', 3, 1611571208564057286, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057295, '371325', '费县', 3, 1611571208564057286, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057296, '371326', '平邑县', 3, 1611571208564057286, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057297, '371327', '莒南县', 3, 1611571208564057286, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057298, '371328', '蒙阴县', 3, 1611571208564057286, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057299, '371329', '临沭县', 3, 1611571208564057286, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057300, '3714', '德州市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057301, '371401', '市辖区', 3, 1611571208564057300, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057302, '371402', '德城区', 3, 1611571208564057300, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057303, '371421', '陵县', 3, 1611571208564057300, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057304, '371422', '宁津县', 3, 1611571208564057300, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057305, '371423', '庆云县', 3, 1611571208564057300, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057306, '371424', '临邑县', 3, 1611571208564057300, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057307, '371425', '齐河县', 3, 1611571208564057300, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057308, '371426', '平原县', 3, 1611571208564057300, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057309, '371427', '夏津县', 3, 1611571208564057300, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057310, '371428', '武城县', 3, 1611571208564057300, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057311, '371481', '乐陵市', 3, 1611571208564057300, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057312, '371482', '禹城市', 3, 1611571208564057300, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057313, '3715', '聊城市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057314, '371501', '市辖区', 3, 1611571208564057313, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057315, '371502', '东昌府区', 3, 1611571208564057313, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057316, '371521', '阳谷县', 3, 1611571208564057313, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057317, '371522', '莘县', 3, 1611571208564057313, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057318, '371523', '茌平县', 3, 1611571208564057313, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057319, '371524', '东阿县', 3, 1611571208564057313, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057320, '371525', '冠县', 3, 1611571208564057313, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057321, '371526', '高唐县', 3, 1611571208564057313, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057322, '371581', '临清市', 3, 1611571208564057313, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057323, '3716', '滨州市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057324, '371601', '市辖区', 3, 1611571208564057323, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057325, '371602', '滨城区', 3, 1611571208564057323, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057326, '371621', '惠民县', 3, 1611571208564057323, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057327, '371622', '阳信县', 3, 1611571208564057323, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057328, '371623', '无棣县', 3, 1611571208564057323, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057329, '371624', '沾化县', 3, 1611571208564057323, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057330, '371625', '博兴县', 3, 1611571208564057323, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057331, '371626', '邹平县', 3, 1611571208564057323, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057332, '3717', '菏泽市', 2, 1611571208564057168, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057333, '371701', '市辖区', 3, 1611571208564057332, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057334, '371702', '牡丹区', 3, 1611571208564057332, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057335, '371721', '曹县', 3, 1611571208564057332, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057336, '371722', '单县', 3, 1611571208564057332, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057337, '371723', '成武县', 3, 1611571208564057332, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057338, '371724', '巨野县', 3, 1611571208564057332, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057339, '371725', '郓城县', 3, 1611571208564057332, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057340, '371726', '鄄城县', 3, 1611571208564057332, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057341, '371727', '定陶县', 3, 1611571208564057332, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057342, '371728', '东明县', 3, 1611571208564057332, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057343, '41', '河南', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057344, '4101', '郑州市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057345, '410101', '市辖区', 3, 1611571208564057344, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057346, '410102', '中原区', 3, 1611571208564057344, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057347, '410103', '二七区', 3, 1611571208564057344, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057348, '410104', '管城回族区', 3, 1611571208564057344, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057349, '410105', '金水区', 3, 1611571208564057344, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057350, '410106', '上街区', 3, 1611571208564057344, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057351, '410108', '惠济区', 3, 1611571208564057344, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057352, '410122', '中牟县', 3, 1611571208564057344, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057353, '410181', '巩义市', 3, 1611571208564057344, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057354, '410182', '荥阳市', 3, 1611571208564057344, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057355, '410183', '新密市', 3, 1611571208564057344, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057356, '410184', '新郑市', 3, 1611571208564057344, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057357, '410185', '登封市', 3, 1611571208564057344, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057358, '4102', '开封市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057359, '410201', '市辖区', 3, 1611571208564057358, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057360, '410202', '龙亭区', 3, 1611571208564057358, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057361, '410203', '顺河回族区', 3, 1611571208564057358, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057362, '410204', '鼓楼区', 3, 1611571208564057358, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057363, '410205', '禹王台区', 3, 1611571208564057358, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057364, '410211', '金明区', 3, 1611571208564057358, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057365, '410221', '杞县', 3, 1611571208564057358, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057366, '410222', '通许县', 3, 1611571208564057358, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057367, '410223', '尉氏县', 3, 1611571208564057358, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057368, '410224', '开封县', 3, 1611571208564057358, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057369, '410225', '兰考县', 3, 1611571208564057358, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057370, '4103', '洛阳市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057371, '410301', '市辖区', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057372, '410302', '老城区', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057373, '410303', '西工区', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057374, '410304', '瀍河回族区', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057375, '410305', '涧西区', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057376, '410306', '吉利区', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057377, '410311', '洛龙区', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057378, '410322', '孟津县', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057379, '410323', '新安县', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057380, '410324', '栾川县', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057381, '410325', '嵩县', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057382, '410326', '汝阳县', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057383, '410327', '宜阳县', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057384, '410328', '洛宁县', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057385, '410329', '伊川县', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057386, '410381', '偃师市', 3, 1611571208564057370, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057387, '4104', '平顶山市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057388, '410401', '市辖区', 3, 1611571208564057387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057389, '410402', '新华区', 3, 1611571208564057387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057390, '410403', '卫东区', 3, 1611571208564057387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057391, '410404', '石龙区', 3, 1611571208564057387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057392, '410411', '湛河区', 3, 1611571208564057387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057393, '410421', '宝丰县', 3, 1611571208564057387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057394, '410422', '叶县', 3, 1611571208564057387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057395, '410423', '鲁山县', 3, 1611571208564057387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057396, '410425', '郏县', 3, 1611571208564057387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057397, '410481', '舞钢市', 3, 1611571208564057387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057398, '410482', '汝州市', 3, 1611571208564057387, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057399, '4105', '安阳市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057400, '410501', '市辖区', 3, 1611571208564057399, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057401, '410502', '文峰区', 3, 1611571208564057399, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057402, '410503', '北关区', 3, 1611571208564057399, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057403, '410505', '殷都区', 3, 1611571208564057399, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057404, '410506', '龙安区', 3, 1611571208564057399, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057405, '410522', '安阳县', 3, 1611571208564057399, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057406, '410523', '汤阴县', 3, 1611571208564057399, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057407, '410526', '滑县', 3, 1611571208564057399, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057408, '410527', '内黄县', 3, 1611571208564057399, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057409, '410581', '林州市', 3, 1611571208564057399, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057410, '4106', '鹤壁市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057411, '410601', '市辖区', 3, 1611571208564057410, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057412, '410602', '鹤山区', 3, 1611571208564057410, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057413, '410603', '山城区', 3, 1611571208564057410, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057414, '410611', '淇滨区', 3, 1611571208564057410, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057415, '410621', '浚县', 3, 1611571208564057410, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057416, '410622', '淇县', 3, 1611571208564057410, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057417, '4107', '新乡市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057418, '410701', '市辖区', 3, 1611571208564057417, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057419, '410702', '红旗区', 3, 1611571208564057417, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057420, '410703', '卫滨区', 3, 1611571208564057417, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057421, '410704', '凤泉区', 3, 1611571208564057417, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057422, '410711', '牧野区', 3, 1611571208564057417, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057423, '410721', '新乡县', 3, 1611571208564057417, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057424, '410724', '获嘉县', 3, 1611571208564057417, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057425, '410725', '原阳县', 3, 1611571208564057417, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057426, '410726', '延津县', 3, 1611571208564057417, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057427, '410727', '封丘县', 3, 1611571208564057417, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057428, '410728', '长垣县', 3, 1611571208564057417, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057429, '410781', '卫辉市', 3, 1611571208564057417, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057430, '410782', '辉县市', 3, 1611571208564057417, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057431, '4108', '焦作市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057432, '410801', '市辖区', 3, 1611571208564057431, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057433, '410802', '解放区', 3, 1611571208564057431, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057434, '410803', '中站区', 3, 1611571208564057431, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057435, '410804', '马村区', 3, 1611571208564057431, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057436, '410811', '山阳区', 3, 1611571208564057431, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057437, '410821', '修武县', 3, 1611571208564057431, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057438, '410822', '博爱县', 3, 1611571208564057431, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057439, '410823', '武陟县', 3, 1611571208564057431, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057440, '410825', '温县', 3, 1611571208564057431, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057441, '410882', '沁阳市', 3, 1611571208564057431, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057442, '410883', '孟州市', 3, 1611571208564057431, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057443, '4109', '濮阳市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057444, '410901', '市辖区', 3, 1611571208564057443, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057445, '410902', '华龙区', 3, 1611571208564057443, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057446, '410922', '清丰县', 3, 1611571208564057443, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057447, '410923', '南乐县', 3, 1611571208564057443, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057448, '410926', '范县', 3, 1611571208564057443, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057449, '410927', '台前县', 3, 1611571208564057443, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057450, '410928', '濮阳县', 3, 1611571208564057443, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057451, '4110', '许昌市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057452, '411001', '市辖区', 3, 1611571208564057451, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057453, '411002', '魏都区', 3, 1611571208564057451, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057454, '411023', '许昌县', 3, 1611571208564057451, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057455, '411024', '鄢陵县', 3, 1611571208564057451, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057456, '411025', '襄城县', 3, 1611571208564057451, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057457, '411081', '禹州市', 3, 1611571208564057451, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057458, '411082', '长葛市', 3, 1611571208564057451, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057459, '4111', '漯河市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057460, '411101', '市辖区', 3, 1611571208564057459, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057461, '411102', '源汇区', 3, 1611571208564057459, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057462, '411103', '郾城区', 3, 1611571208564057459, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057463, '411104', '召陵区', 3, 1611571208564057459, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057464, '411121', '舞阳县', 3, 1611571208564057459, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057465, '411122', '临颍县', 3, 1611571208564057459, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057466, '4112', '三门峡市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057467, '411201', '市辖区', 3, 1611571208564057466, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057468, '411202', '湖滨区', 3, 1611571208564057466, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057469, '411221', '渑池县', 3, 1611571208564057466, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057470, '411222', '陕县', 3, 1611571208564057466, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057471, '411224', '卢氏县', 3, 1611571208564057466, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057472, '411281', '义马市', 3, 1611571208564057466, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057473, '411282', '灵宝市', 3, 1611571208564057466, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057474, '4113', '南阳市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057475, '411301', '市辖区', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057476, '411302', '宛城区', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057477, '411303', '卧龙区', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057478, '411321', '南召县', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057479, '411322', '方城县', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057480, '411323', '西峡县', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057481, '411324', '镇平县', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057482, '411325', '内乡县', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057483, '411326', '淅川县', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057484, '411327', '社旗县', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057485, '411328', '唐河县', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057486, '411329', '新野县', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057487, '411330', '桐柏县', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057488, '411381', '邓州市', 3, 1611571208564057474, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057489, '4114', '商丘市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057490, '411401', '市辖区', 3, 1611571208564057489, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057491, '411402', '梁园区', 3, 1611571208564057489, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057492, '411403', '睢阳区', 3, 1611571208564057489, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057493, '411421', '民权县', 3, 1611571208564057489, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057494, '411422', '睢县', 3, 1611571208564057489, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057495, '411423', '宁陵县', 3, 1611571208564057489, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057496, '411424', '柘城县', 3, 1611571208564057489, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057497, '411425', '虞城县', 3, 1611571208564057489, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057498, '411426', '夏邑县', 3, 1611571208564057489, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057499, '411481', '永城市', 3, 1611571208564057489, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057500, '4115', '信阳市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057501, '411501', '市辖区', 3, 1611571208564057500, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057502, '411502', '浉河区', 3, 1611571208564057500, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057503, '411503', '平桥区', 3, 1611571208564057500, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057504, '411521', '罗山县', 3, 1611571208564057500, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057505, '411522', '光山县', 3, 1611571208564057500, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057506, '411523', '新县', 3, 1611571208564057500, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057507, '411524', '商城县', 3, 1611571208564057500, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057508, '411525', '固始县', 3, 1611571208564057500, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057509, '411526', '潢川县', 3, 1611571208564057500, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057510, '411527', '淮滨县', 3, 1611571208564057500, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057511, '411528', '息县', 3, 1611571208564057500, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057512, '4116', '周口市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057513, '411601', '市辖区', 3, 1611571208564057512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057514, '411602', '川汇区', 3, 1611571208564057512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057515, '411621', '扶沟县', 3, 1611571208564057512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057516, '411622', '西华县', 3, 1611571208564057512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057517, '411623', '商水县', 3, 1611571208564057512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057518, '411624', '沈丘县', 3, 1611571208564057512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057519, '411625', '郸城县', 3, 1611571208564057512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057520, '411626', '淮阳县', 3, 1611571208564057512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057521, '411627', '太康县', 3, 1611571208564057512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057522, '411628', '鹿邑县', 3, 1611571208564057512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057523, '411681', '项城市', 3, 1611571208564057512, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057524, '4117', '驻马店市', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057525, '411701', '市辖区', 3, 1611571208564057524, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057526, '411702', '驿城区', 3, 1611571208564057524, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057527, '411721', '西平县', 3, 1611571208564057524, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057528, '411722', '上蔡县', 3, 1611571208564057524, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057529, '411723', '平舆县', 3, 1611571208564057524, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057530, '411724', '正阳县', 3, 1611571208564057524, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057531, '411725', '确山县', 3, 1611571208564057524, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057532, '411726', '泌阳县', 3, 1611571208564057524, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057533, '411727', '汝南县', 3, 1611571208564057524, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057534, '411728', '遂平县', 3, 1611571208564057524, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057535, '411729', '新蔡县', 3, 1611571208564057524, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057536, '4190', '省直辖县级行政区划', 2, 1611571208564057343, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057537, '419001', '济源市', 3, 1611571208564057536, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057538, '42', '湖北', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057539, '4201', '武汉市', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057540, '420101', '市辖区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057541, '420102', '江岸区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057542, '420103', '江汉区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057543, '420104', '硚口区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057544, '420105', '汉阳区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057545, '420106', '武昌区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057546, '420107', '青山区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057547, '420111', '洪山区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057548, '420112', '东西湖区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057549, '420113', '汉南区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057550, '420114', '蔡甸区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057551, '420115', '江夏区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057552, '420116', '黄陂区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057553, '420117', '新洲区', 3, 1611571208564057539, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057554, '4202', '黄石市', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057555, '420201', '市辖区', 3, 1611571208564057554, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057556, '420202', '黄石港区', 3, 1611571208564057554, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057557, '420203', '西塞山区', 3, 1611571208564057554, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057558, '420204', '下陆区', 3, 1611571208564057554, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057559, '420205', '铁山区', 3, 1611571208564057554, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057560, '420222', '阳新县', 3, 1611571208564057554, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057561, '420281', '大冶市', 3, 1611571208564057554, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057562, '4203', '十堰市', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057563, '420301', '市辖区', 3, 1611571208564057562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057564, '420302', '茅箭区', 3, 1611571208564057562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057565, '420303', '张湾区', 3, 1611571208564057562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057566, '420321', '郧县', 3, 1611571208564057562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057567, '420322', '郧西县', 3, 1611571208564057562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057568, '420323', '竹山县', 3, 1611571208564057562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057569, '420324', '竹溪县', 3, 1611571208564057562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057570, '420325', '房县', 3, 1611571208564057562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057571, '420381', '丹江口市', 3, 1611571208564057562, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057572, '4205', '宜昌市', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057573, '420501', '市辖区', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057574, '420502', '西陵区', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057575, '420503', '伍家岗区', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057576, '420504', '点军区', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057577, '420505', '猇亭区', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057578, '420506', '夷陵区', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057579, '420525', '远安县', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057580, '420526', '兴山县', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057581, '420527', '秭归县', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057582, '420528', '长阳土家族自治县', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057583, '420529', '五峰土家族自治县', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057584, '420581', '宜都市', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057585, '420582', '当阳市', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057586, '420583', '枝江市', 3, 1611571208564057572, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057587, '4206', '襄阳市', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057588, '420601', '市辖区', 3, 1611571208564057587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057589, '420602', '襄城区', 3, 1611571208564057587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057590, '420606', '樊城区', 3, 1611571208564057587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057591, '420607', '襄州区', 3, 1611571208564057587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057592, '420624', '南漳县', 3, 1611571208564057587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057593, '420625', '谷城县', 3, 1611571208564057587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057594, '420626', '保康县', 3, 1611571208564057587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057595, '420682', '老河口市', 3, 1611571208564057587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057596, '420683', '枣阳市', 3, 1611571208564057587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057597, '420684', '宜城市', 3, 1611571208564057587, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057598, '4207', '鄂州市', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057599, '420701', '市辖区', 3, 1611571208564057598, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057600, '420702', '梁子湖区', 3, 1611571208564057598, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057601, '420703', '华容区', 3, 1611571208564057598, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057602, '420704', '鄂城区', 3, 1611571208564057598, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057603, '4208', '荆门市', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057604, '420801', '市辖区', 3, 1611571208564057603, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057605, '420802', '东宝区', 3, 1611571208564057603, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057606, '420804', '掇刀区', 3, 1611571208564057603, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057607, '420821', '京山县', 3, 1611571208564057603, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057608, '420822', '沙洋县', 3, 1611571208564057603, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057609, '420881', '钟祥市', 3, 1611571208564057603, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057610, '4209', '孝感市', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057611, '420901', '市辖区', 3, 1611571208564057610, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057612, '420902', '孝南区', 3, 1611571208564057610, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057613, '420921', '孝昌县', 3, 1611571208564057610, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057614, '420922', '大悟县', 3, 1611571208564057610, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057615, '420923', '云梦县', 3, 1611571208564057610, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057616, '420981', '应城市', 3, 1611571208564057610, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057617, '420982', '安陆市', 3, 1611571208564057610, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057618, '420984', '汉川市', 3, 1611571208564057610, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057619, '4210', '荆州市', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057620, '421001', '市辖区', 3, 1611571208564057619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057621, '421002', '沙市区', 3, 1611571208564057619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057622, '421003', '荆州区', 3, 1611571208564057619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057623, '421022', '公安县', 3, 1611571208564057619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057624, '421023', '监利县', 3, 1611571208564057619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057625, '421024', '江陵县', 3, 1611571208564057619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057626, '421081', '石首市', 3, 1611571208564057619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057627, '421083', '洪湖市', 3, 1611571208564057619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057628, '421087', '松滋市', 3, 1611571208564057619, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057629, '4211', '黄冈市', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057630, '421101', '市辖区', 3, 1611571208564057629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057631, '421102', '黄州区', 3, 1611571208564057629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057632, '421121', '团风县', 3, 1611571208564057629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057633, '421122', '红安县', 3, 1611571208564057629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057634, '421123', '罗田县', 3, 1611571208564057629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057635, '421124', '英山县', 3, 1611571208564057629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057636, '421125', '浠水县', 3, 1611571208564057629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057637, '421126', '蕲春县', 3, 1611571208564057629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057638, '421127', '黄梅县', 3, 1611571208564057629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057639, '421181', '麻城市', 3, 1611571208564057629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057640, '421182', '武穴市', 3, 1611571208564057629, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057641, '4212', '咸宁市', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057642, '421201', '市辖区', 3, 1611571208564057641, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057643, '421202', '咸安区', 3, 1611571208564057641, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057644, '421221', '嘉鱼县', 3, 1611571208564057641, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057645, '421222', '通城县', 3, 1611571208564057641, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057646, '421223', '崇阳县', 3, 1611571208564057641, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057647, '421224', '通山县', 3, 1611571208564057641, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057648, '421281', '赤壁市', 3, 1611571208564057641, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057649, '4213', '随州市', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057650, '421301', '市辖区', 3, 1611571208564057649, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057651, '421303', '曾都区', 3, 1611571208564057649, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057652, '421321', '随县', 3, 1611571208564057649, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057653, '421381', '广水市', 3, 1611571208564057649, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057654, '4228', '恩施土家族苗族自治州', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057655, '422801', '恩施市', 3, 1611571208564057654, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057656, '422802', '利川市', 3, 1611571208564057654, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057657, '422822', '建始县', 3, 1611571208564057654, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057658, '422823', '巴东县', 3, 1611571208564057654, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057659, '422825', '宣恩县', 3, 1611571208564057654, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057660, '422826', '咸丰县', 3, 1611571208564057654, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057661, '422827', '来凤县', 3, 1611571208564057654, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057662, '422828', '鹤峰县', 3, 1611571208564057654, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057663, '4290', '省直辖县级行政区划', 2, 1611571208564057538, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057664, '429004', '仙桃市', 3, 1611571208564057663, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057665, '429005', '潜江市', 3, 1611571208564057663, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057666, '429006', '天门市', 3, 1611571208564057663, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057667, '429021', '神农架林区', 3, 1611571208564057663, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057668, '43', '湖南', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057669, '4301', '长沙市', 2, 1611571208564057668, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057670, '430101', '市辖区', 3, 1611571208564057669, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057671, '430102', '芙蓉区', 3, 1611571208564057669, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "create_user_org_full_id") VALUES (1611571208564057672, '430103', '天心区', 3, 1611571208564057669, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO "incloud5"."incloud_base_mdm_area" ("id", "code", "name", "level", "parent_id", "create_time", "update_time", "create_user_id", "create_user_name", "create_user_parent_org_id", "create_user_parent_org_name", "create_user_parent_dept_id", "create_user_parent_dept_name", "crea